/****************************************************************************
 * struct_defs.h
 * Author Julie Roskies and Joel Welling
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

/*
*	Define some general structures needed in structures.c (structure
*	making and destroying program).
*/

#define CTABSIZ 256	/* maximum size of color table */

/* Color information, possibly including transparency */
typedef struct color_struct { float r, g, b, a; } Color;

/* Vector in 3-space */
typedef struct vector_struct { float x, y, z; } Vector;

/* Coordinate boundaries of the model */
typedef struct boundary_struct {
	float x_min, x_max;	/* Model's minimum and maximum x-axis value */
	float y_min, y_max;	/* Model's minimum and maximum y-axis value */
	float z_min, z_max;	/* Model's minimum and maximum z-axis value */
        } Boundary;

/* Vertex, with coords and possibly a normal vector and a color */
typedef struct vertex_struct {
	float x, y, z;		/* 3-space coords */
	Color *color;		/* color given if non-null */
	Vector *normal;		/* vertex normal */
	} Vertex;

/* Sometimes vertices will be referenced by index */
typedef long Vertex_ID;

/* 
A Vnode is an element of a linked list.  Its first entry is a pointer
to the next vertex of that facet, the second entry is the index of that
vertex in the vertex_list. 
*/
typedef struct vnode_struct {
  	struct vnode_struct *next;
	Vertex_ID myvertex;
	} Vnode;

/* 
A facet is the linked list of Vnodes, and can be referenced as the first
Vnode in the list.
*/
typedef struct vnode_struct Facet;

/* 
A Part is a structure that tells the range of elements associated with that
part of the model.
*/
typedef struct part_struct {
	long min, max;
	Color *color;
	} Part;

/* Structure to hold a model */
typedef struct model_struct {
	Boundary *bound_box;	/* coordinate boundaries */
	Vertex *vertex_list;   	/* all the vertices */
	long vertex_count;	/* number of vertices */
	Facet *facet_list;	/* all the facets */
	long facet_count;	/* number of facets */
	Part *part_list;	/* upper and lower facet bounds for parts */
	long part_count;	/* number of parts */
	Vertex *displace_list;	/* displacements for vertices */
	float displace_scale;	/* factor by which to multiply displacements */
	Color *color_table;	/* Holds table of color values */
	} Model;

/* functions to be used in structure.c */

extern Color *create_color();
extern void destroy_color();
extern Vector *create_vector();
extern void destroy_vector();
extern Vnode *create_vnode();
extern void destroy_vnode();
extern Model *create_model();
extern void destroy_model();
