/****************************************************************************
 * random_flts.h
 * Author Joel Welling
 * Copyright 1991, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/
/* This module just provides a set of floating point numbers for test
 * purposes, which is consistent across platforms.
 */

#define NUM_RANDOM_FLTS 3001
static float random_flts[ NUM_RANDOM_FLTS ]= {
  0.968071, 0.066731, 0.478281, 0.909534, 
  0.351692, 0.932534, 0.654436, 0.021070, 
  0.512205, 0.202019, 0.939977, 0.204082, 
  0.378829, 0.793114, 0.288201, 0.267157, 
  0.356823, 0.128374, 0.703298, 0.737414, 
  0.802521, 0.915231, 0.511382, 0.762057, 
  0.456381, 0.471062, 0.299550, 0.612559, 
  0.073381, 0.498185, 0.219587, 0.041452, 
  0.564916, 0.697869, 0.950986, 0.916608, 
  0.630402, 0.605422, 0.937679, 0.142607, 
  0.807441, 0.877656, 0.346689, 0.186270, 
  0.670770, 0.634890, 0.453427, 0.027592, 
  0.763264, 0.156725, 0.765006, 0.565785, 
  0.071955, 0.276388, 0.327842, 0.528337, 
  0.747450, 0.627392, 0.140896, 0.820830, 
  0.125578, 0.360484, 0.862282, 0.690494, 
  0.058352, 0.813269, 0.607102, 0.688755, 
  0.418691, 0.544781, 0.831362, 0.226132, 
  0.422436, 0.178051, 0.412402, 0.093206, 
  0.812941, 0.865829, 0.120798, 0.576205, 
  0.022554, 0.885804, 0.141990, 0.094509, 
  0.162192, 0.469832, 0.622846, 0.909641, 
  0.097224, 0.763742, 0.730472, 0.222802, 
  0.124226, 0.592754, 0.913296, 0.182578, 
  0.406023, 0.520398, 0.871333, 0.824714, 
  0.065179, 0.702694, 0.050846, 0.487616, 
  0.880745, 0.463248, 0.580822, 0.693687, 
  0.329077, 0.701620, 0.269892, 0.351630, 
  0.587424, 0.411881, 0.446139, 0.749616, 
  0.881713, 0.068985, 0.659257, 0.978938, 
  0.832727, 0.389728, 0.201740, 0.956953, 
  0.982482, 0.115036, 0.139531, 0.388505, 
  0.635435, 0.010864, 0.213218, 0.700614, 
  0.713558, 0.264064, 0.188229, 0.594304, 
  0.727312, 0.769051, 0.287990, 0.056388, 
  0.470671, 0.557882, 0.408019, 0.058095, 
  0.969763, 0.854158, 0.807710, 0.851476, 
  0.923143, 0.466967, 0.830414, 0.755871, 
  0.856696, 0.032154, 0.712824, 0.839178, 
  0.147190, 0.852355, 0.227683, 0.782625, 
  0.863219, 0.440901, 0.483239, 0.576777, 
  0.704965, 0.671468, 0.171081, 0.432277, 
  0.440519, 0.459071, 0.488665, 0.911190, 
  0.016953, 0.896684, 0.969284, 0.986716, 
  0.750842, 0.776995, 0.838192, 0.673985, 
  0.243962, 0.668606, 0.429856, 0.100658, 
  0.700760, 0.142679, 0.939836, 0.847951, 
  0.995034, 0.167518, 0.630575, 0.858253, 
  0.608419, 0.113814, 0.435030, 0.313384, 
  0.785282, 0.606111, 0.745661, 0.225801, 
  0.065182, 0.234326, 0.136990, 0.082135, 
  0.131010, 0.106275, 0.068851, 0.881852, 
  0.883270, 0.907044, 0.555837, 0.127232, 
  0.575650, 0.985693, 0.227890, 0.276410, 
  0.128372, 0.167725, 0.124361, 0.123406, 
  0.335244, 0.754936, 0.981659, 0.943663, 
  0.868750, 0.416690, 0.257048, 0.654032, 
  0.022801, 0.002708, 0.879832, 0.087983, 
  0.237034, 0.016822, 0.170118, 0.368044, 
  0.123097, 0.238970, 0.249896, 0.006367, 
  0.146013, 0.805733, 0.133598, 0.721663, 
  0.791425, 0.361488, 0.998073, 0.919797, 
  0.529213, 0.122434, 0.043203, 0.864457, 
  0.877370, 0.024863, 0.808120, 0.746120, 
  0.441552, 0.065167, 0.400152, 0.464353, 
  0.067876, 0.279984, 0.552336, 0.304910, 
  0.296806, 0.722454, 0.672955, 0.419903, 
  0.961424, 0.922851, 0.426270, 0.107437, 
  0.728583, 0.559868, 0.829100, 0.520009, 
  0.921356, 0.827174, 0.439806, 0.450569, 
  0.949608, 0.483009, 0.315026, 0.826978, 
  0.507872, 0.123146, 0.573098, 0.949424, 
  0.188313, 0.973250, 0.413777, 0.256189, 
  0.253234, 0.966114, 0.561099, 0.550040, 
  0.688568, 0.234054, 0.969943, 0.649992, 
  0.156904, 0.396213, 0.757429, 0.885488, 
  0.956081, 0.586530, 0.405496, 0.877438, 
  0.413704, 0.845302, 0.328007, 0.363311, 
  0.328312, 0.643033, 0.190289, 0.836184, 
  0.766178, 0.763387, 0.785608, 0.954491, 
  0.736637, 0.199386, 0.210680, 0.989870, 
  0.165499, 0.771779, 0.539910, 0.854067, 
  0.005833, 0.509853, 0.504059, 0.162737, 
  0.906067, 0.261489, 0.048225, 0.862148, 
  0.848019, 0.453721, 0.739586, 0.261722, 
  0.299024, 0.067592, 0.625034, 0.627336, 
  0.710625, 0.815323, 0.463520, 0.476803, 
  0.578710, 0.249128, 0.431294, 0.315347, 
  0.448514, 0.641975, 0.305217, 0.614013, 
  0.413754, 0.845127, 0.468081, 0.419587, 
  0.354981, 0.972140, 0.582324, 0.261047, 
  0.233629, 0.630549, 0.123195, 0.081647, 
  0.084271, 0.862781, 0.343369, 0.383294, 
  0.930373, 0.968403, 0.010630, 0.640998, 
  0.783726, 0.474150, 0.117801, 0.362436, 
  0.723278, 0.549095, 0.677783, 0.171792, 
  0.191070, 0.983000, 0.785805, 0.604824, 
  0.828127, 0.253885, 0.024411, 0.183108, 
  0.226025, 0.606735, 0.444155, 0.459654, 
  0.237285, 0.567350, 0.541301, 0.321555, 
  0.430131, 0.884671, 0.704850, 0.360504, 
  0.853074, 0.715479, 0.001502, 0.636800, 
  0.189629, 0.119303, 0.999236, 0.912907, 
  0.668399, 0.677019, 0.084698, 0.859469, 
  0.660019, 0.870503, 0.464293, 0.488147, 
  0.124388, 0.488704, 0.671255, 0.350414, 
  0.095439, 0.115410, 0.810068, 0.332724, 
  0.682760, 0.351369, 0.654279, 0.112892, 
  0.236040, 0.359128, 0.473396, 0.089114, 
  0.074608, 0.474898, 0.725914, 0.264237, 
  0.594201, 0.725150, 0.177144, 0.262600, 
  0.402168, 0.261842, 0.122068, 0.062188, 
  0.132345, 0.586361, 0.550334, 0.256733, 
  0.075065, 0.221589, 0.607147, 0.170504, 
  0.336998, 0.417215, 0.503227, 0.019759, 
  0.768584, 0.157506, 0.132650, 0.004624, 
  0.516635, 0.606046, 0.093738, 0.591243, 
  0.080944, 0.819651, 0.855480, 0.675145, 
  0.544801, 0.032623, 0.937745, 0.946969, 
  0.294465, 0.059814, 0.009157, 0.426810, 
  0.646175, 0.559491, 0.683543, 0.721239, 
  0.781080, 0.290690, 0.891743, 0.118078, 
  0.707905, 0.394970, 0.137837, 0.476489, 
  0.552477, 0.270487, 0.481113, 0.069111, 
  0.876533, 0.574850, 0.660354, 0.957478, 
  0.394502, 0.515834, 0.632623, 0.939303, 
  0.548457, 0.570368, 0.886272, 0.842922, 
  0.630182, 0.895429, 0.269731, 0.276356, 
  0.454920, 0.953274, 0.997596, 0.235999, 
  0.243964, 0.889339, 0.354077, 0.951868, 
  0.284309, 0.491914, 0.428357, 0.836786, 
  0.762401, 0.909470, 0.905897, 0.638935, 
  0.484320, 0.566252, 0.596412, 0.878822, 
  0.082085, 0.229035, 0.818124, 0.630542, 
  0.799403, 0.704396, 0.473464, 0.429585, 
  0.599825, 0.743195, 0.705942, 0.054745, 
  0.696469, 0.703537, 0.290744, 0.940432, 
  0.592876, 0.644822, 0.892301, 0.877185, 
  0.136736, 0.320658, 0.713971, 0.899137, 
  0.230128, 0.619869, 0.538072, 0.714448, 
  0.186121, 0.134484, 0.593270, 0.268206, 
  0.363520, 0.411395, 0.898748, 0.162923, 
  0.115791, 0.372211, 0.592508, 0.715616, 
  0.115406, 0.298450, 0.770361, 0.811875, 
  0.001987, 0.061105, 0.752307, 0.594863, 
  0.705927, 0.644608, 0.472048, 0.842662, 
  0.965266, 0.186020, 0.741800, 0.195394, 
  0.805889, 0.279872, 0.909843, 0.992009, 
  0.414356, 0.503113, 0.260215, 0.777875, 
  0.914507, 0.158963, 0.940798, 0.030298, 
  0.531174, 0.533306, 0.745914, 0.646580, 
  0.831756, 0.516275, 0.458455, 0.833743, 
  0.577380, 0.210762, 0.428606, 0.283307, 
  0.855370, 0.900654, 0.125969, 0.820637, 
  0.086674, 0.867769, 0.016031, 0.892563, 
  0.147641, 0.925873, 0.884573, 0.561997, 
  0.428986, 0.144788, 0.339872, 0.343493, 
  0.303750, 0.280670, 0.373792, 0.834924, 
  0.813977, 0.119706, 0.481504, 0.645733, 
  0.635982, 0.939959, 0.479475, 0.213362, 
  0.150721, 0.908081, 0.496669, 0.006091, 
  0.808735, 0.622639, 0.826728, 0.895409, 
  0.490408, 0.842759, 0.787973, 0.638049, 
  0.768632, 0.672545, 0.200045, 0.197618, 
  0.817333, 0.539917, 0.541112, 0.121083, 
  0.820587, 0.914904, 0.956007, 0.634564, 
  0.034610, 0.437512, 0.280297, 0.670592, 
  0.377471, 0.759772, 0.883954, 0.528192, 
  0.667853, 0.380623, 0.534284, 0.476588, 
  0.003262, 0.361011, 0.371997, 0.493670, 
  0.203770, 0.159970, 0.131718, 0.972402, 
  0.832515, 0.331763, 0.170020, 0.649848, 
  0.871680, 0.711132, 0.770931, 0.692268, 
  0.626036, 0.726938, 0.326832, 0.660645, 
  0.164450, 0.607129, 0.331237, 0.541921, 
  0.366900, 0.215191, 0.070113, 0.034753, 
  0.595814, 0.604397, 0.511341, 0.599075, 
  0.965408, 0.883339, 0.092745, 0.169178, 
  0.043309, 0.224463, 0.141580, 0.875823, 
  0.556226, 0.311600, 0.525671, 0.427907, 
  0.022732, 0.296602, 0.120175, 0.648768, 
  0.023540, 0.447007, 0.309413, 0.187989, 
  0.054135, 0.640650, 0.729910, 0.421036, 
  0.855841, 0.800023, 0.455789, 0.451654, 
  0.404420, 0.967130, 0.050730, 0.369828, 
  0.850468, 0.143475, 0.539006, 0.893777, 
  0.367938, 0.680585, 0.769600, 0.924164, 
  0.992186, 0.295271, 0.352071, 0.014918, 
  0.591873, 0.472246, 0.663686, 0.615413, 
  0.919253, 0.973099, 0.803402, 0.973388, 
  0.613749, 0.533312, 0.394423, 0.469589, 
  0.333336, 0.850212, 0.921244, 0.737755, 
  0.817342, 0.971973, 0.107583, 0.667810, 
  0.115448, 0.646588, 0.561587, 0.483386, 
  0.327174, 0.331188, 0.407550, 0.319360, 
  0.626459, 0.759621, 0.334278, 0.218332, 
  0.231866, 0.997963, 0.833745, 0.151119, 
  0.971062, 0.637147, 0.124507, 0.584811, 
  0.170459, 0.518930, 0.054400, 0.503795, 
  0.369142, 0.975644, 0.241550, 0.186484, 
  0.947617, 0.349133, 0.854294, 0.063065, 
  0.995722, 0.415882, 0.546451, 0.322895, 
  0.747069, 0.954001, 0.642255, 0.373528, 
  0.713621, 0.976533, 0.591860, 0.945488, 
  0.974496, 0.425605, 0.096607, 0.945558, 
  0.062752, 0.221114, 0.530368, 0.233211, 
  0.740044, 0.584768, 0.737006, 0.109186, 
  0.560412, 0.978556, 0.295670, 0.508029, 
  0.327689, 0.149964, 0.571094, 0.323410, 
  0.565846, 0.117545, 0.646306, 0.312915, 
  0.071546, 0.288561, 0.686443, 0.785167, 
  0.265094, 0.278304, 0.730655, 0.239589, 
  0.703909, 0.827262, 0.185147, 0.766661, 
  0.048375, 0.715515, 0.999872, 0.788419, 
  0.300283, 0.736877, 0.897605, 0.860695, 
  0.715433, 0.193275, 0.368724, 0.043122, 
  0.343239, 0.939818, 0.366532, 0.909085, 
  0.057363, 0.012838, 0.222000, 0.128909, 
  0.301399, 0.908443, 0.914076, 0.566493, 
  0.186746, 0.644731, 0.806082, 0.890655, 
  0.471993, 0.991229, 0.657316, 0.520368, 
  0.706744, 0.657187, 0.308787, 0.007027, 
  0.394065, 0.206391, 0.867722, 0.109498, 
  0.399666, 0.236447, 0.152620, 0.742904, 
  0.176265, 0.519152, 0.651989, 0.233628, 
  0.531990, 0.873989, 0.362538, 0.833389, 
  0.782432, 0.276614, 0.399882, 0.969178, 
  0.921345, 0.205964, 0.859833, 0.393338, 
  0.197192, 0.517149, 0.913705, 0.903937, 
  0.174336, 0.222492, 0.910964, 0.568401, 
  0.428883, 0.778686, 0.677898, 0.828549, 
  0.015133, 0.830518, 0.571453, 0.191398, 
  0.349670, 0.223443, 0.425026, 0.881660, 
  0.097431, 0.787564, 0.715049, 0.879863, 
  0.064177, 0.114931, 0.849041, 0.985522, 
  0.320895, 0.708874, 0.378860, 0.518087, 
  0.226023, 0.292566, 0.422024, 0.400359, 
  0.515058, 0.332988, 0.968759, 0.943941, 
  0.111674, 0.646658, 0.772490, 0.126807, 
  0.477176, 0.343943, 0.318205, 0.826846, 
  0.567386, 0.743231, 0.708506, 0.664817, 
  0.530794, 0.423555, 0.544680, 0.594972, 
  0.538486, 0.393721, 0.580494, 0.859381, 
  0.102595, 0.959354, 0.377468, 0.328618, 
  0.251920, 0.799492, 0.728976, 0.766977, 
  0.132480, 0.697736, 0.710918, 0.244153, 
  0.344394, 0.483408, 0.370960, 0.821570, 
  0.827351, 0.689165, 0.648415, 0.394737, 
  0.432395, 0.356921, 0.059554, 0.963190, 
  0.780477, 0.604234, 0.558161, 0.318963, 
  0.997955, 0.138656, 0.178345, 0.100549, 
  0.098010, 0.555813, 0.429167, 0.349930, 
  0.355305, 0.158143, 0.116907, 0.487785, 
  0.855879, 0.827825, 0.731938, 0.200273, 
  0.311233, 0.102899, 0.021842, 0.138584, 
  0.792063, 0.670258, 0.533321, 0.224459, 
  0.027179, 0.592875, 0.187648, 0.807656, 
  0.197109, 0.745810, 0.126620, 0.195063, 
  0.884466, 0.304964, 0.295613, 0.982475, 
  0.860777, 0.724780, 0.332405, 0.216082, 
  0.882923, 0.449312, 0.703867, 0.738802, 
  0.277137, 0.435805, 0.939075, 0.588370, 
  0.538704, 0.960918, 0.726954, 0.330767, 
  0.631175, 0.260274, 0.555226, 0.658355, 
  0.853149, 0.742874, 0.466011, 0.050258, 
  0.488684, 0.592631, 0.245321, 0.373150, 
  0.897595, 0.540934, 0.355625, 0.758372, 
  0.265713, 0.688030, 0.974454, 0.148636, 
  0.137342, 0.678321, 0.887438, 0.414479, 
  0.114127, 0.826514, 0.002849, 0.652830, 
  0.787431, 0.729802, 0.983598, 0.418607, 
  0.990077, 0.538823, 0.076961, 0.843226, 
  0.281698, 0.542972, 0.893484, 0.770382, 
  0.135603, 0.138805, 0.143532, 0.033198, 
  0.679738, 0.499157, 0.791570, 0.945452, 
  0.187188, 0.766024, 0.094088, 0.324530, 
  0.444345, 0.981526, 0.739009, 0.558472, 
  0.808040, 0.741858, 0.211302, 0.595471, 
  0.471660, 0.194899, 0.014078, 0.461737, 
  0.733723, 0.091039, 0.304963, 0.015421, 
  0.634012, 0.198446, 0.785803, 0.769615, 
  0.337251, 0.929335, 0.802813, 0.016989, 
  0.428492, 0.594382, 0.962441, 0.615680, 
  0.360406, 0.056529, 0.940210, 0.804751, 
  0.038055, 0.679219, 0.363223, 0.846095, 
  0.421077, 0.574525, 0.441566, 0.892738, 
  0.769424, 0.455644, 0.354474, 0.503147, 
  0.546683, 0.659437, 0.518568, 0.180695, 
  0.857883, 0.304370, 0.950310, 0.195134, 
  0.233705, 0.753122, 0.212123, 0.662197, 
  0.347505, 0.174564, 0.277877, 0.707911, 
  0.231093, 0.218088, 0.512662, 0.269148, 
  0.897307, 0.875884, 0.115243, 0.318384, 
  0.450409, 0.556809, 0.211122, 0.219833, 
  0.012454, 0.565596, 0.722980, 0.559137, 
  0.225033, 0.241547, 0.739832, 0.082917, 
  0.545918, 0.690142, 0.278051, 0.779623, 
  0.443265, 0.490174, 0.441820, 0.790769, 
  0.664738, 0.719697, 0.498680, 0.895831, 
  0.937785, 0.011342, 0.164979, 0.835092, 
  0.887226, 0.280222, 0.153476, 0.337635, 
  0.837032, 0.364598, 0.557468, 0.849485, 
  0.930194, 0.280448, 0.408622, 0.155228, 
  0.521995, 0.148455, 0.238145, 0.067913, 
  0.838597, 0.516195, 0.847536, 0.281861, 
  0.006370, 0.289356, 0.072631, 0.671108, 
  0.009053, 0.571310, 0.566939, 0.946837, 
  0.582652, 0.731918, 0.781929, 0.469878, 
  0.012140, 0.935405, 0.807513, 0.849171, 
  0.300003, 0.364981, 0.698656, 0.230198, 
  0.645428, 0.107279, 0.385426, 0.167424, 
  0.255733, 0.623570, 0.235337, 0.094330, 
  0.139766, 0.082872, 0.376191, 0.146135, 
  0.372228, 0.448822, 0.817243, 0.381281, 
  0.020132, 0.384182, 0.328118, 0.602784, 
  0.116099, 0.110047, 0.072662, 0.128239, 
  0.045452, 0.880175, 0.977410, 0.345456, 
  0.245155, 0.676067, 0.575653, 0.890584, 
  0.783345, 0.961079, 0.058007, 0.039079, 
  0.584649, 0.293344, 0.133409, 0.724415, 
  0.376216, 0.509600, 0.870550, 0.748444, 
  0.958422, 0.687793, 0.129725, 0.978554, 
  0.071975, 0.457843, 0.581339, 0.188074, 
  0.567890, 0.654001, 0.316313, 0.613342, 
  0.534176, 0.293723, 0.958798, 0.779331, 
  0.969790, 0.534451, 0.669915, 0.753135, 
  0.495530, 0.727922, 0.792214, 0.080180, 
  0.021266, 0.925622, 0.804595, 0.397483, 
  0.435223, 0.675145, 0.145927, 0.393645, 
  0.362938, 0.275652, 0.372199, 0.434913, 
  0.733495, 0.953538, 0.622987, 0.301385, 
  0.607539, 0.939300, 0.914727, 0.141715, 
  0.233023, 0.873525, 0.921046, 0.202813, 
  0.407976, 0.590961, 0.955949, 0.903506, 
  0.318883, 0.748162, 0.983686, 0.340149, 
  0.673785, 0.788281, 0.737632, 0.109007, 
  0.463425, 0.883559, 0.502652, 0.826364, 
  0.159211, 0.874851, 0.261276, 0.892705, 
  0.828389, 0.884263, 0.194090, 0.435927, 
  0.823564, 0.108817, 0.577642, 0.056587, 
  0.982342, 0.498688, 0.259400, 0.390318, 
  0.089648, 0.215349, 0.293824, 0.408531, 
  0.963511, 0.277510, 0.748681, 0.637296, 
  0.065791, 0.486313, 0.746304, 0.529216, 
  0.369872, 0.248956, 0.355580, 0.529082, 
  0.123806, 0.616856, 0.421788, 0.952195, 
  0.501120, 0.615878, 0.388123, 0.324683, 
  0.724695, 0.965765, 0.381270, 0.707036, 
  0.464452, 0.640671, 0.097354, 0.554101, 
  0.856019, 0.391178, 0.962632, 0.819531, 
  0.668688, 0.711313, 0.456827, 0.734479, 
  0.197625, 0.203131, 0.263695, 0.567497, 
  0.452086, 0.619275, 0.096579, 0.575893, 
  0.236131, 0.518367, 0.528088, 0.737251, 
  0.134245, 0.916210, 0.061934, 0.858940, 
  0.881975, 0.443204, 0.565976, 0.346427, 
  0.083874, 0.663330, 0.900528, 0.939894, 
  0.054508, 0.863160, 0.759425, 0.723196, 
  0.574473, 0.216252, 0.457675, 0.772099, 
  0.419382, 0.721370, 0.339596, 0.871468, 
  0.340645, 0.436175, 0.447361, 0.576777, 
  0.954542, 0.975449, 0.314027, 0.088787, 
  0.891659, 0.375961, 0.947727, 0.773634, 
  0.819165, 0.513703, 0.120062, 0.903040, 
  0.177033, 0.020590, 0.842934, 0.231541, 
  0.883750, 0.602358, 0.954737, 0.458223, 
  0.818610, 0.412412, 0.230322, 0.237992, 
  0.133782, 0.569918, 0.109461, 0.474428, 
  0.006093, 0.556821, 0.051204, 0.960636, 
  0.532270, 0.365232, 0.049423, 0.423929, 
  0.741193, 0.997150, 0.197563, 0.560358, 
  0.510853, 0.317625, 0.463398, 0.687885, 
  0.338215, 0.306331, 0.919426, 0.221965, 
  0.908689, 0.874163, 0.680188, 0.727300, 
  0.286575, 0.910510, 0.965292, 0.420357, 
  0.480428, 0.074752, 0.894785, 0.486521, 
  0.631574, 0.945989, 0.447157, 0.163844, 
  0.311221, 0.496580, 0.587773, 0.052414, 
  0.493730, 0.785336, 0.612772, 0.004583, 
  0.102961, 0.076170, 0.692468, 0.441175, 
  0.382501, 0.611894, 0.663140, 0.291191, 
  0.486057, 0.343329, 0.018490, 0.772631, 
  0.253839, 0.983782, 0.192988, 0.734268, 
  0.058534, 0.087773, 0.220789, 0.690108, 
  0.033762, 0.667946, 0.853952, 0.344983, 
  0.164526, 0.441724, 0.397397, 0.658256, 
  0.227060, 0.010170, 0.662839, 0.330021, 
  0.086339, 0.355307, 0.771196, 0.468841, 
  0.967201, 0.434336, 0.760032, 0.453257, 
  0.777665, 0.778522, 0.225889, 0.031504, 
  0.762304, 0.418877, 0.765772, 0.820838, 
  0.506650, 0.986561, 0.510946, 0.540412, 
  0.654507, 0.364898, 0.885395, 0.819033, 
  0.806622, 0.282792, 0.477289, 0.033682, 
  0.292962, 0.140128, 0.363702, 0.379301, 
  0.495434, 0.134899, 0.848142, 0.462635, 
  0.569235, 0.608174, 0.915893, 0.346900, 
  0.386695, 0.141781, 0.378404, 0.148999, 
  0.560658, 0.144176, 0.969837, 0.067308, 
  0.130737, 0.480783, 0.607720, 0.785244, 
  0.845681, 0.493115, 0.604277, 0.652302, 
  0.775907, 0.081566, 0.685984, 0.068869, 
  0.221694, 0.049687, 0.448170, 0.717129, 
  0.184585, 0.296312, 0.179764, 0.753820, 
  0.904486, 0.095656, 0.100720, 0.291181, 
  0.237438, 0.479125, 0.440180, 0.798096, 
  0.623301, 0.410017, 0.865404, 0.754038, 
  0.890800, 0.473123, 0.539282, 0.736481, 
  0.966238, 0.143559, 0.388784, 0.742145, 
  0.225126, 0.074768, 0.811014, 0.446820, 
  0.124454, 0.259184, 0.163948, 0.309040, 
  0.555496, 0.343712, 0.062860, 0.459982, 
  0.439368, 0.163580, 0.751163, 0.676806, 
  0.642705, 0.191343, 0.474902, 0.266006, 
  0.601360, 0.340305, 0.020044, 0.492160, 
  0.813429, 0.559326, 0.228641, 0.779667, 
  0.702886, 0.617425, 0.521812, 0.928011, 
  0.692192, 0.332825, 0.374831, 0.816647, 
  0.592009, 0.538779, 0.125687, 0.147505, 
  0.882491, 0.188547, 0.607487, 0.321860, 
  0.352127, 0.358649, 0.998666, 0.994832, 
  0.549992, 0.473567, 0.260838, 0.151352, 
  0.813872, 0.280882, 0.643512, 0.627301, 
  0.840208, 0.872153, 0.406968, 0.543094, 
  0.489578, 0.928779, 0.471105, 0.181770, 
  0.261604, 0.845936, 0.998417, 0.853614, 
  0.384716, 0.124104, 0.001119, 0.267207, 
  0.312650, 0.608605, 0.589067, 0.664777, 
  0.967255, 0.587732, 0.659609, 0.517246, 
  0.061299, 0.920447, 0.668598, 0.875172, 
  0.201329, 0.312109, 0.502473, 0.041537, 
  0.184262, 0.909440, 0.584631, 0.673840, 
  0.838220, 0.055737, 0.855610, 0.099824, 
  0.901673, 0.854027, 0.953438, 0.286389, 
  0.978130, 0.954556, 0.553596, 0.290780, 
  0.563162, 0.142663, 0.955558, 0.530416, 
  0.730395, 0.615167, 0.047663, 0.791694, 
  0.535614, 0.716260, 0.666866, 0.736943, 
  0.028370, 0.169339, 0.778480, 0.212632, 
  0.078779, 0.363111, 0.886472, 0.916999, 
  0.418848, 0.742082, 0.016823, 0.320521, 
  0.596108, 0.970260, 0.606910, 0.574238, 
  0.924817, 0.160506, 0.865019, 0.487978, 
  0.303168, 0.820577, 0.018395, 0.033563, 
  0.435743, 0.066057, 0.825257, 0.971357, 
  0.782318, 0.492123, 0.708300, 0.810687, 
  0.661462, 0.486780, 0.023319, 0.740242, 
  0.849892, 0.909791, 0.657240, 0.268740, 
  0.651873, 0.674063, 0.589261, 0.247981, 
  0.644324, 0.196170, 0.822219, 0.569140, 
  0.356676, 0.687238, 0.057119, 0.659845, 
  0.507815, 0.075513, 0.693408, 0.943558, 
  0.141570, 0.518665, 0.914915, 0.923888, 
  0.010788, 0.623215, 0.734575, 0.672251, 
  0.109996, 0.757895, 0.412492, 0.959887, 
  0.667686, 0.069733, 0.228627, 0.319559, 
  0.743796, 0.817887, 0.567540, 0.388120, 
  0.014058, 0.389759, 0.957260, 0.370734, 
  0.076998, 0.014379, 0.030579, 0.584812, 
  0.089892, 0.723986, 0.528371, 0.231462, 
  0.242651, 0.443286, 0.155350, 0.253440, 
  0.066501, 0.889926, 0.925690, 0.176497, 
  0.647821, 0.338183, 0.136384, 0.315507, 
  0.407915, 0.365011, 0.635066, 0.151711, 
  0.182898, 0.202605, 0.539831, 0.196956, 
  0.592365, 0.497091, 0.567690, 0.669362, 
  0.511469, 0.598269, 0.254175, 0.601362, 
  0.322255, 0.782545, 0.832824, 0.564906, 
  0.225831, 0.988174, 0.818346, 0.292333, 
  0.878100, 0.744036, 0.468830, 0.525921, 
  0.082219, 0.605214, 0.841427, 0.490134, 
  0.970225, 0.476493, 0.641845, 0.153123, 
  0.679098, 0.181676, 0.350079, 0.271463, 
  0.678767, 0.917769, 0.940826, 0.190236, 
  0.516038, 0.195000, 0.791598, 0.838293, 
  0.977546, 0.624422, 0.403199, 0.203377, 
  0.612596, 0.221544, 0.495710, 0.490696, 
  0.965581, 0.964540, 0.016617, 0.047800, 
  0.569753, 0.858044, 0.537934, 0.539978, 
  0.334537, 0.179779, 0.693101, 0.013635, 
  0.361455, 0.043180, 0.285098, 0.040221, 
  0.960949, 0.225924, 0.230458, 0.476987, 
  0.420924, 0.022055, 0.315279, 0.398470, 
  0.646477, 0.718478, 0.601848, 0.259073, 
  0.940022, 0.097558, 0.749769, 0.905603, 
  0.062097, 0.766385, 0.953403, 0.631851, 
  0.624430, 0.491336, 0.171829, 0.958966, 
  0.671115, 0.864930, 0.972602, 0.032570, 
  0.908110, 0.257700, 0.072791, 0.869059, 
  0.483624, 0.303249, 0.346046, 0.904548, 
  0.325304, 0.661325, 0.303019, 0.971781, 
  0.379803, 0.904866, 0.230853, 0.319825, 
  0.002424, 0.980622, 0.225429, 0.064521, 
  0.747007, 0.178831, 0.696372, 0.371437, 
  0.670167, 0.868200, 0.330404, 0.341282, 
  0.733130, 0.303005, 0.373852, 0.641239, 
  0.560705, 0.446644, 0.510298, 0.044329, 
  0.749893, 0.856344, 0.948878, 0.075197, 
  0.517669, 0.251897, 0.046978, 0.897472, 
  0.156763, 0.277831, 0.217297, 0.159187, 
  0.258453, 0.442726, 0.223708, 0.005461, 
  0.621557, 0.920079, 0.376898, 0.291724, 
  0.788280, 0.707301, 0.633007, 0.521409, 
  0.010307, 0.006859, 0.162649, 0.571012, 
  0.453503, 0.672947, 0.615342, 0.203396, 
  0.529291, 0.564219, 0.278593, 0.046959, 
  0.816116, 0.325571, 0.944431, 0.972879, 
  0.603402, 0.161728, 0.132066, 0.861855, 
  0.604454, 0.355773, 0.867316, 0.226011, 
  0.275853, 0.244214, 0.517735, 0.064132, 
  0.951515, 0.150742, 0.585542, 0.961822, 
  0.157601, 0.748190, 0.532834, 0.611105, 
  0.421137, 0.148176, 0.814501, 0.950428, 
  0.712395, 0.093094, 0.997387, 0.528511, 
  0.418665, 0.941818, 0.501390, 0.022067, 
  0.103547, 0.633456, 0.883922, 0.708001, 
  0.989229, 0.751238, 0.934012, 0.265082, 
  0.995452, 0.451748, 0.329214, 0.946968, 
  0.602490, 0.914756, 0.908790, 0.760091, 
  0.662947, 0.441624, 0.371196, 0.084084, 
  0.589800, 0.185697, 0.034512, 0.302195, 
  0.278790, 0.031899, 0.830706, 0.697455, 
  0.973717, 0.332097, 0.719522, 0.077264, 
  0.965552, 0.603444, 0.785265, 0.954781, 
  0.354683, 0.719278, 0.219863, 0.350135, 
  0.171025, 0.549078, 0.297103, 0.773516, 
  0.463834, 0.205893, 0.533607, 0.126780, 
  0.647517, 0.904803, 0.210864, 0.237317, 
  0.090500, 0.245376, 0.539512, 0.369290, 
  0.277275, 0.370218, 0.066745, 0.250992, 
  0.702315, 0.786268, 0.328257, 0.667867, 
  0.389712, 0.113522, 0.622649, 0.744395, 
  0.832800, 0.842512, 0.094530, 0.003825, 
  0.391589, 0.391632, 0.777341, 0.855423, 
  0.597525, 0.310948, 0.982203, 0.245042, 
  0.215751, 0.193068, 0.482358, 0.306250, 
  0.438444, 0.021870, 0.675541, 0.715718, 
  0.392088, 0.742286, 0.966711, 0.094403, 
  0.528554, 0.294967, 0.762270, 0.918266, 
  0.408489, 0.384919, 0.662660, 0.241289, 
  0.227430, 0.757190, 0.245114, 0.619020, 
  0.148823, 0.022454, 0.474443, 0.746348, 
  0.333402, 0.456647, 0.991389, 0.549153, 
  0.649714, 0.473748, 0.855403, 0.088158, 
  0.495618, 0.530944, 0.803876, 0.887706, 
  0.273230, 0.770587, 0.982109, 0.801784, 
  0.065554, 0.744379, 0.720049, 0.474043, 
  0.129297, 0.382710, 0.715332, 0.356728, 
  0.139900, 0.960446, 0.975748, 0.288722, 
  0.982900, 0.450191, 0.035070, 0.316303, 
  0.906838, 0.026459, 0.865455, 0.556552, 
  0.500207, 0.720858, 0.644710, 0.995824, 
  0.251802, 0.448586, 0.883530, 0.525032, 
  0.219173, 0.865639, 0.326816, 0.284727, 
  0.610018, 0.046865, 0.758770, 0.739315, 
  0.429575, 0.474102, 0.096043, 0.569475, 
  0.434548, 0.071791, 0.858197, 0.417449, 
  0.521982, 0.893267, 0.733751, 0.428819, 
  0.919726, 0.599206, 0.985371, 0.419933, 
  0.320065, 0.630081, 0.415758, 0.571867, 
  0.078666, 0.299288, 0.096900, 0.297839, 
  0.164927, 0.423716, 0.582566, 0.774945, 
  0.470581, 0.341336, 0.514260, 0.900156, 
  0.815438, 0.610303, 0.469631, 0.249987, 
  0.682093, 0.327828, 0.667435, 0.204075, 
  0.221095, 0.401186, 0.632894, 0.140822, 
  0.000392, 0.618265, 0.560755, 0.320457, 
  0.248346, 0.976513, 0.892324, 0.327012, 
  0.275801, 0.989224, 0.624851, 0.440727, 
  0.412939, 0.207417, 0.215672, 0.883520, 
  0.548753, 0.729932, 0.783677, 0.364192, 
  0.340234, 0.253308, 0.614178, 0.022328, 
  0.581136, 0.281613, 0.226403, 0.802232, 
  0.682799, 0.859297, 0.943053, 0.683192, 
  0.477562, 0.503808, 0.003649, 0.725908, 
  0.480321, 0.895973, 0.052920, 0.756122, 
  0.885197, 0.677771, 0.196849, 0.298136, 
  0.885188, 0.412521, 0.181657, 0.433941, 
  0.142453, 0.965334, 0.798133, 0.482687, 
  0.218641, 0.412311, 0.505015, 0.799778, 
  0.693924, 0.731418, 0.602009, 0.376723, 
  0.590715, 0.545063, 0.059915, 0.068278, 
  0.048871, 0.063563, 0.794186, 0.529192, 
  0.959537, 0.847106, 0.285314, 0.844733, 
  0.524877, 0.482163, 0.142870, 0.410066, 
  0.894684, 0.324527, 0.844007, 0.037137, 
  0.289860, 0.642140, 0.519824, 0.508502, 
  0.054451, 0.024839, 0.308279, 0.748375, 
  0.756257, 0.910289, 0.125098, 0.346973, 
  0.455351, 0.185012, 0.415251, 0.504222, 
  0.248576, 0.209437, 0.033414, 0.208112, 
  0.056543, 0.318727, 0.052846, 0.581420, 
  0.800890, 0.195716, 0.991486, 0.695574, 
  0.520243, 0.835493, 0.732711, 0.810103, 
  0.477633, 0.252535, 0.318605, 0.532084, 
  0.277374, 0.626884, 0.280458, 0.033632, 
  0.537173, 0.405556, 0.380604, 0.992524, 
  0.590568, 0.795855, 0.496746, 0.839144, 
  0.005292, 0.530160, 0.047257, 0.061835, 
  0.848888, 0.100103, 0.643255, 0.649778, 
  0.295818, 0.634741, 0.345351, 0.816061, 
  0.470234, 0.078062, 0.626164, 0.947867, 
  0.330597, 0.944769, 0.479950, 0.607971, 
  0.571653, 0.760408, 0.641603, 0.108826, 
  0.165964, 0.022207, 0.101350, 0.756533, 
  0.818062, 0.598096, 0.595677, 0.823354, 
  0.128256, 0.642934, 0.885188, 0.977144, 
  0.743036, 0.528443, 0.626921, 0.038855, 
  0.163184, 0.972273, 0.854916, 0.633418, 
  0.050335, 0.481079, 0.581285, 0.380932, 
  0.425848, 0.061235, 0.988903, 0.997501, 
  0.821643, 0.630506, 0.106327, 0.987607, 
  0.652713, 0.207677, 0.744140, 0.470775, 
  0.805773, 0.339817, 0.294128, 0.934030, 
  0.982751, 0.179317, 0.911174, 0.725787, 
  0.707760, 0.538095, 0.764642, 0.870944, 
  0.510368, 0.619557, 0.504362, 0.560703, 
  0.100637, 0.085647, 0.941635, 0.526485, 
  0.146882, 0.930538, 0.523986, 0.968525, 
  0.561044, 0.630313, 0.956132, 0.213756, 
  0.837990, 0.700273, 0.684531, 0.643764, 
  0.040090, 0.978659, 0.577793, 0.022840, 
  0.157976, 0.488967, 0.748627, 0.865736, 
  0.027062, 0.513269, 0.736681, 0.537430, 
  0.132826, 0.241043, 0.098134, 0.233463, 
  0.326690, 0.039769, 0.759948, 0.473572, 
  0.970307, 0.283934, 0.442097, 0.531351, 
  0.914247, 0.398230, 0.745107, 0.752237, 
  0.098502, 0.429638, 0.396001, 0.138592, 
  0.408297, 0.973794, 0.161432, 0.566273, 
  0.462761, 0.910060, 0.432010, 0.489823, 
  0.423329, 0.168690, 0.027254, 0.556155, 
  0.409733, 0.125387, 0.789618, 0.736424, 
  0.165156, 0.549567, 0.209996, 0.135463, 
  0.833501, 0.652093, 0.666814, 0.747748, 
  0.050322, 0.411921, 0.499985, 0.148825, 
  0.841559, 0.895986, 0.287416, 0.249856, 
  0.869780, 0.448848, 0.816129, 0.332542, 
  0.358908, 0.248139, 0.822365, 0.782237, 
  0.416829, 0.849619, 0.338392, 0.826563, 
  0.975006, 0.128010, 0.562986, 0.140162, 
  0.677577, 0.772982, 0.275625, 0.511077, 
  0.425075, 0.942439, 0.258825, 0.475398, 
  0.354360, 0.758811, 0.624222, 0.195919, 
  0.654797, 0.911638, 0.445776, 0.524577, 
  0.360487, 0.261905, 0.857119, 0.719394, 
  0.510044, 0.679484, 0.501631, 0.926873, 
  0.529102, 0.840023, 0.753435, 0.504109, 
  0.968033, 0.316422, 0.644271, 0.645610, 
  0.089404, 0.919896, 0.156687, 0.514479, 
  0.862336, 0.415513, 0.989877, 0.216696, 
  0.174323, 0.614099, 0.412616, 0.829120, 
  0.525737, 0.858391, 0.353697, 0.886224, 
  0.120296, 0.210816, 0.605618, 0.630340, 
  0.890299, 0.107249, 0.557213, 0.419402, 
  0.947272, 0.310648, 0.923510, 0.915305, 
  0.627070, 0.567781, 0.560915, 0.716474, 
  0.487677, 0.717603, 0.230953, 0.350013, 
  0.133115, 0.220830, 0.566709, 0.307439, 
  0.834928, 0.979325, 0.136559, 0.360666, 
  0.837716, 0.490256, 0.246889, 0.958012, 
  0.701071, 0.852507, 0.588352, 0.591371, 
  0.959757, 0.145565, 0.010772, 0.907029, 
  0.456214, 0.934283, 0.822334, 0.083284, 
  0.502064, 0.383249, 0.799758, 0.989741, 
  0.100852, 0.030711, 0.339754, 0.233967, 
  0.251541, 0.906464, 0.541406, 0.086469, 
  0.885789, 0.677965, 0.447135, 0.723505, 
  0.168220, 0.694024, 0.681517, 0.869291, 
  0.546531, 0.269870, 0.460662, 0.506288, 
  0.415435, 0.471434, 0.413317, 0.871649, 
  0.405717, 0.235651, 0.954933, 0.907781, 
  0.618900, 0.754690, 0.897522, 0.719752, 
  0.785401, 0.237277, 0.953719, 0.036942, 
  0.143741, 0.495125, 0.123411, 0.029529, 
  0.173090, 0.570546, 0.753034, 0.341310, 
  0.264570, 0.434551, 0.210602, 0.811101, 
  0.704421, 0.671264, 0.317390, 0.119856, 
  0.142698, 0.730707, 0.991505, 0.548415, 
  0.966358, 0.946437, 0.456196, 0.585258, 
  0.701128, 0.353719, 0.305010, 0.486529, 
  0.590995, 0.258730, 0.523471, 0.734736, 
  0.753855, 0.646882, 0.764265, 0.926945, 
  0.217428, 0.517300, 0.268255, 0.481998, 
  0.951851, 0.478856, 0.293100, 0.656272, 
  0.150120, 0.610489, 0.776128, 0.292818, 
  0.341196, 0.767633, 0.841233, 0.307553, 
  0.714070, 0.297429, 0.892812, 0.415198, 
  0.651148, 0.197822, 0.901727, 0.242144, 
  0.456551, 0.425198, 0.976880, 0.210406, 
  0.072081, 0.741145, 0.137351, 0.289509, 
  0.258445, 0.405606, 0.771507, 0.210296, 
  0.884463, 0.064607, 0.866567, 0.034582, 
  0.675096, 0.642695, 0.327400, 0.016292, 
  0.410328, 0.168634, 0.323845, 0.124398, 
  0.466063, 0.216657, 0.539596, 0.117211, 
  0.414479, 0.441323, 0.359354, 0.871030, 
  0.866521, 0.336234, 0.081437, 0.938601, 
  0.077379, 0.218788, 0.228111, 0.335824, 
  0.624394, 0.999618, 0.546119, 0.508857, 
  0.064225, 0.412687, 0.543439, 0.739321, 
  0.055382, 0.870839, 0.755613, 0.465710, 
  0.039473, 0.079458, 0.590108, 0.505536, 
  0.296115, 0.129704, 0.622747, 0.710594, 
  0.571026, 0.982102, 0.581625, 0.437547, 
  0.318336, 0.663061, 0.376149, 0.395715, 
  0.881849, 0.604259, 0.731539, 0.506243, 
  0.603877, 0.277658, 0.015100, 0.668102, 
  0.690345, 0.558539, 0.407423, 0.745727, 
  0.429378, 0.163036, 0.211438, 0.468851, 
  0.242494, 0.801546, 0.974387, 0.538610, 
  0.931250, 0.597134, 0.249204, 0.502276, 
  0.579236, 0.830828, 0.939823, 0.897572, 
  0.493890, 0.315972, 0.293286, 0.375739, 
  0.920231, 0.024825, 0.881982, 0.524108, 
  0.302483, 0.897081, 0.192210, 0.992828, 
  0.455620, 0.599633, 0.738555, 0.884998, 
  0.762669, 0.949993, 0.353850, 0.005163, 
  0.751539, 0.328237, 0.543772, 0.682789, 
  0.925371, 0.792976, 0.185065, 0.504607, 
  0.623805, 0.124889, 0.402179, 0.117694, 
  0.440861, 0.695465, 0.493433, 0.361092, 
  0.720290, 0.375415, 0.885200, 0.022773, 
  0.272496, 0.077410, 0.015602, 0.728116, 
  0.677043, 0.754157, 0.613115, 0.439711, 
  0.704150, 0.966964, 0.444874, 0.455689, 
  0.295201, 0.988647, 0.138479, 0.220573, 
  0.781623, 0.323544, 0.725180, 0.405428, 
  0.448433, 0.127359, 0.523122, 0.889294, 
  0.822825, 0.016555, 0.250386, 0.543115, 
  0.391970, 0.135586, 0.565889, 0.664466, 
  0.212996, 0.581490, 0.392582, 0.890038, 
  0.335647, 0.005697, 0.329750, 0.039797, 
  0.972662, 0.774624, 0.495487, 0.267863, 
  0.763270, 0.633965, 0.488436, 0.544893, 
  0.957509, 0.213616, 0.950321, 0.405942, 
  0.340976, 0.473443, 0.295236, 0.163801, 
  0.489998, 0.545621, 0.706916, 0.881967, 
  0.681207, 0.272804, 0.546433, 0.894202, 
  0.854294, 0.939016, 0.784241, 0.189941, 
  0.944713, 0.113991, 0.229739, 0.917375, 
  0.888615, 0.725226, 0.185238, 0.651885, 
  0.359191, 0.673674, 0.196778, 0.316700, 
  0.887290, 0.147099, 0.722643, 0.228266, 
  0.620542, 0.017878, 0.392067, 0.110540, 
  0.563499, 0.098982, 0.992507, 0.244706, 
  0.371786, 0.538940, 0.138909, 0.226081, 
  0.477956, 0.923150, 0.416022, 0.422669, 
  0.037140, 0.645761, 0.340044, 0.925755, 
  0.370986, 0.525282, 0.577640, 0.730177, 
  0.198956 };
