Keyboard User Interface
----------------------

File: kui.c

Works with renderers: any

Interaction: by keyboard strokes

Required Hooks: none

Light support: full

Camera support: full

Model support: full

Auxiliary routines:

Comments:
	This user interface provides a generic way for a user at a simple
	terminal to manipulate the rendering of a model.  At each
	call to ui_traverselights or ui_camera, the information is
	cached as well as passed on to the renderer.  When ui_render
	is called, the following occurs:

	1)  The object is rendered as described with the existing lighting
	    and camera information.

	2)  A transformation is calculated which will move the 'lookat'
	    point to the origin, and applied to the lights and camera.

	3)  The user is given the opportunity to reposition the camera
	    or model through keyboard input, to start a trace, to exit, 
	    to move to the next P3D rendering instruction, or to print 
	    help information.  The user interface may return or the 
	    application may exit as a result of this.

	4)  If the model has been repositioned, the transformation of step
	    (2) is recalculated and reapplied.

	5)  If the camera has been repositioned, the model is rerendered.

	6)  Loop back to (3) above.

	The net result is that a view of the model gets rendered, and the
	user is asked for input.  As long as the user continues moving
	around the given model, the model is repeatedly rerendered from
	the new positions.  Camera motion is specified in a 'magic crystal
	ball' paradigm;  the user requests that the camera move up, down,
	left, or right, or rotate clockwise or anticlockwise with respect
	to the model, and the new view of the model is drawn.  Further
	movement commands are with respect to the new model position, not
	with respect to some fixed set of axes.  When the user asks to 
	quit examining the current model, the next P3D model is rendered 
	in the same way.

	If the user requests that a trace of rendering positions be begun,
	the camera information for each subsequent view is saved in a file
	called 'kui_trace.dat' in the current directory.  This information 
	can be used later to reconstruct the 'flight path' or to return to 
	a specific viewpoint.

Bugs:
	There is currently no way to rotate the model by less than 5 degrees.

	If you zoom in toward the model far enough, it is possible to
	place the lookfrom point on top of the lookat point.  Then the
	renderer may crash, and it will certainly be impossible to
	zoom back out.


	
	


