
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <gl/image.h>

#define NOPTS 1
#define MINARGS 3

main(argc,argv)
int argc;
char *argv[];
{
	char *pname,*pstr;
	float pver;
	unsigned short dev_month,dev_year;
	int err_ret,nopts,nargs;
	char pstat;
	char *opt_array[NOPTS],*opt_desc[NOPTS];
	int opt_loc[NOPTS];

	char *imgfile_in,*imgfile_out,*imgcmd;
	unsigned char *buff,*buf_ptr;
	IMAGE *image;
	int x,y,z;
	int xsize,ysize,zsize,ibits;
	int num_bytes;
	short rbuf[4096],gbuf[4096],bbuf[4096];
	short *rptr,*gptr,*bptr;
	register int i;

	pname = "iristohdf";
	pver = 1.0;
	dev_month = 6;
	dev_year = 1989;
	pstat = 'D';
	pstr = "public domain software";

	opt_desc[0] = "iristohdf <irisimg_in> <hdffile_out>";
	opt_array[0] = opt_desc[0];
	nopts = NOPTS;

	err_ret = prog_title(pname,pver,dev_month,dev_year,pstat,pstr);

	if (argc < MINARGS){
		err_ret = prog_opts(nopts,opt_array,opt_desc);
		exit(1);
	}

	if (argc > MINARGS)
		err_ret = opt_index(argv,opt_array,argc,nopts,opt_loc);

	imgfile_in  = argv[argc-2];
	imgfile_out = argv[argc-1];

	err_ret = iris_getdims(imgfile_in,&xsize,&ysize,&zsize);
	if (err_ret){
		printf("Problem with file %s\n",imgfile_in);
		exit(1);
	}

	if (zsize == 1)
		ibits = 8;
	else if (zsize == 3)
		ibits = 24;
	else{
		printf("Illegal zsize : %d\n",zsize);
		exit(1);
	}

	num_bytes = xsize * ysize * zsize;
	buff = (unsigned char *)malloc(num_bytes);
	if (!buff){
		puts("Not enough memory for buff\n");
		exit(1);
	}

	err_ret = irisimg_io(imgfile_in,&xsize,&ysize,&zsize,"rb",buff);

	if (zsize == 1){
		err_ret = DFR8putimage(imgfile_out,buff,xsize,ysize,11);
		if (err_ret){
			puts("Problem with DFR8addimage");
			exit(1);
		}
	}
	else{
		err_ret = DF24setdims(xsize,ysize,0); 
		if (err_ret){
			puts("Problem with DF24setdims");
			exit(1);
		}
		err_ret = DF24addimage(imgfile_out,buff,xsize,ysize); 
		if (err_ret){
			puts("Problem with DF24addimage");
			exit(1);
		}
	}

	free(buff);
}

