
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>
#include <stdio.h>

#define NOPTS 3
#define MINARGS 2

#define PALBUFSIZE 256

main(argc,argv)
int argc;
char *argv[];
{
	char *pname,*pstr;
	float pver;
	unsigned short dev_month, dev_year;
	int err_ret,nopts,nargs;
	char pstat;
	char *opt_array[NOPTS],*opt_desc[NOPTS];
	int opt_loc[NOPTS];

	char *imgfile;
	unsigned char *buff,*temp_buff,palette[PALBUFSIZE][3];
	short ir,ig,ib;
	int mem_flag,igid,num_bytes;
	long xsize,ysize,zsize,tsize,ispal,pil;
	short dev,val;
	Colorindex ic,ic1;

	pname = "df_dspl";
	pver = 1.02;
	dev_month = 7;
	dev_year = 1989;
	pstat = 'P';
	pstr = "public domain software";

	mem_flag = 1;
	ispal = 0;

	opt_desc[0] = "df_dspl [-options] <image_name>";
	opt_array[0] = opt_desc[0];
	opt_array[1] = "-m"; opt_desc[1] = "(turn off palette memory)";
	opt_array[2] = "-swapxy"; opt_desc[2] = "(transpose the X and Y data dimensions)";
	nopts = NOPTS;

	err_ret = prog_title(pname,pver,dev_month,dev_year,pstat,pstr);

	if (argc < MINARGS){
		err_ret = prog_opts(nopts,opt_array,opt_desc);
		exit(1);
	}

	if (argc > MINARGS)
		err_ret = opt_index(argv,opt_array,argc,nopts,opt_loc);

	mem_flag = !opt_loc[1];

	imgfile  = argv[argc-1];

/* Assuming the image is HDF to begin with, test if it's 8 or 24 bit */

Hdf8:
	err_ret = DFR8getdims(imgfile,&xsize,&ysize,&ispal);
	if (err_ret){
		goto Hdf24;
	}
	else{
		zsize = 1;
		num_bytes = xsize * ysize * zsize * sizeof(char);
		buff = (unsigned char *)malloc(num_bytes);
		if (!buff){
			printf("%s: Not enough memory\n",imgfile);
			exit(1);
		}
		err_ret = DFR8getimage(imgfile,buff,xsize,ysize,palette);
		if (err_ret){
			printf("%s: Error with DFR8getimage\n",imgfile);
			exit(1);
		}
		goto Hdfdone;
	}

Hdf24:
	err_ret = DF24getdims(imgfile,&xsize,&ysize,&pil); 
	if (err_ret){
		goto Hdfsd;
	}
	else{
		zsize = 3;
		num_bytes = xsize * ysize * zsize * sizeof(char);
		temp_buff = (unsigned char *)malloc(num_bytes);
		if (!temp_buff){
			printf("%s: Not enough memory\n",imgfile);
			exit(1);
		}
		err_ret = DF24getimage(imgfile,temp_buff,xsize,ysize);
		if (err_ret){
			printf("%s: Error with DF24getimage\n",imgfile);
			exit(1);
		}
		buff = (unsigned char *)malloc(num_bytes);
		if (!buff){
			printf("%s: Not enough memory\n",imgfile);
			exit(1);
		}
		ch_seqfmt(1,2,temp_buff,buff,xsize,ysize);
		free(temp_buff);
		goto Hdfdone;
	}

Hdfsd:
	err_ret = gx_sdgetdim(imgfile,&xsize,&ysize);
	if (err_ret){
		printf("%s: Cannot read - unknown format\n",imgfile);
		exit(1);
	}
	else{
		zsize = 1;
		num_bytes = xsize * ysize * zsize * sizeof(char);
		buff = (unsigned char *)malloc(num_bytes);
		if (!buff){
			printf("%s: Not enough memory\n",imgfile);
			exit(1);
		}
		err_ret = gx_sdgetdata(imgfile,buff,xsize,ysize);
		if (err_ret){
			printf("%s: Error with DFSDgetdata\n",imgfile);
			exit(1);
		}
	}

Hdfdone:

	if (opt_loc[2]){
		tsize = xsize;
		xsize = ysize;
		ysize = tsize;
	}
		
	prefsize(xsize,ysize); 
	igid=winopen(imgfile); 
	winconstraints(); 
	if (zsize == 1){
		cmode();
		onemap();
	}
	else{
		RGBmode();
	}
	singlebuffer();
	drawmode(NORMALDRAW);
	gconfig();

/* if ispal=false then load default gray palette values */

	if (!ispal){
		for(ic=0; ic < PALBUFSIZE; ic++){
			palette[ic][0] = (unsigned char)ic;
			palette[ic][1] = (unsigned char)ic;
			palette[ic][2] = (unsigned char)ic;
		}
	}

	wintitle(imgfile);
	
	if (zsize == 1){
		for(ic=0; ic < PALBUFSIZE; ic++){
			ic1 = ic | 512; /* statement is ic1=ic+512 */
			ir = (short)palette[ic][0];
			ig = (short)palette[ic][1];
			ib = (short)palette[ic][2];
			mapcolor(ic1, ir,ig,ib);
		}
	}

	if (zsize == 1){
		err_ret = seq8(buff,xsize,ysize);
		if (err_ret){
			puts("problem with seq8\n");
			gexit();
			exit(1);
		}
	}
	else{
		err_ret = seq24(buff,xsize,ysize);
		if (err_ret){
			puts("problem with seq24\n");
			gexit();
			exit(1);
		}
	}

	for(;;){
		dev = qread(&val);
		if (dev == REDRAW){
			if ((mem_flag) && (zsize == 1)){
				for(ic=0; ic < PALBUFSIZE; ic++){
					ic1 = ic | 512;
					ir = (short)palette[ic][0];
					ig = (short)palette[ic][1];
					ib = (short)palette[ic][2];
					mapcolor(ic1, ir,ig,ib);
				}
			}
			if (zsize == 1){
				err_ret = seq8(buff,xsize,ysize);
				if (err_ret){
					puts("problem with seq8\n");
					gexit();
					exit(1);
				}
			}
			else{
				err_ret = seq24(buff,xsize,ysize);
				if (err_ret){
					puts("problem with seq24\n");
					gexit();
					exit(1);
				}
			}
		}
	}


}

int seq8(buff,xsiz,ysiz)
unsigned char buff[];
int xsiz,ysiz;
{
	register int i,j;
	int ix;
	int err_ret;
	unsigned char *bufptr;
	short num_cols;
	Colorindex *colors,*jc;

	err_ret = 0;

	colors = (Colorindex *)malloc(xsiz * sizeof(Colorindex));
	if (!colors){
		err_ret = 1;
		goto error;
	}

	num_cols = (short)xsiz;

	reshapeviewport();

	bufptr = &buff[0];

	ix = 0;
	for(i=ysiz-1; i>=0; i--){
		j = xsiz;
		jc = colors;
		do{
			j--;
			*jc++ = (*bufptr++)|512;
		}while(j);

		cmov2i(ix,i);
		writepixels(num_cols,colors);
	}

	free(colors);

error:
	return(err_ret);
}

int seq24(buff,xsiz,ysiz)
unsigned char buff[];
int xsiz,ysiz;
{
	register int i;
	int err_ret;
	unsigned char *rptr,*gptr,*bptr,*bufptr;
	int ix,xsiz3;
	short num_cols;

	err_ret = 0;
	num_cols = (short)xsiz;
	ix = 0;
	xsiz3 = xsiz * 3;
	bufptr = &buff[0];

	reshapeviewport();

	i = ysiz;
	do{
		i--;
		rptr = bufptr;
		gptr = rptr + xsiz;
		bptr = gptr + xsiz;
		bufptr = bufptr + xsiz3;
		cmov2i(ix,i);
		writeRGB(num_cols,rptr,gptr,bptr);
	}while(i);

error:
	return(err_ret);
}

int gx_sdgetdim(dfile,xsiz,ysiz)
char *dfile;
int *xsiz,*ysiz;
{
	int ret,err_ret;
	int rank,maxrank,sizes[2];

	err_ret = 0;
	maxrank = 2;
	ret = DFSDgetdims(dfile,&rank,sizes,maxrank);
	if (ret){
		err_ret = 1;
		goto error;
	}

	if (rank != 2){
		err_ret = 2;
		goto error;
	}

	*xsiz = sizes[0];
	*ysiz = sizes[1];

error:
	return(err_ret);

}

int gx_sdgetdata(dfile,ibuf,xsiz,ysiz)
char *dfile;
unsigned char ibuf[];
int xsiz,ysiz;
{
	int ret,err_ret;
	int rank,sizes[2];
	int num_bytes;
	int size1;
	float *dbuf;
	float minval,maxval;
	register int i;

	err_ret = 0;

	rank = 2;
	sizes[0] = xsiz;
	sizes[1] = ysiz;

	num_bytes = xsiz * ysiz * sizeof(float);
	dbuf = (float *)malloc(num_bytes);
	if (!dbuf){
		err_ret = 3;
		printf("%s: Not enough memory\n",dfile);
		goto error;
	}
	
	ret = DFSDgetdata(dfile,rank,sizes,dbuf);
	if (ret){
		err_ret = 4;
		goto error;
	}

	size1 = xsiz * ysiz;
	findMinMax(dbuf,size1,&minval,&maxval);

	floattoR8(dbuf,ibuf,size1,minval,maxval);

	free(dbuf);
error:
	return(err_ret);

}

int findMinMax(data,size,min,max)
float data[];
int size;
float *min,*max;
{
	register int i;
	register float dval,ms,ml;

	ms = data[0];
	ml = data[0];
	i = size-1;
	do{
		dval = data[i];
		if (ml < dval)
			ml = dval;
		else if (ms > dval)
			ms = dval;
		i--;
	}while(i);

	*min = ms;
	*max = ml;

	return(0);
}

int floattoR8(fdata,rdata,size,min,max)
float fdata[];
unsigned char rdata[];
int size;
float min,max;
{
	register int i;
	register float *fptr,ml,step;
	register unsigned char *rptr;
	int err_ret;
	float maxchar_val;

	err_ret = 0;
	maxchar_val = 255.0;

	step = (max - min) / maxchar_val;
	if (step == 0.0){
		err_ret = 1;
		goto error;
	}

	i = size;
	rptr = rdata;
	fptr = fdata;
	ml = min;
	do{
		i--;
		*rptr++ = (unsigned char) ((*fptr++ - ml) / step);
	}while(i);

error:
	return(err_ret);
}
