/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: pen.c,v 1.2 1993/04/13 17:35:20 gbourhis Exp $";
#endif


#include <stdio.h>
#include <Xm/Xm.h>
#include <X11/StringDefs.h>
#include <Xm/Label.h>
#include "view.h"

#include "blank.xbm"
#include "left.xbm"
#include "right.xbm"


#define DEF_WHITE	WhitePixel(myDpy, DefaultScreen(myDpy))

#define CBAR_WIDTH	15
#define L_BORDER	0
#define T_BORDER	5
#define CBOX_HEIGHT	15
#define CBOX_SEP	10


extern Display *myDpy;
extern GC drawAreaGC;


Pixmap Blank, L_arrow, R_arrow;
int oldy = -1;



void
DrawPenPointer(V)
	View *V;
{
	XWindowAttributes attr;
	Widget w;
	int y, fluff;
	Cardinal arg;
	Arg argList[10];
	Pixel fg, bg;

	w = V->colorpal;

	XGetWindowAttributes(myDpy, XtWindow(w), &attr);

	fluff = T_BORDER + CBOX_HEIGHT + CBOX_SEP;
	y = ((attr.height - fluff) * V->doodleColor / 256) + fluff;

	if (y >= 0)
	{
		arg = 0;
		XtSetArg(argList[arg], XtNforeground, &fg); arg++;
		XtSetArg(argList[arg], XtNbackground, &bg); arg++;
		XtGetValues(w, argList, arg);
		XSetForeground(myDpy, drawAreaGC, fg);
		XSetBackground(myDpy, drawAreaGC, bg);

		if (oldy >= 0)
		{
			XCopyPlane(myDpy, Blank, XtWindow(w), drawAreaGC,
				0, 0, blank_width, blank_height,
				(attr.width - blank_width),
				(oldy - (blank_height / 2)),
				(unsigned long)1);
		}

		XCopyPlane(myDpy, R_arrow, XtWindow(w), drawAreaGC,
			0, 0, right_width, right_height,
			(attr.width - right_width),
			(y - (right_height / 2)),
			(unsigned long)1);
		oldy = y;

		XSetForeground(myDpy, drawAreaGC, V->doodleColor);
		XFillRectangle(myDpy, XtWindow(w), drawAreaGC,
			L_BORDER, T_BORDER,
			(attr.width - L_BORDER - right_width), CBOX_HEIGHT);
	}
}


void
CBExposePenPal(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	XExposeEvent *ExEvent = (XExposeEvent *)event;
	View *V = (View *)client_data;
	XWindowAttributes attr;
	unsigned long pix;
	int i, fluff;
	int y, height;
	Cardinal arg;
	Arg argList[10];
	Pixel fg, bg;

	XGetWindowAttributes(myDpy, XtWindow(w), &attr);
	XSetForeground(myDpy, drawAreaGC, V->doodleColor);
	XFillRectangle(myDpy, XtWindow(w), drawAreaGC,
		L_BORDER, T_BORDER,
		(attr.width - L_BORDER - right_width), CBOX_HEIGHT);

	fluff = T_BORDER + CBOX_HEIGHT + CBOX_SEP;
	height = attr.height - fluff;
	for (i=0; i<height; i++)
	{
		pix = i * 256 / height;
		XSetForeground(myDpy, drawAreaGC, pix);
		XDrawLine(myDpy, XtWindow(w), drawAreaGC, L_BORDER, i + fluff,
			(attr.width - L_BORDER - right_width - 1), i + fluff); 
	}

	y = (height * V->doodleColor / 256) + fluff;

	if (y >= 0)
	{
		arg = 0;
		XtSetArg(argList[arg], XtNforeground, &fg); arg++;
		XtSetArg(argList[arg], XtNbackground, &bg); arg++;
		XtGetValues(w, argList, arg);
		XSetForeground(myDpy, drawAreaGC, fg);
		XSetBackground(myDpy, drawAreaGC, bg);

		XCopyPlane(myDpy, R_arrow, XtWindow(w), drawAreaGC,
			0, 0, right_width, right_height,
			(attr.width - right_width),
			(y - (right_height / 2)),
			(unsigned long)1);
		oldy = y;
	}
}


void
CBPenPress(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	XButtonPressedEvent *BuEvent = (XButtonPressedEvent *)event;
	View *V = (View *)client_data;
	XWindowAttributes attr;
	unsigned long pix;
	int y, fluff;
	Cardinal arg;
	Arg argList[10];
	Pixel fg, bg;

	XGetWindowAttributes(myDpy, XtWindow(w), &attr);
	fluff = T_BORDER + CBOX_HEIGHT + CBOX_SEP;
	y = BuEvent->y;
	if (y < fluff)
	{
		y = fluff;
	}
	if (y > (attr.height - 1))
	{
		y = attr.height - 1;
	}

	arg = 0;
	XtSetArg(argList[arg], XtNforeground, &fg); arg++;
	XtSetArg(argList[arg], XtNbackground, &bg); arg++;
	XtGetValues(w, argList, arg);
	pix = (y - fluff) * 256 / (attr.height - fluff);

	XSetForeground(myDpy, drawAreaGC, fg);
	XSetBackground(myDpy, drawAreaGC, bg);

	if (oldy >= 0)
	{
		XCopyPlane(myDpy, Blank, XtWindow(w), drawAreaGC,
			0, 0, blank_width, blank_height,
			(attr.width - blank_width),
			(oldy - (blank_width / 2)),
			(unsigned long)1);
	}
	XCopyPlane(myDpy, R_arrow, XtWindow(w), drawAreaGC,
		0, 0, right_width, right_height,
		(attr.width - right_width),
		(y - (right_height / 2)),
		(unsigned long)1);
	oldy =  y;

	XSetForeground(myDpy, drawAreaGC, pix);

	XFillRectangle(myDpy, XtWindow(w), drawAreaGC,
		L_BORDER, T_BORDER,
		(attr.width - L_BORDER - right_width), CBOX_HEIGHT);

	XFlush(myDpy);          /* EJB */
}


void
CBPenMove(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	XPointerMovedEvent *MoEvent = (XPointerMovedEvent *)event;
	View *V = (View *)client_data;
	XWindowAttributes attr;
	unsigned long pix;
	int y, fluff;
	Cardinal arg;
	Arg argList[10];
	Pixel fg, bg;

	XGetWindowAttributes(myDpy, XtWindow(w), &attr);
	fluff = T_BORDER + CBOX_HEIGHT + CBOX_SEP;
	y = MoEvent->y;
	if (y < fluff)
	{
		y = fluff;
	}
	if (y > (attr.height - 1))
	{
		y = attr.height - 1;
	}

	arg = 0;
	XtSetArg(argList[arg], XtNforeground, &fg); arg++;
	XtSetArg(argList[arg], XtNbackground, &bg); arg++;
	XtGetValues(w, argList, arg);
	pix = (y - fluff) * 256 / (attr.height - fluff);

	XSetForeground(myDpy, drawAreaGC, fg);
	XSetBackground(myDpy, drawAreaGC, bg);

	if (oldy >= 0)
	{
		XCopyPlane(myDpy, Blank, XtWindow(w), drawAreaGC,
			0, 0, blank_width, blank_height,
			(attr.width - blank_width),
			(oldy - (blank_width / 2)),
			(unsigned long)1);
	}
	XCopyPlane(myDpy, R_arrow, XtWindow(w), drawAreaGC,
		0, 0, right_width, right_height,
		(attr.width - right_width),
		(y - (right_height / 2)),
		(unsigned long)1);
	oldy =  y;

	XSetForeground(myDpy, drawAreaGC, pix);

	XFillRectangle(myDpy, XtWindow(w), drawAreaGC,
		L_BORDER, T_BORDER,
		(attr.width - L_BORDER - right_width), CBOX_HEIGHT);

	XFlush(myDpy);          /* EJB */
}


void
CBPenRelease(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	View *V = (View *)client_data;
	XButtonReleasedEvent *BuEvent = (XButtonReleasedEvent *)event;
	XWindowAttributes attr;
	unsigned long pix;
	int fluff;
	Cardinal arg;
	Arg argList[10];
	Pixel fg, bg;

	XGetWindowAttributes(myDpy, XtWindow(w), &attr);
	arg = 0;
	XtSetArg(argList[arg], XtNforeground, &fg); arg++;
	XtSetArg(argList[arg], XtNbackground, &bg); arg++;
	XtGetValues(w, argList, arg);
	XSetForeground(myDpy, drawAreaGC, fg);
	XSetBackground(myDpy, drawAreaGC, bg);

	if (oldy >= 0)
	{
		fluff = T_BORDER + CBOX_HEIGHT + CBOX_SEP;
		pix = (oldy - fluff) * 256 / (attr.height - fluff);

		XSetForeground(myDpy, drawAreaGC, pix);
		XFillRectangle(myDpy, XtWindow(w), drawAreaGC,
			L_BORDER, T_BORDER,
			(attr.width - L_BORDER - right_width), CBOX_HEIGHT);

		XSetForeground(myDpy, drawAreaGC, fg);
		XCopyPlane(myDpy, Blank, XtWindow(w), drawAreaGC,
			0, 0, blank_width, blank_height,
			(attr.width - blank_width),
			(oldy - (blank_width / 2)),
			(unsigned long)1);
		XCopyPlane(myDpy, R_arrow, XtWindow(w), drawAreaGC,
			0, 0, right_width, right_height,
			(attr.width - right_width),
			(oldy - (right_height / 2)),
			(unsigned long)1);

		XFlush(myDpy);          /* EJB */
		V->doodleColor = pix;
		if (V->matchButton)
		{
			XColor *xcolor;

			xcolor = XColorCellOfView(V, (int)pix);
			V->matchButton->red = xcolor->red / 256;;
			V->matchButton->green = xcolor->green / 256;
			V->matchButton->blue = xcolor->blue / 256;
			XClearArea(myDpy, XtWindow(V->matchButton->widget),
					0, 0, 1, 1, True);
		}
	}
}


Widget
InitPenMenu(V, penPulldown)
	View *V;
	Widget penPulldown;
{
	Widget 	b;
	Cardinal i;
	Arg	argList[10];

	i = 0;
	XtSetArg(argList[i], XmNwidth, 60); i++;
	XtSetArg(argList[i], XmNheight, 2); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNrecomputeSize, False); i++;
	if ((V->cData)&&(V->type == V_WHITEBOARD))
	{
		XtSetArg(argList[i], XmNbackground, DEF_WHITE); i++;
	}
	b = XmCreateLabel(penPulldown, "paletteArea", argList, i);
	XtManageChild(b);

	i = 0;
	XtSetArg(argList[i], XmNwidth, 60); i++;
	XtSetArg(argList[i], XmNheight, 256 + T_BORDER + CBOX_HEIGHT +
		CBOX_SEP); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNrecomputeSize, False); i++;
	if ((V->cData)&&(V->type == V_WHITEBOARD))
	{
		XtSetArg(argList[i], XmNbackground, DEF_WHITE); i++;
	}
	b = XmCreateLabel(penPulldown, "paletteArea", argList, i);
	XtAddEventHandler(b, ExposureMask, 0, CBExposePenPal,
		(caddr_t)V);
	XtAddEventHandler(b, ButtonPressMask, 0, CBPenPress,
		(caddr_t)V);
	XtAddEventHandler(b, ButtonMotionMask, 0, CBPenMove,
		(caddr_t)V);
	XtAddEventHandler(b, ButtonReleaseMask, 0, CBPenRelease,
		(caddr_t)V);
	XtManageChild(b);

	Blank = XCreateBitmapFromData(myDpy, DefaultRootWindow(myDpy),
		blank_bits, blank_width, blank_height);
	L_arrow = XCreateBitmapFromData(myDpy, DefaultRootWindow(myDpy),
		left_bits, left_width, left_height);
	R_arrow = XCreateBitmapFromData(myDpy, DefaultRootWindow(myDpy),
		right_bits, right_width, right_height);

	return(b);
}


Widget
InitPen(V, form)
	View *V;
	Widget form;
{
	Widget 	b;
	Cardinal i;
	Arg argList[20];

	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNwidth, CBAR_WIDTH + L_BORDER + right_width);i++;
	XtSetArg(argList[i], XmNheight, 256 + T_BORDER + CBOX_HEIGHT +
		CBOX_SEP); i++;
	XtSetArg(argList[i], XmNlabelType, XmPIXMAP); i++;
	XtSetArg(argList[i], XmNrecomputeSize, False); i++;
/*
	if ((V->cData)&&(V->type == V_WHITEBOARD))
	{
		XtSetArg(argList[i], XmNbackground, DEF_WHITE); i++;
	}
*/
	b = XmCreateLabel(form, "paletteArea", argList, i);
	XtAddEventHandler(b, ExposureMask, 0, CBExposePenPal,
		(caddr_t)V);
	XtAddEventHandler(b, ButtonPressMask, 0, CBPenPress,
		(caddr_t)V);
	XtAddEventHandler(b, ButtonMotionMask, 0, CBPenMove,
		(caddr_t)V);
	XtAddEventHandler(b, ButtonReleaseMask, 0, CBPenRelease,
		(caddr_t)V);
	XtManageChild(b);

	Blank = XCreateBitmapFromData(myDpy, DefaultRootWindow(myDpy),
		blank_bits, blank_width, blank_height);
	L_arrow = XCreateBitmapFromData(myDpy, DefaultRootWindow(myDpy),
		left_bits, left_width, left_height);
	R_arrow = XCreateBitmapFromData(myDpy, DefaultRootWindow(myDpy),
		right_bits, right_width, right_height);

	return(b);
}

