
#include "gr_com.h"
#ifdef XtSpecificationRelease
#include <X11/StringDefs.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiSrc.h>
#endif
static A_TopWind_t mynoteWin;

/*
 * Open the top level window with the logbook and buttons to open the file
 * window.
 */
void
gr_InitNotes (shellName,parent,notefile)
char *shellName;
Widget parent;
char *notefile;
{
	Widget		boxWind;
	FILE		*notefp;
	/* remove the conditional declaration ...
#ifdef DTMOK
	extern void DTM_setControlOn(), DTM_setControlOff ();
#endif
	   gbourhis Feb 93 */

	DBPRINTARG("IN gr_InitNotes: notefile is [%s]\n", notefile);

	mynoteWin.shell = 
		gr_MakeWindow("XDS Control",parent,&(mynoteWin.win),
			      (XtCallbackProc)gr_Terminate,CNTRLWIND,	
			      td_getToolName(),"Quit",(caddr_t) &mynoteWin,
			      0,0,380,240);


	boxWind = gr_MakeBulletin("XDSbulletin",mynoteWin.win,1,1,374, 140);

	/* if the notefile does not exist, atempt to create it 
	   gbourhis, Feb 93 */
	if ((notefp=fopen(notefile, "a+")) == NULL) {
	  sprintf(msg, "Cannot open %s", notefile);
	  perror(msg);
	  exit(1);
	}
	else
	  fclose(notefp);

	mynoteWin.msgWin = gr_MakeText("XDStext",boxWind,
					&mynoteWin.msgVPort,VERTONLY,
					SELECTABLE,FILESOURCE, notefile,
					0, 0, 370, 330);


	mynoteWin.numAniWins = 0;
	mynoteWin.numBossWins = 0;
	mynoteWin.numFileWins = 0;
	mynoteWin.bossWin = NULL;
	mynoteWin.fileWin = NULL;
	mynoteWin.aniWin = NULL;
	DBPRINT(" ALL DONE WITH gr_InitNotes\n");
}
#ifdef XtSpecificationRelease
/* save the notes from the Text Widget to the file
   gbourhis, Feb 93. */
void gr_SaveNotes()
{
	Arg arg;
	Widget  asciiSrc;
	XtSetArg(arg, XtNtextSource, &asciiSrc);
	XtGetValues(mynoteWin.msgWin, &arg, (Cardinal)1);
	XawAsciiSave(asciiSrc);
}
#endif
