
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)parsewrite.c	1.1	NCSA	6/29/87";
#endif lint

#include <suntool/sunview.h>
#include <suntool/canvas.h>

#include "session.h"
#include "defs.h"

/*********************************************************************/
/*  parsewrite
*   write out some chars from parse
*   Has a choice of where to send the stuff
*/
parsewrite(tw,dat,len)
	struct session *tw;
	char *dat;
	int len;
{
	int i;
	extern char parsedat[];

/*
*  send the string where it belongs
*  1. Check for a capture file.  If so, echo a copy of the string
*  2. Check for dumb terminal type, convert special chars if so
*  3. Check for Tektronix mode, sending Tek stuff
*  4. or, send to virtual screen anyway
*/
	docap(dat,len);
/*
* raw mode for debugging, passes through escape sequences and other
* special characters as <27> symbols
*/
	if (tw->s_termstate == DUMBTYPE) {
		for (i=0; i < len ; i++,dat++) 
			if (*dat == 27 || *dat > 126) {
				sprintf(parsedat,"<%d>",*dat);
				VSwrite(tw->s_winval,parsedat,strlen(parsedat));
			}
			else
				VSwrite(tw->s_winval,dat,1);
	}
	else {
		if (tw->s_termstate == TEKTYPE)
			VGwrite(tw->s_tekwin,dat,len);
		else 
		if (tw->s_termstate == RASTYPE) {  /* send to color raster */
			i = VRwrite(dat,len);
			if (i < len) {
				tw->s_termstate = VTTYPE;
				parsewrite(tw,dat+i,len-i);
			}
		}
		else
			VSwrite(tw->s_winval,dat,len);	/* send to virtual VT102 */

	}

}
