/* error.c
 * Error message processing routine, for the file-conversion code.
 *
 * Peter Webb, Summer 1990
 */

#include <stdio.h>

/* Package include files */

#include "extern.h"     /* External routines and global variables */
#include "error.h"      /* Error type definitions */
#include "reformat.h"   /* Package-wide contants */
#include "window.h"     /* Constants specific to the GUI */

/* Keep all of the following messages and names in the same order as the 
 * elements of the enums in error.h.
 */

static char *errors[] = {

/* Success */

  "No problem, dude! (This message is never printed)",

/* Warnings */

 "Couldn't find default geometry in merged resource database.",
 "Couldn't find minimum application size in resource database (using 500x600)",
 "Can't find application resource database file",
 "Invalid foreground color",
 "Invalid background color",
 "Invalid border color",
 "Can't allocate requested color",
 "Background color equal to foreground color (using white and black)",
 "Couldn't find default font in merged resource database.",
 "Couldn't open specified file",
 "Data in the file does not match the specified file type.",
 "Input file correct type, but wrong version.",
 "File already exists.  Overwrite permission denied.  No action taken.",
 "File system error.  Check file name and protections.",
 "Unable to determine file type.",
 "That action/use is not yet a supported feature.",
 "The input data file appears to be corrupted.",
 "Input file name doesn't make sense. (Possibly NULL?)",
 "Output file name doesn't make sense. (Possibly NULL?)",
 "Input file type not specified.",
 "Output file type not specified.",
 "File does not contain a palette.",
 "Conversion operation failed.",
 "Can't open input file.  Check name and protection.",
 "Can't open output file.  Check name and protection.",
 "Output file is corrupted! Please report this to NCSA.",
 "Unrecognized command line option.",
 "Image is too complex.  Too many color planes.",
 "Too many colors.",
 "Bad color specified in data file.",
 "The dimensions of the image specify an area of zero size",
 "There is no colormap in the input file",
 "The input was not a recognizable integer.",

/* Errors */

 "No more dynamic memory.  Wicked bummer!",
 "Null pointer unexpected",
 "Input in incorrect format",
 "Internal error.  This never happens.  (Please report this error to NCSA).",
 "This machine is not powerful enough to run this program",
};

static char *names[] = {
 "Main",
 "SetUpWithDefaults",
 "InitWidgets",
 "ParseConversion",
 "ScanDir",
 "FreeStrList",
 "FreeStrArray",
 "TiffToRI8",
 "Reformat",
 "AppendType",
 "FullInputPath",
 "WhatFileType",
 "LastPathElement",
 "ReplaceDialogText",
 "FileListCallBack",
 "FullOutputPath",
 "GIF2RI8",
 "FitsToHDF",
 "GetConfirmation",
 "Convert (reformat.c)",
 "WriteHDF",
 "XWDToRI8",
 "FileTypeCallBack",
 "ChangeInputFiles",
 "SunToRI8",
 "WriteFITS",
 "WriteGIF",
 "WriteTIFF",
 "WriteXWD",
 "DoTheData (tiff2ri8.c)",
 "LoadPixrect (sun2ri8.c)",
 "WriteSunrast",
 "WriteRaw",
 "Raw8ToRI8",
 "DialogNewString",
 "GetDimWidth",
 "GetDimHeight",
 "PixrectToHDF (sun2ri8.c)",
};

static FILE *err_file = stderr;

void set_err_file(fp)
  FILE *fp;
{
  if (fp == NULL) return;
  err_file = fp;
}

ErrorCode err_msg(func, err_code)
  FuncName func;
  ErrorCode err_code;
{
  int i;

  sprintf(ScratchBuf, "%s\n", names[(int)func]);
  i = strlen(ScratchBuf);

  if ((int)err_code < ERROR)
    sprintf(ScratchBuf+i, "  Warning: %s\n", errors[(int)err_code]);
  else
    printf(ScratchBuf+i,
	   "  Error: %s\n", errors[(int)err_code-ERROR+WARNINGS+1]);
#ifdef XGUI

  if (MsgOut != NULL && XtIsRealized(MsgOut))
    WriteOutputMsg(ScratchBuf);
  else fprintf(err_file, "%s", ScratchBuf);

#else

  fprintf(err_file, "%s", ScratchBuf);

#endif

  return(err_code);
}

