/* window.h
 * Definitions and constants specific to the GUI
 *
 * Peter Webb, Summer 1990
 */

/* Prevent multiple inclusion of this file */

#ifndef window_h
#define window_h

/* Constants */

#define PAGE_WIDTH 80     /* Width of a page, in characters */
#define PAGE_HEIGHT 15     /* Height of a page, in lines */
#define VERT_SEP 3          /* Whitespace between lines of text */
#define INNER_BORDER 20     /* Whitespace around each widget */
#define MIN_DIR_STR "XXXXXXXXXX"  /* Smallest width for dir. boxes */

/* Text strings used by the widgets */


#define INPUT_DIR "Input Directory:" /* Label for input dir. box */
#define OUTPUT_DIR "Output Directory:" /* Just guess */
#define OUTPUT_FILE "Output File:"      /* Another real hard one */
#define INPUT_FILES "Input Files:"   /* Viewport label */
#define INPUT_FILE "Input File:"
#define DIM_BOX_LBL "Image Dimensions:"
#define HELP_TITLE "Reformat On-Line Help"
#define SEARCH_LBL "Search for:"    /* Help search box */
#define HEIGHT_LBL "Height:"
#define WIDTH_LBL "Width:"
#define INPUT_TYPE "Input file type:"
#define TOGGLE_LBL_TXT "Search direction:"
#define COMPRESS_LBL_TXT "Compress?"
#define SEARCH_BTN_TXT  "Search"
#define DEF_TOGGLE_DIR "Forward"
#define FORWARD "Forward"
#define BACKWARD "Backward"

#define GEOM_SIZE 30        /* Maximum length of a geometry string */
#define ST_SIZE 20 

/* Program defaults */

#define BORDER_WIDTH 2
#define DEF_GEOM     "=500x600"
#define DEF_FONT     "9x15"

/* Resource names for the sub-widgets beneath the application shell.  Each of
 * these names should be unique.
 */

#define NUM_CHILDREN 33
#define DIM_LABEL "dimensionLabel"
#define DIM_FORM "dimensionForm"
#define DIM_WIDTH "dimensionWidthBox"
#define DIM_HEIGHT "dimensionHeightBox"
#define COMP_YES_TOGGLE "compressYesToggle"
#define COMP_NO_TOGGLE "compressNoToggle"
#define COMPRESS_LBL "compressLabel"
#define TOP_FORM   "topForm"
#define VIEWPORT   "viewPort"
#define OUT_FILE   "outFileName"
#define IN_FILE    "inFileName"
#define CVT_BTTN   "convertButton"
#define HLP_BTTN   "helpButton"
#define QUIT_BTTN  "quitButton"
#define FROM_BOX   "fromBox"
#define TO_BOX     "toBox"
#define VIEW_LBL   "viewLabel"
#define VIEW_LST   "viewList"
#define HELP_QUIT  "helpQuitButton"
#define HELP_FORM  "helpForm"
#define HELP_TEXT  "helpText"
#define SEARCH_BOX "helpSearchBox"
#define FOR_TOGGLE "helpForwardToggle"
#define BACK_TOGGLE "helpBackwardToggle"
#define TOGGLE_LBL "helpDirectionLabel"
#define IN_TYPE_PORT "inputTypeViewport"
#define IN_TYPE_LST  "inputTypeList"
#define IN_TYPE_LBL  "inputTypeLabel"
#define MSG_BOX    "messageBox"
#define APP_LBL    "applicationLabel"
#define CONFIRM_YES "confirmYes"
#define CONFIRM_NO  "confirmNo"
#define CONFIRM_BOX "confirmBox"
#define CONFIRM_SHELL "confirmShell"
#define SEARCH_BTN  "helpSearchButton"

/* typedef enum wt {
  ViewPort=0, OutFileName, ConvertButton, HelpButton, FromBox, ToBox,
  ViewLabel, TopForm, QuitButton, ViewList, HelpQuitButton, HelpForm,
  HelpShell, HelpText, HelpSearch, HelpForwardToggle, HelpBackwardToggle,
  HelpDirectionLabel, InFileName, InputTypeViewport, InputTypeList,
  InputTypeLabel,
  } GUI;
*/
#endif /* window_h */

