/* confirm.c
 * Manage the creation and manipulation of the confirm dialog box.
 *
 * Peter Webb, Summer 1990.
 */

/* X include files */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/* Widget include files */

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Text.h>

/* Package include files */

#include "window.h"   
#include "types.h"      /* Package-wide type definitions */
#include "error.h"      /* Error codes */
#include "extern.h"     /* External routines and global variables */
#include "reformat.h"   /* Package-wide contants */

/* Static variables */

static Arg argList[MAX_ARGS];
static int argNum = 0;
static Widget confirmBox;

/* Create the confirm dialog box.  This is a popup window. */

ErrorCode CreateConfirmBox(root, yes_callback, no_callback, str)
     Widget root;
     XtCallbackProc yes_callback, no_callback;
     char *str;
{
  Widget dialog, yes, no, text;
  Dimension width, height, width1, height1;
  int i, cr, len;
  XFontStruct *font;

/* Make the popup shell. */

  argNum = 0;
  XtSetArg(argList[argNum], XtNborderWidth, 4); argNum++;
  XtSetArg(argList[argNum], XtNtitle, "Confirmation"); argNum++;

  confirmBox = XtCreatePopupShell(CONFIRM_SHELL, transientShellWidgetClass,
				  root, argList, argNum);

/* Create the dialog box contained in the shell */ 

  argNum = 0;
  XtSetArg(argList[argNum], XtNvalue, str); argNum++;
  XtSetArg(argList[argNum], XtNlabel, "Please confirm operation"); argNum++;

  dialog = XtCreateManagedWidget(CONFIRM_BOX, dialogWidgetClass, confirmBox,
				 argList, argNum);

/* Get a pointer to the text field */

  text = XtNameToWidget(dialog, "value");

/* Add the yes and no buttons below the text field */

  argNum = 0;
  XtSetArg(argList[argNum], XtNlabel, "Yes"); argNum++;
  XtSetArg(argList[argNum], XtNfromVert, text); argNum++;

  yes = XtCreateManagedWidget(CONFIRM_YES, commandWidgetClass, dialog,
			     argList, argNum);
  XtAddCallback(yes, XtNcallback, yes_callback, confirmBox);

  argNum = 0;
  XtSetArg(argList[argNum], XtNlabel, "No"); argNum++;
  XtSetArg(argList[argNum], XtNfromVert, text); argNum++;
  XtSetArg(argList[argNum], XtNfromHoriz, yes); argNum++;

  no = XtCreateManagedWidget(CONFIRM_NO, commandWidgetClass, dialog,
			     argList, argNum);
  XtAddCallback(no, XtNcallback, no_callback, confirmBox);

/* Find the number of lines and the length of the longest string in the
 * value field.
 */

  i = len = cr = 0;
  while (*str != '\0')
    {
      if (len < i) len = i;
      if (*str++ == '\n')
	{
	  cr++;
	  i = 0;
	}
      i++;
    }

/* Get the font */

  argNum = 0;
  XtSetArg(argList[argNum], XtNfont, &font); argNum++;
  XtGetValues(text, argList, argNum);

/* Calculate the width and height of the text field */

  width = (len+1) * (font->max_bounds.rbearing - font->min_bounds.lbearing);
  height = (cr+2) * (font->max_bounds.ascent + font->max_bounds.descent);

/* Set the size of the text field - set it to ReadOnly also. */

  argNum = 0;
  XtSetArg(argList[argNum], XtNdisplayCaret, False); argNum++;
  XtSetArg(argList[argNum], XtNeditType, XawtextRead); argNum++;
  XtSetArg(argList[argNum], XtNresizable, True); argNum++;
  XtSetArg(argList[argNum], XtNwidth, width); argNum++;
  XtSetArg(argList[argNum], XtNheight, height); argNum++;
  XtSetValues(text, argList, argNum);

/* Realize it */

  XtRealizeWidget(confirmBox);
  
/* Place the dialog box in the center of the screen */

  width = DisplayWidth(AppDisplay, AppScreen);  
  height = DisplayHeight(AppDisplay, AppScreen);  

  argNum = 0;
  XtSetArg(argList[argNum], XtNwidth, &width1); argNum++;
  XtSetArg(argList[argNum], XtNheight, &height1); argNum++;
  XtGetValues(dialog, argList, argNum);

  argNum = 0;
  XtSetArg(argList[argNum], XtNx, width/2 - width1/2); argNum++;
  XtSetArg(argList[argNum], XtNy, height/2 - height1/2); argNum++;
  XtSetValues(confirmBox, argList, argNum);

/* Pop it up */

  XtPopup(confirmBox, XtGrabExclusive);

/* Done */

  return(AllOk);
}



