#include "Contour.h";
typedef struct StyleRec {
	int height;		/* height in pixels of the bit map */
	int rowBytes;	/* width in bytes of the total bit map width */
	int ascent;		/* ascent from the top to the text origin */
	unsigned char *mask;	/* pointer to the font mask */
	int offset[10];	/* offset to the end of each digit */
} StyleRec;

typedef struct DigitRec {
	Point location;
	int style;
	unsigned int color;
} DigitRec;

typedef struct PixMap {
	unsigned char *data;
	Rect bounds;
} PixMap;

typedef struct Object {
	int kind;
	int maskRigNo;
	PixMap mask;
} Object;

typedef struct Image {
	Object object;
	int	seqNumber;
	int contourOn;
	unsigned char **nameList;
	ContourRec	cont;
} Image;

typedef struct Counter {
	Object object;
	DigitRec *digitList;
	int digitCount;
} Counter;

typedef Object *(*ObjectHandler)();

#define ImageKind 	0
#define CounterKind	1
