/* SCCS @(#)i_olim.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          i_olim.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   i_olim.layout.c                                     */
/*                                                                      */
/* DESCRIPTION  :   IO operations of LaboImage  (load)                  */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include <strings.h>
#include "libwidgets/widgetstructure.h"
#include "i_olim.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;
extern Widget gLabowidget;

/********************************************************
/   Creation Function for IO_load_image_planeout_widget 
/*******************************************************/

Widget
build_IO_load_image_planeout_widget(IO_widget_planeout, numplan, typedesc)
	xs_struc_widget_planeout *IO_widget_planeout;
	int numplan, typedesc;
{
	Widget IO_load_image_planeout_widget;
	Widget IO_load_image_planeout_separator;
	Widget IO_load_image_planeout_command;
	Widget IO_load_image_planeout_CANCEL;
	Widget IO_load_image_planeout_OK;
	Widget IO_load_image_planeout_HELP;
	Widget IO_load_image_planeout_form1;
        Widget selectplaneoutput;
	Arg args[MAX_ARGS];
	int n;

	/* Creating IO_load_image_planeout_widget Widget */ 

	n = 0;
	if (numplan == 3) {
	  XtSetArg(args[n],XmNheight,255); n++;
	  XtSetArg(args[n],XmNwidth,355); n++;  /*255*/
	}
	else if (numplan == 2) {
	  XtSetArg(args[n],XmNheight,200); n++;
	  XtSetArg(args[n],XmNwidth,355); n++;  /*255*/
	}
	else {    
	  XtSetArg(args[n],XmNheight,140); n++;
	  XtSetArg(args[n],XmNwidth,335); n++;  /*235*/
	}
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNx,8); n++;
	XtSetArg(args[n],XmNy,5); n++;
/*        XtSetArg(args[n],XmNmwmDecorations, -1); n++; /*voir si OK avec Openwin*/
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(panel_titres[24], XmSTRING_DEFAULT_CHARSET)); n++;

	IO_load_image_planeout_widget = 
	  XmCreateFormDialog(IO_widget_planeout->IO_load_image_file_widget,
				"IO_load_image_planeout_widget", args, n);

	/* Creating IO_load_image_planeout_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	IO_load_image_planeout_command = 
		XmCreateForm(IO_load_image_planeout_widget,
			"IO_load_image_planeout_command",args,n);
	XtManageChild(IO_load_image_planeout_command);

	/* Creating IO_load_image_planeout_CANCEL Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[398],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,68); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	IO_load_image_planeout_CANCEL = 
		XmCreatePushButton(IO_load_image_planeout_command,
			"IO_load_image_planeout_CANCEL",args,n);
	XtManageChild(IO_load_image_planeout_CANCEL);

	/* Adding Callbacks for IO_load_image_planeout_CANCEL */ 

	XtAddCallback(IO_load_image_planeout_CANCEL,XmNactivateCallback,
		IO_load_image_planeout_CANCEL_callb, IO_widget_planeout);

	/* Creating IO_load_image_planeout_OK Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("OK",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,32); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	IO_load_image_planeout_OK = 
		XmCreatePushButton(IO_load_image_planeout_command,
			"IO_load_image_planeout_OK",args,n);
	XtManageChild(IO_load_image_planeout_OK);

	/* Adding Callbacks for IO_load_image_planeout_OK */ 

	XtAddCallback(IO_load_image_planeout_OK,XmNactivateCallback,
		IO_load_image_planeout_OK_callb,IO_widget_planeout);

	/* Creating IO_load_image_planeout_HELP Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,36); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,64); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNsensitive, False); n++;

	IO_load_image_planeout_HELP = 
		XmCreatePushButton(IO_load_image_planeout_command,
			"IO_load_image_planeout_HELP",args,n);
	XtManageChild(IO_load_image_planeout_HELP);



	/* Creating IO_load_image_planeout_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,IO_load_image_planeout_command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	IO_load_image_planeout_separator = 
		XmCreateSeparator(IO_load_image_planeout_widget,
			"IO_load_image_planeout_separator",args,n);
	XtManageChild(IO_load_image_planeout_separator);


	/* Creating IO_load_image_planeout_form1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,IO_load_image_planeout_separator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	IO_load_image_planeout_form1 = 
		XmCreateForm(IO_load_image_planeout_widget,
			"IO_load_image_planeout_form1",args,n);
	XtManageChild(IO_load_image_planeout_form1);

	/* Creating selectplaneoutput Widget */ 

	if (numplan == 3)  /* (typedesc == 6) */
	  selectplaneoutput = 
	    build_Selection3Planesout(IO_load_image_planeout_form1, 
			IO_load_image_planeout_OK, paneltabs[74], 
				   paneltabs[75], paneltabs[76]);
	else if (numplan == 2) 
	  if (typedesc == 4)
	  selectplaneoutput = 
	    build_Selection2Planesout(IO_load_image_planeout_form1, 
				   IO_load_image_planeout_OK, 
				   paneltabs[77], paneltabs[78]);
	  else /* (typedesc == 5) */
	  selectplaneoutput = 
	    build_Selection2Planesout(IO_load_image_planeout_form1, 
				   IO_load_image_planeout_OK, 
				   paneltabs[79], paneltabs[80]);
	else selectplaneoutput =
	  build_SelectionPlaneout(IO_load_image_planeout_form1, 
			IO_load_image_planeout_OK, paneltabs[105], 0);

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetValues(selectplaneoutput, args, n);
	XtManageChild(selectplaneoutput);

	return(IO_load_image_planeout_widget);
}


/********************************************************
/   Creation Function for IO_load_image_file_widget 
/*******************************************************/

Widget
build_IO_load_image_file_widget(IO_load_image,typeimage, message)
	Widget IO_load_image;
	int    typeimage;
	char *message;
{
	Widget IO_load_image_file_widget;
	Widget IO_load_image_file_selection;
	Widget IO_load_image_separator;
	xs_struc_widgetIO *IO_param_file;
	xs_struc_widgetparamIO *IO_parametres_widget;
	Arg args[MAX_ARGS];
	int n;

	/* Creating IO_load_image_file_widget Widget */ 

	n = 0;
	if (typeimage == IO_LOAD_LTS || typeimage == IO_LOAD_RGB) {
	  XtSetArg(args[n],XmNheight,307); n++;
	  XtSetArg(args[n],XmNwidth,625); n++;
	}
	else {    
	  XtSetArg(args[n],XmNheight,307); n++;
	  XtSetArg(args[n],XmNwidth,405); n++;
	}
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNx,193); n++;
	XtSetArg(args[n],XmNy,78); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(message, XmSTRING_DEFAULT_CHARSET)); n++;

	IO_load_image_file_widget = 
	    XmCreateFormDialog(gLabowidget,"IO_load_image_file_widget",args,n);

	if (typeimage == IO_LOAD_LTS || typeimage == IO_LOAD_RGB) {

	  /* Creating IO_parametres_widget Widget */ 

	  IO_parametres_widget = 
	    build_IO_parametres_widget(IO_load_image_file_widget);

	  n = 0;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,66); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	  XtSetValues(IO_parametres_widget->parent, args, n);
	  XtManageChild(IO_parametres_widget->parent);


	  /* Creating IO_load_image_separator Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition, 65); n++;
	  XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;

	  IO_load_image_separator = 
		XmCreateSeparator(IO_load_image_file_widget,
			"IO_load_image_separator",args,n);
	  XtManageChild(IO_load_image_separator);
	  

	  /* Creating IO_load_image_file_selection Widget */
 
	  n = 0;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;	
	  XtSetArg(args[n],XmNrightPosition,64); n++;
	}

	else {
	  /* Creating IO_load_image_file_selection Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	}
	
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	if (strcmp (repertoire_image, "") == 0)
		strcpy(repertoire_image, "*");

	XtSetArg(args[n],XmNdirMask,
		XmStringLtoRCreate(repertoire_image,
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNfilterLabelString,
		XmStringLtoRCreate(paneltabs[268],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNlistLabelString,
		XmStringLtoRCreate(paneltabs[270],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNbuttonFontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelFontList, gFontlist); n++;
	XtSetArg(args[n],XmNtextFontList, gSmall_fontlist); n++;

	IO_load_image_file_selection = 
          XtCreateWidget("IO_load_image_file_selection", 
			 xmFileSelectionBoxWidgetClass, 
			 IO_load_image_file_widget, args,n);

	/* help button unsensitive! */
	XtSetSensitive(XmFileSelectionBoxGetChild 
	   (IO_load_image_file_selection, XmDIALOG_HELP_BUTTON), False);
    
	XtManageChild(IO_load_image_file_selection);

	/* Adding Callbacks for IO_load_image_file_selection */ 

	XtAddCallback(IO_load_image_file_selection,XmNcancelCallback,
	IO_load_image_file_CANCEL_callb, IO_load_image_file_widget);

	IO_param_file = (xs_struc_widgetIO *) malloc (sizeof (xs_struc_widgetIO));
	IO_param_file->filewidget = IO_load_image_file_widget;
	IO_param_file->param = IO_parametres_widget;

	switch (typeimage) {

	case IO_LOAD_STANDARD:
	XtAddCallback(IO_load_image_file_selection,XmNokCallback,
		IO_load_image_stand_OK_callb,IO_load_image_file_widget); 
	break;
	case IO_LOAD_BSTANDARD:
	XtAddCallback(IO_load_image_file_selection,XmNokCallback,
		IO_load_image_bstand_OK_callb,IO_load_image_file_widget);
	break;
	case IO_LOAD_LTS:
	XtAddCallback(IO_load_image_file_selection,XmNokCallback,
		IO_load_image_lts_OK_callb,IO_param_file);
	break;
	case IO_LOAD_RGB:
	XtAddCallback(IO_load_image_file_selection,XmNokCallback,
		IO_load_image_rgb_OK_callb,IO_param_file);
	break;
	case IO_LOAD_MELANIE:
	XtAddCallback(IO_load_image_file_selection,XmNokCallback,
		IO_load_image_melanie_OK_callb,IO_load_image_file_widget);
	break;
	case IO_LOAD_SUN:
	XtAddCallback(IO_load_image_file_selection,XmNokCallback,
		IO_load_image_sun_OK_callb,IO_load_image_file_widget);
	break;
	case IO_LOAD_GEL_STANDARD:
	XtAddCallback(IO_load_image_file_selection,XmNokCallback,
		IO_load_gel_standard_OK_callb,IO_load_image_file_widget);
	break;
	case IO_LOAD_GEL_MELANIE:
	XtAddCallback(IO_load_image_file_selection,XmNokCallback,
		IO_load_gel_melanie_OK_callb,IO_load_image_file_widget);
	break;
	default: break;
}

	return(IO_load_image_file_widget);
}
