/* SCCS @(#)LaboImage.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            LaboImage.layout.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   LaboImage.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Interface for LaboImage                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include "LaboImage.layout.h"
#include "LaboImage.callback.h"
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include "tabmenu.h"
#include "icon/sobel1"
#include "icon/sobel2"
#include "icon/roberts1"
#include "icon/roberts2"
#include "icon/laplace1"
#include "icon/laplace2"
#include "icon/laplace3"
#include "global.h"
#include "define.h"
#include "win4.h"


#include "libwidgets/utilplane.h"

static Widget Quit_Labo;
static Widget Help_Labo;

XmFontList gFontlist, gSmall_fontlist;
Pixel      gOldLace, glavender, gthistle, gorchid;

char    *accelerator[];


/********* MORPHOLOGIE BINAIRE *****/
extern Widget build_Quit_Morpho_Bin();
extern void QUIT_actcall();

/********* GEL1D TOOL *****/
extern Widget build_Quit_Gel1D();
extern void QUIT_Gel1D_actcall();


/**********************************/
/* on inserera ici plus tard les differents flags globaux!!!!!!!!!!!!!*/
int     flag_compl = FALSE;
int	flag_creer = FALSE;
int	flag_help = FALSE; 
int	flag_help_only = FALSE;
int	flag_exec = OFF;
int 	flag_mapedit_open = FALSE;
int     flag_conv = FALSE;



/********************************************************
/   Layout Procedure for LaboImage 
/*******************************************************/

void
layout_LaboImage(labof22)
	Widget labof22;
 {
	Widget Form_4;
	Arg args[MAX_ARGS];
	int n;

	/* Les Fontes employees */

	gFontlist = FontNameToFontList(labof22,
	    "-adobe-times-bold-r-normal--14-140-75-75-p-77-iso8859-1");

	gSmall_fontlist = FontNameToFontList(labof22,
	    "-adobe-times-medium-r-normal--12-120-75-75-p-64-iso8859-1");

	/* Les couleurs employees */

        gOldLace = ColorNameToPixel(labof22,"OldLace");

	glavender = ColorNameToPixel(labof22,"lavender");

	gthistle = ColorNameToPixel(labof22,"thistle");

	gorchid = ColorNameToPixel(labof22,"orchid");

        
	/* Creating Quit_Labo Widget */ 

	Quit_Labo = build_Quit_Labo(labof22);

	/* Creating Help_Labo Widget */ 

	Help_Labo = build_Help_Labo(labof22);

	/* Creating Form_4 Widget */ 

	Form_4 = build_Form_4(labof22);
}


/********************************************************
/   Creation Function for Quit_Labo 
/*******************************************************/

Widget
build_Quit_Labo(labof22)
	Widget labof22;
{
	Arg args[MAX_ARGS];
	int n;

	/* Creating Quit_Labo Widget */ 

	n = 0;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(panel_titres[0],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNlabelFontList, gFontlist); n++;
	XtSetArg(args[n],XmNbuttonFontList, gFontlist); n++;
	XtSetArg(args[n],XmNmessageString,
		XmStringLtoRCreate(panel_titres[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNshadowThickness,2); n++;
	XtSetArg(args[n],XmNx,12); n++;
	XtSetArg(args[n],XmNy,14); n++;

	Quit_Labo = XmCreateInformationDialog(labof22,"Quit_Labo",args,n);

	/* Adding Callbacks for Quit_Labo */ 

	XtAddCallback(Quit_Labo,XmNcancelCallback,Cancel_Labo,NULL);
	XtAddCallback(Quit_Labo,XmNokCallback,OKquitLaboimage,NULL);

	return(Quit_Labo);
}


/********************************************************
/   Creation Function for Help_Labo 
/*******************************************************/

Widget 
build_Help_Labo(labof22)
	Widget labof22;
{
        Widget MainWindow_7;
        Widget WorkRegion;
        Dimension X, Y, Width;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Help_Labo Widget */ 

        n = 0;
	XtSetArg(args[n],XmNx, &X); n++;
	XtSetArg(args[n],XmNy, &Y); n++;
	XtSetArg(args[n],XmNwidth, &Width); n++;
        XtGetValues(labof22, args, n);
	
	n = 0;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNshadowThickness,2); n++;
	XtSetArg(args[n],XmNx,X+Width); n++;
	XtSetArg(args[n],XmNy,Y-30); n++;
	XtSetArg(args[n],XmNheight,297); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,350); n++;

	Help_Labo = XmCreateFormDialog(labof22,"Help_Labo",args,n);

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	MainWindow_7 = XmCreateMainWindow(Help_Labo,"MainWindow_7",args,n);
	XtManageChild(MainWindow_7);

        /* Creating WorkRegion Widget */

        n = 0;
        XtSetArg(args[n],XmNbackground, gOldLace); n++;
        XtSetArg(args[n],XmNheight,297); n++;
        XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;

        WorkRegion = CreateWorkRegion(MainWindow_7,"WorkRegion",args,n
);
        XtManageChild(WorkRegion);

        /* Creating Help_Area Widget */

        n = 0;
        XtSetArg(args[n],XmNeditMode,XmMULTI_LINE_EDIT); n++;
        XtSetArg(args[n],XmNheight,700); n++;
        Help_Area = XmCreateScrolledText(WorkRegion,"Help_Area", args,n);
        XtManageChild(Help_Area);

        /* Set parent's geometry resources */

        n = 0;
        XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
        XtSetValues(XtParent(Help_Area), args, n);

	return(Help_Labo);
}


/********************************************************
/   Creation Function for Form_4 
/*******************************************************/

Widget
build_Form_4(labof22)
	Widget labof22;
{
	Widget Form_4;
	Widget Form_2;
	Widget Frame_4;
	Widget Quit_Morpho_Bin;
        Widget Quit_Gel1D;
	Widget PushButton_6;
	Widget MenuBar_0;
	Widget IO;
	Widget DISPLAY;
	Widget PREPROCESSING;
	Widget PROCESSING;
	Widget MEASURES;
	Widget AUXILIARY;
	Widget TOOLS;
	Widget MACROS;
	Widget MainWindow_7;
	Widget WorkRegion;
	Widget scrollbar;
	Arg args[MAX_ARGS];
	int n;


	/* Creating Form_4 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,297); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,680); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;

	Form_4 = XmCreateForm(labof22,"Form_4",args,n);
	XtManageChild(Form_4);

	/* Creating Form_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,90); n++;

	Form_2 = XmCreateForm(Form_4,"Form_2",args,n);
	XtManageChild(Form_2);

	/* Creating Frame_4 Widget */ 

	Frame_4 = build_Frame_4(Form_2);

	/* Creating QUIT_Morpho_Bin Widget */ 

	Quit_Morpho_Bin = build_Quit_Morpho_Bin (labof22);

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,70); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,97); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 1); n++;

	QUIT_Morpho_Bin = XmCreatePushButton(Form_2,"QUIT_Morpho_Bin",args,n);
/*	XtManageChild(QUIT_Morpho_Bin);*/

	/* Adding Callbacks for QUIT_Morpho_Bin */ 

	XtAddCallback(QUIT_Morpho_Bin ,XmNactivateCallback,QUIT_actcall,Quit_Morpho_Bin);


	/* Creating QUIT_Gel1D Widget */ 

	Quit_Gel1D = build_Quit_Gel1D (labof22);

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,70); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,97); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 1); n++;

	QUIT_Gel1D = XmCreatePushButton(Form_2,"QUIT_Gel1D",args,n);
/*	XtManageChild(QUIT_Gel1D);*/

	/* Adding Callbacks for QUIT_Gel1D */ 

	XtAddCallback(QUIT_Gel1D ,XmNactivateCallback,
		      QUIT_Gel1D_actcall,Quit_Gel1D);

	/* Creating PushButton_6 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,70); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,97); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	PushButton_6 = XmCreatePushButton(Form_2,"PushButton_6",args,n);
	XtManageChild(PushButton_6);

	/* Adding Callbacks for PushButton_6 */ 

	XtAddCallback(PushButton_6,XmNactivateCallback,
		      Quit_Laboimage,Quit_Labo);

	/* Creating Menu_Gel1D Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 1); n++;
	XtSetArg(args[n],XmNheight, 30); n++;
	
	Menu_Gel1D = XmCreateMenuBar(Form_4,"Menu_Gel1D",args,n);
/*	XtManageChild(Menu_Gel1D);*/
        build_Menugel1D(Menu_Gel1D);

	/* Creating Menu_Morpho_Binaire Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, glavender); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 1); n++;
	XtSetArg(args[n],XmNheight, 30); n++;

	Menu_Morpho_Binaire = XmCreateMenuBar(Form_4,"Menu_Morpho_Binaire",args,n);
/*	XtManageChild(Menu_Morpho_Binaire);*/

	/* Creating MenuBar_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	MenuBar_0 = XmCreateMenuBar(Form_4,"MenuBar_0",args,n);
	XtManageChild(MenuBar_0);


	/* Creating MainWindow_7 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,Form_2); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNtopWidget,MenuBar_0); n++;

	MainWindow_7 = XmCreateMainWindow(Form_4,"MainWindow_7",args,n);
	XtManageChild(MainWindow_7);

        /* Creating WorkRegion Widget */

        n = 0;
        XtSetArg(args[n],XmNbackground, gOldLace); n++;
        XtSetArg(args[n],XmNheight,200); n++;
        XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;

        WorkRegion = CreateWorkRegion(MainWindow_7,"WorkRegion",args,n
);
        XtManageChild(WorkRegion);

        /* Creating Comment_Area Widget */

        n = 0;
        XtSetArg(args[n],XmNheight,700); n++;
        XtSetArg(args[n],XmNeditMode,XmMULTI_LINE_EDIT); n++;
        XtSetArg(args[n],XmNcursorPositionVisible, True); n++;
	XtSetArg(args[n],XmNeditable, False); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
        Comment_Area = 
	    XmCreateScrolledText(WorkRegion,"Comment_Area", args,n);
        XtManageChild(Comment_Area);

        /* Set parent's geometry resources */

        n = 0;
        XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
        XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
        XtSetValues(XtParent(Comment_Area), args, n);



/* Creating IO Widget */ 

	IO = build_IO(MenuBar_0, Comment_Area);

	/* Creating DISPLAY Widget */ 

	DISPLAY = build_DISPLAY(MenuBar_0, Comment_Area);

	/* Creating PREPROCESSING Widget */ 

	PREPROCESSING = build_PREPROCESSING(MenuBar_0, Comment_Area);

	/* Creating PROCESSING Widget */ 

	PROCESSING = build_PROCESSING(MenuBar_0, Comment_Area);

	/* Creating MEASURES Widget */ 

	MEASURES = build_MEASURES(MenuBar_0, Comment_Area);

	/* Creating AUXILIARY Widget */ 

	AUXILIARY = build_AUXILIARY(MenuBar_0, Comment_Area);

	/* Creating TOOLS Widget */ 

	TOOLS = build_TOOLS(MenuBar_0, Comment_Area);

	/* Creating MACROS Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("MACROS",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNsensitive, False); n++;

	MACROS = XmCreateCascadeButton(MenuBar_0,"MACROS",args,n);
	XtManageChild(MACROS);


	return(Form_4);
}


/********************************************************
/   Creation Function for Frame_4 
/*******************************************************/

Widget
build_Frame_4(Form_2)
	Widget Form_2;
{
	Widget Frame_4;
	Widget label_HELP;
	Widget Frame_41;
	Widget RadioBox_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Widget RadioButton_4;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Frame_4 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,1); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	Frame_4 = XmCreateFrame(Form_2,"Frame_4",args,n);
	XtManageChild(Frame_4);

	/* Creating label_HELP Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;

	label_HELP = XmCreateLabel (Frame_4,"label_HELP",args,n);
	XtManageChild(label_HELP);

	/* Creating Frame_41 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,11); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	Frame_41 = XmCreateFrame(Form_2,"Frame_41",args,n);
	XtManageChild(Frame_41);

	/* Creating RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	RadioBox_1 = XmCreateRadioBox(Frame_41,"RadioBox_1",args,n);
	XtManageChild(RadioBox_1);

	/* Creating RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("OFF",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,True); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox_1,"RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			Help_off, Help_Labo);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("ON",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox_1,"RadioButton_3",args,n);

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback,
			Help_on, Help_Labo);

	XtManageChild(RadioButton_3);


	/* Creating RadioButton_4 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("ONLY",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_4 = XmCreateToggleButton(RadioBox_1,"RadioButton_4",args,n);

	/* Adding Callbacks for RadioButton_4 */ 

	XtAddCallback(RadioButton_4,XmNvalueChangedCallback,
			Help_only, Help_Labo);

	XtManageChild(RadioButton_4);

	return(Frame_4);
}

/********************************************************
/   Creation Function for IO 
/*******************************************************/

Widget
build_IO(MenuBar_0, Comment_Area)
Widget MenuBar_0;
Widget Comment_Area;
{
	Widget IO;
	Widget PulldownMenu_26;
	Widget CascadeButton_27;
	Widget PulldownMenu_50;
	Widget Label_51;
	Widget Separator_52;
	Widget IO_load_image;
	Widget IO_load_imageb;
	Widget IO_load_lts;
	Widget IO_load_rgb;
	Widget IO_load_melanie;
	Widget IO_load_sun;
	Widget CascadeButton_28;
	Widget PulldownMenu_58;
	Widget Label_59;
	Widget Separator_60;
	Widget IO_store_single;
	Widget IO_store_cartesian;
	Widget IO_store_polar;
	Widget IO_store_rgb;
	Widget IO_store_melanie;
	Widget IO_store_sun;
	Widget CascadeButton_29;
	Widget PulldownMenu_66;
	Widget Label_67;
	Widget Separator_68;
	Widget IO_postscript_normal;
	Widget IO_postscript_maximum;
	Arg args[MAX_ARGS];
	int n;

	/* Creating IO Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNmnemonic, 'I'); n++;*/
	IO = XmCreateCascadeButton(MenuBar_0,"IO",args,n);

	/* Adding Callbacks for IO */ 

	XtAddCallback(IO,XmNcascadingCallback, IO_actcall,Comment_Area);

	XtManageChild(IO);

	/* Creating PulldownMenu_26 Widget */ 


	PulldownMenu_26 = CreatePulldownMenu(IO,"PulldownMenu_26",NULL,0);

	/* Creating CascadeButton_27 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(e_stabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNmnemonic, 'l'); n++;*/
	CascadeButton_27 = 
		XmCreateCascadeButton(PulldownMenu_26,"CascadeButton_27",args,n);
	/* Adding Callbacks for CascadeButton_27 */ 

	XtAddCallback(CascadeButton_27,XmNcascadingCallback, 
		      IO_load_actcall,Comment_Area);

	XtManageChild(CascadeButton_27);

	/* Creating PulldownMenu_50 Widget */ 


	PulldownMenu_50 = 
	  CreatePulldownMenu(CascadeButton_27,"PulldownMenu_50",NULL,0);

	/* Creating Label_51 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_51 = XmCreateLabel(PulldownMenu_50,"Label_51",args,n);
	XtManageChild(Label_51);

	/* Creating Separator_52 Widget */ 


	Separator_52 = XmCreateSeparator(PulldownMenu_50,"Separator_52",NULL,0);
	XtManageChild(Separator_52);

	/* Creating IO_load_image Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(acquistabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[0],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNaccelerator, "Esc<Key>i<Key>l<Key>s"); n++;
	XtSetArg(args[n],XmNmnemonic, 's'); n++;*/
	IO_load_image = XmCreatePushButton(PulldownMenu_50,"IO_load_image",args,n);

	/* Adding Callbacks for IO_load_image */ 

	XtAddCallback(IO_load_image,XmNactivateCallback,
				IO_load_image_actcall,Comment_Area);

	XtManageChild(IO_load_image);
	 
	/* Creating IO_load_imageb Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(acquistabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNaccelerator, "Esc<Keys>ilt"); n++;
	XtSetArg(args[n],XmNmnemonic, 't'); n++;*/
	IO_load_imageb = XmCreatePushButton(PulldownMenu_50,"IO_load_imageb",args,n);

	/* Adding Callbacks for IO_load_imageb */ 


	XtAddCallback(IO_load_imageb,XmNactivateCallback,
			IO_load_bimage_actcall,Comment_Area);

	XtManageChild(IO_load_imageb);

	/* Creating IO_load_lts Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(acquistabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[2],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNaccelerator, "Esc<Keys>i+l+l"); n++;
	XtSetArg(args[n],XmNmnemonic, 'l'); n++;*/
	IO_load_lts = XmCreatePushButton(PulldownMenu_50,"IO_load_lts",args,n);
	XtManageChild(IO_load_lts);

	/* Adding Callbacks for IO_load_lts */ 

	XtAddCallback(IO_load_lts,XmNactivateCallback,IO_load_lts_actcall,Comment_Area);

	/* Creating IO_load_rgb Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(acquistabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[3],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNaccelerator, "Esc<Key>i+Esc<Key>l+Esc<Key>r"); n++;
	XtSetArg(args[n],XmNmnemonic, 'r'); n++;*/
	IO_load_rgb = XmCreatePushButton(PulldownMenu_50,"IO_load_rgb",args,n);
	XtManageChild(IO_load_rgb);

	/* Adding Callbacks for IO_load_rgb */ 

	XtAddCallback(IO_load_rgb,XmNactivateCallback,IO_load_rgb_actcall,Comment_Area);

	/* Creating IO_load_melanie Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(acquistabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[4],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNaccelerator, "Esc<Key>i+<Key>l+<Key>m"); n++;
	XtSetArg(args[n],XmNmnemonic, 'm'); n++;*/
	IO_load_melanie = XmCreatePushButton(PulldownMenu_50,"IO_load_melanie",args,n);
	XtManageChild(IO_load_melanie);

	/* Adding Callbacks for IO_load_melanie */ 

	XtAddCallback(IO_load_melanie,
		   XmNactivateCallback,IO_load_melanie_actcall,Comment_Area);

        /* Creating IO_load_sun Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(acquistabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	IO_load_sun = XmCreatePushButton(PulldownMenu_50,"IO_load_sun",args,n);
	XtManageChild(IO_load_sun);

	/* Adding Callbacks for IO_load_sun */ 

	XtAddCallback(IO_load_sun,XmNactivateCallback,IO_load_sun_actcall,Comment_Area);

	/* Creating CascadeButton_28 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(e_stabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	CascadeButton_28 = 
		XmCreateCascadeButton(PulldownMenu_26,"CascadeButton_28",args,n);
	/* Adding Callbacks for CascadeButton_28 */ 

	XtAddCallback(CascadeButton_28,XmNcascadingCallback, 
		      IO_store_actcall,Comment_Area);

	XtManageChild(CascadeButton_28);

	/* Creating PulldownMenu_58 Widget */ 


	PulldownMenu_58 = CreatePulldownMenu(CascadeButton_28,"PulldownMenu_58",NULL,0);

	/* Creating Label_59 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[8],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_59 = XmCreateLabel(PulldownMenu_58,"Label_59",args,n);
	XtManageChild(Label_59);

	/* Creating Separator_60 Widget */ 


	Separator_60 = XmCreateSeparator(PulldownMenu_58,"Separator_60",NULL,0);
	XtManageChild(Separator_60);

	/* Creating IO_store_single Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sauvetabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[8],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	IO_store_single = XmCreatePushButton(PulldownMenu_58,"IO_store_single",args,n);
	XtManageChild(IO_store_single);

	/* Adding Callbacks for IO_store_single */ 

	XtAddCallback(IO_store_single,XmNactivateCallback,
			IO_store_single_actcall,Comment_Area);


	/* Creating IO_store_cartesian Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sauvetabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[9],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	IO_store_cartesian = 
		XmCreatePushButton(PulldownMenu_58,"IO_store_cartesian",args,n);
	XtManageChild(IO_store_cartesian);

	/* Adding Callbacks for IO_store_cartesian */ 

	XtAddCallback(IO_store_cartesian,XmNactivateCallback,
			IO_store_cartesian_actcall,Comment_Area);


	/* Creating IO_store_polar Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sauvetabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[10],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	IO_store_polar = XmCreatePushButton(PulldownMenu_58,"IO_store_polar",args,n);
	XtManageChild(IO_store_polar);

	/* Adding Callbacks for IO_store_polar */ 

	XtAddCallback(IO_store_polar,XmNactivateCallback,
				IO_store_polar_actcall,Comment_Area);


	/* Creating IO_store_rgb Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sauvetabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[11],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	IO_store_rgb = XmCreatePushButton(PulldownMenu_58,"IO_store_rgb",args,n);
	XtManageChild(IO_store_rgb);


	/* Adding Callbacks for IO_store_rgb */ 

	XtAddCallback(IO_store_rgb,XmNactivateCallback,
				IO_store_rgb_actcall,Comment_Area);


	/* Creating IO_store_melanie Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sauvetabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[12],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	IO_store_melanie =
		XmCreatePushButton(PulldownMenu_58,"IO_store_melanie",args,n);
	XtManageChild(IO_store_melanie);


	/* Adding Callbacks for IO_store_melanie */ 

	XtAddCallback(IO_store_melanie,XmNactivateCallback,
				IO_store_melanie_actcall,Comment_Area);


	/* Creating IO_store_sun Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(acquistabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	IO_store_sun = XmCreatePushButton(PulldownMenu_58,"IO_store_sun",args,n);
	XtManageChild(IO_store_sun);

	/* Adding Callbacks for IO_store_sun */ 

	XtAddCallback(IO_store_sun,XmNactivateCallback,
				IO_store_sun_actcall,Comment_Area);

	/* Creating CascadeButton_29 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(e_stabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	CascadeButton_29 = 
		XmCreateCascadeButton(PulldownMenu_26,"CascadeButton_29",args,n);
	/* Adding Callbacks for CascadeButton_29 */ 

	XtAddCallback(CascadeButton_29,XmNcascadingCallback, 
		      IO_postscript_actcall,Comment_Area);

	XtManageChild(CascadeButton_29);

	/* Creating PulldownMenu_66 Widget */ 


	PulldownMenu_66 = CreatePulldownMenu(CascadeButton_29,"PulldownMenu_66",NULL,0);

	/* Creating Label_67 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[9],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_67 = XmCreateLabel(PulldownMenu_66,"Label_67",args,n);
	XtManageChild(Label_67);

	/* Creating Separator_68 Widget */ 


	Separator_68 = XmCreateSeparator(PulldownMenu_66,"Separator_68",NULL,0);
	XtManageChild(Separator_68);

	/* Creating IO_postscript_normal Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(lasertabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[15],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	IO_postscript_normal = 
		XmCreatePushButton(PulldownMenu_66,"IO_postscript_normal",args,n);
	XtManageChild(IO_postscript_normal);

	/* Adding Callbacks for IO_postscript_normal */ 

	XtAddCallback(IO_postscript_normal,
		XmNactivateCallback,IO_postscript_normal_actcall,Comment_Area);


	/* Creating IO_postscript_maximum Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(lasertabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[16],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	IO_postscript_maximum = 
		XmCreatePushButton(PulldownMenu_66,"IO_postscript_maximum",args,n);
	XtManageChild(IO_postscript_maximum);

	/* Adding Callbacks for IO_postscript_maximum */ 

	XtAddCallback(IO_postscript_maximum,
		XmNactivateCallback,IO_postscript_maximum_actcall,Comment_Area);

	return(IO);
}


/********************************************************
/   Creation Function for DISPLAY 
/*******************************************************/

Widget
build_DISPLAY(MenuBar_0, Comment_Area)
	Widget MenuBar_0;
Widget Comment_Area;
{
	Widget DISPLAY;
	Widget PulldownMenu_92;
	Widget DISPLAY_show_image;
	Widget PulldownMenu_94;
	Widget Label_95;
	Widget Separator_96;
	Widget DISPLAY_show_graytonelin;
	Widget DISPLAY_show_graytonelog;
	Widget DISPLAY_show_threshold;
	Widget DISPLAY_show_floydst;
	Widget DISPLAY_show_rgbdirect;
	Widget DISPLAY_show_rgbfloydst;
	Widget DISPLAY_3Dpersp;
	Widget DISPLAY_lookup_table_edit;
	Arg args[MAX_ARGS];
	int n;

	/* Creating DISPLAY Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	DISPLAY = XmCreateCascadeButton(MenuBar_0,"DISPLAY",args,n);

	/* Adding Callbacks for DISPLAY */ 

	XtAddCallback(DISPLAY,XmNcascadingCallback, 
		      DISPLAY_actcall,Comment_Area);

	XtManageChild(DISPLAY);

	/* Creating PulldownMenu_92 Widget */ 


	PulldownMenu_92 = CreatePulldownMenu(DISPLAY,"PulldownMenu_92",NULL,0);

	/* Creating DISPLAY_show_image Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	DISPLAY_show_image = 
		XmCreateCascadeButton(PulldownMenu_92,"DISPLAY_show_image",args,n);
	/* Adding Callbacks for DISPLAY_show_image */ 

	XtAddCallback(DISPLAY_show_image,XmNcascadingCallback, 
		      DISPLAY_show_actcall,Comment_Area);

		XtManageChild(DISPLAY_show_image);

	/* Creating PulldownMenu_94 Widget */ 


	PulldownMenu_94 = 
		CreatePulldownMenu(DISPLAY_show_image,"PulldownMenu_94",NULL,0);

	/* Creating Label_95 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[10],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_95 = XmCreateLabel(PulldownMenu_94,"Label_95",args,n);
	XtManageChild(Label_95);

	/* Creating Separator_96 Widget */ 


	Separator_96 = XmCreateSeparator(PulldownMenu_94,"Separator_96",NULL,0);
	XtManageChild(Separator_96);

	/* Creating DISPLAY_show_graytonelin Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(affichtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[22],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	DISPLAY_show_graytonelin = 
		XmCreatePushButton(PulldownMenu_94,"DISPLAY_show_graytonelin",args,n);
	XtManageChild(DISPLAY_show_graytonelin);

	/* Adding Callbacks for DISPLAY_show_graytonelin */ 

	XtAddCallback(DISPLAY_show_graytonelin,
		XmNactivateCallback,DISPLAY_show_graytonelin_actcall,Comment_Area);

	/* Creating DISPLAY_show_graytonelog Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(affichtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[23],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	DISPLAY_show_graytonelog = 
		XmCreatePushButton(PulldownMenu_94,"DISPLAY_show_graytonelog",args,n);
	XtManageChild(DISPLAY_show_graytonelog);

	/* Adding Callbacks for DISPLAY_show_graytonelog */ 

	XtAddCallback(DISPLAY_show_graytonelog,
		XmNactivateCallback,DISPLAY_show_graytonelog_actcall,Comment_Area);

	/* Creating DISPLAY_show_threshold Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(affichtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[20],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	DISPLAY_show_threshold = 
		XmCreatePushButton(PulldownMenu_94,"DISPLAY_show_threshold",args,n);
	XtManageChild(DISPLAY_show_threshold);

	/* Adding Callbacks for DISPLAY_show_threshold */ 

	XtAddCallback(DISPLAY_show_threshold,
		XmNactivateCallback,DISPLAY_show_threshold_actcall,Comment_Area);

	/* Creating DISPLAY_show_floydst Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(affichtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[21],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	DISPLAY_show_floydst = 
		XmCreatePushButton(PulldownMenu_94,"DISPLAY_show_floydst",args,n);
	XtManageChild(DISPLAY_show_floydst);

	/* Adding Callbacks for DISPLAY_show_floydst */ 

	XtAddCallback(DISPLAY_show_floydst,
		XmNactivateCallback,DISPLAY_show_floydst_actcall,Comment_Area);

	/* Creating DISPLAY_show_rgbdirect Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(affichtabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[24],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	DISPLAY_show_rgbdirect = 
		XmCreatePushButton(PulldownMenu_94,"DISPLAY_show_rgbdirect",args,n);
	XtManageChild(DISPLAY_show_rgbdirect);

	/* Adding Callbacks for DISPLAY_show_rgbdirect */ 

	XtAddCallback(DISPLAY_show_rgbdirect,
		XmNactivateCallback,DISPLAY_show_rgbdirect_actcall,Comment_Area);

	/* Creating DISPLAY_show_rgbfloydst Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(affichtabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[25],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	DISPLAY_show_rgbfloydst = 
		XmCreatePushButton(PulldownMenu_94,"DISPLAY_show_rgbfloydst",args,n);
	XtManageChild(DISPLAY_show_rgbfloydst);

	/* Adding Callbacks for DISPLAY_show_rgbfloydst */ 

	XtAddCallback(DISPLAY_show_rgbfloydst,
		XmNactivateCallback,DISPLAY_show_rgbfloydst_actcall,Comment_Area);

	/* Creating DISPLAY_3Dpersp Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[28],
			XmSTRING_DEFAULT_CHARSET)); n++;*/
	XtSetArg(args[n],XmNsensitive, False); n++;

	DISPLAY_3Dpersp = XmCreatePushButton(PulldownMenu_92,"DISPLAY_3Dpersp",args,n);
	XtManageChild(DISPLAY_3Dpersp);

	/* Adding Callbacks for DISPLAY_3Dpersp */ 

	XtAddCallback(DISPLAY_3Dpersp,XmNactivateCallback,
				DISPLAY_3Dpersp_actcall,Comment_Area);

	/* Creating DISPLAY_lookup_table_edit Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(disptabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;
/*	XtSetArg(args[n],XmNacceleratorText,
		XmStringLtoRCreate(accelerator[29],
			XmSTRING_DEFAULT_CHARSET)); n++;*/

	DISPLAY_lookup_table_edit = 
		XmCreatePushButton(PulldownMenu_92,"DISPLAY_lookup_table_edit",args,n);
	XtManageChild(DISPLAY_lookup_table_edit);

	/* Adding Callbacks for DISPLAY_lookup_table_edit */ 

	XtAddCallback(DISPLAY_lookup_table_edit,XmNactivateCallback,
			DISPLAY_lookup_table_edit_actcall,Comment_Area);

	return(DISPLAY);
}


/********************************************************
/   Creation Function for PREPROCESSING 
/*******************************************************/

Widget
build_PREPROCESSING(MenuBar_0, Comment_Area)
	Widget MenuBar_0;
Widget Comment_Area;
{
	Widget PREPROCESSING;
	Widget PulldownMenu_71;
	Widget PREPRO_histo_equal;
	Widget PREPRO_enhancement;
	Widget PulldownMenu_75;
	Widget Label_76;
	Widget Separator_77;
	Widget PREPRO_enhanc_median_filter;
	Widget PREPRO_enhanc_high_pass_filter;
	Widget PREPRO_freq_dom_filters;
	Widget PulldownMenu_81;
	Widget Label_83;
	Widget Separator_84;
	Widget PREPRO_hamming;
	Widget PREPRO_hanning;
	Widget PREPRO_gaussian;
	Widget PREPRO_correct_background;
	Arg args[MAX_ARGS];
	int n;

	/* Creating PREPROCESSING Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPROCESSING = XmCreateCascadeButton(MenuBar_0,"PREPROCESSING",args,n);

	/* Adding Callbacks for PREPROCESSING */ 

	XtAddCallback(PREPROCESSING,XmNcascadingCallback, 
		      PREPROCESSING_actcall,Comment_Area);

	XtManageChild(PREPROCESSING);

	/* Creating PulldownMenu_71 Widget */ 


	PulldownMenu_71 = CreatePulldownMenu(PREPROCESSING,"PulldownMenu_71",NULL,0);

	/* Creating PREPRO_histo_equal Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(rehausstabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_histo_equal = 
		XmCreatePushButton(PulldownMenu_71,"PREPRO_histo_equal",args,n);
	XtManageChild(PREPRO_histo_equal);

	/* Adding Callbacks for PREPRO_histo_equal */ 

	XtAddCallback(PREPRO_histo_equal,XmNactivateCallback,
			PREPRO_histo_equal_actcall,Comment_Area);

	/* Creating PREPRO_enhancement Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_enhancement = 
		XmCreateCascadeButton(PulldownMenu_71,"PREPRO_enhancement",args,n);
	/* Adding Callbacks for PREPRO_enhancement */ 

	XtAddCallback(PREPRO_enhancement,XmNcascadingCallback, 
		      PREPRO_enhancement_actcall,Comment_Area);

	XtManageChild(PREPRO_enhancement);

	/* Creating PulldownMenu_75 Widget */ 


	PulldownMenu_75 = 
		CreatePulldownMenu(PREPRO_enhancement,"PulldownMenu_75",NULL,0);

	/* Creating Label_76 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[18],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_76 = XmCreateLabel(PulldownMenu_75,"Label_76",args,n);
	XtManageChild(Label_76);

	/* Creating Separator_77 Widget */ 


	Separator_77 = XmCreateSeparator(PulldownMenu_75,"Separator_77",NULL,0);
	XtManageChild(Separator_77);

	/* Creating PREPRO_enhanc_median_filter Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(rehausstabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_enhanc_median_filter = 
		XmCreatePushButton(PulldownMenu_75,"PREPRO_enhanc_median_filter",args,n);
	XtManageChild(PREPRO_enhanc_median_filter);

	/* Adding Callbacks for PREPRO_enhanc_median_filter */ 

	XtAddCallback(PREPRO_enhanc_median_filter,
		XmNactivateCallback,PREPRO_enhanc_median_filter_actcall,Comment_Area);

	/* Creating PREPRO_enhanc_high_pass_filter Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(rehausstabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_enhanc_high_pass_filter = 
		XmCreatePushButton(PulldownMenu_75,"PREPRO_enhanc_high_pass_filter",args,n);
	XtManageChild(PREPRO_enhanc_high_pass_filter);

	/* Adding Callbacks for PREPRO_enhanc_high_pass_filter */ 

	XtAddCallback(PREPRO_enhanc_high_pass_filter,XmNactivateCallback,
		PREPRO_enhanc_high_pass_filter_actcall,Comment_Area);

	/* Creating PREPRO_freq_dom_filters Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(rehausstabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_freq_dom_filters = 
		XmCreateCascadeButton(PulldownMenu_75,"PREPRO_freq_dom_filters",args,n);
	/* Adding Callbacks for PREPRO_freq_dom_filters */ 

	XtAddCallback(PREPRO_freq_dom_filters,XmNcascadingCallback, 
		      PREPRO_filters_actcall,Comment_Area);

	XtManageChild(PREPRO_freq_dom_filters);

	/* Creating PulldownMenu_81 Widget */ 


	PulldownMenu_81 = 
		CreatePulldownMenu(PREPRO_freq_dom_filters,"PulldownMenu_81",NULL,0);

	/* Creating Label_83 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[38],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_83 = XmCreateLabel(PulldownMenu_81,"Label_83",args,n);
	XtManageChild(Label_83);

	/* Creating Separator_84 Widget */ 


	Separator_84 = XmCreateSeparator(PulldownMenu_81,"Separator_84",NULL,0);
	XtManageChild(Separator_84);

	/* Creating PREPRO_hamming Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(freqfltrtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_hamming = XmCreatePushButton(PulldownMenu_81,"PREPRO_hamming",args,n);
	XtManageChild(PREPRO_hamming);

	/* Adding Callbacks for PREPRO_hamming */ 

	XtAddCallback(PREPRO_hamming,XmNactivateCallback,
			PREPRO_hamming_actcall,Comment_Area);

	/* Creating PREPRO_hanning Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(freqfltrtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_hanning = XmCreatePushButton(PulldownMenu_81,"PREPRO_hanning",args,n);
	XtManageChild(PREPRO_hanning);

	/* Adding Callbacks for PREPRO_hanning */ 

	XtAddCallback(PREPRO_hanning,XmNactivateCallback,
				PREPRO_hanning_actcall,Comment_Area);

	/* Creating PREPRO_gaussian Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(freqfltrtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_gaussian = XmCreatePushButton(PulldownMenu_81,"PREPRO_gaussian",args,n);
	XtManageChild(PREPRO_gaussian);

	/* Adding Callbacks for PREPRO_gaussian */ 

	XtAddCallback(PREPRO_gaussian,XmNactivateCallback,
			PREPRO_gaussian_actcall,Comment_Area);

	/* Creating PREPRO_correct_background Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_correct_background = 
		XmCreatePushButton(PulldownMenu_71,"PREPRO_correct_background",args,n);
	XtManageChild(PREPRO_correct_background);

	/* Adding Callbacks for PREPRO_correct_background */ 

	XtAddCallback(PREPRO_correct_background,XmNactivateCallback,
			PREPRO_correct_background_actcall,Comment_Area);

	return(PREPROCESSING);
}


/********************************************************
/   Creation Function for PROCESSING 
/*******************************************************/

Widget
build_PROCESSING(MenuBar_0, Comment_Area)
	Widget MenuBar_0;
Widget Comment_Area;
{
	Widget PROCESSING;
	Widget PulldownMenu_105;
	Widget PROCESS_aut_threshold;
	Widget PulldownMenu_107;
	Widget PROCESS_lapla_perc_histo;
	Widget PROCESS_dyn_threshold;
	Widget PROCESS_transforms;
	Widget PulldownMenu_111;
	Widget Label_112;
	Widget Separator_113;
	Widget PROCESS_complex_fourier_2D;
	Widget PROCESS_complex_inverse_fourier_2D;
	Widget PROCESS_complex_optical_fourier_2D;
	Widget PROCESS_complex_opt_inv_fourier_2D;
	Widget Separator_119;
	Widget Label_120;
	Widget Separator_121;
	Widget PROCESS_real_fourier_2D;
	Widget PROCESS_real_optical_fourier_2D;
	Widget PROCESS_convolution;
	Widget PulldownMenu_125;
	Widget Label_126;
	Widget Separator_127;
	Widget PROCESS_convol_createmask;
	Widget PROCESS_convol;
	Widget PulldownMenu_130;
	Widget Label_131;
	Widget Separator_132;
	Widget PROCESS_convol_mask;
	Widget PROCESS_convol_image;
	Widget PROCESS_correl;
	Widget PulldownMenu_136;
	Widget Label_137;
	Widget Separator_138;
	Widget PROCESS_correl_mask;
	Widget PROCESS_correl_image;
        Pixmap bitmap_option, pix;
	GC gc;
	XGCValues values;
	Widget PROCESS_edges;
	Widget PulldownMenu_142;
	Widget Label_143;
	Widget Separator_144;
	Widget PROCESS_edges_sobel;
	Widget PulldownMenu_146;
	Widget PROCESS_edges_sobel_racine;
	Widget PROCESS_edges_sobel_absolue;
	Widget PROCESS_edges_laplacian;
	Widget PulldownMenu_laplacian;
	Widget PROCESS_edges_laplacian_1;
	Widget PROCESS_edges_laplacian_2;
	Widget PROCESS_edges_laplacian_3;
	Widget PROCESS_edges_roberts;
	Widget PulldownMenu_151;
	Widget PROCESS_edges_roberts_racine;
	Widget PROCESS_edges_roberts_absolue;
	Widget PROCESS_edges_frei_chen;
	Widget PROCESS_edges_mero_vassy;
	Widget PROCESS_edges_zero_crossing;
	Widget PROCESS_edges_ridge_riding;
	Widget PROCESS_regions;
	Widget PulldownMenu_159;
	Widget Label_160;
	Widget Separator_161;
	Widget PROCESS_region_growing;
	Widget PROCESS_regions_OPR;
	Widget PulldownMenu_164;
	Widget Label_165;
	Widget Separator_166;
	Widget PROCESS_OPR_graytone;
	Widget PROCESS_OPR_rgb;
/*
	Widget PROCESS_regions_graph;
	Widget PulldownMenu_171;
	Widget Label_172;
	Widget Separator_173;
	Widget PROCESS_graph_construction;
	Widget PROCESS_graph_image;
	Widget PROCESS_region_extraction;
	Widget PROCESS_elimin_small_regions;
*/
	Widget PROCESS_binary_morpho;
	Widget PROCESS_gray_scale_morpho;
	Widget PulldownMenu_180;
	Widget Label_181;
	Widget Separator_182;
	Widget PROCESS_erosion;
	Widget PulldownMenu_184;
	Widget Label_185;
	Widget Separator_186;
	Widget PROCESS_erosion_sphere;
	Widget PROCESS_erosion_cone;
	Widget PROCESS_erosion_cylinder;
	Widget PROCESS_erosion_gaussian;
	Widget PROCESS_erosion_imageplane;
	Widget PROCESS_dilatation;
	Widget PulldownMenu_193;
	Widget Label_194;
	Widget Separator_195;
	Widget PROCESS_dilatation_sphere;
	Widget PROCESS_dilatation_cone;
	Widget PROCESS_dilatation_cylinder;
	Widget PROCESS_dilatation_gaussian;
	Widget PROCESS_dilatation_imageplane;
	Widget PROCESS_opening;
	Widget PulldownMenu_202;
	Widget Label_203;
	Widget Separator_204;
	Widget PROCESS_opening_sphere;
	Widget PROCESS_opening_cone;
	Widget PROCESS_opening_cylinder;
	Widget PROCESS_opening_gaussian;
	Widget PROCESS_opening_imageplane;
	Widget PROCESS_closure;
	Widget PulldownMenu_212;
	Widget Label_213;
	Widget Separator_214;
	Widget PROCESS_closure_sphere;
	Widget PROCESS_closure_cone;
	Widget PROCESS_closure_cylinder;
	Widget PROCESS_closure_gaussian;
	Widget PROCESS_closure_imageplane;
	Arg args[MAX_ARGS];
	int n;

	/* Creating PROCESSING Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESSING = XmCreateCascadeButton(MenuBar_0,"PROCESSING",args,n);

	/* Adding Callbacks for PROCESSING */ 

	XtAddCallback(PROCESSING,XmNcascadingCallback, 
		      PROCESSING_actcall, Comment_Area);

	XtManageChild(PROCESSING);

	/* Creating PulldownMenu_105 Widget */ 


	PulldownMenu_105 = CreatePulldownMenu(PROCESSING,"PulldownMenu_105",NULL,0);

	/* Creating PROCESS_aut_threshold Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_aut_threshold = 
		XmCreateCascadeButton(PulldownMenu_105,"PROCESS_aut_threshold",args,n);
	/* Adding Callbacks for PROCESS_aut_threshold */ 

	XtAddCallback(PROCESS_aut_threshold,XmNcascadingCallback, 
		      PROCESS_thresh_actcall, Comment_Area);

	XtManageChild(PROCESS_aut_threshold);

	/* Creating PulldownMenu_107 Widget */ 


	PulldownMenu_107 = 
		CreatePulldownMenu(PROCESS_aut_threshold,"PulldownMenu_107",NULL,0);

	/* Creating PROCESS_lapla_perc_histo Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(seuiltabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_lapla_perc_histo = 
		XmCreatePushButton(PulldownMenu_107,"PROCESS_lapla_perc_histo",args,n);
	XtManageChild(PROCESS_lapla_perc_histo);

	/* Adding Callbacks for PROCESS_lapla_perc_histo */ 

	XtAddCallback(PROCESS_lapla_perc_histo,
		XmNactivateCallback,PROCESS_lapla_perc_histo_actcall,Comment_Area);

	/* Creating PROCESS_dyn_threshold Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(seuiltabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_dyn_threshold = 
		XmCreatePushButton(PulldownMenu_107,"PROCESS_dyn_threshold",args,n);
	XtManageChild(PROCESS_dyn_threshold);

	/* Adding Callbacks for PROCESS_dyn_threshold */ 

	XtAddCallback(PROCESS_dyn_threshold,
		XmNactivateCallback,PROCESS_dyn_threshold_actcall,Comment_Area);

	/* Creating PROCESS_transforms Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_transforms = 
		XmCreateCascadeButton(PulldownMenu_105,"PROCESS_transforms",args,n);
	/* Adding Callbacks for PROCESS_transforms */ 

	XtAddCallback(PROCESS_transforms,XmNcascadingCallback, 
		      PROCESS_transforms_actcall, Comment_Area);

	XtManageChild(PROCESS_transforms);

	/* Creating PulldownMenu_111 Widget */ 


	PulldownMenu_111 = 
		CreatePulldownMenu(PROCESS_transforms,"PulldownMenu_111",NULL,0);

	/* Creating Label_112 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(typtransftabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_112 = XmCreateLabel(PulldownMenu_111,"Label_112",args,n);
	XtManageChild(Label_112);

	/* Creating Separator_113 Widget */ 


	Separator_113 = XmCreateSeparator(PulldownMenu_111,"Separator_113",NULL,0);
	XtManageChild(Separator_113);

	/* Creating PROCESS_complex_fourier_2D Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(transformtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_complex_fourier_2D = 
		XmCreatePushButton(PulldownMenu_111,"PROCESS_complex_fourier_2D",args,n);
	XtManageChild(PROCESS_complex_fourier_2D);

	/* Adding Callbacks for PROCESS_complex_fourier_2D */ 

	XtAddCallback(PROCESS_complex_fourier_2D,
		XmNactivateCallback,PROCESS_complex_fourier_2D_actcall,Comment_Area);

	/* Creating PROCESS_complex_inverse_fourier_2D Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(transformtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_complex_inverse_fourier_2D = 
		XmCreatePushButton(PulldownMenu_111,"PROCESS_complex_inverse_fourier_2D",args,n);
	XtManageChild(PROCESS_complex_inverse_fourier_2D);

	/* Adding Callbacks for PROCESS_complex_inverse_fourier_2D */ 

	XtAddCallback(PROCESS_complex_inverse_fourier_2D,
		XmNactivateCallback,PROCESS_complex_inverse_fourier_2D_actcall,Comment_Area);

	/* Creating PROCESS_complex_optical_fourier_2D Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(transformtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_complex_optical_fourier_2D = 
	XmCreatePushButton(PulldownMenu_111,"PROCESS_complex_optical_fourier_2D",args,n);
	XtManageChild(PROCESS_complex_optical_fourier_2D);

	/* Adding Callbacks for PROCESS_complex_optical_fourier_2D */ 

	XtAddCallback(PROCESS_complex_optical_fourier_2D,
	XmNactivateCallback,PROCESS_complex_optical_fourier_2D_actcall,Comment_Area);

	/* Creating PROCESS_complex_opt_inv_fourier_2D Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(transformtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_complex_opt_inv_fourier_2D = 
	XmCreatePushButton(PulldownMenu_111,"PROCESS_complex_opt_inv_fourier_2D",args,n);
	XtManageChild(PROCESS_complex_opt_inv_fourier_2D);

	/* Adding Callbacks for PROCESS_complex_opt_inv_fourier_2D */ 

	XtAddCallback(PROCESS_complex_opt_inv_fourier_2D,
	XmNactivateCallback,PROCESS_complex_opt_inv_fourier_2D_actcall,Comment_Area);

	/* Creating Separator_119 Widget */ 


	Separator_119 = XmCreateSeparator(PulldownMenu_111,"Separator_119",NULL,0);
	XtManageChild(Separator_119);

	/* Creating Label_120 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(typtransftabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_120 = XmCreateLabel(PulldownMenu_111,"Label_120",args,n);
	XtManageChild(Label_120);

	/* Creating Separator_121 Widget */ 


	Separator_121 = XmCreateSeparator(PulldownMenu_111,"Separator_121",NULL,0);
	XtManageChild(Separator_121);

	/* Creating PROCESS_real_fourier_2D Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(transformtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_real_fourier_2D = 
	XmCreatePushButton(PulldownMenu_111,"PROCESS_real_fourier_2D",args,n);
	XtManageChild(PROCESS_real_fourier_2D);

	/* Adding Callbacks for PROCESS_real_fourier_2D */ 

	XtAddCallback(PROCESS_real_fourier_2D,
		XmNactivateCallback,PROCESS_real_fourier_2D_actcall,Comment_Area);

	/* Creating PROCESS_real_optical_fourier_2D Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(transformtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_real_optical_fourier_2D = 
	XmCreatePushButton(PulldownMenu_111,"PROCESS_real_optical_fourier_2D",args,n);
	XtManageChild(PROCESS_real_optical_fourier_2D);

	/* Adding Callbacks for PROCESS_real_optical_fourier_2D */ 

	XtAddCallback(PROCESS_real_optical_fourier_2D,
	XmNactivateCallback,PROCESS_real_optical_fourier_2D_actcall,Comment_Area);

	/* Creating PROCESS_convolution Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_convolution = 
		XmCreateCascadeButton(PulldownMenu_105,"PROCESS_convolution",args,n);
	/* Adding Callbacks for PROCESS_convolution */ 

	XtAddCallback(PROCESS_convolution,XmNcascadingCallback, 
		      PROCESS_convolution_actcall, Comment_Area);

	XtManageChild(PROCESS_convolution);

	/* Creating PulldownMenu_125 Widget */ 


	PulldownMenu_125 = 
		CreatePulldownMenu(PROCESS_convolution,"PulldownMenu_125",NULL,0);

	/* Creating Label_126 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[17],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_126 = XmCreateLabel(PulldownMenu_125,"Label_126",args,n);
	XtManageChild(Label_126);

	/* Creating Separator_127 Widget */ 


	Separator_127 = XmCreateSeparator(PulldownMenu_125,"Separator_127",NULL,0);
	XtManageChild(Separator_127);

	/* Creating PROCESS_convol_createmask Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(convcorrtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_convol_createmask = 
		XmCreatePushButton(PulldownMenu_125,"PROCESS_convol_createmask",args,n);
	XtManageChild(PROCESS_convol_createmask);

	/* Adding Callbacks for PROCESS_convol_createmask */ 

	XtAddCallback(PROCESS_convol_createmask,
		XmNactivateCallback,PROCESS_convol_createmask_actcall,Comment_Area);

	/* Creating PROCESS_convol Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(convcorrtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_convol = 
		XmCreateCascadeButton(PulldownMenu_125,"PROCESS_convol",args,n);

	/* Adding Callbacks for PROCESS_convol */ 

	XtAddCallback(PROCESS_convol,XmNcascadingCallback, 
		      PROCESS_convol_actcall, Comment_Area);

	XtManageChild(PROCESS_convol);

	/* Creating PulldownMenu_130 Widget */ 


	PulldownMenu_130 = CreatePulldownMenu(PROCESS_convol,"PulldownMenu_130",NULL,0);

	/* Creating Label_131 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[39],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_131 = XmCreateLabel(PulldownMenu_130,"Label_131",args,n);
	XtManageChild(Label_131);

	/* Creating Separator_132 Widget */ 


	Separator_132 = XmCreateSeparator(PulldownMenu_130,"Separator_132",NULL,0);
	XtManageChild(Separator_132);

	/* Creating PROCESS_convol_mask Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(typconvcorrtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_convol_mask = 
		XmCreatePushButton(PulldownMenu_130,"PROCESS_convol_mask",args,n);
	XtManageChild(PROCESS_convol_mask);

	/* Adding Callbacks for PROCESS_convol_mask */ 

	XtAddCallback(PROCESS_convol_mask,
		XmNactivateCallback,PROCESS_convol_mask_actcall,Comment_Area);

	/* Creating PROCESS_convol_image Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(typconvcorrtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_convol_image = 
		XmCreatePushButton(PulldownMenu_130,"PROCESS_convol_image",args,n);
	XtManageChild(PROCESS_convol_image);

	/* Adding Callbacks for PROCESS_convol_image */ 

	XtAddCallback(PROCESS_convol_image,
		XmNactivateCallback,PROCESS_convol_image_actcall,Comment_Area);

	/* Creating PROCESS_correl Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(convcorrtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_correl = 
		XmCreateCascadeButton(PulldownMenu_125,"PROCESS_correl",args,n);

	/* Adding Callbacks for PROCESS_correl */ 

	XtAddCallback(PROCESS_correl,XmNcascadingCallback, 
		      PROCESS_correl_actcall, Comment_Area);

	XtManageChild(PROCESS_correl);

	/* Creating PulldownMenu_136 Widget */ 


	PulldownMenu_136 = CreatePulldownMenu(PROCESS_correl,"PulldownMenu_136",NULL,0);

	/* Creating Label_137 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[39],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_137 = XmCreateLabel(PulldownMenu_136,"Label_137",args,n);
	XtManageChild(Label_137);

	/* Creating Separator_138 Widget */ 


	Separator_138 = XmCreateSeparator(PulldownMenu_136,"Separator_138",NULL,0);
	XtManageChild(Separator_138);

	/* Creating PROCESS_correl_mask Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(typconvcorrtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_correl_mask = 
		XmCreatePushButton(PulldownMenu_136,"PROCESS_correl_mask",args,n);
	XtManageChild(PROCESS_correl_mask);

	/* Adding Callbacks for PROCESS_correl_mask */ 

	XtAddCallback(PROCESS_correl_mask,
		XmNactivateCallback,PROCESS_correl_mask_actcall,Comment_Area);

	/* Creating PROCESS_correl_image Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(typconvcorrtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_correl_image = 
		XmCreatePushButton(PulldownMenu_136,"PROCESS_correl_image",args,n);
	XtManageChild(PROCESS_correl_image);

	/* Adding Callbacks for PROCESS_correl_image */ 

	XtAddCallback(PROCESS_correl_image,
		XmNactivateCallback,PROCESS_correl_image_actcall,Comment_Area);

	/* Creating PROCESS_edges Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_edges = XmCreateCascadeButton(PulldownMenu_105,"PROCESS_edges",args,n);
	/* Adding Callbacks for PROCESS_edges */ 

	XtAddCallback(PROCESS_edges,XmNcascadingCallback, 
		      PROCESS_edges_actcall, Comment_Area);

	XtManageChild(PROCESS_edges);

	/* Creating PulldownMenu_142 Widget */ 


	PulldownMenu_142 = CreatePulldownMenu(PROCESS_edges,"PulldownMenu_142",NULL,0);

	/* Creating Label_143 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[19],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_143 = XmCreateLabel(PulldownMenu_142,"Label_143",args,n);
	XtManageChild(Label_143);

	/* Creating Separator_144 Widget */ 


	Separator_144 = XmCreateSeparator(PulldownMenu_142,"Separator_144",NULL,0);
	XtManageChild(Separator_144);

	/* Creating PROCESS_edges_sobel Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(contourtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_edges_sobel = 
		XmCreateCascadeButton(PulldownMenu_142,"PROCESS_edges_sobel",args,n);

	/* Adding Callbacks for PROCESS_edges_sobel */ 

	XtAddCallback(PROCESS_edges_sobel,XmNcascadingCallback, 
		      PROCESS_edges_sobel_actcall, Comment_Area);


	XtManageChild(PROCESS_edges_sobel);

	/* Creating PulldownMenu_146 Widget */ 


	PulldownMenu_146 = 
		CreatePulldownMenu(PROCESS_edges_sobel,"PulldownMenu_146",NULL,0);

	/* Creating PROCESS_edges_sobel_racine Widget */ 

	PROCESS_edges_sobel_racine = 
	    XmCreatePushButton(PulldownMenu_146,"PROCESS_edges_sobel_racine",NULL, 0);

	XtManageChild(PROCESS_edges_sobel_racine);

        n = 0;
	XtSetArg(args[n],XmNforeground, &values.foreground);n++;
	XtSetArg(args[n],XmNbackground, &values.background);n++;
	XtGetValues(PROCESS_edges_sobel_racine, args, n);
        gc = XtGetGC (PROCESS_edges_sobel_racine, 
		        GCForeground|GCBackground, &values);
        bitmap_option = XCreateBitmapFromData (
				      XtDisplay(PROCESS_edges_sobel_racine), 
				      RootWindowOfScreen(XtScreen(PROCESS_edges_sobel_racine)),
				      sobel1_bits, sobel1_width,
				      sobel1_height);
        pix = XCreatePixmap (XtDisplay(PROCESS_edges_sobel_racine),
			    RootWindowOfScreen(XtScreen(PROCESS_edges_sobel_racine)),
			    sobel1_width, sobel1_height, 
			    DefaultDepthOfScreen (XtScreen(PROCESS_edges_sobel_racine)));

	XCopyPlane(XtDisplay(PROCESS_edges_sobel_racine),bitmap_option, pix, gc, 0, 0, 
		   sobel1_width, sobel1_height, 0, 0, 1);
	
        n = 0;
	XtSetArg(args[n],XmNlabelType, XmPIXMAP); n++;
	XtSetArg(args[n],XmNlabelPixmap, pix); n++;
        XtSetValues(PROCESS_edges_sobel_racine, args, n);

	XFreePixmap (XtDisplay(PROCESS_edges_sobel_racine), bitmap_option);

	/* Adding Callbacks for PROCESS_edges_sobel_racine */ 

	XtAddCallback(PROCESS_edges_sobel_racine,
		XmNactivateCallback,PROCESS_edges_sobel_racine_actcall,Comment_Area);

	/* Creating PROCESS_edges_sobel_absolue Widget */ 

	PROCESS_edges_sobel_absolue = 
	  XmCreatePushButton(PulldownMenu_146,"PROCESS_edges_sobel_absolue", NULL,0);
	XtManageChild(PROCESS_edges_sobel_absolue);

        n = 0;
	XtSetArg(args[n],XmNforeground, &values.foreground);n++;
	XtSetArg(args[n],XmNbackground, &values.background);n++;
	XtGetValues(PROCESS_edges_sobel_absolue, args, n);
        gc = XtGetGC (PROCESS_edges_sobel_absolue, 
		        GCForeground|GCBackground, &values);

        bitmap_option = XCreateBitmapFromData (
			              XtDisplay(PROCESS_edges_sobel_absolue), 
		                      RootWindowOfScreen(XtScreen(PROCESS_edges_sobel_absolue)),
				      sobel2_bits, sobel2_width,
				      sobel2_height);
        pix = XCreatePixmap (XtDisplay(PROCESS_edges_sobel_absolue),
			    RootWindowOfScreen(XtScreen(PROCESS_edges_sobel_absolue)),
			    sobel2_width, sobel2_height, 
			    DefaultDepthOfScreen (XtScreen(PROCESS_edges_sobel_absolue)));

	XCopyPlane(XtDisplay(PROCESS_edges_sobel_absolue),bitmap_option, pix, gc, 0, 0, 
		   sobel2_width, sobel2_height, 0, 0, 1);
	
        n = 0;
	XtSetArg(args[n],XmNlabelType, XmPIXMAP); n++;
	XtSetArg(args[n],XmNlabelPixmap, pix); n++;
        XtSetValues(PROCESS_edges_sobel_absolue, args, n);

	XFreePixmap (XtDisplay(PROCESS_edges_sobel_absolue), bitmap_option);

	/* Adding Callbacks for PROCESS_edges_sobel_absolue */ 

	XtAddCallback(PROCESS_edges_sobel_absolue,
		XmNactivateCallback,PROCESS_edges_sobel_absolue_actcall,Comment_Area);

	/* Creating PROCESS_edges_laplacian Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(contourtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_edges_laplacian = 
		XmCreateCascadeButton(PulldownMenu_142,"PROCESS_edges_laplacian",args,n);

	/* Adding Callbacks for PROCESS_edges_laplacian */ 

	XtAddCallback(PROCESS_edges_laplacian,XmNcascadingCallback, 
		      PROCESS_edges_laplacian_actcall, Comment_Area);


	XtManageChild(PROCESS_edges_laplacian);


	/* Creating PulldownMenu_laplacian Widget */ 

	PulldownMenu_laplacian = 
	CreatePulldownMenu(PROCESS_edges_laplacian,"PulldownMenu_laplacian",NULL,0);

	/* Creating PROCESS_edges_laplacian_1 Widget */ 

	PROCESS_edges_laplacian_1 = 
		XmCreatePushButton(PulldownMenu_laplacian,
					"PROCESS_edges_laplacian_1",args,n);

	XtManageChild(PROCESS_edges_laplacian_1);

        n = 0;
	XtSetArg(args[n],XmNforeground, &values.foreground);n++;
	XtSetArg(args[n],XmNbackground, &values.background);n++;
	XtGetValues(PROCESS_edges_laplacian_1, args, n);
        gc = XtGetGC (PROCESS_edges_laplacian_1, 
		        GCForeground|GCBackground, &values);

        bitmap_option = XCreateBitmapFromData (
			              XtDisplay(PROCESS_edges_laplacian_1), 
		                      RootWindowOfScreen(XtScreen(PROCESS_edges_laplacian_1)),
				      laplace1_bits, laplace1_width,
				      laplace1_height);
        pix = XCreatePixmap (XtDisplay(PROCESS_edges_laplacian_1),
			    RootWindowOfScreen(XtScreen(PROCESS_edges_laplacian_1)),
			    laplace1_width, laplace1_height, 
			    DefaultDepthOfScreen (XtScreen(PROCESS_edges_laplacian_1)));

	XCopyPlane(XtDisplay(PROCESS_edges_laplacian_1),bitmap_option, pix, gc, 0, 0, 
		   laplace1_width, laplace1_height, 0, 0, 1);
	
        n = 0;
	XtSetArg(args[n],XmNlabelType, XmPIXMAP); n++;
	XtSetArg(args[n],XmNlabelPixmap, pix); n++;
        XtSetValues(PROCESS_edges_laplacian_1, args, n);

	XFreePixmap (XtDisplay(PROCESS_edges_laplacian_1), bitmap_option);


	/* Adding Callbacks for PROCESS_edges_laplacian_1 */ 

	XtAddCallback(PROCESS_edges_laplacian_1,
		XmNactivateCallback,PROCESS_edges_laplacian_1_actcall,Comment_Area);


	/* Creating PROCESS_edges_laplacian_2 Widget */ 

	PROCESS_edges_laplacian_2 = 
		XmCreatePushButton(PulldownMenu_laplacian,
					"PROCESS_edges_laplacian_2",args,n);

	XtManageChild(PROCESS_edges_laplacian_2);

        n = 0;
	XtSetArg(args[n],XmNforeground, &values.foreground);n++;
	XtSetArg(args[n],XmNbackground, &values.background);n++;
	XtGetValues(PROCESS_edges_laplacian_2, args, n);
        gc = XtGetGC (PROCESS_edges_laplacian_2, 
		        GCForeground|GCBackground, &values);

        bitmap_option = XCreateBitmapFromData (
			              XtDisplay(PROCESS_edges_laplacian_2), 
		                      RootWindowOfScreen(XtScreen(PROCESS_edges_laplacian_2)),
				      laplace2_bits, laplace2_width,
				      laplace2_height);
        pix = XCreatePixmap (XtDisplay(PROCESS_edges_laplacian_2),
			    RootWindowOfScreen(XtScreen(PROCESS_edges_laplacian_2)),
			    laplace2_width, laplace2_height, 
			    DefaultDepthOfScreen (XtScreen(PROCESS_edges_laplacian_2)));

	XCopyPlane(XtDisplay(PROCESS_edges_laplacian_2),bitmap_option, pix, gc, 0, 0, 
		   laplace2_width, laplace2_height, 0, 0, 1);
	
        n = 0;
	XtSetArg(args[n],XmNlabelType, XmPIXMAP); n++;
	XtSetArg(args[n],XmNlabelPixmap, pix); n++;
        XtSetValues(PROCESS_edges_laplacian_2, args, n);

	XFreePixmap (XtDisplay(PROCESS_edges_laplacian_2), bitmap_option);

	/* Adding Callbacks for PROCESS_edges_laplacian_2 */ 

	XtAddCallback(PROCESS_edges_laplacian_2,
		XmNactivateCallback,PROCESS_edges_laplacian_2_actcall,Comment_Area);


	/* Creating PROCESS_edges_laplacian_3 Widget */ 

	PROCESS_edges_laplacian_3 = 
		XmCreatePushButton(PulldownMenu_laplacian,
					"PROCESS_edges_laplacian_3",args,n);

	XtManageChild(PROCESS_edges_laplacian_3);

        n = 0;
	XtSetArg(args[n],XmNforeground, &values.foreground);n++;
	XtSetArg(args[n],XmNbackground, &values.background);n++;
	XtGetValues(PROCESS_edges_laplacian_3, args, n);
        gc = XtGetGC (PROCESS_edges_laplacian_3, 
		        GCForeground|GCBackground, &values);

        bitmap_option = XCreateBitmapFromData (
			              XtDisplay(PROCESS_edges_laplacian_3), 
		                      RootWindowOfScreen(XtScreen(PROCESS_edges_laplacian_3)),
				      laplace3_bits, laplace3_width,
				      laplace3_height);
        pix = XCreatePixmap (XtDisplay(PROCESS_edges_laplacian_3),
			    RootWindowOfScreen(XtScreen(PROCESS_edges_laplacian_3)),
			    laplace3_width, laplace3_height, 
			    DefaultDepthOfScreen (XtScreen(PROCESS_edges_laplacian_3)));

	XCopyPlane(XtDisplay(PROCESS_edges_laplacian_3),bitmap_option, pix, gc, 0, 0, 
		   laplace3_width, laplace3_height, 0, 0, 1);
	
        n = 0;
	XtSetArg(args[n],XmNlabelType, XmPIXMAP); n++;
	XtSetArg(args[n],XmNlabelPixmap, pix); n++;
        XtSetValues(PROCESS_edges_laplacian_3, args, n);

	XFreePixmap (XtDisplay(PROCESS_edges_laplacian_3), bitmap_option);


	/* Adding Callbacks for PROCESS_edges_laplacian_3 */ 

	XtAddCallback(PROCESS_edges_laplacian_3,
		XmNactivateCallback,PROCESS_edges_laplacian_3_actcall,Comment_Area);


	/* Creating PROCESS_edges_roberts Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(contourtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_edges_roberts = XmCreateCascadeButton(PulldownMenu_142,"PROCESS_edges_roberts",args,n);

	/* Adding Callbacks for PROCESS_edges_roberts */ 

	XtAddCallback(PROCESS_edges_roberts,XmNcascadingCallback, 
		      PROCESS_edges_roberts_actcall, Comment_Area);

	XtManageChild(PROCESS_edges_roberts);

	/* Creating PulldownMenu_151 Widget */ 


	PulldownMenu_151 = CreatePulldownMenu(PROCESS_edges_roberts,"PulldownMenu_151",NULL,0);

	/* Creating PROCESS_edges_roberts_racine Widget */ 

	PROCESS_edges_roberts_racine =
	XmCreatePushButton(PulldownMenu_151,"PROCESS_edges_roberts_racine", NULL, 0);
	XtManageChild(PROCESS_edges_roberts_racine);

        n = 0;
	XtSetArg(args[n],XmNforeground, &values.foreground);n++;
	XtSetArg(args[n],XmNbackground, &values.background);n++;
	XtGetValues(PROCESS_edges_roberts_racine, args, n);
        gc = XtGetGC (PROCESS_edges_roberts_racine, 
		        GCForeground|GCBackground, &values);

        bitmap_option = XCreateBitmapFromData (
			              XtDisplay(PROCESS_edges_roberts_racine), 
		                      RootWindowOfScreen(XtScreen(PROCESS_edges_roberts_racine)),
				      roberts1_bits, roberts1_width,
				      roberts1_height);
        pix = XCreatePixmap (XtDisplay(PROCESS_edges_roberts_racine),
			    RootWindowOfScreen(XtScreen(PROCESS_edges_roberts_racine)),
			    roberts1_width, roberts1_height, 
			    DefaultDepthOfScreen (XtScreen(PROCESS_edges_roberts_racine)));

	XCopyPlane(XtDisplay(PROCESS_edges_roberts_racine),bitmap_option, pix, gc, 0, 0, 
		   roberts1_width, roberts1_height, 0, 0, 1);
	
        n = 0;
	XtSetArg(args[n],XmNlabelType, XmPIXMAP); n++;
	XtSetArg(args[n],XmNlabelPixmap, pix); n++;
        XtSetValues(PROCESS_edges_roberts_racine, args, n);

	XFreePixmap (XtDisplay(PROCESS_edges_roberts_racine), bitmap_option);

	/* Adding Callbacks for PROCESS_edges_roberts_racine */ 

	XtAddCallback(PROCESS_edges_roberts_racine,XmNactivateCallback,PROCESS_edges_roberts_racine_actcall,Comment_Area);

	/* Creating PROCESS_edges_roberts_absolue Widget */ 

	PROCESS_edges_roberts_absolue = 
	XmCreatePushButton(PulldownMenu_151,"PROCESS_edges_roberts_absolue", NULL, 0);
	XtManageChild(PROCESS_edges_roberts_absolue);

        n = 0;
	XtSetArg(args[n],XmNforeground, &values.foreground);n++;
	XtSetArg(args[n],XmNbackground, &values.background);n++;
	XtGetValues(PROCESS_edges_roberts_absolue, args, n);
        gc = XtGetGC (PROCESS_edges_roberts_absolue, 
		        GCForeground|GCBackground, &values);

        bitmap_option = XCreateBitmapFromData (
			              XtDisplay(PROCESS_edges_roberts_absolue), 
		                      RootWindowOfScreen(XtScreen(PROCESS_edges_roberts_absolue)),
				      roberts2_bits, roberts2_width,
				      roberts2_height);
        pix = XCreatePixmap (XtDisplay(PROCESS_edges_roberts_absolue),
			    RootWindowOfScreen(XtScreen(PROCESS_edges_roberts_absolue)),
			    roberts2_width, roberts2_height, 
			    DefaultDepthOfScreen (XtScreen(PROCESS_edges_roberts_absolue)));

	XCopyPlane(XtDisplay(PROCESS_edges_roberts_absolue),bitmap_option, pix, gc, 0, 0, 
		   roberts2_width, roberts2_height, 0, 0, 1);
	
        n = 0;
	XtSetArg(args[n],XmNlabelType, XmPIXMAP); n++;
	XtSetArg(args[n],XmNlabelPixmap, pix); n++;
        XtSetValues(PROCESS_edges_roberts_absolue, args, n);

	XFreePixmap (XtDisplay(PROCESS_edges_roberts_absolue), bitmap_option);

	/* Adding Callbacks for PROCESS_edges_roberts_absolue */ 

	XtAddCallback(PROCESS_edges_roberts_absolue,XmNactivateCallback,PROCESS_edges_roberts_absolue_actcall,Comment_Area);

	/* Creating PROCESS_edges_frei_chen Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(contourtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_edges_frei_chen = XmCreatePushButton(PulldownMenu_142,"PROCESS_edges_frei_chen",args,n);
	XtManageChild(PROCESS_edges_frei_chen);

	/* Adding Callbacks for PROCESS_edges_frei_chen */ 

	XtAddCallback(PROCESS_edges_frei_chen,XmNactivateCallback,PROCESS_edges_frei_chen_actcall,Comment_Area);

	/* Creating PROCESS_edges_mero_vassy Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(contourtabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_edges_mero_vassy = XmCreatePushButton(PulldownMenu_142,"PROCESS_edges_mero_vassy",args,n);
	XtManageChild(PROCESS_edges_mero_vassy);

	/* Adding Callbacks for PROCESS_edges_mero_vassy */ 

	XtAddCallback(PROCESS_edges_mero_vassy,XmNactivateCallback,PROCESS_edges_mero_vassy_actcall,Comment_Area);

	/* Creating PROCESS_edges_zero_crossing Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(contourtabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_edges_zero_crossing = XmCreatePushButton(PulldownMenu_142,"PROCESS_edges_zero_crossing",args,n);
	XtManageChild(PROCESS_edges_zero_crossing);

	/* Adding Callbacks for PROCESS_edges_zero_crossing */ 

	XtAddCallback(PROCESS_edges_zero_crossing,XmNactivateCallback,PROCESS_edges_zero_crossing_actcall,Comment_Area);

	/* Creating PROCESS_edges_ridge_riding Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(contourtabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_edges_ridge_riding = XmCreatePushButton(PulldownMenu_142,"PROCESS_edges_ridge_riding",args,n);
	XtManageChild(PROCESS_edges_ridge_riding);

	/* Adding Callbacks for PROCESS_edges_ridge_riding */ 

	XtAddCallback(PROCESS_edges_ridge_riding,XmNactivateCallback,PROCESS_edges_ridge_riding_actcall,Comment_Area);

	/* Creating PROCESS_regions Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_regions = XmCreateCascadeButton(PulldownMenu_105,"PROCESS_regions",args,n);

	/* Adding Callbacks for PROCESS_regions */ 

	XtAddCallback(PROCESS_regions,XmNcascadingCallback, 
		      PROCESS_regions_actcall, Comment_Area);

	XtManageChild(PROCESS_regions);

	/* Creating PulldownMenu_159 Widget */ 


	PulldownMenu_159 = CreatePulldownMenu(PROCESS_regions,"PulldownMenu_159",NULL,0);

	/* Creating Label_160 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[20],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_160 = XmCreateLabel(PulldownMenu_159,"Label_160",args,n);
	XtManageChild(Label_160);

	/* Creating Separator_161 Widget */ 


	Separator_161 = XmCreateSeparator(PulldownMenu_159,"Separator_161",NULL,0);
	XtManageChild(Separator_161);

	/* Creating PROCESS_region_growing Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(segmenttabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_region_growing = XmCreatePushButton(PulldownMenu_159,"PROCESS_region_growing",args,n);
	XtManageChild(PROCESS_region_growing);

	/* Adding Callbacks for PROCESS_region_growing */ 

	XtAddCallback(PROCESS_region_growing,XmNactivateCallback,PROCESS_region_growing_actcall,Comment_Area);

	/* Creating PROCESS_regions_OPR Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(segmenttabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNsensitive, False); n++;

	PROCESS_regions_OPR = XmCreateCascadeButton(PulldownMenu_159,"PROCESS_regions_OPR",args,n);
		
	/* Adding Callbacks for PROCESS_regions_OPR */ 

	XtAddCallback(PROCESS_regions_OPR,XmNcascadingCallback, 
		      PROCESS_regions_OPR_actcall, Comment_Area);

	XtManageChild(PROCESS_regions_OPR);

	/* Creating PulldownMenu_164 Widget */ 


	PulldownMenu_164 = CreatePulldownMenu(PROCESS_regions_OPR,"PulldownMenu_164",NULL,0);

	/* Creating Label_165 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[63],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_165 = XmCreateLabel(PulldownMenu_164,"Label_165",args,n);
	XtManageChild(Label_165);

	/* Creating Separator_166 Widget */ 


	Separator_166 = XmCreateSeparator(PulldownMenu_164,"Separator_166",NULL,0);
	XtManageChild(Separator_166);

	/* Creating PROCESS_OPR_graytone Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oprtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_OPR_graytone = XmCreatePushButton(PulldownMenu_164,"PROCESS_OPR_graytone",args,n);
	XtManageChild(PROCESS_OPR_graytone);

	/* Adding Callbacks for PROCESS_OPR_graytone */ 

	XtAddCallback(PROCESS_OPR_graytone,XmNactivateCallback,PROCESS_OPR_graytone_actcall,Comment_Area);

	/* Creating PROCESS_OPR_rgb Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oprtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_OPR_rgb = XmCreatePushButton(PulldownMenu_164,"PROCESS_OPR_rgb",args,n);
	XtManageChild(PROCESS_OPR_rgb);

	/* Adding Callbacks for PROCESS_OPR_rgb */ 

	XtAddCallback(PROCESS_OPR_rgb,XmNactivateCallback,PROCESS_OPR_rgb_actcall,Comment_Area);

/*************************************************** SEGMENT4.c********************/
	/* Creating PROCESS_regions_graph Widget */ 
/**********
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("graph",
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_regions_graph = XmCreateCascadeButton(PulldownMenu_159,"PROCESS_regions_graph",args,n);
	XtManageChild(PROCESS_regions_graph);

***/
	/* Creating PulldownMenu_171 Widget */ 
/**********

	PulldownMenu_171 = CreatePulldownMenu(PROCESS_regions_graph,"PulldownMenu_171",NULL,0);

***/
	/* Creating Label_172 Widget */ 
/**********
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("graph",
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_172 = XmCreateLabel(PulldownMenu_171,"Label_172",args,n);
	XtManageChild(Label_172);
***/
	/* Creating Separator_173 Widget */ 
/**********

	Separator_173 = XmCreateSeparator(PulldownMenu_171,"Separator_173",NULL,0);
	XtManageChild(Separator_173);
***/
	/* Creating PROCESS_graph_construction Widget */ 
/**********
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("graph construction",
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_graph_construction = XmCreatePushButton(PulldownMenu_171,"PROCESS_graph_construction",args,n);
	XtManageChild(PROCESS_graph_construction);
***/
	/* Adding Callbacks for PROCESS_graph_construction */ 
/**********
	XtAddCallback(PROCESS_graph_construction,XmNactivateCallback,PROCESS_graph_construction_actcall,Comment_Area);
***/
	/* Creating PROCESS_graph_image Widget */ 
/**********
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("graph -> image",
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_graph_image = XmCreatePushButton(PulldownMenu_171,"PROCESS_graph_image",args,n);
	XtManageChild(PROCESS_graph_image);
***/
	/* Adding Callbacks for PROCESS_graph_image */ 
/**********
	XtAddCallback(PROCESS_graph_image,XmNactivateCallback,PROCESS_graph_image_actcall,Comment_Area);
***/
	/* Creating PROCESS_region_extraction Widget */ 
/**********
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("region extraction",
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_region_extraction = XmCreatePushButton(PulldownMenu_171,"PROCESS_region_extraction",args,n);
	XtManageChild(PROCESS_region_extraction);
***/
	/* Adding Callbacks for PROCESS_region_extraction */ 
/**********
	XtAddCallback(PROCESS_region_extraction,XmNactivateCallback,PROCESS_region_extraction_actcall,Comment_Area);
***/
	/* Creating PROCESS_elimin_small_regions Widget */ 
/**********
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("eliminate small regions",
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_elimin_small_regions = XmCreatePushButton(PulldownMenu_171,"PROCESS_elimin_small_regions",args,n);
	XtManageChild(PROCESS_elimin_small_regions);
***/
	/* Adding Callbacks for PROCESS_elimin_small_regions */ 
/**********
	XtAddCallback(PROCESS_elimin_small_regions,XmNactivateCallback,PROCESS_elimin_small_regions_actcall,Comment_Area);
***/
	/* Creating PROCESS_binary_morpho Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_binary_morpho = XmCreatePushButton(PulldownMenu_105,"PROCESS_binary_morpho",args,n);
	XtManageChild(PROCESS_binary_morpho);

	/* Adding Callbacks for PROCESS_binary_morpho */ 

	XtAddCallback(PROCESS_binary_morpho,XmNactivateCallback,PROCESS_binary_morpho_actcall,Comment_Area);

	/* Creating PROCESS_gray_scale_morpho Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(traitetabs[8],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_gray_scale_morpho = XmCreateCascadeButton(PulldownMenu_105,"PROCESS_gray_scale_morpho",args,n);

	/* Adding Callbacks for PROCESS_gray_scale_morpho */ 

	XtAddCallback(PROCESS_gray_scale_morpho,XmNcascadingCallback, 
		      PROCESS_gray_scale_morpho_actcall, Comment_Area);

	XtManageChild(PROCESS_gray_scale_morpho);

	/* Creating PulldownMenu_180 Widget */ 


	PulldownMenu_180 = CreatePulldownMenu(PROCESS_gray_scale_morpho,"PulldownMenu_180",NULL,0);

	/* Creating Label_181 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[21],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_181 = XmCreateLabel(PulldownMenu_180,"Label_181",args,n);
	XtManageChild(Label_181);

	/* Creating Separator_182 Widget */ 


	Separator_182 = XmCreateSeparator(PulldownMenu_180,"Separator_182",NULL,0);
	XtManageChild(Separator_182);

	/* Creating PROCESS_erosion Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphnivgristabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_erosion = XmCreateCascadeButton(PulldownMenu_180,"PROCESS_erosion",args,n);
	/* Adding Callbacks for PROCESS_erosion */ 

	XtAddCallback(PROCESS_erosion,XmNcascadingCallback, 
		      PROCESS_erosion_actcall, Comment_Area);

	XtManageChild(PROCESS_erosion);

	/* Creating PulldownMenu_184 Widget */ 


	PulldownMenu_184 = CreatePulldownMenu(PROCESS_erosion,"PulldownMenu_184",NULL,0);

	/* Creating Label_185 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[49],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_185 = XmCreateLabel(PulldownMenu_184,"Label_185",args,n);
	XtManageChild(Label_185);

	/* Creating Separator_186 Widget */ 


	Separator_186 = XmCreateSeparator(PulldownMenu_184,"Separator_186",NULL,0);
	XtManageChild(Separator_186);

	/* Creating PROCESS_erosion_sphere Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_erosion_sphere = XmCreatePushButton(PulldownMenu_184,"PROCESS_erosion_sphere",args,n);
	XtManageChild(PROCESS_erosion_sphere);

	/* Adding Callbacks for PROCESS_erosion_sphere */ 

	XtAddCallback(PROCESS_erosion_sphere,XmNactivateCallback,PROCESS_erosion_sphere_actcall,Comment_Area);

	/* Creating PROCESS_erosion_cone Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_erosion_cone = XmCreatePushButton(PulldownMenu_184,"PROCESS_erosion_cone",args,n);
	XtManageChild(PROCESS_erosion_cone);

	/* Adding Callbacks for PROCESS_erosion_cone */ 

	XtAddCallback(PROCESS_erosion_cone,XmNactivateCallback,PROCESS_erosion_cone_actcall,Comment_Area);

	/* Creating PROCESS_erosion_cylinder Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_erosion_cylinder = XmCreatePushButton(PulldownMenu_184,"PROCESS_erosion_cylinder",args,n);
	XtManageChild(PROCESS_erosion_cylinder);

	/* Adding Callbacks for PROCESS_erosion_cylinder */ 

	XtAddCallback(PROCESS_erosion_cylinder,XmNactivateCallback,PROCESS_erosion_cylinder_actcall,Comment_Area);

	/* Creating PROCESS_erosion_gaussian Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_erosion_gaussian = XmCreatePushButton(PulldownMenu_184,"PROCESS_erosion_gaussian",args,n);
	XtManageChild(PROCESS_erosion_gaussian);

	/* Adding Callbacks for PROCESS_erosion_gaussian */ 

	XtAddCallback(PROCESS_erosion_gaussian,XmNactivateCallback,PROCESS_erosion_gaussian_actcall,Comment_Area);

	/* Creating PROCESS_erosion_imageplane Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_erosion_imageplane = XmCreatePushButton(PulldownMenu_184,"PROCESS_erosion_imageplane",args,n);
	XtManageChild(PROCESS_erosion_imageplane);

	/* Adding Callbacks for PROCESS_erosion_imageplane */ 

	XtAddCallback(PROCESS_erosion_imageplane,XmNactivateCallback,PROCESS_erosion_imageplane_actcall,Comment_Area);

	/* Creating PROCESS_dilatation Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphnivgristabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_dilatation = XmCreateCascadeButton(PulldownMenu_180,"PROCESS_dilatation",args,n);
	/* Adding Callbacks for PROCESS_dilatation */ 

	XtAddCallback(PROCESS_dilatation,XmNcascadingCallback, 
		      PROCESS_dilatation_actcall, Comment_Area);

	XtManageChild(PROCESS_dilatation);

	/* Creating PulldownMenu_193 Widget */ 


	PulldownMenu_193 = CreatePulldownMenu(PROCESS_dilatation,"PulldownMenu_193",NULL,0);

	/* Creating Label_194 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[49],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_194 = XmCreateLabel(PulldownMenu_193,"Label_194",args,n);
	XtManageChild(Label_194);

	/* Creating Separator_195 Widget */ 


	Separator_195 = XmCreateSeparator(PulldownMenu_193,"Separator_195",NULL,0);
	XtManageChild(Separator_195);

	/* Creating PROCESS_dilatation_sphere Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_dilatation_sphere = XmCreatePushButton(PulldownMenu_193,"PROCESS_dilatation_sphere",args,n);
	XtManageChild(PROCESS_dilatation_sphere);

	/* Adding Callbacks for PROCESS_dilatation_sphere */ 

	XtAddCallback(PROCESS_dilatation_sphere,XmNactivateCallback,PROCESS_dilatation_sphere_actcall,Comment_Area);

	/* Creating PROCESS_dilatation_cone Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_dilatation_cone = XmCreatePushButton(PulldownMenu_193,"PROCESS_dilatation_cone",args,n);
	XtManageChild(PROCESS_dilatation_cone);

	/* Adding Callbacks for PROCESS_dilatation_cone */ 

	XtAddCallback(PROCESS_dilatation_cone,XmNactivateCallback,PROCESS_dilatation_cone_actcall,Comment_Area);

	/* Creating PROCESS_dilatation_cylinder Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_dilatation_cylinder = XmCreatePushButton(PulldownMenu_193,"PROCESS_dilatation_cylinder",args,n);
	XtManageChild(PROCESS_dilatation_cylinder);

	/* Adding Callbacks for PROCESS_dilatation_cylinder */ 

	XtAddCallback(PROCESS_dilatation_cylinder,XmNactivateCallback,PROCESS_dilatation_cylinder_actcall,Comment_Area);

	/* Creating PROCESS_dilatation_gaussian Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_dilatation_gaussian = XmCreatePushButton(PulldownMenu_193,"PROCESS_dilatation_gaussian",args,n);
	XtManageChild(PROCESS_dilatation_gaussian);

	/* Adding Callbacks for PROCESS_dilatation_gaussian */ 

	XtAddCallback(PROCESS_dilatation_gaussian,XmNactivateCallback,PROCESS_dilatation_gaussian_actcall,Comment_Area);

	/* Creating PROCESS_dilatation_imageplane Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_dilatation_imageplane = XmCreatePushButton(PulldownMenu_193,"PROCESS_dilatation_imageplane",args,n);
	XtManageChild(PROCESS_dilatation_imageplane);

	/* Adding Callbacks for PROCESS_dilatation_imageplane */ 

	XtAddCallback(PROCESS_dilatation_imageplane,XmNactivateCallback,PROCESS_dilatation_imageplane_actcall,Comment_Area);

	/* Creating PROCESS_opening Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphnivgristabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_opening = XmCreateCascadeButton(PulldownMenu_180,"PROCESS_opening",args,n);
	/* Adding Callbacks for PROCESS_opening */ 

	XtAddCallback(PROCESS_opening,XmNcascadingCallback, 
		      PROCESS_opening_actcall, Comment_Area);

	XtManageChild(PROCESS_opening);

	/* Creating PulldownMenu_202 Widget */ 


	PulldownMenu_202 = CreatePulldownMenu(PROCESS_opening,"PulldownMenu_202",NULL,0);

	/* Creating Label_203 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[49],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_203 = XmCreateLabel(PulldownMenu_202,"Label_203",args,n);
	XtManageChild(Label_203);

	/* Creating Separator_204 Widget */ 


	Separator_204 = XmCreateSeparator(PulldownMenu_202,"Separator_204",NULL,0);
	XtManageChild(Separator_204);

	/* Creating PROCESS_opening_sphere Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_opening_sphere = XmCreatePushButton(PulldownMenu_202,"PROCESS_opening_sphere",args,n);
	XtManageChild(PROCESS_opening_sphere);

	/* Adding Callbacks for PROCESS_opening_sphere */ 

	XtAddCallback(PROCESS_opening_sphere,XmNactivateCallback,PROCESS_opening_sphere_actcall,Comment_Area);

	/* Creating PROCESS_opening_cone Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_opening_cone = XmCreatePushButton(PulldownMenu_202,"PROCESS_opening_cone",args,n);
	XtManageChild(PROCESS_opening_cone);

	/* Adding Callbacks for PROCESS_opening_cone */ 

	XtAddCallback(PROCESS_opening_cone,XmNactivateCallback,PROCESS_opening_cone_actcall,Comment_Area);

	/* Creating PROCESS_opening_cylinder Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_opening_cylinder = XmCreatePushButton(PulldownMenu_202,"PROCESS_opening_cylinder",args,n);
	XtManageChild(PROCESS_opening_cylinder);

	/* Adding Callbacks for PROCESS_opening_cylinder */ 

	XtAddCallback(PROCESS_opening_cylinder,XmNactivateCallback,PROCESS_opening_cylinder_actcall,Comment_Area);

	/* Creating PROCESS_opening_gaussian Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_opening_gaussian = XmCreatePushButton(PulldownMenu_202,"PROCESS_opening_gaussian",args,n);
	XtManageChild(PROCESS_opening_gaussian);

	/* Adding Callbacks for PROCESS_opening_gaussian */ 

	XtAddCallback(PROCESS_opening_gaussian,XmNactivateCallback,PROCESS_opening_gaussian_actcall,Comment_Area);

	/* Creating PROCESS_opening_imageplane Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_opening_imageplane = XmCreatePushButton(PulldownMenu_202,"PROCESS_opening_imageplane",args,n);
	XtManageChild(PROCESS_opening_imageplane);

	/* Adding Callbacks for PROCESS_opening_imageplane */ 

	XtAddCallback(PROCESS_opening_imageplane,XmNactivateCallback,PROCESS_opening_imageplane_actcall,Comment_Area);

	/* Creating PROCESS_closure Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphnivgristabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_closure = 
		XmCreateCascadeButton(PulldownMenu_180,"PROCESS_closure",args,n);
	/* Adding Callbacks for PROCESS_closure */ 

	XtAddCallback(PROCESS_closure,XmNcascadingCallback, 
		      PROCESS_closure_actcall, Comment_Area);

	XtManageChild(PROCESS_closure);

	/* Creating PulldownMenu_212 Widget */ 


	PulldownMenu_212 = CreatePulldownMenu(PROCESS_closure,"PulldownMenu_212",NULL,0);

	/* Creating Label_213 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[49],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_213 = XmCreateLabel(PulldownMenu_212,"Label_213",args,n);
	XtManageChild(Label_213);

	/* Creating Separator_214 Widget */ 


	Separator_214 = XmCreateSeparator(PulldownMenu_212,"Separator_214",NULL,0);
	XtManageChild(Separator_214);

	/* Creating PROCESS_closure_sphere Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_closure_sphere = 
		XmCreatePushButton(PulldownMenu_212,"PROCESS_closure_sphere",args,n);
	XtManageChild(PROCESS_closure_sphere);

	/* Adding Callbacks for PROCESS_closure_sphere */ 

	XtAddCallback(PROCESS_closure_sphere,
		XmNactivateCallback,PROCESS_closure_sphere_actcall,Comment_Area);

	/* Creating PROCESS_closure_cone Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_closure_cone = 
		XmCreatePushButton(PulldownMenu_212,"PROCESS_closure_cone",args,n);
	XtManageChild(PROCESS_closure_cone);

	/* Adding Callbacks for PROCESS_closure_cone */ 

	XtAddCallback(PROCESS_closure_cone,
		XmNactivateCallback,PROCESS_closure_cone_actcall,Comment_Area);

	/* Creating PROCESS_closure_cylinder Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_closure_cylinder = 
		XmCreatePushButton(PulldownMenu_212,"PROCESS_closure_cylinder",args,n);
	XtManageChild(PROCESS_closure_cylinder);

	/* Adding Callbacks for PROCESS_closure_cylinder */ 

	XtAddCallback(PROCESS_closure_cylinder,
		XmNactivateCallback,PROCESS_closure_cylinder_actcall,Comment_Area);

	/* Creating PROCESS_closure_gaussian Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_closure_gaussian = 
		XmCreatePushButton(PulldownMenu_212,"PROCESS_closure_gaussian",args,n);
	XtManageChild(PROCESS_closure_gaussian);

	/* Adding Callbacks for PROCESS_closure_gaussian */ 

	XtAddCallback(PROCESS_closure_gaussian,
		XmNactivateCallback,PROCESS_closure_gaussian_actcall,Comment_Area);

	/* Creating PROCESS_closure_imageplane Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(morphelemtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PROCESS_closure_imageplane = 
		XmCreatePushButton(PulldownMenu_212,"PROCESS_closure_imageplane",args,n);
	XtManageChild(PROCESS_closure_imageplane);

	/* Adding Callbacks for PROCESS_closure_imageplane */ 

	XtAddCallback(PROCESS_closure_imageplane,
		XmNactivateCallback,PROCESS_closure_imageplane_actcall,Comment_Area);

	return(PROCESSING);
}


/********************************************************
/   Creation Function for MEASURES 
/*******************************************************/

Widget
build_MEASURES(MenuBar_0, Comment_Area)
	Widget MenuBar_0;
Widget Comment_Area;
{
	Widget MEASURES;
	Widget PulldownMenu_0;
	Widget MEASURES_histogram;
	Widget PulldownMenu_2;
	Widget Label_3;
	Widget Separator_4;
	Widget MEASURES_histo_calculate;
	Widget MEASURES_histo_show;
	Widget MEASURES_histo_print;
	Widget MEASURES_image_stat;
	Widget MEASURES_colour_regions;
	Widget PulldownMenu_10;
	Widget Label_11;
	Widget Separator_12;
	Widget MEASURES_colour_fill;
	Widget PulldownMenu_14;
	Widget Label_15;
	Widget Separator_16;
	Widget MEASURES_colour_fill_b0c8;
	Widget MEASURES_colour_fill_b0c4;
	Widget MEASURES_colour_fill_c0c8;
	Widget MEASURES_colour_fill_c0c4;
	Widget MEASURES_colour_save;
	Widget MEASURES_power;
	Widget PulldownMenu_13;
	Widget Label_14;
	Widget Separator_15;
	Widget MEASURES_power_calculate;
	Widget MEASURES_power_cut_freq;
	Arg args[MAX_ARGS];
	int n;

	/* Creating MEASURES Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES = XmCreateCascadeButton(MenuBar_0,"MEASURES",args,n);

	/* Adding Callbacks for MEASURES */ 

	XtAddCallback(MEASURES,XmNcascadingCallback, 
		      MEASURES_actcall, Comment_Area);

	XtManageChild(MEASURES);

	/* Creating PulldownMenu_0 Widget */ 


	PulldownMenu_0 = CreatePulldownMenu(MEASURES,"PulldownMenu_0",NULL,0);

	/* Creating MEASURES_histogram Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(mesuretabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_histogram = 
		XmCreateCascadeButton(PulldownMenu_0,"MEASURES_histogram",args,n);
	/* Adding Callbacks for MEASURES_histogram */ 

	XtAddCallback(MEASURES_histogram,XmNcascadingCallback, 
		      MEASURES_histogram_actcall, Comment_Area);

	XtManageChild(MEASURES_histogram);

	/* Creating PulldownMenu_2 Widget */ 


	PulldownMenu_2 = CreatePulldownMenu(MEASURES_histogram,"PulldownMenu_2",NULL,0);

	/* Creating Label_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[22],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_3 = XmCreateLabel(PulldownMenu_2,"Label_3",args,n);
	XtManageChild(Label_3);

	/* Creating Separator_4 Widget */ 


	Separator_4 = XmCreateSeparator(PulldownMenu_2,"Separator_4",NULL,0);
	XtManageChild(Separator_4);

	/* Creating MEASURES_histo_calculate Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(histtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_histo_calculate = 
		XmCreatePushButton(PulldownMenu_2,"MEASURES_histo_calculate",args,n);
	XtManageChild(MEASURES_histo_calculate);

	/* Adding Callbacks for MEASURES_histo_calculate */ 

	XtAddCallback(MEASURES_histo_calculate,
		XmNactivateCallback,MEASURES_histo_calculate_actcall,Comment_Area);

	/* Creating MEASURES_histo_show Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(histtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_histo_show = 
		XmCreatePushButton(PulldownMenu_2,"MEASURES_histo_show",args,n);
	XtManageChild(MEASURES_histo_show);

	/* Adding Callbacks for MEASURES_histo_show */ 

	XtAddCallback(MEASURES_histo_show,
		XmNactivateCallback,MEASURES_histo_show_actcall,Comment_Area);

	/* Creating MEASURES_histo_print Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(histtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_histo_print = 
		XmCreatePushButton(PulldownMenu_2,"MEASURES_histo_print",args,n);
	XtManageChild(MEASURES_histo_print);

	/* Adding Callbacks for MEASURES_histo_print */ 

	XtAddCallback(MEASURES_histo_print,
		XmNactivateCallback,MEASURES_histo_print_actcall,Comment_Area);

	/* Creating MEASURES_image_stat Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(mesuretabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_image_stat = 
		XmCreatePushButton(PulldownMenu_0,"MEASURES_image_stat",args,n);
	XtManageChild(MEASURES_image_stat);

	/* Adding Callbacks for MEASURES_image_stat */ 

	XtAddCallback(MEASURES_image_stat,
		XmNactivateCallback,MEASURES_image_stat_actcall,Comment_Area);

	/* Creating MEASURES_colour_regions Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(auxtabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_colour_regions = 
		XmCreateCascadeButton(PulldownMenu_0,"MEASURES_colour_regions",args,n);
	/* Adding Callbacks for MEASURES_colour_regions */ 

	XtAddCallback(MEASURES_colour_regions,XmNcascadingCallback, 
		      MEASURES_colour_regions_actcall, Comment_Area);

	XtManageChild(MEASURES_colour_regions);

	/* Creating PulldownMenu_10 Widget */ 


	PulldownMenu_10 = 
		CreatePulldownMenu(MEASURES_colour_regions,"PulldownMenu_10",NULL,0);

	/* Creating Label_11 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[32],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_11 = XmCreateLabel(PulldownMenu_10,"Label_11",args,n);
	XtManageChild(Label_11);

	/* Creating Separator_12 Widget */ 


	Separator_12 = XmCreateSeparator(PulldownMenu_10,"Separator_12",NULL,0);
	XtManageChild(Separator_12);

	/* Creating MEASURES_colour_fill Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(colortabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_colour_fill = 
		XmCreateCascadeButton(PulldownMenu_10,"MEASURES_colour_fill",args,n);
	/* Adding Callbacks for MEASURES_colour_fill */ 

	XtAddCallback(MEASURES_colour_fill,XmNcascadingCallback, 
		      MEASURES_colour_fill_actcall, Comment_Area);

	XtManageChild(MEASURES_colour_fill);

	/* Creating PulldownMenu_14 Widget */ 


	PulldownMenu_14 = 
		CreatePulldownMenu(MEASURES_colour_fill,"PulldownMenu_14",NULL,0);

	/* Creating Label_15 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[42],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_15 = XmCreateLabel(PulldownMenu_14,"Label_15",args,n);
	XtManageChild(Label_15);

	/* Creating Separator_16 Widget */ 


	Separator_16 = XmCreateSeparator(PulldownMenu_14,"Separator_16",NULL,0);
	XtManageChild(Separator_16);

	/* Creating MEASURES_colour_fill_b0c8 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(color_rtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_colour_fill_b0c8 = 
		XmCreatePushButton(PulldownMenu_14,"MEASURES_colour_fill_b0c8",args,n);
	XtManageChild(MEASURES_colour_fill_b0c8);

	/* Adding Callbacks for MEASURES_colour_fill_b0c8 */ 

	XtAddCallback(MEASURES_colour_fill_b0c8,
		XmNactivateCallback,MEASURES_colour_fill_b0c8_actcall,Comment_Area);

	/* Creating MEASURES_colour_fill_b0c4 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(color_rtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_colour_fill_b0c4 = 
		XmCreatePushButton(PulldownMenu_14,"MEASURES_colour_fill_b0c4",args,n);
	XtManageChild(MEASURES_colour_fill_b0c4);

	/* Adding Callbacks for MEASURES_colour_fill_b0c4 */ 

	XtAddCallback(MEASURES_colour_fill_b0c4,
		XmNactivateCallback,MEASURES_colour_fill_b0c4_actcall,Comment_Area);

	/* Creating MEASURES_colour_fill_c0c8 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(color_rtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_colour_fill_c0c8 = 
		XmCreatePushButton(PulldownMenu_14,"MEASURES_colour_fill_c0c8",args,n);
	XtManageChild(MEASURES_colour_fill_c0c8);

	/* Adding Callbacks for MEASURES_colour_fill_c0c8 */ 

	XtAddCallback(MEASURES_colour_fill_c0c8,
		XmNactivateCallback,MEASURES_colour_fill_c0c8_actcall,Comment_Area);

	/* Creating MEASURES_colour_fill_c0c4 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(color_rtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_colour_fill_c0c4 = 
		XmCreatePushButton(PulldownMenu_14,"MEASURES_colour_fill_c0c4",args,n);
	XtManageChild(MEASURES_colour_fill_c0c4);

	/* Adding Callbacks for MEASURES_colour_fill_c0c4 */ 

	XtAddCallback(MEASURES_colour_fill_c0c4,
		XmNactivateCallback,MEASURES_colour_fill_c0c4_actcall,Comment_Area);

	/* Creating MEASURES_colour_save Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(colortabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_colour_save = 
	 XmCreatePushButton(PulldownMenu_10,"MEASURES_colour_save",args,n);
	XtManageChild(MEASURES_colour_save);

	/* Adding Callbacks for MEASURES_colour_save */ 

	XtAddCallback(MEASURES_colour_save,
		XmNactivateCallback,MEASURES_colour_save_actcall,Comment_Area);


	/* Creating MEASURES_power Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(mesuretabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_power = XmCreateCascadeButton(PulldownMenu_0,"MEASURES_power",args,n);
	/* Adding Callbacks for MEASURES_power */ 

	XtAddCallback(MEASURES_power,XmNcascadingCallback, 
		      MEASURES_power_actcall, Comment_Area);

	XtManageChild(MEASURES_power);

	/* Creating PulldownMenu_13 Widget */ 


	PulldownMenu_13 = CreatePulldownMenu(MEASURES_power,"PulldownMenu_13",NULL,0);

	/* Creating Label_14 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[37],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_14 = XmCreateLabel(PulldownMenu_13,"Label_14",args,n);
	XtManageChild(Label_14);

	/* Creating Separator_15 Widget */ 


	Separator_15 = XmCreateSeparator(PulldownMenu_13,"Separator_15",NULL,0);
	XtManageChild(Separator_15);

	/* Creating MEASURES_power_calculate Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(puisstabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_power_calculate = 
		XmCreatePushButton(PulldownMenu_13,"MEASURES_power_calculate",args,n);
	XtManageChild(MEASURES_power_calculate);

	/* Adding Callbacks for MEASURES_power_calculate */ 

	XtAddCallback(MEASURES_power_calculate,
		XmNactivateCallback,MEASURES_power_calculate_actcall,Comment_Area);

	/* Creating MEASURES_power_cut_freq Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(puisstabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	MEASURES_power_cut_freq = 
		XmCreatePushButton(PulldownMenu_13,"MEASURES_power_cut_freq",args,n);
	XtManageChild(MEASURES_power_cut_freq);

	/* Adding Callbacks for MEASURES_power_cut_freq */ 

	XtAddCallback(MEASURES_power_cut_freq,
		XmNactivateCallback,MEASURES_power_cut_freq_actcall,Comment_Area);

	return(MEASURES);
}


/********************************************************
/   Creation Function for AUXILIARY 
/*******************************************************/

Widget
build_AUXILIARY(MenuBar_0, Comment_Area)
	Widget MenuBar_0;
Widget Comment_Area;
{
	Widget AUXILIARY;
	Widget PulldownMenu_0_0;
	Widget AUXIL_conversions;
	Widget PulldownMenu_6;
	Widget Label_7;
	Widget Separator_8;
	Widget AUXIL_convers_binary;
	Widget AUXIL_convers_byte;
	Widget AUXIL_convers_short;
	Widget AUXIL_convers_integer;
	Widget AUXIL_convers_real;
	Widget AUXIL_convers_complex;
	Widget Separator_15_0;
	Widget Label_16;
	Widget Separator_17;
	Widget AUXIL_convers_cart_pol;
	Widget AUXIL_convers_pol_cart;
	Widget Separator_20;
	Widget Label_21;
	Widget Separator_22;
	Widget AUXIL_convers_rgb_graytone;
	Widget AUXIL_arithm;
	Widget PulldownMenu_25;
	Widget Label_26;
	Widget Separator_27;
	Widget AUXIL_arithm_plus;
	Widget AUXIL_arithm_moins;
	Widget AUXIL_arithm_fois;
	Widget AUXIL_arithm_div;
	Widget Separator_32;
	Widget Label_33;
	Widget Separator_34;
	Widget AUXIL_arithm_plusconst;
	Widget AUXIL_arithm_moinsconst;
	Widget AUXIL_arithm_foisconst;
	Widget AUXIL_arithm_divconst;
	Widget Separator_39;
	Widget Label_40;
	Widget Separator_41;
	Widget AUXIL_arithm_fois2const;
	Widget Separator_43;
	Widget Label_44;
	Widget Separator_45;
	Widget AUXIL_arithm_fois4;
	Widget AUXIL_logic;
	Widget PulldownMenu_48;
	Widget Label_49;
	Widget Separator_50;
	Widget AUXIL_logic_and;
	Widget AUXIL_logic_andmask;
	Widget AUXIL_logic_or;
	Widget AUXIL_logic_xor;
	Widget AUXIL_logic_not;
	Widget AUXIL_geom;
	Widget PulldownMenu_57;
	Widget Label_58;
	Widget Separator_59;
	Widget AUXIL_geom_rotation;
	Widget AUXIL_geom_translation;
	Widget AUXIL_geom_scalingS;
	Widget AUXIL_geom_scalingF;
	Widget AUXIL_geom_transposition;
	Widget AUXIL_geom_symmetryX;
	Widget AUXIL_geom_symmetryY;
	Widget AUXIL_modif;
	Widget PulldownMenu_68;
	Widget AUXIL_modif_enlarg;
	Widget PulldownMenu_70;
	Widget AUXIL_modif_enlarg_1st_ord_interp;
	Widget AUXIL_modif_padding;
	Widget PulldownMenu_73;
	Widget Label_75;
	Widget Separator_76;
	Widget AUXIL_modif_padding_const;
	Widget AUXIL_modif_padding_prolong;
	Widget AUXIL_modif_padding_period;
	Widget AUXIL_modif_noise;
	Widget PulldownMenu_81_0;
	Widget Label_82;
	Widget Separator_83;
	Widget AUXIL_modif_noise_unif;
	Widget AUXIL_modif_noise_gauss;
	Widget AUXIL_modif_cut;
	Widget AUXIL_gener;
	Widget PulldownMenu_88;
	Widget Label_89;
	Widget Separator_90;
	Widget AUXIL_gener_band_image;
	Widget PulldownMenu_92_0;
	Widget Label_93;
	Widget Separator_94;
	Widget AUXIL_gener_band_image_8;
	Widget AUXIL_gener_band_image_16;
	Widget AUXIL_gener_band_image_32;
	Widget AUXIL_gener_band_image_64;
	Widget AUXIL_gener_monochrome;
	Widget AUXIL_gener_gray_tone;
	Widget AUXIL_desctool;
	Widget AUXIL_free;
	Widget PulldownMenu_104;
	Widget Label_105;
	Widget Separator_106;
	Widget AUXIL_free_all_planes;
	Widget AUXIL_free_single_plane;
	Widget AUXIL_free_all_vectors;
	Widget AUXIL_free_single_vector;
	Widget AUXIL_copy_plane;
	Arg args[MAX_ARGS];
	int n;

	/* Creating AUXILIARY Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXILIARY = XmCreateCascadeButton(MenuBar_0,"AUXILIARY",args,n);

	/* Adding Callbacks for AUXILIARY */ 

	XtAddCallback(AUXILIARY,XmNcascadingCallback, 
		      AUXILIARY_actcall, Comment_Area);

	XtManageChild(AUXILIARY);

	/* Creating PulldownMenu_0_0 Widget */ 


	PulldownMenu_0_0 = CreatePulldownMenu(AUXILIARY,"PulldownMenu_0_0",NULL,0);

	/* Creating AUXIL_conversions Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(auxtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_conversions = 
		XmCreateCascadeButton(PulldownMenu_0_0,"AUXIL_conversions",args,n);
	/* Adding Callbacks for AUXIL_conversions */ 

	XtAddCallback(AUXIL_conversions,XmNcascadingCallback, 
		      AUXIL_convers_actcall, Comment_Area);

	XtManageChild(AUXIL_conversions);

	/* Creating PulldownMenu_6 Widget */ 


	PulldownMenu_6 = CreatePulldownMenu(AUXIL_conversions,"PulldownMenu_6",NULL,0);

	/* Creating Label_7 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[23],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_7 = XmCreateLabel(PulldownMenu_6,"Label_7",args,n);
	XtManageChild(Label_7);

	/* Creating Separator_8 Widget */ 


	Separator_8 = XmCreateSeparator(PulldownMenu_6,"Separator_8",NULL,0);
	XtManageChild(Separator_8);

	/* Creating AUXIL_convers_binary Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(converttabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_binary = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_binary",args,n);
	XtManageChild(AUXIL_convers_binary);

	/* Adding Callbacks for AUXIL_convers_binary */ 

	XtAddCallback(AUXIL_convers_binary,XmNactivateCallback,AUXIL_convers_binary_actcall,Comment_Area);

	/* Creating AUXIL_convers_byte Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(converttabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_byte = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_byte",args,n);
	XtManageChild(AUXIL_convers_byte);

	/* Adding Callbacks for AUXIL_convers_byte */ 

	XtAddCallback(AUXIL_convers_byte,XmNactivateCallback,AUXIL_convers_byte_actcall,Comment_Area);

	/* Creating AUXIL_convers_short Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(converttabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_short = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_short",args,n);
	XtManageChild(AUXIL_convers_short);

	/* Adding Callbacks for AUXIL_convers_short */ 

	XtAddCallback(AUXIL_convers_short,XmNactivateCallback,AUXIL_convers_short_actcall,Comment_Area);

	/* Creating AUXIL_convers_integer Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(converttabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_integer = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_integer",args,n);
	XtManageChild(AUXIL_convers_integer);

	/* Adding Callbacks for AUXIL_convers_integer */ 

	XtAddCallback(AUXIL_convers_integer,XmNactivateCallback,AUXIL_convers_integer_actcall,Comment_Area);

	/* Creating AUXIL_convers_real Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(converttabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_real = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_real",args,n);
	XtManageChild(AUXIL_convers_real);

	/* Adding Callbacks for AUXIL_convers_real */ 

	XtAddCallback(AUXIL_convers_real,XmNactivateCallback,AUXIL_convers_real_actcall,Comment_Area);

	/* Creating AUXIL_convers_complex Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(converttabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_complex = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_complex",args,n);
	XtManageChild(AUXIL_convers_complex);

	/* Adding Callbacks for AUXIL_convers_complex */ 


XtAddCallback(AUXIL_convers_complex,XmNactivateCallback,AUXIL_convers_complex_actcall,Comment_Area);

	/* Creating Separator_15_0 Widget */ 


	Separator_15_0 = XmCreateSeparator(PulldownMenu_6,"Separator_15_0",NULL,0);
	XtManageChild(Separator_15_0);

	/* Creating Label_16 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[24],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_16 = XmCreateLabel(PulldownMenu_6,"Label_16",args,n);
	XtManageChild(Label_16);

	/* Creating Separator_17 Widget */ 


	Separator_17 = XmCreateSeparator(PulldownMenu_6,"Separator_17",NULL,0);
	XtManageChild(Separator_17);

	/* Creating AUXIL_convers_cart_pol Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(converttabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_cart_pol = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_cart_pol",args,n);
	XtManageChild(AUXIL_convers_cart_pol);

	/* Adding Callbacks for AUXIL_convers_cart_pol */ 

	XtAddCallback(AUXIL_convers_cart_pol,XmNactivateCallback,AUXIL_convers_cart_pol_actcall,Comment_Area);

	/* Creating AUXIL_convers_pol_cart Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(converttabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_pol_cart = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_pol_cart",args,n);
	XtManageChild(AUXIL_convers_pol_cart);

	/* Adding Callbacks for AUXIL_convers_pol_cart */ 

	XtAddCallback(AUXIL_convers_pol_cart,XmNactivateCallback,AUXIL_convers_pol_cart_actcall,Comment_Area);

	/* Creating Separator_20 Widget */ 


	Separator_20 = XmCreateSeparator(PulldownMenu_6,"Separator_20",NULL,0);
	XtManageChild(Separator_20);

	/* Creating Label_21 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[29],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_21 = XmCreateLabel(PulldownMenu_6,"Label_21",args,n);
	XtManageChild(Label_21);

	/* Creating Separator_22 Widget */ 


	Separator_22 = XmCreateSeparator(PulldownMenu_6,"Separator_22",NULL,0);
	XtManageChild(Separator_22);

	/* Creating AUXIL_convers_rgb_graytone Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(recttabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_convers_rgb_graytone = XmCreatePushButton(PulldownMenu_6,"AUXIL_convers_rgb_graytone",args,n);
	XtManageChild(AUXIL_convers_rgb_graytone);

	/* Adding Callbacks for AUXIL_convers_rgb_graytone */ 

	XtAddCallback(AUXIL_convers_rgb_graytone,XmNactivateCallback,AUXIL_convers_rgb_graytone_actcall,Comment_Area);

	/* Creating AUXIL_arithm Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(auxtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm = XmCreateCascadeButton(PulldownMenu_0_0,"AUXIL_arithm",args,n);
	/* Adding Callbacks for AUXIL_arithm */ 

	XtAddCallback(AUXIL_arithm,XmNcascadingCallback, 
		      AUXIL_arithm_actcall, Comment_Area);

	XtManageChild(AUXIL_arithm);

	/* Creating PulldownMenu_25 Widget */ 


	PulldownMenu_25 = CreatePulldownMenu(AUXIL_arithm,"PulldownMenu_25",NULL,0);

	/* Creating Label_26 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[25],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_26 = XmCreateLabel(PulldownMenu_25,"Label_26",args,n);
	XtManageChild(Label_26);

	/* Creating Separator_27 Widget */ 


	Separator_27 = XmCreateSeparator(PulldownMenu_25,"Separator_27",NULL,0);
	XtManageChild(Separator_27);

	/* Creating AUXIL_arithm_plus Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_plus = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_plus",args,n);
	XtManageChild(AUXIL_arithm_plus);

	/* Adding Callbacks for AUXIL_arithm_plus */ 

	XtAddCallback(AUXIL_arithm_plus,XmNactivateCallback,AUXIL_arithm_plus_actcall,Comment_Area);

	/* Creating AUXIL_arithm_moins Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_moins = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_moins",args,n);
	XtManageChild(AUXIL_arithm_moins);

	/* Adding Callbacks for AUXIL_arithm_moins */ 

	XtAddCallback(AUXIL_arithm_moins,XmNactivateCallback,AUXIL_arithm_moins_actcall,Comment_Area);

	/* Creating AUXIL_arithm_fois Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_fois = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_fois",args,n);
	XtManageChild(AUXIL_arithm_fois);

	/* Adding Callbacks for AUXIL_arithm_fois */ 

	XtAddCallback(AUXIL_arithm_fois,XmNactivateCallback,AUXIL_arithm_fois_actcall,Comment_Area);

	/* Creating AUXIL_arithm_div Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_div = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_div",args,n);
	XtManageChild(AUXIL_arithm_div);

	/* Adding Callbacks for AUXIL_arithm_div */ 

	XtAddCallback(AUXIL_arithm_div,XmNactivateCallback,AUXIL_arithm_div_actcall,Comment_Area);

	/* Creating Separator_32 Widget */ 


	Separator_32 = XmCreateSeparator(PulldownMenu_25,"Separator_32",NULL,0);
	XtManageChild(Separator_32);

	/* Creating Label_33 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[26],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_33 = XmCreateLabel(PulldownMenu_25,"Label_33",args,n);
	XtManageChild(Label_33);

	/* Creating Separator_34 Widget */ 


	Separator_34 = XmCreateSeparator(PulldownMenu_25,"Separator_34",NULL,0);
	XtManageChild(Separator_34);

	/* Creating AUXIL_arithm_plusconst Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_plusconst = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_plusconst",args,n);
	XtManageChild(AUXIL_arithm_plusconst);

	/* Adding Callbacks for AUXIL_arithm_plusconst */ 

	XtAddCallback(AUXIL_arithm_plusconst,XmNactivateCallback,AUXIL_arithm_plusconst_actcall,Comment_Area);

	/* Creating AUXIL_arithm_moinsconst Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_moinsconst = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_moinsconst",args,n);
	XtManageChild(AUXIL_arithm_moinsconst);

	/* Adding Callbacks for AUXIL_arithm_moinsconst */ 

	XtAddCallback(AUXIL_arithm_moinsconst,XmNactivateCallback,AUXIL_arithm_moinsconst_actcall,Comment_Area);

	/* Creating AUXIL_arithm_foisconst Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_foisconst = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_foisconst",args,n);
	XtManageChild(AUXIL_arithm_foisconst);

	/* Adding Callbacks for AUXIL_arithm_foisconst */ 

	XtAddCallback(AUXIL_arithm_foisconst,XmNactivateCallback,AUXIL_arithm_foisconst_actcall,Comment_Area);

	/* Creating AUXIL_arithm_divconst Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_divconst = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_divconst",args,n);
	XtManageChild(AUXIL_arithm_divconst);

	/* Adding Callbacks for AUXIL_arithm_divconst */ 

	XtAddCallback(AUXIL_arithm_divconst,XmNactivateCallback,AUXIL_arithm_divconst_actcall,Comment_Area);

	/* Creating Separator_39 Widget */ 


	Separator_39 = XmCreateSeparator(PulldownMenu_25,"Separator_39",NULL,0);
	XtManageChild(Separator_39);

	/* Creating Label_40 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[28],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_40 = XmCreateLabel(PulldownMenu_25,"Label_40",args,n);
	XtManageChild(Label_40);

	/* Creating Separator_41 Widget */ 


	Separator_41 = XmCreateSeparator(PulldownMenu_25,"Separator_41",NULL,0);
	XtManageChild(Separator_41);

	/* Creating AUXIL_arithm_fois2const Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_fois2const = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_fois2const",args,n);
	XtManageChild(AUXIL_arithm_fois2const);

	/* Adding Callbacks for AUXIL_arithm_fois2const */ 

	XtAddCallback(AUXIL_arithm_fois2const,
		XmNactivateCallback,AUXIL_arithm_fois2const_actcall,Comment_Area);

	/* Creating Separator_43 Widget */ 


	Separator_43 = XmCreateSeparator(PulldownMenu_25,"Separator_43",NULL,0);
	XtManageChild(Separator_43);

	/* Creating Label_44 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[27],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_44 = XmCreateLabel(PulldownMenu_25,"Label_44",args,n);
	XtManageChild(Label_44);

	/* Creating Separator_45 Widget */ 


	Separator_45 = XmCreateSeparator(PulldownMenu_25,"Separator_45",NULL,0);
	XtManageChild(Separator_45);

	/* Creating AUXIL_arithm_fois4 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oparithtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_arithm_fois4 = XmCreatePushButton(PulldownMenu_25,"AUXIL_arithm_fois4",args,n);
	XtManageChild(AUXIL_arithm_fois4);

	/* Adding Callbacks for AUXIL_arithm_fois4 */ 

	XtAddCallback(AUXIL_arithm_fois4,XmNactivateCallback,AUXIL_arithm_fois4_actcall,Comment_Area);

	/* Creating AUXIL_logic Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(auxtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_logic = XmCreateCascadeButton(PulldownMenu_0_0,"AUXIL_logic",args,n);
	/* Adding Callbacks for AUXIL_logic */ 

	XtAddCallback(AUXIL_logic,XmNcascadingCallback, 
		      AUXIL_logic_actcall, Comment_Area);

	XtManageChild(AUXIL_logic);

	/* Creating PulldownMenu_48 Widget */ 


	PulldownMenu_48 = CreatePulldownMenu(AUXIL_logic,"PulldownMenu_48",NULL,0);

	/* Creating Label_49 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[30],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_49 = XmCreateLabel(PulldownMenu_48,"Label_49",args,n);
	XtManageChild(Label_49);

	/* Creating Separator_50 Widget */ 


	Separator_50 = XmCreateSeparator(PulldownMenu_48,"Separator_50",NULL,0);
	XtManageChild(Separator_50);

	/* Creating AUXIL_logic_and Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oplogtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_logic_and = XmCreatePushButton(PulldownMenu_48,"AUXIL_logic_and",args,n);
	XtManageChild(AUXIL_logic_and);

	/* Adding Callbacks for AUXIL_logic_and */ 

	XtAddCallback(AUXIL_logic_and,XmNactivateCallback,AUXIL_logic_and_actcall,Comment_Area);

	/* Creating AUXIL_logic_andmask Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oplogtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_logic_andmask = XmCreatePushButton(PulldownMenu_48,"AUXIL_logic_andmask",args,n);
	XtManageChild(AUXIL_logic_andmask);

	/* Adding Callbacks for AUXIL_logic_andmask */ 

	XtAddCallback(AUXIL_logic_andmask,XmNactivateCallback,AUXIL_logic_andmask_actcall,Comment_Area);

	/* Creating AUXIL_logic_or Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oplogtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_logic_or = XmCreatePushButton(PulldownMenu_48,"AUXIL_logic_or",args,n);
	XtManageChild(AUXIL_logic_or);

	/* Adding Callbacks for AUXIL_logic_or */ 

	XtAddCallback(AUXIL_logic_or,XmNactivateCallback,AUXIL_logic_or_actcall,Comment_Area);

	/* Creating AUXIL_logic_xor Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oplogtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_logic_xor = XmCreatePushButton(PulldownMenu_48,"AUXIL_logic_xor",args,n);
	XtManageChild(AUXIL_logic_xor);

	/* Adding Callbacks for AUXIL_logic_xor */ 

	XtAddCallback(AUXIL_logic_xor,XmNactivateCallback,AUXIL_logic_xor_actcall,Comment_Area);

	/* Creating AUXIL_logic_not Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(oplogtabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_logic_not = XmCreatePushButton(PulldownMenu_48,"AUXIL_logic_not",args,n);
	XtManageChild(AUXIL_logic_not);

	/* Adding Callbacks for AUXIL_logic_not */ 

	XtAddCallback(AUXIL_logic_not,XmNactivateCallback,AUXIL_logic_not_actcall,Comment_Area);

	/* Creating AUXIL_geom Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(auxtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_geom = XmCreateCascadeButton(PulldownMenu_0_0,"AUXIL_geom",args,n);
	/* Adding Callbacks for AUXIL_geom */ 

	XtAddCallback(AUXIL_geom,XmNcascadingCallback, 
		      AUXIL_geom_actcall, Comment_Area);

	XtManageChild(AUXIL_geom);

	/* Creating PulldownMenu_57 Widget */ 


	PulldownMenu_57 = CreatePulldownMenu(AUXIL_geom,"PulldownMenu_57",NULL,0);

	/* Creating Label_58 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[30],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_58 = XmCreateLabel(PulldownMenu_57,"Label_58",args,n);
	XtManageChild(Label_58);

	/* Creating Separator_59 Widget */ 


	Separator_59 = XmCreateSeparator(PulldownMenu_57,"Separator_59",NULL,0);
	XtManageChild(Separator_59);

	/* Creating AUXIL_geom_rotation Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(opgeomtabs[5],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_geom_rotation = XmCreatePushButton(PulldownMenu_57,"AUXIL_geom_rotation",args,n);
	XtManageChild(AUXIL_geom_rotation);

	/* Adding Callbacks for AUXIL_geom_rotation */ 

	XtAddCallback(AUXIL_geom_rotation,XmNactivateCallback,AUXIL_geom_rotation_actcall,Comment_Area);

	/* Creating AUXIL_geom_translation Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(opgeomtabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_geom_translation = XmCreatePushButton(PulldownMenu_57,"AUXIL_geom_translation",args,n);
	XtManageChild(AUXIL_geom_translation);

	/* Adding Callbacks for AUXIL_geom_translation */ 

	XtAddCallback(AUXIL_geom_translation,XmNactivateCallback,AUXIL_geom_translation_actcall,Comment_Area);

	/* Creating AUXIL_geom_scalingS Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(opgeomtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_geom_scalingS = XmCreatePushButton(PulldownMenu_57,"AUXIL_geom_scalingS",args,n);
	XtManageChild(AUXIL_geom_scalingS);

	/* Adding Callbacks for AUXIL_geom_scalingS */ 

	XtAddCallback(AUXIL_geom_scalingS,XmNactivateCallback,AUXIL_geom_scalingS_actcall,Comment_Area);

	/* Creating AUXIL_geom_scalingF Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(opgeomtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_geom_scalingF = XmCreatePushButton(PulldownMenu_57,"AUXIL_geom_scalingF",args,n);
	XtManageChild(AUXIL_geom_scalingF);

	/* Adding Callbacks for AUXIL_geom_scalingF */ 

	XtAddCallback(AUXIL_geom_scalingF,XmNactivateCallback,AUXIL_geom_scalingF_actcall,Comment_Area);

	/* Creating AUXIL_geom_transposition Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(opgeomtabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_geom_transposition = XmCreatePushButton(PulldownMenu_57,"AUXIL_geom_transposition",args,n);
	XtManageChild(AUXIL_geom_transposition);

	/* Adding Callbacks for AUXIL_geom_transposition */ 

	XtAddCallback(AUXIL_geom_transposition,XmNactivateCallback,AUXIL_geom_transposition_actcall,Comment_Area);

	/* Creating AUXIL_geom_symmetryX Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(opgeomtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_geom_symmetryX = XmCreatePushButton(PulldownMenu_57,"AUXIL_geom_symmetryX",args,n);
	XtManageChild(AUXIL_geom_symmetryX);

	/* Adding Callbacks for AUXIL_geom_symmetryX */ 

	XtAddCallback(AUXIL_geom_symmetryX,
		XmNactivateCallback,AUXIL_geom_symmetryX_actcall,Comment_Area);

	/* Creating AUXIL_geom_symmetryY Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(opgeomtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_geom_symmetryY = XmCreatePushButton(PulldownMenu_57,"AUXIL_geom_symmetryY",args,n);
	XtManageChild(AUXIL_geom_symmetryY);

	/* Adding Callbacks for AUXIL_geom_symmetryY */ 

	XtAddCallback(AUXIL_geom_symmetryY,XmNactivateCallback,AUXIL_geom_symmetryY_actcall,Comment_Area);

	/* Creating AUXIL_modif Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(auxtabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif = XmCreateCascadeButton(PulldownMenu_0_0,"AUXIL_modif",args,n);
	/* Adding Callbacks for AUXIL_modif */ 

	XtAddCallback(AUXIL_modif,XmNcascadingCallback, 
		      AUXIL_modif_actcall, Comment_Area);

	XtManageChild(AUXIL_modif);

	/* Creating PulldownMenu_68 Widget */ 


	PulldownMenu_68 = CreatePulldownMenu(AUXIL_modif,"PulldownMenu_68",NULL,0);

	/* Creating AUXIL_modif_enlarg Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(recttabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_enlarg = XmCreateCascadeButton(PulldownMenu_68,"AUXIL_modif_enlarg",args,n);

	/* Adding Callbacks for AUXIL_modif_enlarg */ 

	XtAddCallback(AUXIL_modif_enlarg,XmNcascadingCallback, 
		      AUXIL_modif_enlarg_actcall, Comment_Area);

	XtManageChild(AUXIL_modif_enlarg);

	/* Creating PulldownMenu_70 Widget */ 


	PulldownMenu_70 = CreatePulldownMenu(AUXIL_modif_enlarg,"PulldownMenu_70",NULL,0);

	/* Creating AUXIL_modif_enlarg_1st_ord_interp Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(aggrandtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_enlarg_1st_ord_interp = XmCreatePushButton(PulldownMenu_70,"AUXIL_modif_enlarg_1st_ord_interp",args,n);
	XtManageChild(AUXIL_modif_enlarg_1st_ord_interp);

	/* Adding Callbacks for AUXIL_modif_enlarg_1st_ord_interp */ 

	XtAddCallback(AUXIL_modif_enlarg_1st_ord_interp,XmNactivateCallback,AUXIL_modif_enlarg_1st_ord_interp_actcall,Comment_Area);

	/* Creating AUXIL_modif_padding Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(recttabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_padding = XmCreateCascadeButton(PulldownMenu_68,"AUXIL_modif_padding",args,n);
	/* Adding Callbacks for AUXIL_modif_padding */ 

	XtAddCallback(AUXIL_modif_padding,XmNcascadingCallback, 
		      AUXIL_modif_padding_actcall, Comment_Area);

	XtManageChild(AUXIL_modif_padding);

	/* Creating PulldownMenu_73 Widget */ 


	PulldownMenu_73 = CreatePulldownMenu(AUXIL_modif_padding,"PulldownMenu_73",NULL,0);

	/* Creating Label_75 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[35],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_75 = XmCreateLabel(PulldownMenu_73,"Label_75",args,n);
	XtManageChild(Label_75);

	/* Creating Separator_76 Widget */ 


	Separator_76 = XmCreateSeparator(PulldownMenu_73,"Separator_76",NULL,0);
	XtManageChild(Separator_76);

	/* Creating AUXIL_modif_padding_const Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(padtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_padding_const = XmCreatePushButton(PulldownMenu_73,"AUXIL_modif_padding_const",args,n);
	XtManageChild(AUXIL_modif_padding_const);

	/* Adding Callbacks for AUXIL_modif_padding_const */ 

	XtAddCallback(AUXIL_modif_padding_const,XmNactivateCallback,AUXIL_modif_padding_const_actcall,Comment_Area);

	/* Creating AUXIL_modif_padding_prolong Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(padtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_padding_prolong = XmCreatePushButton(PulldownMenu_73,"AUXIL_modif_padding_prolong",args,n);
	XtManageChild(AUXIL_modif_padding_prolong);

	/* Adding Callbacks for AUXIL_modif_padding_prolong */ 

	XtAddCallback(AUXIL_modif_padding_prolong,XmNactivateCallback,AUXIL_modif_padding_prolong_actcall,Comment_Area);

	/* Creating AUXIL_modif_padding_period Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(padtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_padding_period = XmCreatePushButton(PulldownMenu_73,"AUXIL_modif_padding_period",args,n);
	XtManageChild(AUXIL_modif_padding_period);

	/* Adding Callbacks for AUXIL_modif_padding_period */ 

	XtAddCallback(AUXIL_modif_padding_period,XmNactivateCallback,AUXIL_modif_padding_period_actcall,Comment_Area);

	/* Creating AUXIL_modif_noise Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(bruittabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_noise = XmCreateCascadeButton(PulldownMenu_68,"AUXIL_modif_noise",args,n);
	/* Adding Callbacks for AUXIL_modif_noise */ 

	XtAddCallback(AUXIL_modif_noise,XmNcascadingCallback, 
		      AUXIL_modif_noise_actcall, Comment_Area);

	XtManageChild(AUXIL_modif_noise);

	/* Creating PulldownMenu_81_0 Widget */ 


	PulldownMenu_81_0 = CreatePulldownMenu(AUXIL_modif_noise,"PulldownMenu_81_0",NULL,0);

	/* Creating Label_82 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[12],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_82 = XmCreateLabel(PulldownMenu_81_0,"Label_82",args,n);
	XtManageChild(Label_82);

	/* Creating Separator_83 Widget */ 


	Separator_83 = XmCreateSeparator(PulldownMenu_81_0,"Separator_83",NULL,0);
	XtManageChild(Separator_83);

	/* Creating AUXIL_modif_noise_unif Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(typbruittabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_noise_unif = XmCreatePushButton(PulldownMenu_81_0,"AUXIL_modif_noise_unif",args,n);
	XtManageChild(AUXIL_modif_noise_unif);

	/* Adding Callbacks for AUXIL_modif_noise_unif */ 

	XtAddCallback(AUXIL_modif_noise_unif,
		XmNactivateCallback,AUXIL_modif_noise_unif_actcall,Comment_Area);

	/* Creating AUXIL_modif_noise_gauss Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(typbruittabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_noise_gauss = XmCreatePushButton(PulldownMenu_81_0,"AUXIL_modif_noise_gauss",args,n);
	XtManageChild(AUXIL_modif_noise_gauss);

	/* Adding Callbacks for AUXIL_modif_noise_gauss */ 

	XtAddCallback(AUXIL_modif_noise_gauss,XmNactivateCallback,AUXIL_modif_noise_gauss_actcall,Comment_Area);

	/* Creating AUXIL_modif_cut Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(opgeomtabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_modif_cut = XmCreatePushButton(PulldownMenu_68,"AUXIL_modif_cut",args,n);
	XtManageChild(AUXIL_modif_cut);

	/* Adding Callbacks for AUXIL_modif_cut */ 

	XtAddCallback(AUXIL_modif_cut,XmNactivateCallback,AUXIL_modif_cut_actcall,Comment_Area);

	/* Creating AUXIL_gener Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(auxtabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_gener = XmCreateCascadeButton(PulldownMenu_0_0,"AUXIL_gener",args,n);
	/* Adding Callbacks for AUXIL_gener */ 

	XtAddCallback(AUXIL_gener,XmNcascadingCallback, 
		      AUXIL_gener_image_actcall, Comment_Area);

	XtManageChild(AUXIL_gener);

	/* Creating PulldownMenu_88 Widget */ 


	PulldownMenu_88 = CreatePulldownMenu(AUXIL_gener,"PulldownMenu_88",NULL,0);

	/* Creating Label_89 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[11],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_89 = XmCreateLabel(PulldownMenu_88,"Label_89",args,n);
	XtManageChild(Label_89);

	/* Creating Separator_90 Widget */ 


	Separator_90 = XmCreateSeparator(PulldownMenu_88,"Separator_90",NULL,0);
	XtManageChild(Separator_90);

	/* Creating AUXIL_gener_band_image Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(genimtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_gener_band_image = XmCreateCascadeButton(PulldownMenu_88,"AUXIL_gener_band_image",args,n);

	/* Adding Callbacks for AUXIL_gener */ 

	XtAddCallback(AUXIL_gener_band_image,XmNcascadingCallback, 
		      AUXIL_gener_band_image_actcall, Comment_Area);

	XtManageChild(AUXIL_gener_band_image);

	/* Creating PulldownMenu_92_0 Widget */ 


	PulldownMenu_92_0 = CreatePulldownMenu(AUXIL_gener_band_image,"PulldownMenu_92_0",NULL,0);

	/* Creating Label_93 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[36],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_93 = XmCreateLabel(PulldownMenu_92_0,"Label_93",args,n);
	XtManageChild(Label_93);

	/* Creating Separator_94 Widget */ 


	Separator_94 = XmCreateSeparator(PulldownMenu_92_0,"Separator_94",NULL,0);
	XtManageChild(Separator_94);

	/* Creating AUXIL_gener_band_image_8 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(bandimtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_gener_band_image_8 = XmCreatePushButton(PulldownMenu_92_0,"AUXIL_gener_band_image_8",args,n);
	XtManageChild(AUXIL_gener_band_image_8);

	/* Adding Callbacks for AUXIL_gener_band_image_8 */ 

	XtAddCallback(AUXIL_gener_band_image_8,XmNactivateCallback,AUXIL_gener_band_image_8_actcall,Comment_Area);

	/* Creating AUXIL_gener_band_image_16 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(bandimtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_gener_band_image_16 = XmCreatePushButton(PulldownMenu_92_0,"AUXIL_gener_band_image_16",args,n);
	XtManageChild(AUXIL_gener_band_image_16);

	/* Adding Callbacks for AUXIL_gener_band_image_16 */ 

	XtAddCallback(AUXIL_gener_band_image_16,XmNactivateCallback,AUXIL_gener_band_image_16_actcall,Comment_Area);

	/* Creating AUXIL_gener_band_image_32 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(bandimtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_gener_band_image_32 = XmCreatePushButton(PulldownMenu_92_0,"AUXIL_gener_band_image_32",args,n);
	XtManageChild(AUXIL_gener_band_image_32);

	/* Adding Callbacks for AUXIL_gener_band_image_32 */ 

	XtAddCallback(AUXIL_gener_band_image_32,XmNactivateCallback,AUXIL_gener_band_image_32_actcall,Comment_Area);

	/* Creating AUXIL_gener_band_image_64 Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(bandimtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_gener_band_image_64 = XmCreatePushButton(PulldownMenu_92_0,"AUXIL_gener_band_image_64",args,n);
	XtManageChild(AUXIL_gener_band_image_64);

	/* Adding Callbacks for AUXIL_gener_band_image_64 */ 

	XtAddCallback(AUXIL_gener_band_image_64,
		XmNactivateCallback,AUXIL_gener_band_image_64_actcall,Comment_Area);

	/* Creating AUXIL_gener_monochrome Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(genimtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_gener_monochrome = XmCreatePushButton(PulldownMenu_88,"AUXIL_gener_monochrome",args,n);
	XtManageChild(AUXIL_gener_monochrome);

	/* Adding Callbacks for AUXIL_gener_monochrome */ 

	XtAddCallback(AUXIL_gener_monochrome,XmNactivateCallback,AUXIL_gener_monochrome_actcall,Comment_Area);

	/* Creating AUXIL_gener_gray_tone Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(genimtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_gener_gray_tone = XmCreatePushButton(PulldownMenu_88,"AUXIL_gener_gray_tone",args,n);
	XtManageChild(AUXIL_gener_gray_tone);

	/* Adding Callbacks for AUXIL_gener_gray_tone */ 

	XtAddCallback(AUXIL_gener_gray_tone,XmNactivateCallback,AUXIL_gener_gray_tone_actcall,Comment_Area);

	/* Creating AUXIL_desctool Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(auxtabs[8],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_desctool = XmCreatePushButton(PulldownMenu_0_0,"AUXIL_desctool",args,n);
	XtManageChild(AUXIL_desctool);

	/* Adding Callbacks for AUXIL_desctool */ 

	XtAddCallback(AUXIL_desctool,XmNactivateCallback,AUXIL_desctool_actcall,Comment_Area);

	/* Creating AUXIL_free Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(basetabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_free = XmCreateCascadeButton(PulldownMenu_0_0,"AUXIL_free",args,n);
	/* Adding Callbacks for AUXIL_free */ 

	XtAddCallback(AUXIL_free,XmNcascadingCallback, 
		      AUXIL_free_actcall, Comment_Area);

	XtManageChild(AUXIL_free);

	/* Creating PulldownMenu_104 Widget */ 


	PulldownMenu_104 = CreatePulldownMenu(AUXIL_free,"PulldownMenu_104",NULL,0);

	/* Creating Label_105 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[41],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_105 = XmCreateLabel(PulldownMenu_104,"Label_105",args,n);
	XtManageChild(Label_105);

	/* Creating Separator_106 Widget */ 


	Separator_106 = XmCreateSeparator(PulldownMenu_104,"Separator_106",NULL,0);
	XtManageChild(Separator_106);

	/* Creating AUXIL_free_all_planes Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(libtabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_free_all_planes = XmCreatePushButton(PulldownMenu_104,"AUXIL_free_all_planes",args,n);
	XtManageChild(AUXIL_free_all_planes);

	/* Adding Callbacks for AUXIL_free_all_planes */ 

	XtAddCallback(AUXIL_free_all_planes,XmNactivateCallback,AUXIL_free_all_planes_actcall,Comment_Area);

	/* Creating AUXIL_free_single_plane Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(libtabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_free_single_plane = XmCreatePushButton(PulldownMenu_104,"AUXIL_free_single_plane",args,n);
	XtManageChild(AUXIL_free_single_plane);

	/* Adding Callbacks for AUXIL_free_single_plane */ 

	XtAddCallback(AUXIL_free_single_plane,XmNactivateCallback,AUXIL_free_single_plane_actcall,Comment_Area);

	/* Creating AUXIL_free_all_vectors Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(libtabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_free_all_vectors = XmCreatePushButton(PulldownMenu_104,"AUXIL_free_all_vectors",args,n);
	XtManageChild(AUXIL_free_all_vectors);

	/* Adding Callbacks for AUXIL_free_all_vectors */ 

	XtAddCallback(AUXIL_free_all_vectors,XmNactivateCallback,AUXIL_free_all_vectors_actcall,Comment_Area);

	/* Creating AUXIL_free_single_vector Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(libtabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_free_single_vector = XmCreatePushButton(PulldownMenu_104,"AUXIL_free_single_vector",args,n);
	XtManageChild(AUXIL_free_single_vector);

	/* Adding Callbacks for AUXIL_free_single_vector */ 

	XtAddCallback(AUXIL_free_single_vector,XmNactivateCallback,AUXIL_free_single_vector_actcall,Comment_Area);

	/* Creating AUXIL_copy_plane Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(basetabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	AUXIL_copy_plane = XmCreatePushButton(PulldownMenu_0_0,"AUXIL_copy_plane",args,n);
	XtManageChild(AUXIL_copy_plane);

	/* Adding Callbacks for AUXIL_copy_plane */ 

	XtAddCallback(AUXIL_copy_plane,XmNactivateCallback,AUXIL_copy_plane_actcall,Comment_Area);

	return(AUXILIARY);
}


/********************************************************
/   Creation Function for TOOLS 
/*******************************************************/

Widget
build_TOOLS(MenuBar_0, Comment_Area)
	Widget MenuBar_0;
Widget Comment_Area;
{
	Widget TOOLS;
	Widget PulldownMenu_112;
	Widget TOOLS_expert;
	Widget PulldownMenu_114;
	Widget TOOLS_expert_enhancement;
	Widget TOOLS_expert_contour;
	Widget TOOLS_expert_threshold;
	Widget TOOLS_expert_count_elem;
	Widget TOOLS_expert_classify;
	Widget TOOLS_gel1D;
	Arg args[MAX_ARGS];
	int n;

	/* Creating TOOLS Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbackground, gthistle); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(menutabs[6],
			XmSTRING_DEFAULT_CHARSET)); n++;

	TOOLS = XmCreateCascadeButton(MenuBar_0,"TOOLS",args,n);

	/* Adding Callbacks for TOOLS */ 

	XtAddCallback(TOOLS,XmNcascadingCallback, 
		      TOOLS_actcall, Comment_Area);

	XtManageChild(TOOLS);

	/* Creating PulldownMenu_112 Widget */ 


	PulldownMenu_112 = CreatePulldownMenu(TOOLS,"PulldownMenu_112",NULL,0);

	/* Creating TOOLS_expert Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(tooltabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNsensitive, False); n++;

	TOOLS_expert = XmCreateCascadeButton(PulldownMenu_112,"TOOLS_expert",args,n);
	XtManageChild(TOOLS_expert);

	/* Creating PulldownMenu_114 Widget */ 


	PulldownMenu_114 = 
	  CreatePulldownMenu(TOOLS_expert,"PulldownMenu_114",NULL,0);

	/* Creating TOOLS_expert_enhancement Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sysexptabs[0],
			XmSTRING_DEFAULT_CHARSET)); n++;

	TOOLS_expert_enhancement = 
	  XmCreatePushButton(PulldownMenu_114,"TOOLS_expert_enhancement",args,n);
	XtManageChild(TOOLS_expert_enhancement);

	/* Adding Callbacks for TOOLS_expert_enhancement */ 

	XtAddCallback(TOOLS_expert_enhancement,XmNactivateCallback,
		      TOOLS_expert_enhancement_actcall,Comment_Area);

	/* Creating TOOLS_expert_contour Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sysexptabs[1],
			XmSTRING_DEFAULT_CHARSET)); n++;

	TOOLS_expert_contour = 
	  XmCreatePushButton(PulldownMenu_114,"TOOLS_expert_contour",args,n);
	XtManageChild(TOOLS_expert_contour);

	/* Adding Callbacks for TOOLS_expert_contour */ 

	XtAddCallback(TOOLS_expert_contour,XmNactivateCallback,
		      TOOLS_expert_contour_actcall,Comment_Area);

	/* Creating TOOLS_expert_threshold Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sysexptabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	TOOLS_expert_threshold = XmCreatePushButton(PulldownMenu_114,"TOOLS_expert_threshold",args,n);
	XtManageChild(TOOLS_expert_threshold);

	/* Adding Callbacks for TOOLS_expert_threshold */ 

	XtAddCallback(TOOLS_expert_threshold,XmNactivateCallback,TOOLS_expert_threshold_actcall,Comment_Area);

	/* Creating TOOLS_expert_count_elem Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sysexptabs[3],
			XmSTRING_DEFAULT_CHARSET)); n++;

	TOOLS_expert_count_elem = XmCreatePushButton(PulldownMenu_114,"TOOLS_expert_count_elem",args,n);
	XtManageChild(TOOLS_expert_count_elem);

	/* Adding Callbacks for TOOLS_expert_count_elem */ 

	XtAddCallback(TOOLS_expert_count_elem,XmNactivateCallback,TOOLS_expert_count_elem_actcall,Comment_Area);

	/* Creating TOOLS_expert_classify Widget */ 

	n = 1;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(sysexptabs[4],
			XmSTRING_DEFAULT_CHARSET)); n++;

	TOOLS_expert_classify = XmCreatePushButton(PulldownMenu_114,"TOOLS_expert_classify",args,n);
	XtManageChild(TOOLS_expert_classify);

	/* Adding Callbacks for TOOLS_expert_classify */ 

	XtAddCallback(TOOLS_expert_classify,XmNactivateCallback,TOOLS_expert_classify_actcall,Comment_Area);

	/* Creating TOOLS_gel1D Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(tooltabs[2],
			XmSTRING_DEFAULT_CHARSET)); n++;

	TOOLS_gel1D = XmCreatePushButton(PulldownMenu_112,"TOOLS_gel1D",args,n);
	XtManageChild(TOOLS_gel1D);

	/* Adding Callbacks for TOOLS_gel1D */ 

	XtAddCallback(TOOLS_gel1D,XmNactivateCallback,TOOLS_gel1D_actcall,Comment_Area);

	return(TOOLS);
}
