/* SCCS @(#)statistics.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       statistics.layout.c                            */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   statistics.layout.c                                 */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Statistics Display)                      */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "statistics.layout.h"
#include "../define.h"
#include "../structure.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;
extern char *paneltabs[];

extern void keep_sensitive_button();

/********************************************************
/   Creation Function for statistics_widget 
/*******************************************************/

Widget
build_statistics_widget(statistics, im_desc, message)
	Widget statistics;
	struct image_ecran *im_desc;
	char *message;
{
	Widget statistics_widget;
	Widget Desc_label;
	Widget lines;
	Widget colons;
	Widget Stat_label;
	Widget min;
	Widget max;
	Widget Colons_text;
	Widget Min_text;
	Widget Min_text2;
	Widget Min_text3;
	Widget Max_text;
	Widget Max_text2;
	Widget Max_text3;
	Widget lines_text;
	Widget Type;
	Widget Type_text;
	Widget Exptd;
	Widget Deviation;
	Widget Exptd_text;
	Widget Exptd_text2;
	Widget Exptd_text3;
	Widget Deviation_text;
	Widget Deviation_text2;
	Widget Deviation_text3;
	Widget QUIT;
	char *repfloat;
	Arg args[MAX_ARGS];
	int n;

	repfloat = (char *) malloc (20);

	/* Creating statistics_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,310); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	if (im_desc->nbr_plan <= 1)
	  XtSetArg(args[n],XmNwidth,218); 
	else 
	  XtSetArg(args[n],XmNwidth,250); 
	n++;
	XtSetArg(args[n],XmNx,44); n++;
	XtSetArg(args[n],XmNy,23); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		 XmStringLtoRCreate(message, XmSTRING_DEFAULT_CHARSET)); n++;

	statistics_widget = 
	   XmCreateFormDialog (statistics,"statistics_widget",args,n);
/*	XtManageChild(statistics_widget);*/

	/* Creating Desc_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	if (im_desc->nbr_plan == 0)  /* stat. sur une zone d'interet*/
             XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[12],
			XmSTRING_DEFAULT_CHARSET));
	else XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[8],
			XmSTRING_DEFAULT_CHARSET)); 
	n++;

	Desc_label = XmCreateLabel(statistics_widget,"Desc_label",args,n);
	XtManageChild(Desc_label);


	/* Creating lines Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
        if (im_desc->nbr_plan == 0)  /* stat. sur une zone d'interet*/
	    XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[243],
			XmSTRING_DEFAULT_CHARSET)); 
	else
	    XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[244],
			XmSTRING_DEFAULT_CHARSET)); 
	n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,60); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,18); n++;

	lines = XmCreateLabel(statistics_widget,"lines",args,n);
	XtManageChild(lines);

        if (im_desc->nbr_plan != 0) 
	{
	  /* Creating colons Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[245],
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,60); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,10); n++;

	  colons = XmCreateLabel(statistics_widget,"colons",args,n);
	  XtManageChild(colons);
	}
	
	/* Creating Stat_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[57],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,38); n++;

	Stat_label = XmCreateLabel(statistics_widget,"Stat_label",args,n);
	XtManageChild(Stat_label);

	/* Creating min Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[25],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,25); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,48); n++;

	min = XmCreateLabel(statistics_widget,"min",args,n);
	XtManageChild(min);

	/* Creating max Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[26],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,25); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,56); n++;

	max = XmCreateLabel(statistics_widget,"max",args,n);
	XtManageChild(max);

        if (im_desc->nbr_plan != 0) 
	{
	  /* Creating Colons_text Widget */ 

	  sprintf (repfloat, "%d", im_desc->ncolonne);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,colons); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,10); n++;

	  Colons_text = 
	     XmCreateLabel(statistics_widget,"Colons_text",args,n);

	  XtManageChild(Colons_text);
	}
	
	/* Creating Min_text Widget */ 

	if (im_desc->nbr_plan <= 1) 
	{
	  sprintf (repfloat, "%.4f", im_desc->mini[0]);
	  n = 0;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,min); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,48); n++;

	  Min_text = XmCreateLabel(statistics_widget,"Min_text",args,n);
	  XtManageChild(Min_text);
	}

	else 
	{
	  sprintf (repfloat, "%.2f", im_desc->mini[0]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,min); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,45); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,48); n++;

	  Min_text = XmCreateLabel(statistics_widget,"Min_text",args,n);

	  XtManageChild(Min_text);

	  sprintf (repfloat, "%.2f", im_desc->mini[1]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,50); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,70); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,48); n++;

	  Min_text2 = XmCreateLabel(statistics_widget,"Min_text2",args,n);

	  XtManageChild(Min_text2);

	  sprintf (repfloat, "%.2f", im_desc->mini[2]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,75); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,48); n++;

	  Min_text3 = XmCreateLabel(statistics_widget,"Min_text3",args,n);

	  XtManageChild(Min_text3);
	  
	}

	/* Creating Max_text Widget */ 

	if (im_desc->nbr_plan <= 1) 
	{
	  sprintf (repfloat, "%.4f", im_desc->maxi[0]);
	  n = 0;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,max); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,56); n++;

	  Max_text = XmCreateLabel(statistics_widget,"Max_text",args,n);
	  XtManageChild(Max_text);
	}

	else 
	{
	  sprintf (repfloat, "%.2f", im_desc->maxi[0]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,max); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,45); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,56); n++;

	  Max_text = XmCreateLabel(statistics_widget,"Max_text",args,n);
	  XtManageChild(Max_text);

	  sprintf (repfloat, "%.2f", im_desc->maxi[1]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,50); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,70); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,56); n++;

	  Max_text2 = XmCreateLabel(statistics_widget,"Max_text2",args,n);
	  XtManageChild(Max_text2);

	  sprintf (repfloat, "%.2f", im_desc->maxi[2]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,75); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,56); n++;

	  Max_text3 = XmCreateLabel(statistics_widget,"Max_text3",args,n);
	  XtManageChild(Max_text3);
	  
	}


	/* Creating lines_text Widget */ 

	if (im_desc->nbr_plan == 0) 
	   sprintf (repfloat, "%d", im_desc->npixels);
	else
	   sprintf (repfloat, "%d", im_desc->nligne);
	n = 0;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,lines); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,18); n++;

	lines_text = XmCreateLabel(statistics_widget,"lines_text",args,n);
	XtManageChild(lines_text);

	if (im_desc->nbr_plan != 0) 
	{
	  /* Creating Type Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[11],
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,26); n++;

	  Type = XmCreateLabel(statistics_widget,"Type",args,n);
	  XtManageChild(Type);

	  /* Creating Type_text Widget */ 

	  sprintf (repfloat, "%s", im_desc->type);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,Type); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,26); n++;

	  Type_text = XmCreateLabel(statistics_widget,"Type_text",args,n);
	  XtManageChild(Type_text);
	}
	
	/* Creating Exptd Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[13],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,64); n++;

	Exptd = XmCreateLabel(statistics_widget,"Exptd",args,n);
	XtManageChild(Exptd);

	/* Creating Deviation Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[14],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,72); n++;

	Deviation = XmCreateLabel(statistics_widget,"Deviation",args,n);
	XtManageChild(Deviation);

	/* Creating Exptd_text Widget */ 

	if (im_desc->nbr_plan <= 1) 
	{
	  sprintf (repfloat, "%.4f", im_desc->mu[0]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,Exptd); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,64); n++;

	  Exptd_text = XmCreateLabel(statistics_widget,"Exptd_text",args,n);
	  XtManageChild(Exptd_text);
	}

	else 
	{
	  sprintf (repfloat, "%.2f", im_desc->mu[0]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,Exptd); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,55); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,64); n++;

	  Exptd_text = XmCreateLabel(statistics_widget,"Exptd_text",args,n);
	  XtManageChild(Exptd_text);

	  sprintf (repfloat, "%.2f", im_desc->mu[1]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,60); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,75); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,64); n++;

	  Exptd_text2 = XmCreateLabel(statistics_widget,"Exptd_text2",args,n);
	  XtManageChild(Exptd_text2);

	  sprintf (repfloat, "%.2f", im_desc->mu[2]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition,80); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,64); n++;

	  Exptd_text3 = XmCreateLabel(statistics_widget,"Exptd_text3",args,n);
	  XtManageChild(Exptd_text3);

	}
	/* Creating Deviation_text Widget */ 

	if (im_desc->nbr_plan <= 1) 
	{
	  sprintf (repfloat, "%.4f", im_desc->ecart[0]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,Deviation); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,72); n++;

	  Deviation_text = XmCreateLabel(statistics_widget,"Deviation_text",args,n);
	  XtManageChild(Deviation_text);
	}

	else 
	{
	  sprintf (repfloat, "%.2f", im_desc->ecart[0]);
	  n = 0;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	  XtSetArg(args[n],XmNleftWidget,Deviation); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,55); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,72); n++;

	  Deviation_text = XmCreateLabel(statistics_widget,"Deviation_text",args,n);
	  XtManageChild(Deviation_text);

	  sprintf (repfloat, "%.2f", im_desc->ecart[1]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition, 60); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,75); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,72); n++;

	  Deviation_text2 = XmCreateLabel(statistics_widget,"Deviation_text2",args,n);
	  XtManageChild(Deviation_text2);

	  sprintf (repfloat, "%.2f", im_desc->ecart[2]);
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition, 80); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNrightPosition,95); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,72); n++;

	  Deviation_text3 = XmCreateLabel(statistics_widget,"Deviation_text3",args,n);
	  XtManageChild(Deviation_text3);

	}

	/* Creating QUIT Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList,gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 32); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 68); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,85); n++;

	QUIT = XmCreatePushButton(statistics_widget,"QUIT",args,n);
	XtManageChild(QUIT);

	/* Adding Callbacks for QUIT */ 

	XtAddCallback(QUIT,XmNactivateCallback,
		      QUIT_stat_actcall, statistics_widget);
	XtAddCallback(QUIT,XmNactivateCallback, 
		      keep_sensitive_button, statistics);

	free (repfloat);
	return(statistics_widget);
}
