/* SCCS @(#)profile.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       profile.callback.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   profile.callback.c                                  */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Profile on Image)                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "../libwidgets/widgetstructure.h"
#include "profile.layout.h"
#include "../IOplans.layout.h"
#include <X11/cursorfont.h>
#include <stdio.h>
#include <memory.h>
#include <malloc.h>
#include <math.h>
#include "Display/displayplane.callback.h" /* cf redisplay*/

extern Display *gDisplay;
extern GC default_gc, gc_xor;

struct profil_affiche_s {
    char    vect, approxime;
};

static int PX1, PY1, PX2, PY2, PX3, PY3, Largeur, regime;
static int px1, px2, px3, px4, py1, py2, py3, py4;
static float ad, ai, bp, bq, br, bs, bt;

static void (*func_x)(), (* trouver_4_pts)();
static float (* interpoler_si_besoin)();


static struct description_vecteur dir_desc_vect_temp;
static struct directoire_image dir_vecteur_temp;

#define max(x,y) (((x) > (y)) ? (x) : (y))
#define min(x,y) (((x) < (y)) ? (x) : (y))



void
profile_HELP_callb (HELP,profile_widget, callData)
	Widget HELP;
	Widget profile_widget;
	caddr_t callData;
{
/*XtUnmanageChild(threshold_widget);*/
}

void
profile_QUIT_callb (QUIT, data_display, callData)
    Widget QUIT;
    xs_struc_display_menu * data_display;
    caddr_t callData;
{
  XCopyArea(gDisplay, data_display->ret->pixmap, 
	    XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	    data_display->im_desc->ncolonne, 
	    data_display->im_desc->nligne,
	    0, 0);
  XtUnmanageChild(XtParent(XtParent(QUIT)));
  XtDestroyWidget(XtParent(XtParent(QUIT)));
}


void track_mouse_profile(w, data_display, event)
    Widget          w;
    xs_struc_display_menu * data_display;
    XEvent         *event;
{
  char message[25];
  Arg args[MAX_ARGS];
  int X, Y, n;
  float x,y;
  struct profil_s *profil;

  if (dir_desc_vect_temp.prive == NULL)  return;

  profil = (struct profil_s *)dir_desc_vect_temp.prive;

  X = event->xmotion.x; /* positions sur le drawing du profile! */
  Y = event->xmotion.y;
  x = profil->X1+profil->DX*X;  /* positions sur le drawing de l'image! */
  y = profil->Y1+profil->DY*X;


  sprintf (message, "X:%6.1f Y:%6.1f", x,y);
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_profile[4], args, n);

  sprintf (message, "Val: %f", *((profil->Vals[0])+X));
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_profile[5], args, n);
}


/*****************************************************************************/
static float
ne_pas_interpoler(fX,fY,VRAM,type, colonnes)
float fX, fY;
unsigned char *VRAM;
int type, colonnes;
{
    int X1= fX, Y1 = fY;
    float G;
    switch (type) {
	case -1 :
	case  0 :
	    G = *(VRAM+Y1*colonnes+X1);
	    break;
	case  1 :
	    G = *((unsigned short *)VRAM+Y1*colonnes+X1);
	    break;
	case  2 :
	    G = *((unsigned int *)VRAM+Y1*colonnes+X1);
	    break;
	case  3 :
	    G = *((float *)VRAM+Y1*colonnes+X1);
	    break;
    }
    return(G);
}

/*****************************************************************************/

static float
interpolation_bilineaire_generale(fX,fY,VRAM,type, colonnes)
float fX, fY;
unsigned char *VRAM;
int type, colonnes;
{
    int X1,Y1;
    float G1, G2, G3, G4, G12, G34, DX;
    X1 = fX;
    Y1 = fY;
    switch (type) {
	case -1 :
	case  0 :
	    G1 = *(VRAM+Y1*colonnes+X1);
	    break;
	case  1 :
	    G1 = *((unsigned short *)VRAM+Y1*colonnes+X1);
	    break;
	case  2 :
	    G1 = *((unsigned int *)VRAM+Y1*colonnes+X1);
	    break;
	case  3 :
	    G1 = *((float *)VRAM+Y1*colonnes+X1);
	    break;
    }
    if (((float)X1 == fX) && ((float)Y1 == fY))
	return(G1);
    switch (type) {
	case -1 :
	case  0 :
	    G2 = *(VRAM+Y1*colonnes+X1+1);
	    G3 = *(VRAM+(Y1+1)*colonnes+X1);
	    G4 = *(VRAM+(Y1+1)*colonnes+X1+1);
	    break;
	case  1 :
	    G2 = *((unsigned short *)VRAM+Y1*colonnes+X1+1);
	    G3 = *((unsigned short *)VRAM+(Y1+1)*colonnes+X1);
	    G4 = *((unsigned short *)VRAM+(Y1+1)*colonnes+X1+1);
	    break;
	case  2 :
	    G2 = *((unsigned int *)VRAM+Y1*colonnes+X1+1);
	    G3 = *((unsigned int *)VRAM+(Y1+1)*colonnes+X1);
	    G4 = *((unsigned int *)VRAM+(Y1+1)*colonnes+X1+1);
	    break;
	case  3 :
	    G2 = *((float *)VRAM+Y1*colonnes+X1+1);
	    G3 = *((float *)VRAM+(Y1+1)*colonnes+X1);
	    G4 = *((float *)VRAM+(Y1+1)*colonnes+X1+1);
	    break;
    }
    DX = (fX-X1);
    if (G1 == G2)
	G12 = G1;
    else
	G12 = G1 + DX*(G2-G1);
    if (G3 == G4)
	G34 = G3;
    else
	G34 = G3 + DX*(G4-G3);
    if (G12 == G34)
	return(G34);
    else
	return(G12 + (fY-Y1)*(G34-G12));
}



/*****************************************************************************/

static void
lib_vecteur_temp(desc_vect, vecteur)
struct description_vecteur desc_vect;
struct directoire_image vecteur;
{
    int N, NP;
    struct profil_s *profil;
    struct profil_affiche_s *profil_aff;
    if (dir_desc_vect_temp.prive == NULL)
	return;
    switch (dir_desc_vect_temp.genre) {
	case 0:
	    free(((struct histogr *)dir_desc_vect_temp.prive)->tab_hist);
	    break;
	case 1:
	    break;
	case 2:
	    profil = (struct profil_s *)dir_desc_vect_temp.prive;
	    for(N = 0 ; N < profil->NPr ; N++)
		free(profil->Vals[N]);
	    for (NP = 0 ; NP < MAX_PROFIL ; NP++)
	    {
		profil_aff = (struct profil_affiche_s *)profil->aff_profil[NP];
	    }
	    break;
    }
    free(dir_desc_vect_temp.prive);
    dir_desc_vect_temp.prive = NULL;
    dir_vecteur_temp.flag_reserve = LIBRE;
    dir_vecteur_temp.image = NULL;
}

/*****************************************************************************/


static void
calcule_le_profil_i(new, data_display)
    int new;
    xs_struc_display_menu *data_display;
{
    int LL, L, M;
    float *Adr, *Adrs, LLdbl, DPX, DPY, X, Y, XX, YY;
    struct profil_s *profil;
    if (new)
    {
        lib_vecteur_temp();
	profil = (struct profil_s *)malloc(sizeof(*profil));
	if (profil == NULL)
	{
	    write_erreur(900);
	    return;
	}
	dir_desc_vect_temp.prive = (char *)profil;
	memset(profil,0,sizeof(*profil));
	for (L = 0 ; L < MAX_PROFIL ; L++)
	    for (M = 0 ; M < 4 ; M++)
		profil->Coef[L][M] = 0.0;
	profil->NPr = 0;
	if (PY1 == PY2)
	{
	    LL = abs(PX1 - PX2) + 1;
	    profil->DX = 1.0;
	    profil->DY = 0.0;
	}
	else if (PX1 == PX2)
	{
	    LL = abs(PY1 - PY2) + 1;
	    profil->DX = 0.0;
	    profil->DY = 1.0;
	}
	else
	{
	    LLdbl = sqrt((double)((PX2-PX1)*(PX2-PX1)+(PY2-PY1)*(PY2-PY1)));
	    LL = LLdbl;
	    profil->DX = (PX2-PX1)/LLdbl;
	    profil->DY = (PY2-PY1)/LLdbl;
	}
	profil->X1 = PX1;
	profil->Y1 = PY1;
	profil->X2 = PX2;
	profil->Y2 = PY2;
	profil->Largeur = Largeur;
    }
    else
    {
	LL = dir_desc_vect_temp.ncase;
	profil = (struct profil_s *)dir_desc_vect_temp.prive;
    }

    Adr = (float *)malloc(LL*sizeof(float));
    if (Adr == NULL)
    {
	write_erreur(900);
	if (new)
	    free(profil);
	return;
    }
    Adrs = Adr;
    DPY = profil->DX;
    DPX = - profil->DY;
    X = profil->X1;
    Y = profil->Y1;
    profil->total[profil->NPr] = 0.0;
    for (L = 0 ; L < LL ; L++ , Adr++ , X += profil->DX , Y += profil->DY)
    {
	*Adr = 0.0;
	XX = X - Largeur*DPX;
	YY = Y - Largeur*DPY;
	for (M = -Largeur ; M <= Largeur ; M++ , XX += DPX , YY += DPY)
	{
	    *Adr += interpoler_si_besoin(XX,YY,
		data_display->ret->image, data_display->ret->type,
		data_display->im_desc->ncolonne);
	}
	*Adr /= Largeur+Largeur+1;
	if (L)
	{
	    profil->vmin[profil->NPr] = min(profil->vmin[profil->NPr],*Adr);
	    profil->vmax[profil->NPr] = max(profil->vmax[profil->NPr],*Adr);
	}
	else
	{
	    profil->vmin[profil->NPr] = *Adr;
	    profil->vmax[profil->NPr] = *Adr;
	}
	profil->total[profil->NPr] += *Adr;
    }
    profil->Vals[profil->NPr] = Adrs;
    strncpy(profil->filename[profil->NPr],data_display->im_desc->filename,29);
    if (new)
    {
	dir_desc_vect_temp.type = 3;
	dir_desc_vect_temp.genre = 2;
	dir_desc_vect_temp.ncase = LL;
	dir_desc_vect_temp.b_min = 0;
	dir_desc_vect_temp.b_max = LL-1;
	dir_desc_vect_temp.vmin = profil->vmin[profil->NPr];
	dir_desc_vect_temp.vmax = profil->vmax[profil->NPr];
	dir_desc_vect_temp.total = profil->total[profil->NPr];
	dir_vecteur_temp.flag_reserve = LIBRE;
	dir_vecteur_temp.image = (unsigned char *)profil;
    }
    else
    {
	dir_desc_vect_temp.vmin = min(profil->vmin[profil->NPr],
					dir_desc_vect_temp.vmin);
	dir_desc_vect_temp.vmax = max(profil->vmax[profil->NPr],
					dir_desc_vect_temp.vmax);
	dir_desc_vect_temp.total += profil->total[profil->NPr];
    }
    (profil->NPr)++;
}


/*****************************************************************************/

static void
tracer_rectangle(Drawing_Area)
    Widget Drawing_Area;
{
    XSetForeground(gDisplay, gc_xor, 128);

    XDrawLine (gDisplay, XtWindow(Drawing_Area), gc_xor, 
	       px1,py1,px2,py2);
    XDrawLine (gDisplay, XtWindow(Drawing_Area), gc_xor, 
	       px2,py2,px3,py3);
    XDrawLine (gDisplay, XtWindow(Drawing_Area), gc_xor, 
	       px3,py3,px4,py4);
    XDrawLine (gDisplay, XtWindow(Drawing_Area), gc_xor, 
	       px4,py4,px1,py1);
}



static void
trouver_4_pts_horis(data_display)
    xs_struc_display_menu * data_display;
{
    int d;

    d = abs(PY3-PY2);
    px1 = px4 = PX1;
    py1 = py2 = PY1+d;
    px2 = px3 = PX2;
    py3 = py4 = PY1-d;
    if (py3 < 0)
    {
	py1 = py2 = (PY1<<1);
	py3 = py4 = 0;
    }
    if (py1 >= data_display->im_desc->nligne)
    {
	py1 = py2 = data_display->im_desc->nligne-1;
	py3 = py4 = (PY1<<1)-data_display->im_desc->nligne+1;
    }
    Largeur = PY1 - py3;
}

/*****************************************************************************/

static void
trouver_4_pts_vert(data_display)
    xs_struc_display_menu * data_display;
{
    int d;

    d = abs(PX3-PX2);
    px1 = px2 = PX1-d;
    py1 = py4 = PY1;
    py2 = py3 = PY2;
    px3 = px4 = PX1+d;
    if (px1 < 0)
    {
	px1 = px2 = 0;
	px3 = px4 = (PX1 << 1);
    }
    if (px3 >= data_display->im_desc->ncolonne)
    {
	px1 = px2 = (PX1<<1)-data_display->im_desc->ncolonne+1;
	px3 = px4 = data_display->im_desc->ncolonne-1;
    }
    Largeur = PX1 - px1;
}


/*****************************************************************************/

static void
trouver_intersection(a,b,c,d,x,y)
float a, b, c, d;
short *x, *y;
{
    float res;
    res = (d - b) / (a - c);
    *x = res;
    *y = res * a + b;
}


/*****************************************************************************/

static void
trouver_4_pts_incl(data_display)
    xs_struc_display_menu * data_display;
{
    short qx1, qx2, qx3, qx4, qy1, qy2, qy3, qy4;

    bq = PY3 - ad*PX3;
    br = bp+bp-bq;
    trouver_intersection(ad,bq,ai,bs,&qx1,&qy1);
    trouver_intersection(ad,bq,ai,bt,&qx2,&qy2);
    trouver_intersection(ad,br,ai,bt,&qx3,&qy3);
    trouver_intersection(ad,br,ai,bs,&qx4,&qy4);
    
    if ((qx1 < 0) || (qx1 >= data_display->im_desc->ncolonne) ||
	(qx2 < 0) || (qx2 >= data_display->im_desc->ncolonne) ||
	(qx3 < 0) || (qx3 >= data_display->im_desc->ncolonne) ||
	(qx4 < 0) || (qx4 >= data_display->im_desc->ncolonne))
	return;
    if ((qy1 < 0) || (qy1 >= data_display->im_desc->nligne) ||
	(qy2 < 0) || (qy2 >= data_display->im_desc->nligne) ||
	(qy3 < 0) || (qy3 >= data_display->im_desc->nligne) ||
	(qy4 < 0) || (qy4 >= data_display->im_desc->nligne))
	return;
    px1 = qx1;    py1 = qy1;
    px2 = qx2;    py2 = qy2;
    px3 = qx3;    py3 = qy3;
    px4 = qx4;    py4 = qy4;
    Largeur = sqrt((double)((PX1-px1)*(PX1-px1)+(PY1-py1)*(PY1-py1)));
}



/*****************************************************************************/

void
affiche_1_sous_profil_reel(Drawing_Area, pixmap_profil, Adrf, C)
    Widget Drawing_Area;
    Pixmap pixmap_profil;
    int C;
    float *Adrf;
{
    int x1,x2,y1,y2;
    x1 = 0;
    y1 = 256.0-256.0 * (*Adrf-dir_desc_vect_temp.vmin)/
		(dir_desc_vect_temp.vmax-dir_desc_vect_temp.vmin);

    XSetForeground(gDisplay, default_gc, C);

    for (x2 = 1 ; x2 < dir_desc_vect_temp.ncase ; x2++)
    {
	y2 = 256.0-256.0 * (*(Adrf+x2)-dir_desc_vect_temp.vmin)/
		    (dir_desc_vect_temp.vmax-dir_desc_vect_temp.vmin);

        XDrawLine (gDisplay, pixmap_profil, 
		   default_gc, 
	           x1,y1,x2,y2);
	x1 = x2;
	y1 = y2;
    }
}


/*****************************************************************************/

static void
affiche_profil_proc(data_display)
    xs_struc_display_menu * data_display;
{
    struct profil_s *profil;
    struct profil_affiche_s *profil_affiche;
    int N, R, G, B, NP;
    float Min, Max;
    Arg args[MAX_ARGS];
    int n;

    if (data_display->pixmap_profile)
    {
      XtRemoveCallback(data_display->Drawing_Area_profile, XmNexposeCallback,
		     redisplay, data_display->pixmap_profile);
      XFreePixmap(gDisplay, data_display->pixmap_profile);
      data_display->pixmap_profile = NULL;
    }
      
    data_display->pixmap_profile = 
      XCreatePixmap(gDisplay,
		    XtWindow(data_display->Drawing_Area_profile), 
		    dir_desc_vect_temp.ncase, 280, 
		    DefaultDepthOfScreen (XtScreen(
			       data_display->Drawing_Area_profile)));
    XtAddCallback (data_display->Drawing_Area_profile, XmNexposeCallback, 
		   redisplay, data_display->pixmap_profile);

    
    XSetForeground (gDisplay, default_gc, 
		    get_pixel_by_name (data_display->Drawing_Area_profile, 
				       "CornflowerBlue"));
    XFillRectangle(gDisplay, data_display->pixmap_profile, default_gc, 0, 0, 
		   dir_desc_vect_temp.ncase, 280);
    XSetForeground (gDisplay, default_gc, 
		    get_pixel_by_name (data_display->Drawing_Area_profile, 
				       "black"));

    if (dir_vecteur_temp.image == NULL)
    {
	write_erreur(21);
	return;
    }
    if (dir_desc_vect_temp.genre != 2)
    {
	write_erreur(970);
	return;
    }

    profil = (struct profil_s *)dir_desc_vect_temp.prive;
    for (NP = 0 ; NP < MAX_PROFIL ; NP++)
	if (profil->aff_profil[NP] == NULL)
	    break;
    if (NP == MAX_PROFIL)
	return;
    profil_affiche = (struct profil_affiche_s *)malloc(sizeof(*profil_affiche));
    if (profil_affiche == NULL)
    {
      write_erreur(900);
      return;
    }
    memset(profil_affiche,0,sizeof(*profil_affiche));
    profil->aff_profil[NP] = (char *)profil_affiche;
/*    Map_R[0] = Map_G[0] = Map_B[0] = 255;
    for (N = 1 ; N < 256 ; N++)
	Map_R[N] = Map_G[N] = Map_B[N] = N+1;
	for (N = 0 ; N < MAX_PROFIL ; N++) {
	    Map_R[N+2] = 128 + (random() % 100);
	    Map_G[N+2] = 128 + (random() % 100);
	    Map_B[N+2] = 128 + (random() % 100);
	} table de couleur!!!!!!!!!!!!
*/

    n = 0;
    XtSetArg(args[n], XmNwidth, dir_desc_vect_temp.ncase);n++;
    XtSetArg(args[n], XmNheight, 280);n++;
    XtSetValues(XtParent(data_display->Drawing_Area_profile), args, n);
    XtSetValues(data_display->Drawing_Area_profile, args, n);
    
    for(N = 0 ; N < profil->NPr ; N++)
	affiche_1_sous_profil_reel(data_display->Drawing_Area_profile, 
				   data_display->pixmap_profile,
				   profil->Vals[N],N+2);
    XCopyArea (gDisplay, data_display->pixmap_profile, 
	       XtWindow (data_display->Drawing_Area_profile), default_gc, 
	       0, 0, dir_desc_vect_temp.ncase, 280, 0, 0);
}



/* return distance between p1 and p2 */
double ComputeDistance (x1, y1, x2, y2)
    int x1, y1, x2, y2;
{
  int 		dx,dy;
  double 	dd;

  dx = x2 - x1;
  dy = y2 - y1;
  dd = (double)(sqrt ((double) (dx * dx + dy * dy)));

  return (dd);
}


/* return (the smaller) angle formed by (p1,p2) and (p1,p3) */
int ComputeAngle (x1, y1, x2, y2, x3, y3)
    int x1, y1, x2, y2, x3, y3;
{
  int 		ax,ay,bx,by;
  double 	val, angle;
  
  ax = x2 - x1;
  ay = y2 - y1;
  bx = x3 - x1;
  by = y3 - y1;

  if (ax == 0 && ay == 0) return 0;
  val = ((ax * bx) + (ay * by)) / 
        (sqrt((double)(ax*ax + ay*ay)) * sqrt((double)(bx*bx + by*by)));
  angle = acos ((double)(val)) * 180.0 / 3.14159265;
  return ((int) angle);
}


void
Set_labels(data_display)
  xs_struc_display_menu * data_display;
{
  double distance;
  char message[25];
  XImage *xi;
  Arg args[MAX_ARGS];
  int x3, y3, angle, n;

  xi = XGetImage(gDisplay, data_display->ret->pixmap, 0, 0, 
		 data_display->im_desc->ncolonne, 
		 data_display->im_desc->nligne, 
		 AllPlanes, ZPixmap);

  sprintf (message, "P1 (%d,%d) Val: %d", PX1, PY1, XGetPixel(xi, PX1, PY1));
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_profile[0], args, n);
	
  sprintf (message, "P2 (%d,%d) Val: %d", PX2, PY2, XGetPixel(xi, PX2, PY2));
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_profile[1], args, n);

  distance = ComputeDistance (PX1, PY1, PX2, PY2);
  sprintf (message, "Distance: %.3f pixels", distance);
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_profile[2], args, n);

  y3 = PY1;
  x3 = PX1 + 10; /* same horizontal line */
  angle = ComputeAngle (PX1, PY1, PX2, PY2, x3, y3);
  if (PY2 > PY1) angle = -angle;

  sprintf (message, "Angle: %d degrees", angle);
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(data_display->label_profile[3], args, n);
}


/*****************************************************************************/


void
do_largeur(Drawing_Area, data_display, event)
	Widget Drawing_Area;
	xs_struc_display_menu * data_display;
        XEvent    *event;
{
  Arg args[MAX_ARGS];
  int n;

  switch (event->type){
    case ButtonPress:
    {
      XtRemoveEventHandler(data_display->Drawing_Area, 
                      ButtonPressMask | PointerMotionMask,
			          FALSE,
				  do_largeur, data_display);

      XSetForeground(gDisplay, default_gc, 0);

      XUndefineCursor(gDisplay, XtWindow(data_display->Drawing_Area));
      calcule_le_profil_i(1, data_display);
      affiche_profil_proc(data_display);

    }/* case ButtonPress */

    case MotionNotify:
    {
      PX3 = event->xmotion.x;
      PY3 = event->xmotion.y;

      XSetForeground(gDisplay, gc_xor, 128);
      tracer_rectangle(data_display->Drawing_Area);
      trouver_4_pts(data_display);
      tracer_rectangle(data_display->Drawing_Area);
      Set_labels(data_display);
    }
    
  }/* switch */
}



void
do_profile(Drawing_Area, data_display, event)
	Widget Drawing_Area;
	xs_struc_display_menu * data_display;
        XEvent    *event;
{
  Cursor sizing;
  int X, Y;
  static int firstpress = 0;
  static int Xlast, Ylast; 
  Arg args[MAX_ARGS];
  int n;

  switch (event->type){
    case ButtonPress:
    {
      if (firstpress == 0)
      {
	X = event->xmotion.x;
	Y = event->xmotion.y;
	Xlast = PX2 = PX1 = X;
	Ylast = PY2 = PY1 = Y;

	XSetForeground(gDisplay, gc_xor, 128);
	XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		   gc_xor, PX1,PY1,PX1,PY1);
	firstpress = 1;
      }
      else
      {
	PX2 = event->xmotion.x;
	PY2 = event->xmotion.y;

	XSetForeground(gDisplay, gc_xor, 128);
	XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		   gc_xor, PX1,PY1,Xlast,Ylast);
	XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		   gc_xor, PX1,PY1,PX2,PY2);

	XtRemoveEventHandler(data_display->Drawing_Area, 
			   ButtonPressMask,
			   FALSE,
			   do_profile, data_display);
	XtRemoveEventHandler(data_display->Drawing_Area, 
			   PointerMotionMask,
			   FALSE,
			   do_profile, data_display);
	firstpress = 0;

	if ((PX1 == PX2) && (PY1 == PY2))
	{
	  XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		     gc_xor, PX1,PY1,PX2,PY2);
	  XSetForeground(gDisplay, default_gc, 0);

	  XUndefineCursor(gDisplay, XtWindow(data_display->Drawing_Area));
	  return;
	}
      
	if (PX1 == PX2)
	{
	  trouver_4_pts = trouver_4_pts_vert;
	  (char *)interpoler_si_besoin = (char *)ne_pas_interpoler;
	}
	else if (PY1 == PY2)
	{
	  trouver_4_pts = trouver_4_pts_horis;
	  (char *)interpoler_si_besoin = (char *)ne_pas_interpoler;
	}
	else
	{
	  trouver_4_pts = trouver_4_pts_incl;
	  (char *)interpoler_si_besoin = 
			(char *)interpolation_bilineaire_generale;
	  PX3 = PX2;
	  PY3 = PY2;
	  ad = PY2 - PY1;
	  ad /= PX2 - PX1;
	  ai = -1.0 / ad;
	  bp = PY1 - ad*PX1;
	  bs = PY1+PX1/ad;
	  bt = PY2+PX2/ad;
	}
	px1 = px4 = PX1;
	px2 = px3 = PX2;
	py1 = py4 = PY1;
	py2 = py3 = PY2;

	XSetForeground(gDisplay, gc_xor, 128);
	tracer_rectangle(data_display->Drawing_Area);

	sizing = XCreateFontCursor(gDisplay, XC_sizing);

	XDefineCursor(gDisplay, 
		      XtWindow(data_display->Drawing_Area), sizing);

	XtAddEventHandler(data_display->Drawing_Area, 
			  ButtonPressMask | PointerMotionMask,
			  FALSE,
			  do_largeur, data_display);

      }
      
    }/* case ButtonPress */

    case MotionNotify:
    {
      if (firstpress == 1)
      {
	X = event->xmotion.x;
	Y = event->xmotion.y;

	XSetForeground(gDisplay, gc_xor, 128);
	XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		   gc_xor, PX1,PY1,Xlast,Ylast);
	XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		   gc_xor, PX1,PY1,X,Y);

	Xlast = X;
	Ylast = Y;   
      }
      
    }/* case MotionNotify */
    
  }/* switch */
}


void
profile_CREATE_callb (CREATE, data_display, callData)
	Widget CREATE;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  Cursor pencil;

  pencil = XCreateFontCursor(gDisplay, XC_pencil);

  XDefineCursor(gDisplay, XtWindow(data_display->Drawing_Area), pencil);

  XCopyArea (gDisplay, data_display->ret->pixmap, 
	     XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	     data_display->im_desc->ncolonne, 
	     data_display->im_desc->nligne, 0, 0);

  XtAddEventHandler(data_display->Drawing_Area, 
		    ButtonPressMask,
		    FALSE,
 		    do_profile, data_display);
  XtAddEventHandler(data_display->Drawing_Area, 
		    PointerMotionMask,
		    FALSE,
 		    do_profile, data_display);
}


void
profile_CREATE_2callb (CREATE, SHOW, callData)
	Widget CREATE;
	Widget SHOW;
	caddr_t callData;
{
	Arg args[MAX_ARGS];
	int n;

	n = 0;
	XtSetArg(args[n],XmNsensitive, True); n++;
	XtSetValues(SHOW, args, n);
}

void
profile_SHOW_callb (SHOW, data_display, callData)
	Widget SHOW;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  XCopyArea (gDisplay, data_display->ret->pixmap, 
	     XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	     data_display->im_desc->ncolonne, 
	     data_display->im_desc->nligne, 0, 0);

  XSetForeground(gDisplay, gc_xor, 128);
  XDrawLine (gDisplay, XtWindow(data_display->Drawing_Area), 
	     gc_xor, PX1,PY1,PX2,PY2);
  tracer_rectangle(data_display->Drawing_Area);

  calcule_le_profil_i(1, data_display);
  affiche_profil_proc(data_display);
}



void
profile_GET_PROFILE_callb (GET_PROFILE, data_display, callData)
	Widget GET_PROFILE;
	xs_struc_display_menu * data_display;
	caddr_t callData;
{
  XCopyArea (gDisplay, data_display->ret->pixmap, 
	     XtWindow(data_display->Drawing_Area), default_gc, 0, 0,
	     data_display->im_desc->ncolonne, 
	     data_display->im_desc->nligne, 0, 0);

  XSetForeground(gDisplay, gc_xor, 128);
  XDrawLine (gDisplay, XtWindow(data_display->Drawing_Area), 
	     gc_xor, PX1,PY1,PX2,PY2);
  tracer_rectangle(data_display->Drawing_Area);

  calcule_le_profil_i(1, data_display);
  affiche_profil_proc(data_display);

  Set_labels(data_display);
  
}




























