;**************************************************************************
;** nodes.l                                                              **
;**                                                                      **
;**  Dans ce programme sont traites les definitions, fonctions et metho- **
;**de trois types de nodes. Les bind-nodes qui decrivent les modeles au  **
;**complet,l es not-nodes qui indiquent les modeles negatifs et les join-**
;**nodes qui font les lien entre deux modeles appartenant a une meme re- **
;**gle.                                                                  **
;**                                                                      **
;** Claudia Coiteux-Rosu                                    Juillet 1989 **
;**************************************************************************
;** Methodes:                                                            **
;** Flavor bind-node:                                                    **
;**  add-tests            remove-all-bindings     adds-fact              **
;**  ordonne-vars-fcn     verify-fcn              remove-fact            **
;**  remove                                                              **
;**                                                                      **
;** Flavor join-node:                                                    **
;**  :init                add-tests               add-binding            **
;**  join-bindins         remove-fact             remove-all-bindings    **
;**  remove                                                              **
;**                                                                      **
;** Flavor not-node:                                                     **
;**  :init                add-binding             check-block            **
;**  remove-fact          remove-fact-blocks      remove-all-bindings    **    
;**  remove                                                              **
;**                                                                      **
;**************************************************************************

(eval-when (compile) (load "varenv")
                     (load "psmacs")
                     (load "bindings")
                     (load "ps-util")
                     (load "net"))

;**************************************************************************
;** Definition et methodes concernant les nodes bind-node                **
;**************************************************************************
(defflavor bind-node (
	(pattern nil)	; un modele (pattern) d'une partie gauche de regle
	(vars nil)	; les variables du modele
	(test-list nil)	; les tests qui ont seulement de variables qui ap-
                        ; paraissent dans vars.
	(next-node nil)	; soit un join-node, une node rule, ou un not-node
	(join-how nil)	; si next-node est un join-node ceci sera 'left ou
                        ; 'right
	(net-link nil)	; pointeur au node parent net-node
	)
         nil
        :initable-instance-variables)


;** Methode qui ajoute les tests                                         **
(defmethod (bind-node add-tests) (tsts)
  (setq test-list (usable-tests tsts vars))
  (for i in tsts
       collect (cond ((member (car i) test-list :test 'equal) nil)
                     (t i))))


;** Methode bidon, comme cette methode est appelle recursivement pour les**
;** join-nodes celle ce est une facon simple d'arreter la recursion quand**
;** on arrive aux bind-nodes                                             **
(defmethod (bind-node remove-all-bindings) nil nil)


;** Compare un fait ajoute avec les modele et memorise les appariements  **
(defmethod (bind-node adds-fact) (fact)
  (let ((values (unify pattern 
                 (symeval-in-instance fact 'value) vars)))
    (cond ((eq values '$$FN) ; Le modele est une fonction
               (and (typep next-node 'join-node)
                    (funcall self 'verify-fcn (list fact))))
          ((and (not (eq values '$$FAIL)); Le modele n'est pas une fonction
		(or  (null test-list) 
                     (run-tests vars values test-list)))
                       (make-instance 'binding
	     	        :fact-list (list fact)
		        :values values
		        :back-link next-node
		        :how join-how)))))


;** Methode qui ordonne les variables d'un bind-node fonction            **
(defmethod (bind-node ordonne-vars-fcn) (varsj)
  (let ((varsprop (set-difference vars varsj)))
     (and varsprop
          (setq vars (
              reverse (append (set-difference vars varsprop) varsprop))))))


;** Cette methode est appelee apres l'adjonction d'un fait et elle veri- **
;** fie s'il y a d'appariement entre le fait et la fonction du bind-node.**
(defmethod (bind-node verify-fcn) (faits)
  (let* ((o-c (other-side join-how))
         (o-c-feed (symeval-in-instance next-node (concat o-c '-feed)))
         (o-c-vars (symeval-in-instance o-c-feed 'vars))
	 (o-c-bdgs (symeval-in-instance next-node (concat o-c '-assoc))))
    (for b in o-c-bdgs
         do (for f in faits
                 bind vs res
                     (vrs (reverse (set-difference vars o-c-vars)))
                     (o-vrs vars)
                 when (and (not (eq '$$FAIL
                                  (setq res 
                                   (unify (eval-with-vars o-c-vars
                                           (symeval-in-instance b 'values)
                                           (cadr pattern))
                                          (symeval-in-instance f 'value)
                                           vrs))))
                            (not-exist-binding f 
                               (symeval-in-instance 
                                  next-node (concat join-how '-assoc))))
                 do (and vrs (setq o-vrs 
                               (reverse (set-difference o-vrs vrs))))
                    (setq vs (append res
                            (for vv in o-vrs
                                 collect (nth (position vv o-c-vars)
                                    (symeval-in-instance b 'values)))))
                    (and (or (null test-list)
                         (run-tests vars vs test-list))
                         (make-instance 'binding
                                :fact-list (list f)
                                :values     vs
                                :back-link  next-node
                                :how        join-how))))))


;** Efface les bindings reliant fact au bind-node                        ** 
(defmethod (bind-node remove-fact) (fact)
       (funcall next-node 'remove-fact fact join-how))


;** Efface le modele du bind-node                                        **
(defmethod (bind-node remove) nil
  (funcall net-link 'remove-bind self))


;**************************************************************************
;** Definition et methodes concernant les nodes join-node                **
;**************************************************************************
(defflavor join-node (
	(left-feed nil)    ; parent gauche
	(right-feed nil)   ; parent droit
	(left-assoc nil)   ; bindings pour le parent gauche
	(right-assoc nil)  ; bindings pour le parent droit
	(vars nil)         ; variables de deux parents
	(test-list nil)	   ; tests qui comportent seulement les variables 
                           ; de deux parents
	(next-node nil)	   ; un join-node, un not-node ou un node rule
	(join-how nil)	   ; 'left ou 'right si next-node est un join-node
	)
          nil
         :initable-instance-variables)


(defmethod (join-node :init) (inits)
  (declare (ignore inits))
  (setq vars (psy-merge (symeval-in-instance left-feed 'vars) 
                        (symeval-in-instance right-feed 'vars)))
  (set-in-instance left-feed 'next-node self) 
  (set-in-instance left-feed 'join-how 'left)
  (set-in-instance right-feed 'next-node self) 
  (set-in-instance right-feed 'join-how 'right))


;** Ajoute les tests                                                     **
(defmethod (join-node add-tests) (tsts1)
 (let ((tsts (copy-list tsts1)))
  (if    (for tst in tsts thereis tst)
    (progn
         (setq tsts (funcall left-feed  'add-tests tsts))
         (setq tsts (funcall right-feed 'add-tests tsts))
         (setq test-list (usable-tests tsts vars))))
  (for i in tsts collect (cond ((member (car i) test-list :test 'equal) nil)
                               (t i)))))


;** Ajoute un binding et regarde s'il y a des bindings pour l'autre pa-  **
;** rent pour les joindre et ajouter 'autres bindings.                   **
(defmethod (join-node add-binding) (binding how)
; how est 'left ou 'right
    (ecase how
	     (left  (push1 left-assoc binding)
		    (for cmp in right-assoc
			 do (funcall self 'join-bindings binding cmp)))
	     (right (push1 right-assoc binding)
		    (for cmp in left-assoc
			 do (funcall self 'join-bindings cmp binding)))))


;** Verifie si on peut joindre deux bindings et si c'est le cas elle le  **
;** fait en ajoutant le binding "union" au prochain node (next-node)     **
(defmethod (join-node join-bindings) (left-binding right-binding)
  (let ((all-values (match-bindings left-binding 
                                    (symeval-in-instance left-feed 'vars)
				    right-binding 
                                    (symeval-in-instance right-feed 'vars)
				    test-list 
                                    vars)))
       (or (eq all-values '$$FAIL)
	   (make-instance 'binding
	     :fact-list (append (symeval-in-instance right-binding 
                                                    'fact-list)
				(symeval-in-instance left-binding
                                                    'fact-list))
	     :values all-values
	     :back-link next-node
	     :how join-how))))


;** Efface les bindings pour un fait                                     **
(defmethod (join-node remove-fact) (fact how)
  (let ((db-bindings  (ecase how (left left-assoc) (right right-assoc)))
         rep-bindings found)
     (setq rep-bindings
        (for bdg in db-bindings
            unless (and (memq fact (symeval-in-instance bdg 'fact-list))
                        (setq found (cons bdg found)))
            collect bdg))
     (and found
          (progn()
            (ecase how
                  (left (setq left-assoc rep-bindings)
                        (and (typep right-feed 'bind-node)
                             (eq '|?| (car (symeval-in-instance
                                               right-feed 'pattern)))
                             (setq right-assoc
                               (for obdg in found
                                    do (for bdg in right-assoc
                                            unless (are-joined obdg bdg
                                                              next-node)
                                            collect bdg)))))
                  (right(setq right-assoc rep-bindings)))
            (funcall next-node 'remove-fact fact join-how)))))


;** Efface tous les bindings                                             **
(defmethod (join-node remove-all-bindings) nil
  (setq left-assoc nil)
  (setq right-assoc nil)
  (funcall left-feed 'remove-all-bindings)
  (funcall right-feed 'remove-all-bindings))


;** Efface un modele                                                     **
(defmethod (join-node remove) nil
  (funcall left-feed 'remove)
  (funcall right-feed 'remove))
 

;**************************************************************************
;** Definition et methodes concernant les nodes not-node                 **
;**************************************************************************
(defflavor not-node (
	(not-feed nil)       ; node parent
	(not-assoc nil)      ; bindings pour les modeles negatifs qui re- 
                             ; presente ce not-node
	(blocked-assoc nil)  ; liste de sous-listes (binding bdg-block)
                             ; binding  est un bindding pour la regle qui 
                             ; est bloque par le binding du modele negatif
                             ; bdg-block
	(vars nil)           ; variables des modeles negatifs
	(test-list nil)      ; tests des modeles negatifs
	(rule nil)           ; regle
	)
         ()
         :initable-instance-variables
        (:init-keywords :not-clause :lhs-vars)) ; modele(s) negatif(s) 
                                                ; et variables de la regle


(defmethod (not-node :init) (inits)
  (let ((not-clause (cadr (memq :not-clause inits)))
	 tsts)
       (setq tsts (build-test-list (cdr (memq 'with not-clause))))
       (setq not-feed
	 (add-patterns-net (car (for x in (cdr not-clause)
		 		     until (eq x 'with)
				     tcollect x))
                            *psy-root*))
       (setq vars (psy-merge (cadr (memq :lhs-vars inits)) 
                         (symeval-in-instance not-feed 'vars)))
       (set-in-instance not-feed 'next-node self)
       (if tsts
          (progn
	     (setq tsts (funcall not-feed 'add-tests tsts))
	     (setq test-list (usable-tests tsts vars))
             (setq tsts (for i in tsts 
                             collect (cond ((member (car i) test-list 
                                                    :test 'equal) nil)
                                           (t i))))
	     (check-test-list tsts)))))


;** Ajoute un binding au not-assoc du not-node, c'est-a-dire qu'il y a   **
;** des faits apparies aux modeles negatifs                              **
(defmethod (not-node add-binding) (binding xxx)
 (declare (ignore xxx))
 (let ((lhs-vars (symeval-in-instance 
                      (symeval-in-instance rule 'out-node) 'vars))
       (not-vars (symeval-in-instance not-feed 'vars)))
      (push1 not-assoc binding)
      (for cmp in (symeval-in-instance *psy-db* 'conflict-set)
	   when (and (eq rule (symeval-in-instance cmp 'back-link))
		     (not (eq (match-bindings
			      cmp lhs-vars binding not-vars test-list vars)
			       '$$FAIL)))
	   do (funcall *psy-db* 'remove-conflict-set cmp)
	      (set-in-instance cmp 'back-link self)
	      (push1 blocked-assoc (list cmp binding)))))


;** Un bindings qui a ete ajoute pour une regle est bloque par un autre  **
;** deja existent pour ce node                                           **
(defmethod (not-node check-block) (binding)
  (let ((not-vars (symeval-in-instance not-feed 'vars))
        (lhs-vars (symeval-in-instance
                      (symeval-in-instance rule 'out-node) 'vars)))
       (for cmp in not-assoc
	    when (not (eq (match-bindings binding lhs-vars cmp not-vars
					  test-list vars)
			  '$$FAIL))
	    quit (set-in-instance binding 'back-link self)
		 (push1 blocked-assoc (list binding cmp)))))


;** L'effacement d'un fait provoque un deblocage                         **
(defmethod (not-node remove-fact) (fact xxx)
   (declare (ignore xxx))
       (for bdg in not-assoc
            when (memq fact (symeval-in-instance bdg 'fact-list))
            join (progn ()
                    (setq not-assoc (remove bdg not-assoc :test 'eq))
	            (for pair in blocked-assoc
                         when (eq bdg (cadr pair))
                         collect (progn()
                                   (setq blocked-assoc
                                         (remove pair blocked-assoc
                                                 :test 'eq))
                                   (car pair))))
	    finally (for cmp in $$val
			 do (set-in-instance cmp 'back-link rule)
			    (funcall rule 'add-binding cmp nil))))


;** Appele par (rule remove-fact) efface un blocage                      **
(defmethod (not-node remove-fact-blocks) (fact)
       (for pair in blocked-assoc
            when (memq fact (symeval-in-instance (car pair) 'fact-list))
            do (setq blocked-assoc (remove pair blocked-assoc :test 'eq))))


;** Efface tous les bindings                                             **
(defmethod (not-node remove-all-bindings) nil
       (and not-assoc
            (setq not-assoc nil))
       (and blocked-assoc
	    (setq blocked-assoc  nil))
       (funcall not-feed 'remove-all-bindings))


;** Efface un modele negatif                                             **
(defmethod (not-node remove) nil
  (funcall not-feed 'remove))

