/*****************************************************************************/
/* module menu.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/textsw.h>

static short curseur_courant[] = {
#include "icon/labo_image_cursor.icon"
};
mpr_static (courant_pr, 16, 16, 1, curseur_courant);

static short curseur_wait[] = {
#include "icon/wait_cursor.icon"
};
mpr_static (wait_pr, 16, 16, 1, curseur_wait);

static short icon_laplace1[] = {
#include "icon/laplace1.icon"
};
mpr_static (laplace1_pr, 64, 64, 1, icon_laplace1);

static short icon_laplace2[] = {
#include "icon/laplace2.icon"
};
mpr_static (laplace2_pr, 64, 64, 1, icon_laplace2);

static short icon_laplace3[] = {
#include "icon/laplace3.icon"
};
mpr_static (laplace3_pr, 64, 64, 1, icon_laplace3);

static short icon_roberts1[] = {
#include "icon/roberts1.icon"
};
mpr_static (roberts1_pr, 64, 32, 1, icon_roberts1);

static short icon_roberts2[] = {
#include "icon/roberts2.icon"
};
mpr_static (roberts2_pr, 64, 32, 1, icon_roberts2);

static short icon_sobel1[] = {
#include "icon/sobel1.icon"
};
mpr_static (sobel1_pr, 64, 32, 1, icon_sobel1);

static short icon_sobel2[] = {
#include "icon/sobel2.icon"
};
mpr_static (sobel2_pr, 64, 32, 1, icon_sobel2);
 
#include "help_proc.c" 

#include "tabmenu.h"

extern Pixrect cursor_image_mire;


extern	caddr_t  proc_write_rasterfile();
extern	caddr_t  proc_read_rasterfile();
extern	caddr_t  proc_desc_file();
extern	caddr_t  proc_seuil();
extern	caddr_t  proc_cache_file();
extern	caddr_t  proc_cache_imageplane();
extern	caddr_t  proc_report_erreur();
extern	caddr_t  proc_gris_lin();
extern	caddr_t  proc_gris_log();
extern	caddr_t  proc_couleur_rgb();
extern	caddr_t  proc_laser();
extern	caddr_t  proc_lecture_standard();
extern	caddr_t  proc_mel8();
extern	caddr_t  proc_mel12();
extern	caddr_t  proc_rgb();
extern	caddr_t  proc_lts();
extern  caddr_t  proc_convert();
extern  caddr_t  proc_op_arithm();
extern	caddr_t  proc_bandes();
extern  caddr_t  proc_gen();
extern  caddr_t  proc_padding();
extern  caddr_t  proc_bruit();
extern  caddr_t  proc_opr();
extern  caddr_t  init_main_opr_frame();
extern  caddr_t  proc_graph();
extern	caddr_t	 proc_libere();
extern	caddr_t  proc_lire_desc();
extern	caddr_t  proc_faire_desc();
extern	caddr_t  proc_desctool();
extern	caddr_t  proc_calc_stat();
extern  caddr_t  proc_copie();
extern	caddr_t  proc_histo();
extern	caddr_t  proc_seuillage();
extern	caddr_t  proc_rgb_nivgris();
extern	caddr_t  proc_transpose();
extern	caddr_t  proc_sym_x();
extern	caddr_t  proc_sym_y();
extern	caddr_t  proc_sauve1();
extern	caddr_t  proc_sauve2_cart();
extern	caddr_t  proc_sauve2_pol();
extern	caddr_t  proc_sauve3();
extern	caddr_t  proc_sobel();
extern	caddr_t  proc_laplace();
extern	caddr_t  proc_roberts();
extern	caddr_t	 proc_frei_chen();
extern	caddr_t  proc_egal_histo();
extern	caddr_t  proc_median();
extern	caddr_t  proc_smoothing();
extern	caddr_t  proc_fourier();
extern	caddr_t  proc_haar();
extern  caddr_t  proc_convol();
extern	caddr_t	 proc_affin();
extern  caddr_t  proc_morphbin();
extern  caddr_t  proc_choix_elem();
extern  caddr_t  proc_entree_morphbin();
                         /* extern  caddr_t  proc_entree_macro(); */
extern  caddr_t  proc_sortie_morphbin();
                         /* extern	caddr_t  proc_sortie(); */
extern	caddr_t  proc_high_pass();
extern	caddr_t	 proc_ptile_seuil();
extern	caddr_t	 proc_dyna_seuil();
extern	caddr_t	 proc_linear_filter();
extern	caddr_t  proc_puissance();
extern	caddr_t	 proc_cut_frequncy();
extern	caddr_t	 proc_hamming();
extern	caddr_t	 proc_gaussian();
extern	caddr_t	 proc_ordr1_interp();
extern	caddr_t	 proc_expt1();
extern	caddr_t	 proc_expt2();
extern	caddr_t	 proc_expt3();
extern	caddr_t	 proc_expt0();
 
extern void proc_entree_macro();

caddr_t	 proc_mero_vassy();
caddr_t	 proc_zero_cross();
caddr_t  proc_ridge_ride();
caddr_t  proc_threshold();

caddr_t  proc_cut();
caddr_t  proc_pixedit();
caddr_t  proc_write_N();
caddr_t	 proc_rc_f_8();
caddr_t	 proc_rc_f_4();
caddr_t	 proc_rc_c_8();
caddr_t	 proc_rc_c_4();
caddr_t	 proc_entree_gel1d();
caddr_t	 proc_sortie_gel1d();
caddr_t	 proc_gel1d();
caddr_t	 read_gel1d_proc();
caddr_t	 write_gel1d_proc();
caddr_t	 proc_find_max_gel();
caddr_t	 calcul_profil_proc();

extern  caddr_t  init_main_map_frame();
extern  caddr_t  init_main_grow_frame();
extern  caddr_t  init_main_opr_frame();

extern void proc_cache();

extern Menu puiss_help_proc();
extern Menu freqfltr_help_proc();
extern Menu convol_help_proc();
extern Menu correl_help_proc();
extern Menu color_r_help_proc();
extern Menu mentree_help_proc ();
extern Menu sauve_help_proc();
extern Menu laser_help_proc ();
extern Menu affiche_help_proc ();
extern Menu choixseuil_help_proc ();
extern Menu transforms_help_proc ();
extern Menu convcorr_help_proc ();
extern Menu rehauss_help_proc ();
extern Menu contour_help_proc ();
extern Menu segment_help_proc ();
extern Menu graph_help_proc ();
extern Menu opr_help_proc ();
extern Menu hist_help_proc ();
extern Menu color_help_proc ();
extern Menu cache_help_proc ();
extern Menu trslogmb_help_proc();
extern Menu trsimpmb_help_proc ();
extern Menu aminmb_help_proc ();
extern Menu epaissmb_help_proc ();
extern Menu toutrienmb_help_proc ();
extern Menu trshautnivmb_help_proc ();
extern Menu amincondmb_help_proc ();
extern Menu epaisscondmb_help_proc ();
extern Menu io_help_proc ();
extern Menu display_help_proc ();
extern Menu preprocess_help_proc ();
extern Menu process_help_proc ();
extern Menu measures_help_proc (); 
extern Menu tools_help_proc();
extern Menu aux_help_proc();
extern Menu bruit_help_proc ();
extern Menu pad_help_proc ();
extern Menu bandim_help_proc ();
extern Menu libere_help_proc ();
extern Menu imagetest_help_proc ();
extern Menu modif_help_proc ();
extern Menu convert_help_proc ();
extern Menu oparithm_help_proc ();
extern Menu oplogic_help_proc ();
extern Menu opgeom_help_proc ();
extern Menu elemstruct_help_proc ();
extern Menu morphniv_help_proc ();
/* extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ()
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
extern Menu ();
*/


extern int flag_help; 
extern char *menutabs[];
extern char *Tmenutabs[];

Menu	mprincipal, mpretraite, mtraite, mdisplay, maux, mtools, m_i_o;
Menu    mmorphbin, maff, mmodif, mconvert, moparithm, mtransf, mhisto;
Menu    mmesures, mtyptransfimage, mfreq_fltr;
Menu	mimage, mconvol, mgeom, mmorphniv, mchoixelem, mraster, mlaser;
Menu    mcorrel, mconvcorrel, mdegrad, mentree;
Menu    mmb1, mmb2, mmb3, mmb4, mmb5, mmb6, mmb7, mmb8, mmb9;
Menu	mbases, mbruit, mseg, mopr, mgraph, mpadding, mlibere, mcurs, mcoord;
Menu	mgel1dtool, mgel1_1, mgel1_2, mgel1_3,mgel1_4, mgel1_cor1, mprofil;
Cursor	c_courant, c_wait, c_mire;

static int callback;

/*****************************************************************************/

Menu wait_curseur_proc (m, operation)

    Menu m;
    Menu_generate operation;

{
    extern  Textsw  master;

    if (operation == MENU_NOTIFY){
	window_set (master, WIN_CURSOR, c_wait, 0);
    }
    if (operation == MENU_NOTIFY_DONE){
	window_set (master, WIN_CURSOR, c_courant, 0);
    } 
    return m;
}

/*****************************************************************************/
creer_menu()

{
    Menu    mformat, mio;
    Menu    mpol, mcart;
    Menu    mimagetest, mnbrbandes, msauve;
    Menu    mtemp;
    Menu    mcorresp, mrehauss, mrestaur, mcontours, mrelax;
    Menu    mtexture, mregions, mlaplace, mroberts, msobel;
    Menu    mthresh, mcrctbkg;
    Menu    mpuissance,menlarge;
    Menu    mexpt, mcreerzone, mafficher, mstatzone, msauver, mhisto;
    Menu    mcolors_r, mcolors_r_all, mcache;




    mtemp = menu_create
              (MENU_ITEM,  MENU_STRING, "en preparation...", 
               MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0, 0, 0);


   mbruit = menu_create(MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
               MENU_ITEM,  MENU_STRING, menutabs[34] , 
                   MENU_NOTIFY_PROC, bruit_help_proc, MENU_INVERT, TRUE,
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING,typbruittabs[0], MENU_VALUE, 0,
		   MENU_NOTIFY_PROC, proc_bruit, 0,
               MENU_ITEM, MENU_STRING, typbruittabs[1], MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_bruit, 0,
	       0);

    mpadding = menu_create(MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
               MENU_ITEM,  MENU_STRING, menutabs[35], 
                   MENU_NOTIFY_PROC, pad_help_proc, MENU_INVERT, TRUE,
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, padtabs[0], MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_padding, 0,
               MENU_ITEM, MENU_STRING, padtabs[1], MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, proc_padding, 0,
	       MENU_ITEM, MENU_STRING, padtabs[2], MENU_VALUE, 3,
		   MENU_NOTIFY_PROC, proc_padding, 0,
	       0);

    mnbrbandes = menu_create
              (MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
               MENU_ITEM,  MENU_STRING, menutabs[36], 
                   MENU_NOTIFY_PROC, bandim_help_proc, MENU_INVERT, TRUE, 
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, bandimtabs[0], MENU_VALUE, 8,
                   MENU_NOTIFY_PROC, proc_bandes, 0,
               MENU_ITEM, MENU_STRING, bandimtabs[1], MENU_VALUE, 16,
                   MENU_NOTIFY_PROC, proc_bandes, 0,
               MENU_ITEM, MENU_STRING, bandimtabs[2], MENU_VALUE, 32,
                   MENU_NOTIFY_PROC, proc_bandes, 0,
               MENU_ITEM, MENU_STRING, bandimtabs[3], MENU_VALUE, 64,
                   MENU_NOTIFY_PROC, proc_bandes, 0,
               0);


    mpuissance = menu_create(MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
               MENU_ITEM,  MENU_STRING, menutabs[37], 
                 MENU_NOTIFY_PROC, puiss_help_proc, MENU_INVERT, TRUE,
		 MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
	       MENU_ITEM, MENU_STRING, puisstabs[0], MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_puissance, 0,
	       MENU_ITEM, MENU_STRING, puisstabs[1], MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, proc_cut_frequncy, 0,
	       0, 0);

    mfreq_fltr = menu_create(MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
               MENU_ITEM,  MENU_STRING, menutabs[38], 
                 MENU_NOTIFY_PROC, freqfltr_help_proc, MENU_INVERT, TRUE, 
		 MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
	       MENU_ITEM, MENU_STRING, freqfltrtabs[0], MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_hamming, 0,
	       MENU_ITEM, MENU_STRING, freqfltrtabs[2], MENU_VALUE, 3,
		   MENU_NOTIFY_PROC, proc_hamming, 0,
	       MENU_ITEM, MENU_STRING, freqfltrtabs[1], MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, proc_gaussian, 0,
	       0, 0);


    mconvol = menu_create(MENU_DEFAULT, 1,
             MENU_INITIAL_SELECTION_EXPANDED, FALSE,
             MENU_ITEM,  MENU_STRING, menutabs[39], 
                 MENU_NOTIFY_PROC, convol_help_proc, MENU_INVERT, TRUE,
		 MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
	     MENU_ITEM, MENU_STRING, typconvcorrtabs[0], 
		   MENU_VALUE, 1, MENU_NOTIFY_PROC, proc_convol, 0,
	     MENU_ITEM, MENU_STRING, typconvcorrtabs[1], 
		   MENU_VALUE, 2, MENU_NOTIFY_PROC, proc_convol, 0,
            0,0);
/*                  MENU_NOTIFY_PROC, correl_help_proc, MENU_INVERT, TRUE, 
*/
    mcorrel = menu_create(MENU_DEFAULT, 2,
             MENU_INITIAL_SELECTION_EXPANDED, FALSE,
             MENU_ITEM,  MENU_STRING, menutabs[40], 
		 MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
	     MENU_ITEM, MENU_STRING, typconvcorrtabs[0],  
		   MENU_VALUE, 11, MENU_NOTIFY_PROC, proc_convol, 0,
	     MENU_ITEM, MENU_STRING, typconvcorrtabs[1], 
		   MENU_VALUE, 12, MENU_NOTIFY_PROC, proc_convol, 0,
	     0, 0);

    menlarge = menu_create(
	       MENU_ITEM, MENU_STRING, aggrandtabs[0], MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_ordr1_interp, 0,
	       0, 0);



    msobel = menu_create(
		MENU_ITEM, MENU_IMAGE, &sobel1_pr, MENU_VALUE, 1, 
		    MENU_BOXED, TRUE, MENU_NOTIFY_PROC, proc_sobel, 0,
    		MENU_ITEM, MENU_IMAGE, &sobel2_pr, MENU_VALUE, 2, 
		    MENU_BOXED, TRUE, MENU_NOTIFY_PROC, proc_sobel, 0,
		0, 0);


    mlaplace = menu_create(
		MENU_ITEM, MENU_IMAGE, &laplace1_pr, MENU_VALUE, 0, 
		    MENU_NOTIFY_PROC, proc_laplace, 0,
		MENU_ITEM, MENU_IMAGE, &laplace2_pr, MENU_VALUE, 1, 
		    MENU_NOTIFY_PROC, proc_laplace, 0,
		MENU_ITEM, MENU_IMAGE, &laplace3_pr, MENU_VALUE, 2, 
		    MENU_NOTIFY_PROC, proc_laplace, 0,
		0, 0);


    mroberts = menu_create(
		MENU_ITEM, MENU_IMAGE, &roberts1_pr, MENU_VALUE, 1, 
		    MENU_BOXED, TRUE, MENU_NOTIFY_PROC, proc_roberts, 0,
		MENU_ITEM, MENU_IMAGE, &roberts2_pr, MENU_VALUE, 2, 
		    MENU_BOXED, TRUE, MENU_NOTIFY_PROC, proc_roberts, 0,
		0, 0);



    mlibere = menu_create(MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
               MENU_ITEM,  MENU_STRING, menutabs[41], 
                    MENU_NOTIFY_PROC, libere_help_proc, MENU_INVERT, TRUE, 
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, libtabs[0], MENU_VALUE, 0,
		   MENU_NOTIFY_PROC, proc_libere, 0,
               MENU_ITEM, MENU_STRING, libtabs[1], MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_libere, 0,
	       MENU_ITEM, MENU_STRING, libtabs[2], MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, proc_libere, 0,
	       MENU_ITEM, MENU_STRING, libtabs[3], MENU_VALUE, 3,
		   MENU_NOTIFY_PROC, proc_libere, 0,
	       0, 0);



    mcolors_r = menu_create
		 (MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM,  MENU_STRING, menutabs[42], 
                      MENU_NOTIFY_PROC, color_r_help_proc, MENU_INVERT, TRUE, 
		      MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
                  MENU_ACTION_ITEM, color_rtabs[0], proc_rc_f_8,
		  MENU_ACTION_ITEM, color_rtabs[1], proc_rc_f_4,
		  MENU_ACTION_ITEM, color_rtabs[2], proc_rc_c_8,
		  MENU_ACTION_ITEM, color_rtabs[3], proc_rc_c_4,
		  0,  0);


    mentree = menu_create
              (MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		MENU_ITEM,  MENU_STRING, menutabs[7], 
                   MENU_NOTIFY_PROC, mentree_help_proc, MENU_INVERT, TRUE, 
		   MENU_FEEDBACK, FALSE, MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, acquistabs[0], 
			MENU_VALUE, 0, 
			MENU_NOTIFY_PROC, proc_lecture_standard, 0,
               MENU_ITEM, MENU_STRING,"standard*", 
			MENU_VALUE, 1, 
			MENU_NOTIFY_PROC, proc_lecture_standard, 0,
               MENU_ACTION_ITEM, acquistabs[1], proc_mel8,
               MENU_ACTION_ITEM, acquistabs[2], proc_mel12,
               MENU_ACTION_ITEM, acquistabs[3], proc_lts,
               MENU_ACTION_ITEM, acquistabs[4], proc_rgb,
	       MENU_ACTION_ITEM, "sun raster", proc_read_rasterfile,
               0, 0);


    msauve = menu_create
              ( MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		MENU_ITEM,  MENU_STRING, menutabs[8], 
                    MENU_NOTIFY_PROC, sauve_help_proc, MENU_INVERT, TRUE, 
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ACTION_ITEM, sauvetabs[0], proc_sauve1,
               MENU_ACTION_ITEM, sauvetabs[1], proc_sauve2_cart,
               MENU_ACTION_ITEM, sauvetabs[2], proc_sauve2_pol,
               MENU_ACTION_ITEM, sauvetabs[3], proc_sauve3,
               MENU_ACTION_ITEM, "sun raster", proc_write_rasterfile,
               0, 0);


    mlaser = menu_create
	      (MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
               MENU_ITEM,  MENU_STRING, menutabs[9], 
                   MENU_NOTIFY_PROC, laser_help_proc, MENU_INVERT, TRUE,
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, lasertabs[0], MENU_VALUE, 0,
		    MENU_NOTIFY_PROC, proc_laser, 0,
	       MENU_ITEM, MENU_STRING, lasertabs[1], MENU_VALUE, 1,
		    MENU_NOTIFY_PROC, proc_laser, 0,
	       0, 0);


    maff =  menu_create
            (MENU_DEFAULT, 2,
             MENU_INITIAL_SELECTION_EXPANDED, FALSE,
	     MENU_ITEM,  MENU_STRING,menutabs[10] , 
                 MENU_NOTIFY_PROC, affiche_help_proc, MENU_INVERT, TRUE,
		 MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
            MENU_ACTION_ITEM, affichtabs[0], proc_seuil,
            MENU_ACTION_ITEM, affichtabs[1], proc_report_erreur,
            MENU_ACTION_ITEM, affichtabs[2], proc_gris_lin,
            MENU_ACTION_ITEM, affichtabs[3], proc_gris_log,
            MENU_ITEM, MENU_STRING, affichtabs[4], MENU_VALUE, 0,
	        MENU_NOTIFY_PROC, proc_couleur_rgb, 0,
            MENU_ITEM, MENU_STRING, affichtabs[5], MENU_VALUE, 1,
		MENU_NOTIFY_PROC, proc_couleur_rgb, 0,
            0, 0);


    mimagetest = menu_create
               (MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		MENU_ITEM,  MENU_STRING, menutabs[11],  
                    MENU_NOTIFY_PROC, imagetest_help_proc, MENU_INVERT, TRUE, 
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
                MENU_PULLRIGHT_ITEM, genimtabs[0], mnbrbandes,
                MENU_ITEM, MENU_STRING, genimtabs[1], MENU_VALUE, 1,
		    MENU_NOTIFY_PROC, proc_gen, 0,
                MENU_ITEM, MENU_STRING, genimtabs[2], MENU_VALUE, 2,
		    MENU_NOTIFY_PROC, proc_gen, 0,
                MENU_ITEM, MENU_STRING, genimtabs[3], MENU_VALUE, 3,
		    MENU_NOTIFY_PROC, proc_gen, 0,
                0, 0);


    mmodif  = menu_create
              (MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
               MENU_ITEM, MENU_STRING, menutabs[13], 
		   MENU_NOTIFY_PROC, modif_help_proc, MENU_INVERT, TRUE,
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_PULLRIGHT_ITEM, recttabs[0], menlarge,
	       MENU_PULLRIGHT_ITEM, recttabs[1], mpadding,
               MENU_PULLRIGHT_ITEM, bruittabs[0], mbruit,
               MENU_ACTION_ITEM, opgeomtabs[4], proc_cut,
               0, 0);
 

    mthresh = menu_create
	      (MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
	       MENU_ITEM,  MENU_STRING, menutabs[15],
                   MENU_NOTIFY_PROC, choixseuil_help_proc, MENU_INVERT, TRUE, 
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ACTION_ITEM, seuiltabs[0], proc_ptile_seuil,
	       MENU_ACTION_ITEM, seuiltabs[1], proc_dyna_seuil,
	       0, 0);

    mtransf = menu_create
             (MENU_DEFAULT, 2,
              MENU_INITIAL_SELECTION_EXPANDED, FALSE,
              MENU_ITEM,  MENU_STRING, typtransftabs[1] , 
                  MENU_NOTIFY_PROC, transforms_help_proc, 
		  MENU_INVERT, TRUE, 
		  MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
	      MENU_ITEM, MENU_STRING, transformtabs[0], 
		  MENU_VALUE, 1, MENU_NOTIFY_PROC, proc_fourier, 0,
	      MENU_ITEM, MENU_STRING, transformtabs[1],
		  MENU_VALUE, -1, MENU_NOTIFY_PROC, proc_fourier, 0, 
	      MENU_ITEM, MENU_STRING, transformtabs[2],
		  MENU_VALUE, 2, MENU_NOTIFY_PROC, proc_fourier, 0, 
	      MENU_ITEM, MENU_STRING, transformtabs[3],
		  MENU_VALUE, -2, MENU_NOTIFY_PROC, proc_fourier, 0,
              MENU_ITEM,  MENU_STRING, typtransftabs[0] , 
                  MENU_NOTIFY_PROC, transforms_help_proc, 
		  MENU_INVERT, TRUE, 
		  MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0, 
	      MENU_ITEM, MENU_STRING, transformtabs[0], 
		  MENU_VALUE, 10, MENU_NOTIFY_PROC, proc_fourier, 0,
	      MENU_ITEM, MENU_STRING, transformtabs[2],
		  MENU_VALUE, 20, MENU_NOTIFY_PROC, proc_fourier, 0,
	      0, 0);


    mconvcorrel = menu_create(MENU_DEFAULT, 2,
             MENU_INITIAL_SELECTION_EXPANDED, FALSE,
             MENU_ITEM,  MENU_STRING, menutabs[17], 
                 MENU_NOTIFY_PROC, convcorr_help_proc, MENU_INVERT, TRUE, 
		 MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
	     MENU_ITEM, MENU_STRING, convcorrtabs[0],
		   MENU_VALUE, 3, MENU_NOTIFY_PROC, proc_convol, 0,
	     MENU_PULLRIGHT_ITEM, convcorrtabs[1], mconvol, 
	     MENU_PULLRIGHT_ITEM, convcorrtabs[2], mcorrel, 
             0, 0);


    mrehauss = menu_create(MENU_DEFAULT, 2,
	       MENU_INITIAL_SELECTION_EXPANDED, FALSE,
	       MENU_ITEM,  MENU_STRING, menutabs[18],
                   MENU_NOTIFY_PROC, rehauss_help_proc, MENU_INVERT, TRUE, 
	           MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
	       MENU_ACTION_ITEM, rehausstabs[1] , proc_median,
	       MENU_ACTION_ITEM, rehausstabs[3] , proc_high_pass,
	       MENU_PULLRIGHT_ITEM, rehausstabs[4] , mfreq_fltr, 
	       0, 0);
/* 	       MENU_ACTION_ITEM, rehausstabs[2] , proc_smoothing,
*/

    mcontours = menu_create
	      ( MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		MENU_ITEM,  MENU_STRING, menutabs[19] , 
                   MENU_NOTIFY_PROC, contour_help_proc, MENU_INVERT, TRUE,
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_PULLRIGHT_ITEM, contourtabs[0] , msobel,
	       MENU_PULLRIGHT_ITEM, contourtabs[1] , mlaplace,
	       MENU_PULLRIGHT_ITEM, contourtabs[2] , mroberts,
	       MENU_ACTION_ITEM, contourtabs[3] , proc_frei_chen, 
	       MENU_ACTION_ITEM, contourtabs[4] , proc_mero_vassy,
	       MENU_ACTION_ITEM, contourtabs[5] , proc_zero_cross,
	       MENU_ACTION_ITEM, contourtabs[6] , proc_ridge_ride,
               0, 0);

    mopr = menu_create(MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		MENU_ITEM,  MENU_STRING, menutabs[63] , 
		MENU_NOTIFY_PROC, opr_help_proc, MENU_INVERT, TRUE,
		MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, oprtabs[0] , MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_opr, 0,
               MENU_ITEM, MENU_STRING, oprtabs[1] , MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, init_main_opr_frame, 0,
	       0);

    mgraph = menu_create(MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		MENU_ITEM,  MENU_STRING, menutabs[64] , 
		MENU_NOTIFY_PROC, graph_help_proc, MENU_INVERT, TRUE,
		MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, graphtabs[0] , MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_graph, 0,
               MENU_ITEM, MENU_STRING, graphtabs[1] , MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, proc_graph, 0,
               MENU_ITEM, MENU_STRING, graphtabs[2] , MENU_VALUE, 3,
		   MENU_NOTIFY_PROC, proc_graph, 0,
               MENU_ITEM, MENU_STRING, graphtabs[3] , MENU_VALUE, 4,
		   MENU_NOTIFY_PROC, proc_graph, 0,
	       0);

    mseg = menu_create(MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
                MENU_ITEM,  MENU_STRING, menutabs[20] , 
		MENU_NOTIFY_PROC, segment_help_proc, MENU_INVERT, TRUE,
		MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, segmenttabs[0] , MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, init_main_grow_frame, 0,
               MENU_PULLRIGHT_ITEM, segmenttabs[1], mopr,
	       MENU_PULLRIGHT_ITEM, segmenttabs[2] , mgraph,
	       0, 0);

    mhisto = menu_create
            ( MENU_DEFAULT, 2,
              MENU_INITIAL_SELECTION_EXPANDED, FALSE,
	      MENU_ITEM,  MENU_STRING, menutabs[22] , 
                 MENU_NOTIFY_PROC, hist_help_proc, MENU_INVERT, TRUE,
		 MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0, 
               MENU_ITEM, MENU_STRING, histtabs[0] , MENU_VALUE, 0,
		   MENU_NOTIFY_PROC, proc_histo, 0,
               MENU_ITEM, MENU_STRING, histtabs[1] , MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_histo, 0,
               MENU_ITEM, MENU_STRING, histtabs[2] , MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, proc_histo, 0,
               0, 0);


    mconvert = menu_create
              ( MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		MENU_ITEM, MENU_STRING, menutabs[23],
                   MENU_NOTIFY_PROC, convert_help_proc, MENU_INVERT, TRUE,
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ACTION_ITEM, converttabs[0], proc_seuillage,
               MENU_ITEM, MENU_STRING, "byte", MENU_VALUE, 0,
		   MENU_NOTIFY_PROC, proc_convert, 0,
               MENU_ITEM, MENU_STRING, "short", MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_convert, 0,
               MENU_ITEM, MENU_STRING, converttabs[1], MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, proc_convert, 0,
               MENU_ITEM, MENU_STRING, converttabs[2], MENU_VALUE, 3,
		   MENU_NOTIFY_PROC, proc_convert, 0,
               MENU_ITEM, MENU_STRING, converttabs[3], MENU_VALUE, 4,
		   MENU_NOTIFY_PROC, proc_convert, 0,
               MENU_ITEM, MENU_STRING, menutabs[24],
                   MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
               MENU_ITEM, MENU_STRING, "cart-->pol", MENU_VALUE, 5,
		   MENU_NOTIFY_PROC, proc_convert, 0,
               MENU_ITEM, MENU_STRING, "pol-->cart", MENU_VALUE, 6,
		   MENU_NOTIFY_PROC, proc_convert, 0,
               MENU_ITEM, MENU_STRING, menutabs[29],
                   MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
                MENU_ACTION_ITEM,  recttabs[2], proc_rgb_nivgris,
               0, 0);


    moparithm = menu_create
              (MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
	       MENU_ITEM, MENU_STRING, menutabs[25],
                   MENU_NOTIFY_PROC, oparithm_help_proc, MENU_INVERT, TRUE, 
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, "addition", MENU_VALUE, 20,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, oparithtabs[0], MENU_VALUE, 21,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, "multiplication", MENU_VALUE, 22,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, "division", MENU_VALUE, 23,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, menutabs[26],
                   MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
               MENU_ITEM, MENU_STRING, "addition", MENU_VALUE, 10,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, oparithtabs[0], MENU_VALUE, 11,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, "multiplication", MENU_VALUE, 12,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, "division", MENU_VALUE, 13,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, menutabs[28],
                   MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
               MENU_ITEM, MENU_STRING, "multiplication", MENU_VALUE, 41,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,
               MENU_ITEM, MENU_STRING, menutabs[27],
                   MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
               MENU_ITEM, MENU_STRING, "multiplication", MENU_VALUE, 40,
		   MENU_NOTIFY_PROC, proc_op_arithm, 0,

               0, 0);


    mraster = menu_create 
               (MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		MENU_ITEM,  MENU_STRING, menutabs[30], 
                   MENU_NOTIFY_PROC, oplogic_help_proc, MENU_INVERT, TRUE, 
		   MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, "and", MENU_VALUE, 40,
		   MENU_NOTIFY_PROC, proc_gen, 0,
               MENU_ITEM, MENU_STRING, oplogtabs[0], MENU_VALUE, 41,
		   MENU_NOTIFY_PROC, proc_gen, 0,
               MENU_ITEM, MENU_STRING, "or", MENU_VALUE, 5,
		   MENU_NOTIFY_PROC, proc_gen, 0,
               MENU_ITEM, MENU_STRING, "xor", MENU_VALUE, 6,
		   MENU_NOTIFY_PROC, proc_gen, 0,
               MENU_ITEM, MENU_STRING, "not", MENU_VALUE, 7,
		   MENU_NOTIFY_PROC, proc_gen, 0,
	      0, 0);


    mgeom = menu_create
              (MENU_DEFAULT, 2,
                MENU_INITIAL_SELECTION_EXPANDED, FALSE,
	       MENU_ITEM,  MENU_STRING, menutabs[30], 
                 MENU_NOTIFY_PROC, opgeom_help_proc, MENU_INVERT, TRUE, 
	         MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, "rotation", MENU_VALUE, 0,
                   MENU_NOTIFY_PROC, proc_affin, 0,
               MENU_ITEM, MENU_STRING, "translation", MENU_VALUE, 1,
                   MENU_NOTIFY_PROC, proc_affin, 0,
               MENU_ITEM, MENU_STRING, opgeomtabs[0], MENU_VALUE, 2,
                   MENU_NOTIFY_PROC, proc_affin, 0,
               MENU_ITEM, MENU_STRING, opgeomtabs[1], MENU_VALUE, 3,
                   MENU_NOTIFY_PROC, proc_affin, 0,
	       MENU_ACTION_ITEM, "transposition", proc_transpose,
               MENU_ACTION_ITEM, opgeomtabs[2], proc_sym_x,
               MENU_ACTION_ITEM, opgeomtabs[3], proc_sym_y,
               0);


    mcolors_r_all = menu_create
	         (MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM,  MENU_STRING, menutabs[32], 
                    MENU_NOTIFY_PROC, color_help_proc, MENU_INVERT, TRUE, 
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
                  MENU_PULLRIGHT_ITEM, colortabs[0], mcolors_r,
		  MENU_ACTION_ITEM,colortabs[1], proc_write_N,
		    0);


    mexpt = menu_create
	      (MENU_DEFAULT, 2,
               MENU_INITIAL_SELECTION_EXPANDED, FALSE,
	       MENU_ITEM,  MENU_STRING, menutabs[33], 
                 MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
               MENU_ACTION_ITEM, sysexptabs[0], proc_expt0,
	       MENU_ACTION_ITEM, sysexptabs[1], proc_expt1,
	       MENU_ACTION_ITEM, sysexptabs[2], proc_expt3,
	       MENU_ACTION_ITEM, sysexptabs[3], proc_expt2,
	       MENU_PULLRIGHT_ITEM, sysexptabs[4], mtemp,
               0, 0);

        mcache = menu_create
	     (MENU_DEFAULT, 2,
              MENU_INITIAL_SELECTION_EXPANDED, FALSE,
	      MENU_ITEM,  MENU_STRING, menutabs[61], 
               MENU_NOTIFY_PROC, cache_help_proc, 
               MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
	      MENU_ITEM, MENU_STRING, affcachetabs[0],
		      MENU_NOTIFY_PROC, proc_cache_file, 0,
	      MENU_ITEM, MENU_STRING, affcachetabs[1],
		      MENU_NOTIFY_PROC, proc_cache_imageplane, 0,
	     0, 0);

/*
    mcorresp =
    mrestaur = 
    mrelax = 
    mtexture =
    mregions =
*/

    mmb1 = menu_create(MENU_ITEM, MENU_STRING, morphbintabs[0], 
                           MENU_VALUE, 1, 
                           MENU_NOTIFY_PROC, proc_morphbin, 0,
                       0, 0);
                      
    mmb2 = menu_create(MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[43] , 
                    MENU_NOTIFY_PROC, trslogmb_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, "complement", MENU_VALUE, 20,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, "intersection", MENU_VALUE, 21,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, "union", MENU_VALUE, 22,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb2tabs[0], MENU_VALUE, 23,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, "difference", MENU_VALUE, 24,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               0, 0);

    mmb3 = menu_create(MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[43] , 
                    MENU_NOTIFY_PROC, trsimpmb_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, "erosion", MENU_VALUE, 30,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb3tabs[0], MENU_VALUE, 31,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING,  mmb3tabs[1], MENU_VALUE, 32,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, "dilatation", MENU_VALUE, 33,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING,  mmb3tabs[2], MENU_VALUE, 34,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING,  mmb3tabs[3], MENU_VALUE, 35,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING,  mmb3tabs[4], MENU_VALUE, 36,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb3tabs[5], MENU_VALUE, 37,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               0, 0);

    mmb4 = menu_create(MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[44] , 
                    MENU_NOTIFY_PROC, aminmb_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, mmb4tabs[0],  MENU_VALUE, 40,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb4tabs[1] , MENU_VALUE, 41,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING,mmb4tabs[2],  MENU_VALUE ,42,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb4tabs[3],  MENU_VALUE, 43,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               0, 0);

    mmb5 = menu_create(MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[45] , 
                    MENU_NOTIFY_PROC, epaissmb_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[0],  MENU_VALUE, 50,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[1], MENU_VALUE, 51,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[2],  MENU_VALUE, 52,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[3], MENU_VALUE, 53,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[4],  MENU_VALUE, 54,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               0, 0);

    mmb6 = menu_create(MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[46] , 
                    MENU_NOTIFY_PROC, toutrienmb_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, mmb6tabs[0], 
                   MENU_VALUE, 61,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb6tabs[1],  MENU_VALUE, 62,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb6tabs[2],  MENU_VALUE, 63,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               0, 0);

    mmb7 = menu_create(MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[47] , 
                    MENU_NOTIFY_PROC, trshautnivmb_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, mmb7tabs[0],  MENU_VALUE, 70,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb7tabs[1],   MENU_VALUE, 71,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb7tabs[2],   MENU_VALUE, 72,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb7tabs[3],   MENU_VALUE, 73,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb7tabs[4],   MENU_VALUE, 74,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb7tabs[5],  MENU_VALUE, 75,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb7tabs[6],  MENU_VALUE, 76,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb7tabs[7], MENU_VALUE, 77,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               0, 0);

    mmb8 = menu_create(MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[44] , 
                    MENU_NOTIFY_PROC, amincondmb_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, mmb4tabs[0],  MENU_VALUE, 80,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb4tabs[1], MENU_VALUE, 81,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb4tabs[2], MENU_VALUE, 82,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               0, 0);

    mmb9 = menu_create(MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[45] , 
                    MENU_NOTIFY_PROC, epaisscondmb_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[0], 
                   MENU_VALUE, 90,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[1],
		   MENU_VALUE, 91,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[2],
		   MENU_VALUE, 92,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[3],  
                   MENU_VALUE, 93,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               MENU_ITEM, MENU_STRING, mmb5tabs[4],  
                   MENU_VALUE, 94,
		   MENU_NOTIFY_PROC, proc_morphbin, 0,
               0, 0);

    mmorphbin = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
		  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
                  MENU_PULLRIGHT_ITEM, morphbintabs[1], mmb2,
                  MENU_PULLRIGHT_ITEM, morphbintabs[2], mmb3,
                  MENU_PULLRIGHT_ITEM, morphbintabs[3], mmb4,
                  MENU_PULLRIGHT_ITEM, morphbintabs[4], mmb8,
                  MENU_PULLRIGHT_ITEM, morphbintabs[5], mmb5,
                  MENU_PULLRIGHT_ITEM, morphbintabs[6], mmb9,
                  MENU_PULLRIGHT_ITEM, morphbintabs[7], mmb6,
                  MENU_PULLRIGHT_ITEM, morphbintabs[8], mmb7,
                  0, 0); 
/*                  MENU_ITEM, MENU_STRING, morphbintabs[0], MENU_VALUE, 1,
                      MENU_NOTIFY_PROC, proc_morphbin, 0,
                  MENU_ACTION_ITEM, morphbintabs[9], proc_sortie_morphbin,

*/
    mchoixelem = menu_create
		 (MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[49] , 
                    MENU_NOTIFY_PROC, elemstruct_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
		    MENU_ITEM, MENU_STRING, "sphere", MENU_VALUE, 0, 
		    MENU_NOTIFY_PROC, proc_choix_elem, 0,
		  MENU_ITEM, MENU_STRING, "cone", MENU_VALUE, 1,
		    MENU_NOTIFY_PROC, proc_choix_elem, 0,
		  MENU_ITEM, MENU_STRING, morphelemtabs[0], MENU_VALUE, 2,
		    MENU_NOTIFY_PROC, proc_choix_elem, 0,
		  MENU_ITEM, MENU_STRING, morphelemtabs[1], MENU_VALUE, 3,
		    MENU_NOTIFY_PROC, proc_choix_elem, 0,
		  MENU_ITEM, MENU_STRING, morphelemtabs[2], MENU_VALUE, 10,
		    MENU_NOTIFY_PROC, proc_choix_elem, 0,
		 0, 0);

    mmorphniv = menu_create
                (MENU_DEFAULT, 2,
                 MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		 MENU_ITEM,  MENU_STRING, menutabs[21] , 
                    MENU_NOTIFY_PROC, morphniv_help_proc, MENU_INVERT, TRUE,
		    MENU_FEEDBACK, FALSE , MENU_BOXED, TRUE, 0,
                  MENU_ITEM, MENU_STRING, morphnivgristabs[0] , MENU_VALUE, 10, 
		    MENU_PULLRIGHT, mchoixelem, 0,
		  MENU_ITEM, MENU_STRING, morphnivgristabs[1] , MENU_VALUE, 11, 
		    MENU_PULLRIGHT, mchoixelem, 0,
		  MENU_ITEM, MENU_STRING, morphnivgristabs[2] , MENU_VALUE, 12, 
		    MENU_PULLRIGHT, mchoixelem, 0,
		  MENU_ITEM, MENU_STRING, morphnivgristabs[3] , MENU_VALUE, 13, 
		    MENU_PULLRIGHT, mchoixelem, 0,
		 0, 0);


    mgel1_cor1 = menu_create(
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM, MENU_STRING,menutabs[50] , 
                  MENU_NOTIFY_PROC, mgel1_cor1_CorrigeManuel__help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
               MENU_ITEM, MENU_STRING, gelcortabs[0], 
                   MENU_VALUE, 12,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               MENU_ITEM, MENU_STRING, gelcortabs[1],  
                   MENU_VALUE, 13,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               MENU_ITEM, MENU_STRING, gelcortabs[2],  
                   MENU_VALUE, 14,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               0, 0);

    mgel1_1 = menu_create(
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
                  /* Here ??? 1991 ????
		  MENU_ITEM, MENU_STRING,menutabs[51] , 
                  MENU_NOTIFY_PROC, mgel1_1_FronPreEst_help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
                  */
               MENU_ITEM, MENU_STRING, gel1tabs[0], 
                   MENU_VALUE, 10,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               MENU_ITEM, MENU_STRING, gel1tabs[1],  
                   MENU_VALUE, 11,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
	       MENU_PULLRIGHT_ITEM, gel1tabs[2], mgel1_cor1,
               0, 0);

    mgel1_2 = menu_create(
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
                  /* Here ??? 1991 ????
		  MENU_ITEM, MENU_STRING,menutabs[61] , 
                  MENU_NOTIFY_PROC, mgel1_2_FronPrecis_help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
                  */
               MENU_ITEM, MENU_STRING, gel1tabs[0], 
                   MENU_VALUE, 20,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               MENU_ITEM, MENU_STRING, gel1tabs[1],  
                   MENU_VALUE, 21,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               MENU_ITEM, MENU_STRING, gel1tabs[2],  
                   MENU_VALUE, 22,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               0, 0);

    mgel1_3 = menu_create(
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
                 /* Here ??? 1991 ????
		  MENU_ITEM, MENU_STRING,menutabs[52] , 
                  MENU_NOTIFY_PROC, mgel1_3_ProfilBand_help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
                  */
               MENU_ITEM, MENU_STRING, gel1tabs[0],  
                   MENU_VALUE, 30,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               MENU_ITEM, MENU_STRING, gel3tabs[0],  
                   MENU_VALUE, 31,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               MENU_ITEM, MENU_STRING, gel3tabs[1],  
                   MENU_VALUE, 32,
		   MENU_NOTIFY_PROC, proc_gel1d, 0,
               0, 0);

    mgel1_4 = menu_create(
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
                  /* Here ??? 1991 ????
		  MENU_ITEM, MENU_STRING,menutabs[0] , 
                  MENU_NOTIFY_PROC, mgel1_4_EvalPic_help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
                  */
               MENU_ITEM, MENU_STRING, gel4tabs[0],  
                   MENU_VALUE, 1,
		   MENU_NOTIFY_PROC, proc_find_max_gel, 0,
               MENU_ITEM, MENU_STRING, gel4tabs[1],   
                   MENU_VALUE, 2,
		   MENU_NOTIFY_PROC, proc_find_max_gel, 0,
               MENU_ITEM, MENU_STRING, gel4tabs[2],   
                   MENU_VALUE, 3,
		   MENU_NOTIFY_PROC, proc_find_max_gel, 0,
               MENU_ITEM, MENU_STRING, gel4tabs[3],   
                   MENU_VALUE, 4,
		   MENU_NOTIFY_PROC, proc_find_max_gel, 0,
               MENU_ITEM, MENU_STRING, gel4tabs[4],   
                   MENU_VALUE, 5,
		   MENU_NOTIFY_PROC, proc_find_max_gel, 0,
               MENU_ITEM, MENU_STRING, gel4tabs[5],   
                   MENU_VALUE, 6,
		   MENU_NOTIFY_PROC, proc_find_max_gel, 0,
               MENU_ITEM, MENU_STRING, gel4tabs[6],   
                   MENU_VALUE, 7,
		   MENU_NOTIFY_PROC, proc_find_max_gel, 0,
               0, 0);

    mgel1dtool = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
		  MENU_ITEM, MENU_STRING, geltooltabs[0], 
		    MENU_VALUE, 40,
		    MENU_NOTIFY_PROC, proc_gel1d, 0,
		  MENU_ITEM, MENU_STRING, geltooltabs[1],  
		    MENU_VALUE, 41,
		    MENU_NOTIFY_PROC, proc_gel1d, 0,
                  MENU_PULLRIGHT_ITEM, geltooltabs[2],  mgel1_1,
                  MENU_PULLRIGHT_ITEM, geltooltabs[3], mgel1_2,
                  MENU_PULLRIGHT_ITEM, geltooltabs[4],  mgel1_3,
		  MENU_ITEM, MENU_STRING, geltooltabs[5],  
		    MENU_VALUE, 42,
		    MENU_NOTIFY_PROC, proc_gel1d, 0,
                  MENU_PULLRIGHT_ITEM, geltooltabs[6],  mgel1_4,
		  MENU_ITEM, MENU_STRING, geltooltabs[7],  
		    MENU_NOTIFY_PROC, read_gel1d_proc, 0,
		  MENU_ITEM, MENU_STRING, geltooltabs[8],  
		    MENU_NOTIFY_PROC, write_gel1d_proc, 0,
                  MENU_ACTION_ITEM, geltooltabs[9], proc_sortie_gel1d,
                  0);

         m_i_o  = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc, 
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM, MENU_STRING,menutabs[0] , 
                  MENU_NOTIFY_PROC, io_help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
                  MENU_PULLRIGHT_ITEM, e_stabs[0], mentree,
                  MENU_PULLRIGHT_ITEM, e_stabs[1], msauve,
                  MENU_PULLRIGHT_ITEM, e_stabs[2], mlaser,
                  0);

 
        mdisplay = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM, MENU_STRING,menutabs[1], 
                  MENU_NOTIFY_PROC, display_help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0, 
                  MENU_PULLRIGHT_ITEM, disptabs[0], maff,
		  MENU_ITEM, MENU_STRING, disptabs[1], 
		    MENU_NOTIFY_PROC, proc_threshold,
		    MENU_VALUE, 0, 0,
                  MENU_PULLRIGHT_ITEM, disptabs[3], mcache,
		  MENU_ACTION_ITEM, disptabs[2], init_main_map_frame,
                      0);



    mpretraite  = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM, MENU_STRING, menutabs[2],
                  MENU_NOTIFY_PROC, preprocess_help_proc, MENU_INVERT, TRUE, 
                       MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
                  MENU_ACTION_ITEM, rehausstabs[0] , proc_egal_histo,
                  MENU_PULLRIGHT_ITEM, traitetabs[4], mrehauss,
		  MENU_ACTION_ITEM, traitetabs[0], proc_linear_filter,
                  0);



       mtraite  = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM, MENU_STRING, menutabs[3],
                  MENU_NOTIFY_PROC, process_help_proc, MENU_INVERT, TRUE,  
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
		  MENU_ITEM, MENU_STRING, traitetabs[9],
		    MENU_NOTIFY_PROC, proc_threshold,
		    MENU_VALUE, 1, 0,
		  MENU_PULLRIGHT_ITEM, traitetabs[1], mthresh,
                  MENU_PULLRIGHT_ITEM, traitetabs[2], mtransf,
                  MENU_PULLRIGHT_ITEM, traitetabs[3], mconvcorrel,
                  MENU_PULLRIGHT_ITEM, traitetabs[5], mcontours,
		  MENU_PULLRIGHT_ITEM, traitetabs[6], mseg,
                  MENU_ACTION_ITEM, traitetabs[7], proc_entree_morphbin,
		  MENU_PULLRIGHT_ITEM, traitetabs[8], mmorphniv,
                  0);


      mmesures  = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM, MENU_STRING, menutabs[4], 
                  MENU_NOTIFY_PROC, measures_help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
		  MENU_PULLRIGHT_ITEM, mesuretabs[0], mhisto,
	          MENU_ACTION_ITEM, mesuretabs[1], proc_calc_stat,
		  MENU_PULLRIGHT_ITEM, auxtabs[5], mcolors_r_all,
	          MENU_PULLRIGHT_ITEM, mesuretabs[2], mpuissance,
                  0);



           maux = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
                  MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
		  MENU_ITEM, MENU_STRING, menutabs[5], 
                  MENU_NOTIFY_PROC, aux_help_proc, MENU_INVERT, TRUE, 
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0, 
                  MENU_PULLRIGHT_ITEM, auxtabs[0], mconvert,
                  MENU_PULLRIGHT_ITEM, auxtabs[1], moparithm,
	          MENU_PULLRIGHT_ITEM, auxtabs[2], mraster,
		  MENU_PULLRIGHT_ITEM, auxtabs[3], mgeom,
		  MENU_PULLRIGHT_ITEM, auxtabs[6], mmodif,
		  MENU_PULLRIGHT_ITEM, auxtabs[7], mimagetest,
		  MENU_ITEM, MENU_STRING, "desctool",
		     MENU_NOTIFY_PROC, proc_desctool, 0,
	          MENU_PULLRIGHT_ITEM,  basetabs[2], mlibere,
                  MENU_ACTION_ITEM,  basetabs[3], proc_copie, 
                  0);


/* MENU_GEN_PROC, wait_curseur_proc, */
         mtools = menu_create
                 (MENU_DEFAULT, 2,
                  MENU_INITIAL_SELECTION_EXPANDED, FALSE,
                  MENU_ITEM, MENU_STRING, menutabs[6],
                  MENU_NOTIFY_PROC, tools_help_proc, MENU_INVERT, TRUE,  
                      MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0, 
                  MENU_ACTION_ITEM, tooltabs[0], proc_pixedit,

		  MENU_PULLRIGHT_ITEM, tooltabs[1], mexpt, 

                  MENU_ACTION_ITEM, tooltabs[2], proc_entree_gel1d,
                  0);


/*    mprincipal = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
		  MENU_ITEM, MENU_STRING, "Menu principal",
                  MENU_FEEDBACK, FALSE, MENU_INVERT, TRUE, 0,
                  MENU_PULLRIGHT_ITEM, "Pre-Traitement", mpretraite,
                  MENU_PULLRIGHT_ITEM, "Traitement", mtraite,
                  MENU_PULLRIGHT_ITEM, "Display", mdisplay,
                  MENU_PULLRIGHT_ITEM, "Auxiliares", maux,
                  MENU_PULLRIGHT_ITEM, "Tools", mtools,
                  0);

*/

    mcreerzone = menu_create
		 (MENU_ITEM, MENU_STRING, creezonetabs[0], MENU_VALUE, 20, 0,
		  MENU_ITEM, MENU_STRING, creezonetabs[1], MENU_VALUE, 21, 0,
		  0, 0);

    mafficher  = menu_create
		 (MENU_ITEM, MENU_STRING, affichimtabs[0], MENU_VALUE, 80, 0,
		  MENU_ITEM, MENU_STRING, affichimtabs[1], MENU_VALUE, 81, 0,
		  MENU_ITEM, MENU_STRING, affichimtabs[2], MENU_VALUE, 82, 0,
		  MENU_ITEM, MENU_STRING, affichimtabs[3], MENU_VALUE, 83, 0,
		  MENU_ITEM, MENU_STRING, affichimtabs[4], MENU_VALUE, 84, 0,
		  0, 0);

    mstatzone  = menu_create
		 (MENU_ITEM, MENU_STRING, affichimtabs[3], MENU_VALUE, 60, 0,
		  MENU_ITEM, MENU_STRING, affichimtabs[4], MENU_VALUE, 61, 0,
		  0, 0);

    msauver  = menu_create
		 (MENU_ITEM, MENU_STRING, affichimtabs[1], MENU_VALUE, 50, 0,
		  MENU_ITEM, MENU_STRING, "image", MENU_VALUE, 51, 0,
		  0, 0);

    mhisto  = menu_create
		 (MENU_ITEM, MENU_STRING, histoimtabs[0], MENU_VALUE, 71, 0,
		  MENU_ITEM, MENU_STRING, histoimtabs[1], MENU_VALUE, 72, 0,
		  MENU_ITEM, MENU_STRING, histoimtabs[2], MENU_VALUE, 73, 0,
		  0, 0);

    mcoord  = menu_create
		 (MENU_ITEM, MENU_STRING, coordimtabs[0], MENU_VALUE, 91, 0,
		  MENU_ITEM, MENU_STRING, coordimtabs[1], MENU_VALUE, 92, 0,
		  MENU_ITEM, MENU_STRING, coordimtabs[2], MENU_VALUE, 93, 0,
		  0, 0);

    mcurs  = menu_create
		 (MENU_ITEM,MENU_STRING,cursimtabs[0], MENU_VALUE, 31, 0,
		  MENU_ITEM,MENU_STRING,cursimtabs[1], MENU_VALUE, 32, 0,
		  MENU_ITEM,MENU_STRING,cursimtabs[2], MENU_VALUE, 33,0,
		  MENU_ITEM,MENU_STRING,cursimtabs[3], MENU_VALUE, 34, 0,
		  0, 0);

    mprofil  = menu_create
		 (MENU_ITEM,MENU_STRING, profiltabs[0], MENU_VALUE, 128, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[1], MENU_VALUE, 129, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[2], MENU_VALUE, 130, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[3],
				    MENU_VALUE, 131, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[4],
				    MENU_VALUE, 132, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[5],
				    MENU_VALUE, 133, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[6],
				    MENU_VALUE, 134, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[7],
				    MENU_VALUE, 135, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[8],
				    MENU_VALUE, 136, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[9],
				    MENU_VALUE, 137, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[10],
				    MENU_VALUE, 138, 0,
		  MENU_ITEM,MENU_STRING, profiltabs[11],
				    MENU_VALUE, 139, 0,
		  0, 0);

    mimage = menu_create
                 (MENU_GEN_PROC, wait_curseur_proc,
		  MENU_ITEM, MENU_STRING, imagetabs[0], MENU_VALUE, 1, 0,
		  MENU_PULLRIGHT_ITEM, imagetabs[1], mcreerzone,
		  MENU_PULLRIGHT_ITEM, imagetabs[2], mafficher,
		  MENU_PULLRIGHT_ITEM, imagetabs[3], mstatzone,
		  MENU_ITEM, MENU_STRING, imagetabs[4], MENU_VALUE, 4, 0,
		  MENU_PULLRIGHT_ITEM, imagetabs[5], msauver,
		  MENU_PULLRIGHT_ITEM, imagetabs[6], mcoord,
		  MENU_PULLRIGHT_ITEM, imagetabs[7], mcurs,
		  MENU_PULLRIGHT_ITEM, imagetabs[8], mhisto,
		  MENU_PULLRIGHT_ITEM, imagetabs[9], mprofil, 
		  0);

    c_courant = cursor_create (CURSOR_IMAGE, &courant_pr, 0);
    c_wait = cursor_create (CURSOR_IMAGE, &wait_pr, 0);
    c_mire = cursor_create (CURSOR_IMAGE, &cursor_image_mire,
				 CURSOR_SHOW_CROSSHAIRS, TRUE,
				 CURSOR_OP, PIX_SRC ^ PIX_DST,
				 CURSOR_XHOT, 7, CURSOR_YHOT, 7,
				 CURSOR_CROSSHAIR_GAP, 21,
				 CURSOR_CROSSHAIR_OP, PIX_SRC ^ PIX_DST,
				 CURSOR_CROSSHAIR_LENGTH, 100,
			    0);
}
