; uomfuncs.l 	Copyright 1983, University of Maryland, College Park
;
; This file contains the following functions:
;       plus        difference  add1        lessp    greaterp  hostname
;       concat      concatstr   de-compose  dtpr     getchar   lconc   
;       mklist      mkprogn     ncons       onep     putprop 
;       removelast  rplacad     tconc       yesp     divide-at-key


;arithmetics functions
(defvar COMM)
(defvar $$FORKEYWORDS$$ '(do collect join sum count always initially finally
                          while until when unless let bind never thereis last
	  		  tcollect tjoin from fromd quit being eachtime))

(setf (symbol-function 'plus) (symbol-function '+))
(setf (symbol-function 'difference) (symbol-function '-))
(setf (symbol-function 'add1) (symbol-function '1+))
(setf (symbol-function 'lessp) (symbol-function '<))
(setf (symbol-function 'greaterp) (symbol-function '>))
(setf (symbol-function 'memq) (symbol-function 'member))
(proclaim '(ftype (function (&rest number) number) 
                   plus + difference - < > <= >= lessp greaterp))
(proclaim '(ftype (function (number) number) add1 1+))

;useful functions
(defun pwd() (excl:current-directory))
(defun cd (dir) (excl:chdir dir))
(defun environment-variable (var) (system:getenv var))
(defun hostname()
  (read (excl:run-shell-command "hostname" :wait nil  :output :stream)))
(defun call-line-command()
  (let (fichier)
   (and (> (length (system:command-line-arguments)) 1)
        (setq fichier (system:command-line-argument 1))
        (load fichier))))

;concatenate strings, number and symbols
(defun concatstr(l)
  (let ((farg (cond ((stringp (car l)) (car l))
                    (t                 (write-to-string (car l))))))
   (cond ((null (cdr l)) farg)
         (t (concatenate 'string 
                         farg
                         (concatstr (cdr l)))))))

; concatenates lists, numbers, strings and symbols
(defun concat(&rest l)
  (let (res)
   (declare (dynamic-extent l))
   (cond ((typep (car l) 'list) (apply 'concatenate `(list ,@l)))
         (t (setq res (concatstr l))
            (or (find-symbol res 'user)
                (intern res 'user))))))

;----de-compose
;		form - pattern to de-compose
;		sofar - the sequence of cxxr's needed to get to this part
;			of the pattern
;  de-compose returns a list of this form
;
;	((cxxr . a) (cyyr . b) ... )
; which tells how to get to the value for a and b ..etc..
;
(defun de-compose (form sofar)
	  (cond ((null form ) nil)
		((atom form) (ncons (cons (apply 'concat (cons 'c sofar))
					  form)))
		(t (nconc (de-compose (car form) (cons 'a sofar))
			  (de-compose (cdr form) (cons 'd sofar))))))


;returns t if the object is a list different to ()
(defun dtpr(obj)
   (and obj (listp obj)))

;takes the character number n (count from 0) of the string  or symbol x
(defun getchar(x n)
   (let ((str x))
      (declare (type string str))
      (and (symbolp x) (setq str (write-to-string x)))
      (and (<= n (length str))
           (char str (- n 1)))))

;lconc
(defun lconc (ptr x)
      (prog (xx)
            (return
             (cond ((atom x) ptr)
                   (t (setq xx (last x))
                      (cond ((atom ptr) (cons x xx))
                            ((dtpr (cdr ptr))
                             (rplacd (cdr ptr) x)
                             (rplacd ptr xx))
                            (t (rplaca (rplacd ptr xx) x))))))))


;mklist
(defun mklist (obj)
  (cond ((dtpr obj) obj)
	(t (list obj))))

; if lst has length 1 then return the car, otherwise stick a progn on the front
(proclaim '(ftype (function (cons) cons) mkprogn))
(defun mkprogn (lst)
   (declare (type cons lst))
   (cond ((null (cdr lst)) (car lst))
         (t (cons 'progn lst))))


;returns a list who contains x
(defun ncons(x)
  (cons x nil))


;ask if x is equal to 1
(defun onep(x)
   (equal x 1))

;put a property in a property list
(defun putprop(nom prop elem)
    (declare (type atom nom)
             (type atom elem))
    (setf (get nom elem) prop))


;returns copy of lst with the last element removed.
(setf (symbol-function 'removelast) (symbol-function 'butlast))
(proclaim '(ftype (function (list) list) removelast butlast))

; rplacad does a rplaca and rplacd on the given cons cell (returns the cell)
(defun rplacad (cell new-car new-cdr)
  (declare (type cons cell))
  (rplaca cell new-car)
  (rplacd cell new-cdr))

;tconc
(defun tconc (p x)
      (cond ((atom p) (cons (setq x (ncons x)) x))
            ((dtpr (cdr p)) (rplacd p (cdr (rplacd (cdr p) (ncons x)))))
            (t (rplaca p (cdr (rplacd p (ncons x)))))))


; The yesp function, used by query
(defun yesp (x)
  (and (or (symbolp x) (stringp x))
       (setq x (getchar x 1))
       (or (eq x #\y) (eq x #\Y))))


; search down lst for the optional keywords "to" and "by" which are part of the
; "from" syntax - return a list of the var-name, to-arg, and by-arg

(defun scan-from (lst)
  (declare (type list lst))
  (let ((from-arg (car lst)) 
	to-arg (by-arg 1))
   (setq lst (cdr lst))
   (cond ((eq (car lst) 'to)
	  (setq to-arg (cadr lst))
	  (setq lst (cddr lst))
          (and (eq (car lst) 'by)
	       (setq by-arg (cadr lst))
	       (setq lst (cddr lst))))
	 ((eq (car lst) 'by)
	  (setq by-arg (cadr lst))
	  (setq lst (cddr lst))
          (and (eq (car lst) 'to)
	       (setq to-arg (cadr lst))
	       (setq lst (cddr lst)))))
   `(,from-arg ,to-arg ,by-arg ,@lst)))


; Return a copy of the front of lst up until first occurrence of
; a keyword or a "x in l" phrase.  Has the side effect of setting
; the hung variable COMM to the rest of lst.

(defun divide-at-key (lst)
  (declare  (type list lst))
   (cond ((or (null lst)(member (car lst) $$FORKEYWORDS$$))
            (setq COMM lst) 
            nil)
         ((member (cadr lst) '(in on))
            (setq COMM (cons (cadr lst) (cons (car lst) (cddr lst))))
            nil)
	 ((member (cadr lst) '(from fromd))
	    (setq COMM `(,(cadr lst) ,(car lst) ,@(scan-from (cddr lst))))
	    nil)
         (t (cons (car lst) (divide-at-key (cdr lst))))))


(defun on-hdlr (var lst)
   `(,var ,lst (cdr ,var)))

; JRB@UOM handles destructuring of in clauses.  Destructuring is actually
; done by function de-compose.
(defun in-hdlr (varstruc lst-name lst)
  (let ((dslist (de-compose varstruc '(ar))))
       `((,(cdar dslist) (and (setq ,lst-name ,lst)
			      (,(caar dslist) ,lst-name))
			 (and (setq ,lst-name (cdr ,lst-name))
			      (,(caar dslist) ,lst-name)))
	 ,@(mapcar #'(lambda (pair)
			     `(,(cdr pair) (,(car pair) ,lst-name)
					   (,(car pair) ,lst-name)))
		   (cdr dslist)))))


