/*****************************************************************************/
/* module transimp.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

#define A 01
#define B 02
#define C 04
#define D 010
#define ABCD 017
#define ABCD_VOIS 037777

#define A_VOISINS 0366
#define B_VOISINS 01435
#define C_VOISINS 06213
#define D_VOISINS 034406

extern unsigned short **liste_point;

long b_erosion(nl,nc,image)
/* erosion binaire de taille 1 */
int nl,nc;
short **image;
{
  unsigned short **liste;
  unsigned short *c_liste;
  int i;
  register int j;
  register short *point;
  short pt,**ima;
  long n = 0;                  /* nombre de points qui changent */
    
  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            pt = *point;

            if(((pt & ABCD) != 0) && ((pt & ABCD_VOIS) != ABCD_VOIS))
                 /* exclu le cas A=B=C=D=0 et A=B=C=D=voisins=1 */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if(((pt & A) == A) && ((pt & A_VOISINS) != A_VOISINS)) /* A=1 + voisinage */ 
                   {
                       *point -= A;  /* A -> 0 */
                       *c_liste += A;
		   }
                 if(((pt & B) == B) && ((pt & B_VOISINS) != B_VOISINS)) /* B=1 + voisinage */
                   {
                       *point -= B;  /* B -> 0 */
                       *c_liste += B;
	           }
                 if(((pt & C) == C) && ((pt & C_VOISINS) != C_VOISINS)) /* C=1 + voisinage */
                   {
                       *point -= C;  /* C -> 0 */
                       *c_liste += C;
		   }
                 if(((pt & D) == D) && ((pt & D_VOISINS) != D_VOISINS)) /* D=1 + voisinage */
                   {
                       *point -= D; /* D -> 0 */
                       *c_liste += D;
                   }
                 if((*c_liste & ABCD) != 0 )
                   {
                      c_liste++;
                      n++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
   {
       x0_voisins(nl,ima,liste_point); /* mise a jour des voisins dans ima */
   }
return(n);
} /* b_erosion */
 


/****************************************************************/

long b_dilatation(nl,nc,image)
/* dilatation binaire de taille 1 */
int nl,nc;
short **image;
{
  unsigned short **liste;
  unsigned short *c_liste;
  int i;
  register int j;
  register short *point;
  short pt,**ima;
  long n = 0;
    
  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            pt = *point;
            if((( pt & ABCD) != ABCD) && (( pt & ABCD_VOIS) != 0))
                 /* exclu le cas A=B=C=D=1 et A=B=C=D=voisins=0 */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if(((pt & A) == 0) && ((pt & A_VOISINS) != 0))    /*  A=0 + voisinage */ 
                   {
		       *point += A;  /* A -> 1 */
                       *c_liste += A;
		   }
                 if(((pt & B) == 0) && ((pt & B_VOISINS) != 0)) /* B=0 */
                   {
                       *point += B;  /* B -> 1 */
                       *c_liste += B;
	           }
                 if(((pt & C) == 0) && ((pt & C_VOISINS) != 0)) /* C=0 */
                   {
                       *point += C;  /* C -> 1 */
                       *c_liste += C;
		   }
                 if(((pt & D) == 0) && ((pt & D_VOISINS) != 0))   /* D=0 */
                   {
                       *point += D; /* D -> 1 */
                       *c_liste += D;
                   }
                 if((*c_liste & ABCD) != 0 )
                   {
                      c_liste++;
                      n++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
  {
     x1_voisins(nl,ima,liste_point);
  }
return(n);
} /* b_dilatation */

/**************************************************************/

/* dilatation conditionnelle binaire de taille 1 */

long b_condilat(nl,nc,image,ima_condi)                                                                                   
int nl,nc;
short **image,**ima_condi;
{
  unsigned short **liste;
  register unsigned short *c_liste;
  int i;
  register int j;
  register short *point,*point_condi;
  short pt,pt_condi,**ima;
  long n = 0;
    
  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  ima_condi++;
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      point_condi = *ima_condi++;
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            point_condi++;
            pt = *point;
            pt_condi = *point_condi;
            if((( pt & ABCD) != ABCD) && (( pt & ABCD_VOIS) != 0))
                 /* exclu le cas A=B=C=D=1 et A=B=C=D=voisins=0 */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if(((pt_condi & A) == A) && ((pt & A) == 0) && ((pt & A_VOISINS) != 0))    /* A2=1 A=0 + voisinage */ 
                   {   
		       *point += A;  /* A -> 1 */
                       *c_liste += A;
		   }
                 if(((pt_condi & B) == B) && ((pt & B) == 0) && ((pt & B_VOISINS) != 0))    /* B2=1  B=0 + voisinage */
                   {
                       *point += B;  /* B -> 1 */
                       *c_liste += B;
	           }
                 if(((pt_condi & C) == C) && ((pt & C) == 0) && ((pt & C_VOISINS) != 0))    /* C2=1  C=0 + voisinage */
                   {
                       *point += C;  /* C -> 1 */
                       *c_liste += C;
		   }
                 if(((pt_condi & D) == D) && ((pt & D) == 0) && ((pt & D_VOISINS) != 0))    /* D2=1  D=0 + voisinage */
                   {
                       *point += D; /* D -> 1 */
                       *c_liste += D;
                   }
                 if((*c_liste & ABCD) != 0 )   /* le point change */
                   {
                      c_liste++;
                      n++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
  {
      x1_voisins(nl,ima,liste_point);
  }
return(n);
} /* b_condilat */


/**************************************************************/

/* erosion conditionnelle binaire de taille 1 */

long b_conderos(nl,nc,image,ima_condi)
int nl,nc;
short **image,**ima_condi;
{
  unsigned short **liste;
  register unsigned short *c_liste;
  int i;
  register int j;
  register short *point,*point_condi;
  short pt,pt_condi,**ima;
  long n = 0;
    
  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  ima_condi++;
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      point_condi = *ima_condi++;
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            point_condi++;
            pt = *point;
            pt_condi = *point_condi;
            if((( pt & ABCD) != 0) && (( pt & ABCD_VOIS) != ABCD_VOIS))
                 /* exclu le cas A=B=C=D=0 et A=B=C=D=voisins=1 */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if(((pt_condi & A) == 0) && ((pt & A) == A) && ((pt & A_VOISINS) != A_VOISINS))    /* A2=0 A=1 + voisinage */ 
                   {   
		       *point -= A;  /* A -> 0 */
                       *c_liste += A;
		   }
                 if(((pt_condi & B) == 0) && ((pt & B) == B) && ((pt & B_VOISINS) != B_VOISINS)) /* B2=0  B=1 */
                   {
                       *point -= B;  /* B -> 0 */
                       *c_liste += B;
	           }
                 if(((pt_condi & C) == 0) && ((pt & C) == C) && ((pt & C_VOISINS) != C_VOISINS)) /* C2=0  C=1 */
                   {
                       *point -= C;  /* C -> 0 */
                       *c_liste += C;
		   }
                 if(((pt_condi & D) == 0) && ((pt & D) == D) && ((pt & D_VOISINS) != D_VOISINS))   /* D2=0  D=1 */
                   {
                       *point -= D; /* D -> 0 */
                       *c_liste += D;
                   }
                 if((*c_liste & ABCD) != 0 )   /* le point change */
                   {
                      c_liste++;
                      n++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
   {
      x0_voisins(nl,ima,liste_point);
   }
return(n);
} /* b_conderos */


/************************************************************************/

