/*
  File: rle2wff.c
  Authors: James Painter,
           K.R. Sloan
  Last Modified: 6 September 1990
  Purpose:  Convert a RLE file to WFF format
 */

#include <stdio.h>
#include "rle.h"
#include "wff.h"

typedef FILE	*FILPTR;

static char *RoutineName;

usage()
 {
  fprintf( stderr, "\
usage: %s < rlefile > wfffile \n\
\n\
Where:    rlefile  : Name of input file  (RLE format)\n\
          wfffile  : Name of output file (WFF format)\n\
\n\
", RoutineName );
 }

/*
 * usage : rletowff  < rlefile > wfffile
 *
 *	rlefile			File to convert
 *      ifffile                 Result
 */

int main(argc, argv)
 int  argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int aflag = 1;		/* Alpha channel flag. */
  int scans;			/* Number of scan lines. */
  rle_pixel **inprow;		/* Input buffer. */
  int i, row, width;
  int Left,Right,Top,Bottom;
  int y, nchans;
  FrameBufferType *FrameBuffer = NULL;
  char WhatBands[ValueLength], Name[NameLength], Value[ValueLength];
  short Pixel[10240], *p;
  int BitsPerBand, x;
  
  RoutineName = argv[ArgsParsed++];
  if (argc != ArgsParsed) { usage(); exit(1); }
  
  /* Read header information. */
  
  rle_dflt_hdr.rle_file = stdin;
  rle_get_setup( &rle_dflt_hdr );
  if (! rle_dflt_hdr.alpha)  aflag = 0;
  
  scans = rle_dflt_hdr.ymax - rle_dflt_hdr.ymin + 1;
  
  /* Allocate input buffer. */
  
  if (rle_row_alloc( &rle_dflt_hdr, &inprow ))
   {
    fprintf(stderr, "%s: Out of memory.\n", RoutineName);
    exit(-2);
   }
  
  Right = rle_dflt_hdr.xmax;
  Left  = rle_dflt_hdr.xmin;
  Top   = rle_dflt_hdr.ymax;
  Bottom = rle_dflt_hdr.ymin;
  
  /* Set up the WFF file */
  width = (Right-Left+1);
  nchans = rle_dflt_hdr.ncolors + aflag;
  
  switch (nchans) 
   {
    case 1: strcpy( WhatBands, "I" );     break;
    case 2: strcpy( WhatBands, "IA" );    break;
    case 3: strcpy( WhatBands, "RGB" );   break;
    case 4: strcpy( WhatBands, "RGBA" );  break;
   }
  
  /* Open the WFF file */
  OpenFB(&FrameBuffer);
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  BitsPerBand = 8;
  SetColorSystem(FrameBuffer, WhatBands, BitsPerBand);
  
  (void) strcpy(Name,"X-CreatedBy"); (void) strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);
  
  (void) strcpy(Name,"Encoding"); (void) strcpy(Value,"AIS");
  SetDescriptor(FrameBuffer, Name, Value);
  
  PassImageOut(stdout, FrameBuffer);
  
  /* Read .rle file, output a .wff file */
  
  for (row=0; (row<scans); row++)
   {
    y = rle_getrow( &rle_dflt_hdr, inprow );
    p = Pixel; 
    for(x=0; x<width; x++) 
     {
      for(i=0; i<nchans-aflag; i++)  *p++ = inprow[i][x];
      if (aflag) *p++ = inprow[-1][x];
     }
    (void) NextNPixelsOut(FrameBuffer, width, Pixel);
   }
  (void) CloseFB(&FrameBuffer);
  exit(0);
}
