/*
  File: CMRL2wff.c
  Authors: M. Qian,
           K.R. Sloan  
  Last Modified: 20 October 1990
  Purpose: transfer the CMRL data file into image.wff 
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>
double atof();

static int VERBOSE = 0;
static char *RoutineName;

static void usage()
 {
  fprintf(stderr,"Usage is: \n\t%s [-v][-h]\n", RoutineName);
 } 

static void Pass(fdIn, fdOut)
 FILE *fdIn, *fdOut;
 { 
  int Size = 106;  /* hard coded */
  FrameBufferType *FrameBuffer;
  int Left, Bottom, Right, Top;
  int BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];
  int x,y;
  unsigned short Pixel[1];
  unsigned short MaxPixelValue;

  /* create a new image and establish image parameters */
  FrameBuffer = (FrameBufferType *)0;
  OpenFB(&FrameBuffer);

  Bottom = 0; Left = 0; Top = Size-1; Right = Top;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);

  strcpy(WhatBands,"I"); BitsPerBand = 12;
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"Title");  strcpy(Value,"CMRL Image");
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"X-CreatedBy");  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  PassImageOut(fdOut, FrameBuffer);

  MaxPixelValue = (1 << BitsPerBand) -1;
  for (y=Bottom; y<=Top; y++)
  {
   if (VERBOSE) fprintf(stderr,"y = %d\n",y);
   for (x=Left; x<=Right; x++)
    {
     fread(Pixel, sizeof (unsigned short), 1, fdIn);
     if (MaxPixelValue < Pixel[0])
      fprintf(stderr,"%s: Pixel[%d,%d] = %d > %d!\n",
               RoutineName,x,y,Pixel[0],MaxPixelValue);
     NextPixelOut(FrameBuffer, Pixel);
    }
  }

  CloseFB(&FrameBuffer);
 } 

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;

  RoutineName = argv[ArgsParsed++];
  for(;ArgsParsed < argc;)
  {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit(-1); }
    switch (argv[ArgsParsed++][1])
    {
      case 'h': { usage(); exit(-1); }
    }
  } 

  Pass(stdin,stdout);

  exit(0);
 }
