/*
   File: Intensity.c
   Author: K.R. Sloan, James Painter
   Last Modified: 11 October 1990
   Purpose: Convert a wff file to an intensity image.
            If the input image is RGB or RGBA, then we compute intensity
            Otherwise, we simply take the first band.

            Feel free to extend to other types, as needed.
 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

static int VERBOSE;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }

static void
Pass(fdIn,fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin = 0, *FBout = 0;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  char WhatBands[ValueLength];
  int  BitsPerBand;
  int i, j, x,y,n, width;
  unsigned short *Pixel;
  extern char *malloc( /* unsigned */ );
  int passed = 0, RGB = 0;

  static double cr = .30, cg = .59, cb = .11;  /* Luminance coeffs */  
  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;
    if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

   /* Check for an RGB or RGBA image */
  GetColorSystem( FBin, WhatBands, &BitsPerBand );
  RGB = ((0 == strcmp(WhatBands,"RGB")) || (0 == strcmp(WhatBands,"RGBA")));

  strcpy(WhatBands, "I"); 

  /* Set the output color system */
  SetColorSystem( FBout, WhatBands, BitsPerBand );
  
  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right))
    { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  width = Right-Left+1;
  Pixel = (unsigned short *) 
    malloc ( (unsigned) (width * (FBin->BandsPerPixel) * sizeof(*Pixel) ) );
  if ((unsigned short *)0 == Pixel)
   {
    fprintf( stderr, "%s: No memory for Pixel!\n", RoutineName);
    (void)CloseFB(&FBin); (void)CloseFB(&FBout); return;
   }

  for (y=Bottom;y<=Top;y++)
   {
    if (FAILURE == NextNPixelsIn(FBin,width,Pixel))
     { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
    
    i=0; j=0;
    for (x=Left;x<=Right;x++,i++,j += FBin->BandsPerPixel)
     {
      if (RGB)
       Pixel[i] = (unsigned short)(  Pixel[j]*cr 
                                   + Pixel[j+1]*cg
                                   + Pixel[j+2]*cb
                                   + 0.5);
      else
       Pixel[i] = Pixel[j];
     }
     if (FAILURE == NextNPixelsOut(FBout,width,Pixel))
       { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
   }
  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);

 }

main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];
  while (argc < ArgsParsed)
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit (-1); }	
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      default:
      case 'h': { usage(); exit (-1); }	
     }
   }
  Pass(stdin,stdout);
  exit (0);
}

