/*
  File: IntRamp.c
  Author: K.R. Sloan,
  Last Modified: 19 January 1988
  Purpose: create a standard intensity ramp image
 */
#include <stdio.h>
#include <strings.h>
#include "wff.h"

static char *RoutineName;
static void 
usage()
 {
  fprintf(stderr,"Usage is:\n\t%s\n",RoutineName);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  FILE *FileDescriptor;
  FrameBufferType *FrameBuffer = NULL;
  int Left, Bottom, Top, Right, BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];
  int x,y;
  short Pixel[3];
  int BottomI = 0;
  int TopI = (1 << 16) -1;

  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc) { usage(); exit(-1); }

  OpenFB(&FrameBuffer);
  Bottom = 0; Left = 0; Top = 127; Right = 127;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  strcpy(WhatBands,"I"); BitsPerBand = 16;
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"Title");
  strcpy(Value,"Standard Intensity Ramp");
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  for(y=Bottom; y<=Top;y++)
   {
    Pixel[0] = BottomI
              +(double)(TopI-BottomI)*(double)(y-Bottom)/(double)(Top-Bottom);
    PutConstant(FrameBuffer,y,Left,y,Right,Pixel);
   }
  WriteImage(stdout, FrameBuffer);
  CloseFB(&FrameBuffer);

  exit(0);
 }
