/*
  File: ConvXY.c 
  Authors: K.R. Sloan
  Last Modified: 28 September 1990
  Purpose: Convolve with an arbitrary mxn kernel (plus DC),
 */

#include <stdio.h>
#include "wff.h"

double atof();

static int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr, "Usage is\n\t%s [-h][-v] -k KernelFileName\n",
              RoutineName);
 }

int main(argc, argv)
 int argc;
 char *argv[]; 
 {
  int ArgsParsed = 0;
  char *KernelFileName;
  FILE *KernelFile;
  int km, kn, k, i, j;
  int *Kernel, *Ki;
  int DC;
  double g;

  RoutineName = argv[ArgsParsed++];

  for ( ; (argc > ArgsParsed) ; )
   {
    if ('-' != argv[ArgsParsed][0]) { usage(); exit (-1); }
    switch (argv[ArgsParsed++][1])
     {
      case 'v': VERBOSE = -1; break;
      case 'k': if (ArgsParsed >= argc) { usage(); exit (-1); }
                KernelFileName = argv[ArgsParsed++]; 
                break;
      default:
      case 'h': usage(); exit(-1);  
     }
   }


  if ((char *)0 == KernelFileName) { usage(); exit (-1); }

  KernelFile = fopen(KernelFileName, "r");
  if ((FILE *)0 == KernelFile) 
   {
    fprintf(stderr,"%s: can not open Kernel file %s\n",
             RoutineName, KernelFileName);
    exit(1); 
   }

  if (2 != fscanf(KernelFile," %d %d",&km, &kn))
   {
    fprintf(stderr,"%s: Kernel file %s is bogus!\n",
             RoutineName, KernelFileName);
    exit(1); 
   }

  k = kn*km;

  Kernel = (int *)calloc(k, sizeof(int));
  if ((int *)0 == Kernel)
   {
    fprintf(stderr,"%s: can not allocate Kernel of size %d x %d = %d!\n",
             RoutineName,km,kn,k);
    exit(2); 
   }

  for (i=0, Ki = Kernel;i<k;i++)
   {
    if (1 != fscanf(KernelFile," %lg",&g))
     {
      fprintf(stderr,"%s: Kernel file %s is bogus!\n",
               RoutineName, KernelFileName);
      exit(1); 
     }
    *(Ki++) = 2048.0 * g;
   }
  if (1 != fscanf(KernelFile," %lg",&g))
   {
    fprintf(stderr,"%s: Kernel file %s is bogus!\n",
             RoutineName, KernelFileName);
    exit(1); 
   }
  DC = 2048.0 * g;


 if (VERBOSE)
  {
   fprintf(stderr,"Kernel is %d x %d\n",km,kn);
   Ki = Kernel;
   for (j=0;j<kn;j++)
    {
     for (i=0;i<km;i++,Ki++)
      fprintf(stderr," %8d",*Ki);
     fprintf(stderr,"\n");
    }
   fprintf(stderr," %8d\n",DC);
  }

 (void)wffConvXY(stdin,stdout,DC,Kernel,km,kn);

  exit (0);
 }
