/*
 File: PairingCards.h
 Author: K.R. Sloan
 Last Modified: 22 December 1992
 Purpose: definitions for the pairing cards internal representation
 */

typedef struct GameType
 {
  int Opponent;      /* index into PairingCards */
  char Result;       /* W,L,D,B,H */
  char Color;        /* W,B,?,U,bye */
 } GameType ;

typedef struct PlayerType 
 {
  int Ro;               /* pre-event Rating */
  int Previous;         /* number of games (-1 if established) */
  int Rn;               /* post-event Rating */
  int Rp;               /* Performance Rating */
  unsigned long int ID; /* USCF ID # */
  char Name[64];
  char Team[64];  
  GameType *Games;
 } PlayerType;

int PLAYERS;
int ROUNDS;
PlayerType *PairingCards; /* the hook */

