/*
   File: image.c
   Author: K.R. Sloan
   Last Modified: 6 July 1989
   Purpose: primitive image functions - based on the ATT Targa image format
 */

#include <stdio.h>
#include <string.h>
#include "image.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

/*------------------------------------------------------------*/
/*                                                            */
/*               Image File Interface Routines                */
/*                                                            */
/*------------------------------------------------------------*/

IMAGE *ImCreate(xResolution, yResolution)
 int xResolution, yResolution;
 {
  extern char *malloc();
  IMAGE *newImage;
  
  newImage = (IMAGE *) calloc(1,sizeof(IMAGE));
  if ((IMAGE *)0 == newImage)
   {
    fprintf(stderr,"ImCreate: can't allocate image structure\n");
    return(newImage);
   }

  /* Fill in the fields of the image descriptor. */
  newImage->xres = xResolution;
  newImage->yres = yResolution;
  newImage->im = (unsigned char *)calloc(xResolution * yResolution * 4,
                                         sizeof(unsigned char));

  if ((unsigned char *) 0 == newImage->im)
   {
    fprintf(stderr,"ImCreate: can't allocate image memory\n");
    (void) cfree(newImage);
    newImage = (IMAGE *)0;
    return(newImage);
   }
  return(newImage);
 }

void ImDestroy(image)
 IMAGE *image;
 {
  cfree(image->im);
  cfree(image);
 }

static void WriteTargaHeader(stream, xsize, ysize)
 FILE *stream;
 int xsize, ysize;
 {
  static unsigned char Header[18] = 
   { /* see the ATT manual, fool! */
    0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0
   };

  /* The xsize and ysize fields are the only ones needed */
  Header[12] = (unsigned char) (xsize & 0xff);
  Header[13] = (unsigned char) (xsize >> 8);
  Header[14] = (unsigned char) (ysize & 0xff);
  Header[15] = (unsigned char) (ysize >> 8);

  if (18 != fwrite(Header, 1, 18, stream))
   {
    fprintf(stderr, "WriteTargaHeader: Error writing header\n");
    exit(1); /* a bit presumptuous, but... */
   }
 }

void ImWrite(image, stream)
 IMAGE *image;
 FILE  *stream;
 {
  int i;
  int CharsPerScanline;

  WriteTargaHeader(stream, image->xres, image->yres);

  /* Write out a scan line at a time */

  CharsPerScanline = 4*(image->xres);
  for (i = 0; i<(image->yres); i++) 
   {
    if (   CharsPerScanline
        != fwrite((image->im)+(i*CharsPerScanline), 
                  1, CharsPerScanline, stream) )
     {
      fprintf(stderr,"ImWrite: error writing scanline %d\n", i);
      exit(1); /* a bit persumptious, but... */
     }
   }
  fflush(stream);  /* used to be fclose */
 }

void ImSetPixel(image, x, y, red, green, blue)
 IMAGE *image;
 int x, y;
 int red, green, blue;
 {
  unsigned char *p;

  p = (image->im) + (4 * (x + (y*(image->xres))));
  *p++ = blue;
  *p++ = green;
  *p++ = red;
  *p   = 0; 
 }

void ImGetPixel(image, x, y, red, green, blue)
 IMAGE *image;
 int x, y;
 int *red, *green, *blue;
 {
  unsigned char *p;

  p = (image->im) + (4 * (x + (y*(image->xres))));
  *blue  = *p++;
  *green = *p++;
  *red   = *p++;
 }
