/*
  File: 4D.h
  Author: K.R. Sloan, Jr.
  Last Modified: 23 May 1986
  Purpose: definitions for a 4D homogeneous coordinate manipulation package
 */

typedef struct P4D { double P[4]; } PointType4D;
typedef struct T4D { double T[4][4]; } TransformType4D;

extern void printT();                  /* printT(T)
                                           TransformType4D T; */
extern void printP();                  /* printP(P)
                                           PointType4D P; */
extern PointType4D PxT4D();            /* PxT4D(P, T)
                                           PointType4D P; TransformType4D T;*/
extern TransformType4D TxT4D();        /* TxT4D(A, B)
                                           TransformType4D A, B;            */
extern TransformType4D Identity4D();

extern TransformType4D Translate4D();  /* Translate4D(P)
                                           PointType4D P;                   */
extern TransformType4D Scale4D();      /* Scale4D(P)
                                           PointType4D P;                   */
extern TransformType4D Rotate4D();     /* Rotate4D(P0, P, Radians)
                                           PointType4D P0, P;
                                           double Radians;                  */
extern TransformType4D Perspective4D();/* Perspective4D(f)
                                           double f;                        */
