/*
  File: Scaling.c
  Authors: David Meyers,
           K. R. Sloan
  Purpose: Translation, Scaling, Rotation transforms for improving tiling.
  Last Modified: 26 May 1991

           This is code aimed at finding a transformation from one contour
	   into another, in order that the tiling between the two be done
	   more reasonably.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <TypeDefinitions.h>
#include <BitArray.h>
#include <Contours.h>
#include <TorGraph.h>
#include <Vector.h>
#include <InputStuff.h>

extern BitArray OptimalArea();

  /* WARNING...experimental code below.  We be hacking. */

void FindCentroid (TheContour, Cx, Cy, Cz)
 PointsType *TheContour;
 double *Cx, *Cy, *Cz;
{
 int i;

 *Cx = 0.0; *Cy = 0.0; *Cz = 0.0;
 for (i=0; i<TheContour->n; i++)
  {
   *Cx += TheContour->P[i].x;
   *Cy += TheContour->P[i].y;
   *Cz += TheContour->P[i].z;
  }
 *Cx /= TheContour->n;  *Cy /= TheContour->n;  *Cz /= TheContour->n;
}

void FindNormal(TheContour, Ndx, Ndy, Ndz, N)
 PointsType *TheContour;
 double *Ndx, *Ndy, *Ndz, *N;
{
 int i;
 double ThisX, ThisY, ThisZ, NextX, NextY, NextZ;
 
 *Ndx = 0.0; *Ndy = 0.0; *Ndz = 0.0;
 i = (TheContour->n) - 1;
 NextX = TheContour->P[i].x; 
 NextY = TheContour->P[i].y;
 NextZ = TheContour->P[i].z;
 for(i=0;i<TheContour->n;i++)
  {
   ThisX = NextX; ThisY = NextY; ThisZ = NextZ;
   NextX = TheContour->P[i].x; 
   NextY = TheContour->P[i].y;
   NextZ = TheContour->P[i].z;
   
   *Ndx += (NextY * ThisZ) - (ThisY * NextZ);
   *Ndy += (NextZ * ThisX) - (ThisZ * NextX);
   *Ndz += (NextX * ThisY) - (ThisX * NextY);
  }
 *N = sqrt(((*Ndx) * (*Ndx)) + ((*Ndy) * (*Ndy)) + ((*Ndz) * (*Ndz)));
 if ( ( *N < -0.0000000001) || (0.0000000001 < *N) ) 
  {
   *Ndx /= *N; *Ndy /= *N; *Ndz /= *N; *N = 1.00;
  }
 else *N = 0.00;
}

double FindAveRadius(TheContour, Cx, Cy, Cz)
 PointsType *TheContour;
 double Cx, Cy, Cz;
{
 int i;
 double dx, dy, dz, d;

 d = 0.0;
 for(i=0; i<TheContour->n; i++)
  {
    dx = TheContour->P[i].x - Cx;  
    dy = TheContour->P[i].y - Cy;  
    dz = TheContour->P[i].z - Cz;  
    d += sqrt((dx*dx)+(dy*dy)+(dz*dz));   
  }
 d /= TheContour->n;
 return(d);
}

extern BitArray FindTransform(Contour1, Contour2,
			      start1, start2,
			      Translate, Scale, Rotate)
 PointsType *Contour1, *Contour2;
 int *start1, *start2;
 int Translate, Scale, Rotate;
{
 double Cx1, Cy1, Cz1;
 double Cx2, Cy2, Cz2; 
 double Cx3, Cy3, Cz3; 
 double Ndx1, Ndy1, Ndz1, N1;
 double Ndx2, Ndy2, Ndz2, N2;
 double d1, d2, d; 
 double S2;
 int i;
 BitArray directions;
 int Debug = FALSE;

  /* cheap and dirty translation/scale fix */
  /* first, compute the centroids */
  FindCentroid(Contour1, &Cx1, &Cy1, &Cz1);
  FindCentroid(Contour2, &Cx2, &Cy2, &Cz2);

  /* and the normals */
  FindNormal(Contour1, &Ndx1, &Ndy1, &Ndz1, &N1);
  FindNormal(Contour2, &Ndx2, &Ndy2, &Ndz2, &N2);

  /* and the average distance from the Centroid */
  d1 = FindAveRadius(Contour1, Cx1, Cy1, Cz1);
  d2 = FindAveRadius(Contour2, Cx2, Cy2, Cz2);

  /* choose a good normal */
  if (0.00 == N1) 
   {
    /* N1 is no good, try N2 */
    if (0.00 == N2)
     {
      /* N2 is no good either! use C2-C1 */
      Ndx1 = Cx2-Cx1; Ndy1 = Cy2-Cy1; Ndz1 = Cz2-Cz1;
      N1 = sqrt((Ndx1*Ndx1) + (Ndy1*Ndy1) + (Ndz1*Ndz1));
      if ( ( N1 < -0.0000000001) || (0.0000000001 < N1) ) 
       {
        Ndx1 /= N1; Ndy1 /= N1; Ndz1 /= N1; N1 = 1.00;
       }
      else N1 = 0.00;   /* we are really losing here! good luck... */
     }
    else
     {
      /* N2 is OK, use it */
      Ndx1 = Ndx2; Ndy1 = Ndy2; Ndz1 = Ndz2; N1 = N2;
     }
   }

  /*
     Calculate a point C3 in the direction N1 from C1 
     project C2 onto N1, and then stretch it out. 
     Projecting is equivalent to skewing - it almost always does
     the right thing, but may cause problems.
     Separating the cross-sections avoids problems, and probably improves
     the triangulation
   */

  d = Ndx1*(Cx2-Cx1) + Ndy1*(Cy2-Cy1) + Ndz1*(Cz2-Cz1);
  d *= 5.0;
  Cx3 = Cx1 + Ndx1*d;  Cy3 = Cy1 + Ndy1*d;  Cz3 = Cz1 + Ndz1*d;

  /*
     scale Contour2 so that the average distance to the Centroid
     matches Contour1  ... or not

   */
  if (Scale && (0.0000000001 < d2)) S2 = d1/d2;
  else                              S2 = 1.0;

  if (S2 <0.0000000001) S2 = 1.0;  /* dodged a bullet */

  /* Translate Contour2 so that it's centroid is at C3  - or not...*/
  
  if (!Translate) { Cx3 = Cx2; Cy3 = Cy2; Cz3 = Cz2;}

  /*
     transform Contour2
       -translate C2 to origin
       -scale by S2
       -translate origin to C3
   */

  for (i=0; i<Contour2->n; i++)
   {
    Contour2->P[i].x = (Contour2->P[i].x-Cx2)*S2 + Cx3;
    Contour2->P[i].y = (Contour2->P[i].y-Cy2)*S2 + Cy3;
    Contour2->P[i].z = (Contour2->P[i].z-Cz2)*S2 + Cz3;
   }

  /* find the correspondences */
 if (Debug)
  { (void)fprintf(stderr,"calling Optimal Area\n"); (void) fflush(stderr);}
 *start1 = 0; *start2 = 0;
 directions = 
  OptimalArea(Contour1, Contour2, start1, start2);
 
 if (Debug)
  { (void)fprintf(stderr,"OptimalArea found\n"); (void) fflush(stderr);}
 return(directions);
}
