/*
  File: Vector.h
  Author: James Painter
  Last Modified: September 30, 1985
  Purpose: Include file for use with Vector.c.  Defines basic vector 
           operations.
*/
#ifndef VECTOR_DEFINED
#define VECTOR_DEFINED
#include <Contours.h>
#include <math.h>

#define cross(p1,p2,result) \
 {\
  (result)->x = (p1)->y*(p2)->z - (p2)->y*(p1)->z;\
  (result)->y = (p2)->x*(p1)->z - (p1)->x*(p2)->z;\
  (result)->z = (p1)->x*(p2)->y - (p2)->x*(p1)->y;\
 }

#define dot(p1,p2) \
   ((p1)->x*(p2)->x + (p1)->y*(p2)->y + (p1)->z*(p2)->z)

#define magn(p) \
   (sqrt(dot(p,p)))

#define minus(p1,p2,r) \
 {\
  (r)->x = (p1)->x - (p2)->x; \
  (r)->y = (p1)->y - (p2)->y; \
  (r)->z = (p1)->z - (p2)->z; \
 }

#define plus(p1,p2,r) \
 { \
  (r)->x = (p1)->x + (p2)->x; \
  (r)->y = (p1)->y + (p2)->y; \
  (r)->z = (p1)->z + (p2)->z; \
 }

#define normalize(r) \
 { \
  REAL __norm; \
  if ( (__norm=magn(r))!=0 ) \
   { \
    (r)->x /= __norm; \
    (r)->y /= __norm; \
    (r)->z /= __norm; \
   } \
 }

#endif VECTOR_DEFINED
