/*
  File: Aggregates.h
  Author: David Meyers
  Last Modified: 15 August 1990
  Purpose: Functions for handling aggregate contours
 */

extern int FindContour(/* InSection, ContourNamed, ContourIndex, UseAlias */);
/*
  Section *InSection;
  char *ContourNamed;
  int *ContourIndex;
  int UseAlias;
 */

extern PointsType *MakeAggregateContour(/* TheSection, TheDescriptor */);
/*
 Section *TheSection;
 ContourDescriptor *TheDescriptor;
 */

extern void DumpAggregateContour(/* TheSection,TheAggregate,TheDescriptor */);
/*
 Section *TheSection;
 PointsType *TheAggregate;
 ContourDescriptor *TheDescriptor;
 */

extern ContourDescriptor *MergeContours (/* TheSection,
					    ContourName,
					    Above,
					    Done,
					    TriangleNumber */);
/*
 Section *TheSection;
 char *ContourName;
 int Above;
 int Done;
 int *TriangleNumber;
 */

extern void BuildNameIndex(/* TheSection */);
/*
 Section *TheSection;
 */

extern void FreeDescriptor(/* TheDescriptor */);
/*
  ContourDescriptor *TheDescriptor;
 */

extern char *PointName(/* TheSection, Index, TheDescriptor */);
/*
  Section *TheSection;
  int Index;
  ContourDescriptor *TheDescriptor;
 */
