/*
  File: WingEdge.h
  Author: David Meyers
  Last Modified: 17 August 1990
  Purpose: Type definitions for the Winged Edge data structure.
 */

/*
  A picture of a winged edge record:

                OCCW                     DCW
                    \      Left         /
                     Org----------->Dest
                    /      Right        \
                 OCW                     DCCW
 */
typedef struct WENode {
  struct WEVNode *Org;      
  struct WEVNode *Dest;      
  struct WENode *OCCW;    /* CCW edge around the Org vertex */
  struct WENode *OCW;     /* CW edge around the Org vertex */
  struct WENode *DCCW;    /* CCW edge around the Dest vertex */
  struct WENode *DCW;     /* CW edge around the Dest vertex */
  struct WEFNode *Left;   /* edge ring header for the left face (Org-->Dest) */
  struct WEFNode *Right;  /* the edge ring header for the right face */
 } WingEdgeNode;

/* 
  A winged edge vertex node points to an edge of the ring of edges incident on
  the vertex. It also stores vertex related geometry data and other pertinent 
  information.
 */
typedef struct WEVNode {
  char PointName[80];   /* name of the point (to be used for writing a mesh) */
  int PolyIndex;        /* index in the list of polygon vertices */
  double x, y;          /* the coordinates of the point */
  struct WENode *Edges; /* pointer to canonical incident edge */
 } WEVertexNode;

typedef struct WEFNode {
  WingEdgeNode *Edges;      /* pointer to the head of the edge ring */
  struct WEVNode *Vertices; /* pointer to the vertex ring of the face */
  struct WEFNode *next;     /* pointer to the next face of the shell */
  struct WEFNode *prev;     /* pointer to the previous face */
 } WEFaceNode;
