/*
  File: XOut.c
  Author: David Meyers
  Last Modified: 20 August 1990
  Purpose: X11 window graphics primitives
 */

#include<stdio.h>
#include "framebuffer.h"


int FBminX, FBminY, FBmaxX, FBmaxY;
double FBScaleX, FBScaleY;
double WorldMinX, WorldMaxX, WorldMinY, WorldMaxY;

void SetupX11(WindowLeft, WindowBottom, WindowRight, WindowTop)
 double WindowLeft, WindowBottom, WindowRight, WindowTop;
{
 if(FB_SUCCESS != fb_open(&FBminX, &FBminY, &FBmaxX, &FBmaxY))
  {
   fprintf(stderr, "Unable to open frame buffer: %s\n", fb_error_message);
   exit(1);
  }
 FBScaleY = (double)(FBmaxY - FBminY) / (WindowTop - WindowBottom);
 FBScaleX = (double)(FBmaxX - FBminX) / (WindowRight - WindowLeft);
 WorldMinX = WindowLeft;
 WorldMinY = WindowBottom;
 WorldMaxX = WindowRight;
 WorldMaxY = WindowTop;
 fb_clear();
}

void ToDevice(WorldX, WorldY, DeviceX, DeviceY)
 double WorldX, WorldY;
 int *DeviceX, *DeviceY;
{
 *DeviceX = (int) ((WorldX - WorldMinX) * FBScaleX) + FBminX;
 *DeviceY = FBmaxY - (int) ((WorldY - WorldMinY) * FBScaleY);
}

extern void DrawLine(WorldX1, WorldY1, WorldX2, WorldY2)
 double WorldX1, WorldY1, WorldX2, WorldY2;
{
 int DevX1, DevY1, DevX2, DevY2;

 if((WorldX1 < WorldMaxX) && (WorldX1 > WorldMinX) &&
    (WorldX2 < WorldMaxX) && (WorldX2 > WorldMinX) &&
    (WorldY1 < WorldMaxY) && (WorldY1 > WorldMinY) &&
    (WorldY2 < WorldMaxY) && (WorldY2 > WorldMinY))
  ; /* trivial accept case */

 else if ( ((WorldX1 > WorldMaxX) && (WorldX2 > WorldMaxX)) ||
	   ((WorldX1 < WorldMinX) && (WorldX2 < WorldMinX)) ||
	   ((WorldY1 > WorldMaxY) && (WorldY2 > WorldMaxY)) ||
	   ((WorldY1 < WorldMinY) && (WorldY2 < WorldMinY)))
  ; /* trivial reject case */
 else
  {
   double ClipX, ClipY;

   if ((WorldX1 > WorldMaxX) || (WorldX2 > WorldMaxX))
    {
     if(WorldX1 > WorldX2)
      {
       ClipX = WorldMaxX;
       ClipY = ((WorldMaxX-WorldX2)/(WorldX1-WorldX2))*(WorldY1-WorldY2);
       ClipY = ClipY + WorldY2;
       WorldX1 = ClipX; WorldY1 = ClipY;
      }
     else
      {
       ClipX = WorldMaxX;
       ClipY = ((WorldMaxX-WorldX1)/(WorldX2-WorldX1))*(WorldY2-WorldY1);
       ClipY = ClipY + WorldY1;
       WorldX2 = ClipX; WorldY2 = ClipY;
      }
    }

   if ((WorldX1 < WorldMinX) || (WorldX2 < WorldMinX))
    {
     if(WorldX1 < WorldX2)
      {
       ClipX = WorldMinX;
       ClipY = ((WorldMinX-WorldX1)/(WorldX2-WorldX1))*(WorldY2-WorldY1);
       ClipY = ClipY + WorldY1;
       WorldX1 = ClipX; WorldY1 = ClipY;
      }
     else
      {
       ClipX = WorldMinX;
       ClipY = ((WorldMinX-WorldX2)/(WorldX1-WorldX2))*(WorldY1-WorldY2);
       ClipY = ClipY + WorldY2;
       WorldX2 = ClipX; WorldY2 = ClipY;
      }
    }

   if ((WorldY1 > WorldMaxY) || (WorldY2 > WorldMaxY))
    {
     if(WorldY1 > WorldY2)
      {
       ClipY = WorldMaxY;
       ClipX = ((WorldMaxY-WorldY2)/(WorldY1-WorldY2))*(WorldX1-WorldX2);
       ClipX = ClipX + WorldX2;
       WorldX1 = ClipX; WorldY1 = ClipY;
      }
     else
      {
       ClipY = WorldMaxY;
       ClipX = ((WorldMaxY-WorldY1)/(WorldY2-WorldY1))*(WorldX2-WorldX1);
       ClipX = ClipX + WorldX1;
       WorldX2 = ClipX; WorldY2 = ClipY;
      }
    }

   if ((WorldY1 < WorldMinY) || (WorldY2 < WorldMinY))
    {
     if(WorldY1 < WorldY2)
      {
       ClipY = WorldMinY;
       ClipX = ((WorldMinY-WorldY1)/(WorldY2-WorldY1))*(WorldX2-WorldX1);
       ClipX = ClipX + WorldX1;
       WorldX1 = ClipX; WorldY1 = ClipY;
      }
     else
      {
       ClipY = WorldMinY;
       ClipX = ((WorldMinY-WorldY2)/(WorldY1-WorldY2))*(WorldX1-WorldX2);
       ClipX = ClipX + WorldX2;
       WorldX2 = ClipX; WorldY2 = ClipY;
      }
    }
  }
 if((WorldX1 != WorldX2) || (WorldY1 != WorldY2))
  {
   ToDevice(WorldX1, WorldY1, &DevX1, &DevY1);
   ToDevice(WorldX2, WorldY2, &DevX2, &DevY2);
   fb_drawLine(DevX1, DevY1, DevX2, DevY2, BLACK);
  }
 else
  fprintf(stderr,"line not drawn: X1=%f, Y1=%f, X2=%f, Y2=%f\n",
	  WorldX1, WorldY1, WorldX2, WorldY2);
}

extern void EraseLine(WorldX1, WorldY1, WorldX2, WorldY2)
 double WorldX1, WorldY1, WorldX2, WorldY2;
{
 int DevX1, DevY1, DevX2, DevY2;

 if((WorldX1 < WorldMaxX) && (WorldX1 > WorldMinX) &&
    (WorldX2 < WorldMaxX) && (WorldX2 > WorldMinX) &&
    (WorldY1 < WorldMaxY) && (WorldY1 > WorldMinY) &&
    (WorldY2 < WorldMaxY) && (WorldY2 > WorldMinY))
  ; /* trivial accept case */

 else if ( ((WorldX1 > WorldMaxX) && (WorldX2 > WorldMaxX)) ||
	   ((WorldX1 < WorldMinX) && (WorldX2 < WorldMinX)) ||
	   ((WorldY1 > WorldMaxY) && (WorldY2 > WorldMaxY)) ||
	   ((WorldY1 < WorldMinY) && (WorldY2 < WorldMinY)))
  ; /* trivial reject case */
 else
  {
   double ClipX, ClipY;

   if ((WorldX1 > WorldMaxX) || (WorldX2 > WorldMaxX))
    {
     if(WorldX1 > WorldX2)
      {
       ClipX = WorldMaxX;
       ClipY = ((WorldMaxX-WorldX2)/(WorldX1-WorldX2))*(WorldY1-WorldY2);
       ClipY = ClipY + WorldY2;
       WorldX1 = ClipX; WorldY1 = ClipY;
      }
     else
      {
       ClipX = WorldMaxX;
       ClipY = ((WorldMaxX-WorldX1)/(WorldX2-WorldX1))*(WorldY2-WorldY1);
       ClipY = ClipY + WorldY1;
       WorldX2 = ClipX; WorldY2 = ClipY;
      }
    }

   if ((WorldX1 < WorldMinX) || (WorldX2 < WorldMinX))
    {
     if(WorldX1 < WorldX2)
      {
       ClipX = WorldMinX;
       ClipY = ((WorldMinX-WorldX1)/(WorldX2-WorldX1))*(WorldY2-WorldY1);
       ClipY = ClipY + WorldY1;
       WorldX1 = ClipX; WorldY1 = ClipY;
      }
     else
      {
       ClipX = WorldMinX;
       ClipY = ((WorldMinX-WorldX2)/(WorldX1-WorldX2))*(WorldY1-WorldY2);
       ClipY = ClipY + WorldY2;
       WorldX2 = ClipX; WorldY2 = ClipY;
      }
    }

   if ((WorldY1 > WorldMaxY) || (WorldY2 > WorldMaxY))
    {
     if(WorldY1 > WorldY2)
      {
       ClipY = WorldMaxY;
       ClipX = ((WorldMaxY-WorldY2)/(WorldY1-WorldY2))*(WorldX1-WorldX2);
       ClipX = ClipX + WorldX2;
       WorldX1 = ClipX; WorldY1 = ClipY;
      }
     else
      {
       ClipY = WorldMaxY;
       ClipX = ((WorldMaxY-WorldY1)/(WorldY2-WorldY1))*(WorldX2-WorldX1);
       ClipX = ClipX + WorldX1;
       WorldX2 = ClipX; WorldY2 = ClipY;
      }
    }

   if ((WorldY1 < WorldMinY) || (WorldY2 < WorldMinY))
    {
     if(WorldY1 < WorldY2)
      {
       ClipY = WorldMinY;
       ClipX = ((WorldMinY-WorldY1)/(WorldY2-WorldY1))*(WorldX2-WorldX1);
       ClipX = ClipX + WorldX1;
       WorldX1 = ClipX; WorldY1 = ClipY;
      }
     else
      {
       ClipY = WorldMinY;
       ClipX = ((WorldMinY-WorldY2)/(WorldY1-WorldY2))*(WorldX1-WorldX2);
       ClipX = ClipX + WorldX2;
       WorldX2 = ClipX; WorldY2 = ClipY;
      }
    }
  }
 if((WorldX1 != WorldX2) || (WorldY1 != WorldY2))
  {
   ToDevice(WorldX1, WorldY1, &DevX1, &DevY1);
   ToDevice(WorldX2, WorldY2, &DevX2, &DevY2);
   fb_drawLine(DevX1, DevY1, DevX2, DevY2, WHITE);
   /* to take care of rounding errors we erase from both directions */
   fb_drawLine(DevX2, DevY2, DevX1, DevY1, WHITE);
  }
 else
  fprintf(stderr,"line not drawn: X1=%f, Y1=%f, X2=%f, Y2=%f\n",
	  WorldX1, WorldY1, WorldX2, WorldY2);
}

extern void DrawDot(WorldX, WorldY)
 double WorldX, WorldY;
{
 int X, Y;

 ToDevice(WorldX, WorldY, &X, &Y);
 if((X > FBminX) && ((X+1) < FBmaxX) && (Y > FBminY) && ((Y+1) < FBmaxY))
  {
   fb_writePixel(X, Y, BLACK);
   fb_writePixel(X+1, Y, BLACK);
   fb_writePixel(X, Y+1, BLACK);
   fb_writePixel(X+1, Y+1, BLACK);
   fb_flush();
  }
}

extern void DrawDiamond(WorldX, WorldY)
 double WorldX, WorldY;
{
 int X, Y;

 ToDevice(WorldX, WorldY, &X, &Y);
 if((X-4 > FBminX) && ((X+4) < FBmaxX) && (Y-4 > FBminY) && ((Y+4) < FBmaxY))
  {
   fb_drawLine(X-4, Y, X, Y+4, BLACK);
   fb_drawLine(X+4, Y, X, Y+4, BLACK);
   fb_drawLine(X-4, Y, X, Y-4, BLACK);
   fb_drawLine(X+4, Y, X, Y-4, BLACK);
   fb_flush();
  }
}

extern void DrawX(WorldX, WorldY)
 double WorldX, WorldY;
{
 int X, Y;

 ToDevice(WorldX, WorldY, &X, &Y);
 if((X-4 > FBminX) && ((X+4) < FBmaxX) && (Y-4 > FBminY) && ((Y+4) < FBmaxY))
  {
   fb_drawLine(X-4, Y-4, X+4, Y+4, BLACK);
   fb_drawLine(X+4, Y-4, X-4, Y+4, BLACK);
   fb_drawLine(X-5, Y-4, X+3, Y+4, BLACK);
   fb_drawLine(X+3, Y-4, X-5, Y+4, BLACK);
   fb_flush();
  }
}

extern void X11Quit()
{
 if(FB_SUCCESS != fb_close())
  {
   fprintf(stderr, "Error closing framebuffer: %s\n", fb_error_message);
   exit(1);
  }
}
