/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

static void volatile oom (void) asm ("Loom");

void *
xmalloc (size_t size)
{
  void *res = malloc (size);
  
  if (res)
    return res;
    
  oom ();
}

void *
xrealloc (void *buf, size_t size)
{
  void *res  = realloc (buf, size);
  
  if (res)
    return res;

  oom ();
}


static void volatile 
oom (void)
{
  fprintf (stderr, "Out of memory!\n");
  exit (1);
}
