/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  rename.c,v 1.1.1.1 1994/04/04 04:30:32 amiga Exp
 *
 *  rename.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:32  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#if __GNUC__ != 2
#define alloca __builtin_alloca
#endif

struct rename_vec {
  char *source_name;
  BPTR target_dir_lock;
  BSTR target_name;
};


static int
__rename_func (struct StandardPacket *sp, struct MsgPort *handler,
               BPTR parent_lock,
	       BSTR name,
	       struct rename_vec *rv, int *no_error)
{
  sp->sp_Pkt.dp_Type = ACTION_RENAME_OBJECT;
  sp->sp_Pkt.dp_Arg1 = parent_lock;
  sp->sp_Pkt.dp_Arg2 = name;
  sp->sp_Pkt.dp_Arg3 = rv->target_dir_lock;
  sp->sp_Pkt.dp_Arg4 = rv->target_name;
  
  PutPacket (handler, sp);
  __wait_sync_packet (sp);

  *no_error = sp->sp_Pkt.dp_Res1 == -1;

  /* retry if necessary */
  return 1;
}

static int
__get_target_data (struct StandardPacket *sp, struct MsgPort *handler,
                   BPTR parent_lock,
	           BSTR name,
	           struct rename_vec *rv, int *no_error)
{
  rv->target_dir_lock = parent_lock;
  rv->target_name = name;
  
  sp->sp_Pkt.dp_Res1 = __plock (rv->source_name, __rename_func, rv);
  sp->sp_Pkt.dp_Res2 = ((struct Process *)FindTask(0))->pr_Result2;
  
  *no_error = sp->sp_Pkt.dp_Res1 == -1;
  
  /* don't retry */
  return 0;
}

int
rename(char *from, char *to)
{
  int res;
  struct rename_vec rv;

  rv.source_name = from;
  
  res = __plock (to, __get_target_data, &rv);
  
  if (res == 0 && IoErr() == ERROR_OBJECT_EXISTS)
    {
      syscall (SYS_unlink ,to);
      res = __plock (to, __get_target_data, &rv);
    }

  if (!res) errno = __ioerr_to_errno (IoErr ());
  return res == -1 ? 0 : -1;
}
