/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  mkdir.c,v 1.1.1.1 1994/04/04 04:30:30 amiga Exp
 *
 *  mkdir.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:30  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

static int
__mkdir_func (struct StandardPacket *sp, struct MsgPort *handler,
              BPTR parent_lock,
	      BSTR name,
	      void *dummy, int *no_error)
{
  sp->sp_Pkt.dp_Type = ACTION_CREATE_DIR;
  sp->sp_Pkt.dp_Arg1 = parent_lock;
  sp->sp_Pkt.dp_Arg2 = name;

  PutPacket (handler, sp);
  __wait_sync_packet (sp);

  *no_error = sp->sp_Pkt.dp_Res1 == -1;
    
  /* continue if we failed because of symlink - reference */
  return 1;
}


int
mkdir (char *path, int perm)
{
  BPTR lock;
  int result = -1;
  int omask;
 
  /* protect the obtained lock, we have to free it later */
  omask = syscall (SYS_sigsetmask, ~0);  
  lock = __plock (path, __mkdir_func, 0);

  if (lock)
    {
      __unlock (lock);
      result = syscall (SYS_chmod, path, perm);
    }
  syscall (SYS_sigsetmask, omask);

  errno = __ioerr_to_errno (IoErr ());
  return result;
}
