extern struct MathIeeeDoubTransBase * MathIeeeDoubTransBase;
extern struct MathIeeeDoubBasBase * MathIeeeDoubBasBase;

double const atan (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x1e)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const sin (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x24)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const cos (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x2a)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const tan (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x30)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double sincos (double* pf2, double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double* a0 __asm("a0");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	a0 = pf2;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x36)"
	: "=r" (res)
	: "r" (a6), "r" (a0), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const sinh (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x3c)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const cosh (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x42)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const tanh (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x48)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const exp (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x4e)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const log (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x54)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
/* GRRRR Commodore does it the other way round... */
double const pow (double arg, double exp)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d2 __asm("d2");
	register double d3 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d2 = exp;	/* invert arguments here, so exp really is arg and vice versa */
	d3 = arg;
	__asm volatile ("
	jsr a6@(-0x5a)"
	: "=r" (res)
	: "r" (a6), "r" (d2), "r" (d3)
	: "d0", "d1", "a0", "a1", "d2", "d3");
	return res;
}
double const sqrt (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x60)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const asin (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x72)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const acos (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x78)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const log10 (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubTransBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x7e)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const floor (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubBasBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x5a)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
double const ceil (double parm)
{
	register double res __asm("d0");
	register void *a6 __asm ("a6");
	register double d0 __asm("d0");

	a6 = MathIeeeDoubBasBase;
	d0 = parm;
	__asm volatile ("
	jsr a6@(-0x60)"
	: "=r" (res)
	: "r" (a6), "r" (d0)
	: "d0", "d1", "a0", "a1");
	return res;
}
