/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
/* NOT (!) to be used by custom applications, this is a very special case !! */
#include "ixemul.h"

extern struct ixemul_base *ixemulbase;

int
main (int argc, char *argv[])
{
  int c;
  int do_dots = ixemulbase->ix_translate_dots;
  int do_slash = ixemulbase->ix_translate_slash;
  int mem_buf = ixemulbase->ix_membuf_limit;
  int do_force = ixemulbase->ix_force_translation;
  int do_links = ixemulbase->ix_translate_symlinks;
  int do_sleep = 0;
  int red_zone_size = ixemulbase->ix_red_zone_size;
  int do_watch = ixemulbase->ix_watch_stack;
  int fs_buf_factor = ixemulbase->ix_fs_buf_factor;
  int ignore_global_env = ixemulbase->ix_ignore_global_env;

  while ((c = getopt (argc, argv, "./?ab:defhilm:r:swx")) != EOF)
    switch (c)
      {
      case 'd':      
        mem_buf = 0;
        /* fall into */

      case 'a':
        do_dots =
          do_slash = 
            do_force = 
	      do_links = 0;
        break;

      case 'b':
        fs_buf_factor = atoi (optarg);
        if (! fs_buf_factor)
          fs_buf_factor = 64;
        break;
      
      case '.':
      	do_dots = 1;
      	break;
      	
      case '/':
        do_slash = 1;
        break;
        
      case 'f':
        do_force = 1;
        break;

      case 'i':
        ignore_global_env = 1;
        break;

      case 'e':
        ignore_global_env = 0;
        break;

      case 'l':
	do_links = 1;
	break;

      case 'm':
        mem_buf = atoi (optarg);
	break;

      case 'r':
	red_zone_size = atoi (optarg);
	break;

      case 's':
        do_sleep = 1;
        break;

      case 'w':
	do_watch = 1;
	break;

      case 'x':
      	do_watch = 0;
      	break;

      default:
	fprintf (stderr, "%s [-d|-a|-b N|-f|-.|-/|-m N|-r N|-s|-w|-x]\n", argv[0]);
	fprintf (stderr, "  -d	 reset values to defaults\n"
			 "  -a   full AmigaDOS mode, no ./ translations\n"
			 "  -b N N physical block map into 1 logical (stdio) block\n"
			 "  -f   don't accept AmigaDOS notation\n"
			 "  -i   ignore global environment (ENV:)\n"
			 "  -e   don't ignore global environment (ENV:)\n"
			 "  -.   translate . and ..\n"
			 "  -/   translate /foo -> foo: and a//b -> a/b\n"
			 "  -l   translate contents of symbolic links\n"
			 "  -m N files upto N bytes are cached in memory\n"
			 "  -r N set red zone size to N bytes. 0 disables.\n"
			 "  -s   sleep, don't return.\n"
			 "  -w   enable stack watcher\n"
			 "  -x   disable stack watcher\n");
	exit (1);
      }

  ixemulbase->ix_translate_dots = do_dots;
  ixemulbase->ix_translate_slash = do_slash;
  ixemulbase->ix_translate_symlinks = do_links;
  ixemulbase->ix_force_translation = do_force;
  ixemulbase->ix_membuf_limit = mem_buf;
  ixemulbase->ix_red_zone_size = red_zone_size;
  ixemulbase->ix_watch_stack = do_watch;
  ixemulbase->ix_fs_buf_factor = fs_buf_factor;
  ixemulbase->ix_ignore_global_env = ignore_global_env;
  
  printf ("%sranslate . and .., %stranslate /, %stranslate symlinks,\n"
	  "%sallow AmigaDOS notation, membuf size = %d,\n"
	  "red zone size = %d, stack watcher is %s %s,\n"
	  "%d physical blocks build%s one logical block (for stdio),\n"
	  "%s global environment (ENV:).\n",
    	  do_dots ? "T" : "Don't t",
    	  do_slash ? "" : "don't ",
    	  do_links ? "" : "don't ",
    	  do_force ? "don't " : "",
    	  mem_buf,
	  red_zone_size,
	  do_watch ? "enabled" : "disabled",
	  red_zone_size ? (do_watch ? "(and active)" : "(and not active)")
			: (do_watch ? "(but not active)" : "(and not active)"),
	  fs_buf_factor, fs_buf_factor == 1 ? "s" : "",
	  ignore_global_env ? "Ignore" : "Don't ignore");

  /* if -s is specified, the program keeps the library open until it is 
     interrupted. That way, the library can't be flushed, so the preferences
     are not reset */
  if (do_sleep)
    pause ();

  return 0;
}
