/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  ix_startup.c,v 1.1.1.1 1994/04/04 04:30:42 amiga Exp
 *
 *  ix_startup.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:42  amiga
 * Initial CVS check in.
 *
 *  Revision 1.4  1992/10/20  16:23:24  mwild
 *  move closing of files and freeing of malloc-memory out of CloseLibrary,
 *  and thus out of Forbid.
 *
 *  Revision 1.3  1992/08/09  20:55:51  amiga
 *  import sysbase
 *
 *  Revision 1.2  1992/07/04  19:18:21  mwild
 *  remove SIGWINCH handler before returning
 *
 * Revision 1.1  1992/05/14  19:55:40  mwild
 * Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#ifdef DEBUG
#define DP(a) kprintf a
#else
#define DP(a)
#endif

#define exit_buf u.u_jmp_buf
extern struct ExecBase *SysBase;

void
reset_fpu ()
{
  /* Never try to reset a nonexisting FPU.  */

  /* The flag AFF_68881 is also always set in case the FPU is a 68882.  */
  if (SysBase->AttnFlags & AFF_68881)
    {
      /* reset fpu into a defined state */
      asm volatile ("
	moveml	a5/a6,sp@-
	lea	pc@(Lreset_fpu-.+2),a5
	movel	4:w,a6
	jsr	a6@(-30)		| Supervisor()
	bra	Lafter_reset_fpu

Lreset_fpu:
	clrl	sp@-
	frestore sp@+
	rte

Lafter_reset_fpu:
	moveml	sp@+,a5/a6");
    }
}


/*
 * Note: I kept the partition into startup and _main(), although in this
 *       case, both functions could be done in one function, since this is
 *       a library, and the user can't override _main anyway but globally...
 */

int
ix_startup (char *aline, int alen,
	    int expand, char *wb_default_window, u_int main, int *real_errno)
{
  struct Process	*me		= (struct Process *) SysBase->ThisTask;
  int			exit_val;
  struct WBStartup	*wb_msg;
  int			fd;

  /*
   * The following call to reset the fpu might not be necessary, BUT since
   * a CLI shell doesn't spawn a new process when executing a command - it 
   * insteads calls the command like a subroutine - it depends on the Shell
   * whether the fpu is setup correctly. And I don't like to depend on any
   * thing ;-)
   */
  reset_fpu ();


  /* first deal with WB messages, since those HAVE to be answered properly,
   * even if we should fail later (memory, whatever..) */

  if (! me->pr_CLI)
    {
      /* we have been started by Workbench. Get the StartupMsg */
      WaitPort (& me->pr_MsgPort);
      wb_msg = (struct WBStartup *) GetMsg (& me->pr_MsgPort);
      /* further processing in _main () */
    }
  else
    {
      /* for usage by sys_exit() for example */
      u.u_argline = aline;
      u.u_arglinelen = alen;
    }
  
  u.u_expand_cmd_line = expand;
  if (real_errno) u.u_errno = real_errno;

DP(("ix_startup(start): sp = $%lx\n",({int res;asm("movel sp,%0" : "=g" (res));res;})));

  exit_val = setjmp (exit_buf);

  if (! exit_val)
    {
      /* from now on it's safe to allow signals */
      syscall (SYS_sigsetmask, 0);

      /* the first time thru call the program */
      exit_val = me->pr_CLI ? syscall (SYS__main, aline, alen, main)
			    : syscall (SYS__main, wb_msg, wb_default_window, main);
    }
#if 0
  else
    /* in this case we came from a longjmp-call */
    exit_val --;
#endif
  else
    /* in this case we came from a longjmp-call */
    exit_val = u.p_xstat;
  ix_remove_sigwinch ();

  /* had to move the closing of files out of ix_close(), as close() may 
     actually wait for the last packet to arrive, and inside ix_close() we're
     inside Forbid, and may thus never wait! */

  /* close all files */
  for (fd = 0; fd < NOFILE; fd++) 
    if (u.u_ofile[fd]) syscall (SYS_close, fd);

  /* if at all possible, free memory before entering Forbid ! (Semaphore
     problems..) */
  all_free ();

  /* if started from workbench, Forbid(), since on reply WB will deallocate
   * our task... */
  if (! me->pr_CLI)
    {
      Forbid ();
      ReplyMsg ((struct Message *) wb_msg);
    }

DP(("ix_startup(end): sp = $%lx\n",({int res;asm("movel sp,%0" : "=g" (res));res;})));

  return exit_val;
}

/* this just jumps right back into ix_startup() */
void
_exit (int retcode)
{
  DP(("_exit(%lx)\n", retcode));
  u.p_xstat = retcode;
  longjmp (exit_buf, 1);
}
