/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  ix_resident.c,v 1.1.1.1 1994/04/04 04:30:59 amiga Exp
 *
 *  ix_resident.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:59  amiga
 * Initial CVS check in.
 *
 *  Revision 1.3  1992/10/20  16:21:45  mwild
 *  allocate the a4-region with kmalloc, since the startup code (crt0.c)
 *  references ixemulbase a4-relative after ix_startup() returned, and thus after
 *  malloc-memory is already freed.
 *
 *  Revision 1.2  1992/09/14  01:42:52  mwild
 *  if out of memory, exit. There's no reason to continue, the programs would
 *  just plain crash...
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"
#include <sys/exec.h>

#undef DEBUG
#ifdef DEBUG
#define DP(a) kprintf a
#else
#define DP(a)
#endif


void
ix_resident (int numpar, int a4, int databss_size, long *relocs)
{
  /* for now, only a4 management is supported. relocation is for later, 
     and isn't defined yet */

  if ((numpar == 3 || numpar == 4) && databss_size)
    {
      int mem = kmalloc (databss_size);
      if (! mem)
        {
	  ix_panic ("Out of memory, not purified.");
	  _exit (20);
	}
      else
	{
	  int origmem = a4 - 0x7ffe;

	  bcopy (origmem, mem, databss_size);

DP(("Relocating area $%lx -> $%lx ($%lx)\n", origmem, mem, databss_size));
	  
	  if (numpar == 4 && relocs[0] > 0)
	    {
	      int i, num_rel = relocs[0];
	      
	      for (i = 0, relocs++; i < num_rel; i++, relocs++)
		{
DP(("  [%lx] $%lx -> ", *relocs, *(long *)(mem + *relocs)));
	          *(long *)(mem + *relocs) -= origmem - mem;
DP(("$%lx\n", *(long *)(mem + *relocs)));
	        }
	    }

	  if (u.p_flag & SFREEA4)
	    kfree (origmem);
	  else
	    u.p_flag |= SFREEA4;

	  a4 = mem + 0x7ffe;
	}
    }

  
  if (numpar >= 2 && numpar <= 4)
    {
      /* need output parameter, or the asm is optimized away */
      asm volatile ("movel %0, a4" : "=g" (a4) : "0" (a4));
      
      u.u_a4 = a4;
    }
  else
    ix_panic ("Unsupported ix_resident call.");
}

int
ix_geta4 ()
{
  asm volatile ("movel %0, a4" : "=g" (u.u_a4) : "0" (u.u_a4));
}

void
ix_check_cpu (int machtype)
{
  if (machtype == MID_SUN020)
    {
      if (!((*(struct ExecBase **)4)->AttnFlags & AFF_68020))
	{
	  ix_panic ("This program requires at least a 68020 cpu.");
	  syscall (SYS_exit, 20);
	}
    }
}
