/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  ix_exec_entry.c,v 1.1.1.1 1994/04/04 04:30:55 amiga Exp
 *
 *  ix_exec_entry.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:55  amiga
 * Initial CVS check in.
 *
 *  Revision 1.3  1992/08/09  20:47:19  amiga
 *  call main thru exit, or no atexit handlers will be called!
 *
 *  Revision 1.2  1992/07/04  19:13:42  mwild
 *  add SIGWINCH handler installation/removal
 *
 * Revision 1.1  1992/05/14  19:55:40  mwild
 * Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#ifdef DEBUG
#define DP(a) ({Disable (); kprintf a ; Enable ();})
#else
#define DP(a)
#endif

#define exit_buf u.u_jmp_buf
extern struct ExecBase 	*SysBase;

extern void reset_fpu ();

int
ix_exec_entry (int argc, char **argv, char **environ, int *real_errno, 
	       int (*main)(int, char **, char **))
{
  struct Process	*me		= (struct Process *) SysBase->ThisTask;
  int			exit_val;

  /* we're coming from another process here, either after vfork() or from a
   * process that wants to `replace' itself with this program. Thus the fpu
   * is probably already initialized to some bogous state. That's why we
   * HAVE to restore it into a default state here. */
  reset_fpu ();


DP(("ix_exec_entry: argc = %ld, argv = $%lx\n", argc, argv));

  /* a program started by ix_exec_entry() must have some ix'like shell
     around, that takes care of printing exit-states, so don't print them
     again in sig_exit() */
  u.u_argline = 0;
  u.u_arglinelen = 0;
  
  if (real_errno) u.u_errno = real_errno;

  exit_val = setjmp (exit_buf);

  if (! exit_val)
    {
      u_int curr_disp;
      extern struct ExecBase *SysBase;

      /* install the signal mask that was active before execve() was called */
      syscall (SYS_sigsetmask, u.u_oldmask);


      /* this is not really the right thing to do, the user should call
         ix_get_vars2 () to initialize environ to the address of the variable
         in the calling program. However, this setting guarantees that 
         the user area entry is valid for getenv() calls. */
      u.u_environ = &environ;

      ix_install_sigwinch ();

      /* If this process is traced (under debugger control)
	 then cause a sigtrap.  */
      if (u.p_flag & STRC)
	{
	  u_int curr_disp;
	  extern struct ExecBase *SysBase;
	    
	  DP(("ix_exec_entry(): STRC: _psignal (me=%lx, SIGTRAP);\n", me));

	  _psignal ((struct Task *) me, SIGTRAP);

	  /* The handler for hardware traps has now been told to expect this trap
	     (specialized signal handler called from sig_launch()), and will
	     just stop the process, and increment the PC over this instruction.  */
	  asm (" trap #0");

#if 0
	  /* _psignal() SHOULD have ensured the context switch, but... */
	  for (curr_disp = SysBase->DispCount; curr_disp == SysBase->DispCount; )
	    ;
#endif
	  
	  /* A context switch is guaranteed to have taken place at this time,
	     since we signalled ourselves.  As we are continuing now, it means
	     the debugger process has told us to continue.  */
	  DP(("ix_exec_entry(): STRC: continuing after _psignal (me=%lx, SIGTRAP);\n", me));
	}

      /* the first time thru call the program */
      exit (main (argc, argv, environ));
      /* not reached! */
    }
#if 0
  else
    /* in this case we came from a longjmp-call */
    exit_val --;
#endif
  else
    /* in this case we came from a longjmp-call */
    exit_val = u.p_xstat;

  ix_remove_sigwinch ();

DP(("ix_exec_entry(end): sp = $%lx, exit_val=%lx\n",
    ({int res;asm("movel sp,%0" : "=g" (res));res;}),
    exit_val));

  return exit_val;
}
