/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  dsyscall.c,v 1.1.1.1 1994/04/04 04:29:37 amiga Exp
 *
 *  dsyscall.c,v
 * Revision 1.1.1.1  1994/04/04  04:29:37  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define syscall _syscall
#define KERNEL
#include "ixemul.h"
#undef syscall

#define SYSTEM_CALL(func, vec) #func,

char *sys_call[] = { "bogous",
#include <sys/syscall.def>
};
#undef SYSTEM_CALL

#include <sys/syscall.h>

typedef int (*intfunc)();

static int go = 0;

void
reset_watchdog ()
{
  go = 0;
}

int
syscall (int a0, int a1, int a2, int a3, int a4, int a5, int a6, int a7, int a8)
{
  int result;

if (! ix.ix_translate_dots) go = 1;

#if 0
if (a0 != SYS_sigsetmask)
#endif
if (go)
  kprintf ("%s ($%lx, $%lx, $%lx, $%lx)\n", sys_call[a0], a1, a2, a3, a4);

  result = ((intfunc)((int)ixemulbase-(a0+4)*6))(a1, a2, a3, a4, a5, a6, a7, a8);

if (! ix.ix_translate_dots) go = 1;

#if 0
if (a0 != SYS_sigsetmask)
#endif
if (go)
  kprintf ("\t\t%s() returned $%lx.\n", sys_call[a0], result);
  return result;
}
