/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  __write.c,v 1.1.1.1 1994/04/04 04:30:14 amiga Exp
 *
 *  __write.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:14  amiga
 * Initial CVS check in.
 *
 *  Revision 1.2  1992/08/09  20:40:39  amiga
 *  add a cast to get rid of a warning
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#ifdef DEBUG
#define DP(a) kprintf a
#else
#define DP(a)
#endif

int
__write(struct file *f, char *buf, int len)
{
  int err=errno, res = 0;
  int omask;

  if (HANDLER_NIL(f)) return len;

  omask = syscall (SYS_sigsetmask, ~0);
  __get_file (f);
  /* get results of last call */
  __wait_packet(&f->f_sp);
  res = LastResult(f);
  if (res == -1)
    err = __ioerr_to_errno(LastError(f));
  else
    {
      /* we have no way of telling, whether the last written number
       * of characters was correct or not, we just say, if it wasn't
       * an error (res == -1), than it's ok to continue writing to this
       * file. We have to return 'len' instead of 'res', because the 
       * user normally expects to say "while write(fd,buf,len)==len"
       * as a check whether there was an error with write() or not */

      res = len;

      if (len > 0)
        {
          /* right append-mode means, before each write do an explicit
           * seek to eof */
          if (f->f_flags & FAPPEND) 
	    {
	      SendPacket3(f,__rwport,ACTION_SEEK,f->f_fh->fh_Arg1,0,OFFSET_END);
              __wait_packet(&f->f_sp);
	    }

	  /* We need to save a copy of this buffer in our local buffer,
	   * because the caller is free to change buf after this function
	   * returns. */
	  if (len > f->f_async_len) 
	    {
DP(("asl=%ld,l=%ld,b=$%lx ",f->f_async_len, len,f->f_async_buf));
	      f->f_async_len = len*2;	/* don't waste too much memory */
	      if (! (f->f_async_buf = (char *)krealloc (f->f_async_buf, f->f_async_len)))
	        {
		  f->f_async_len = 0;
		  /* in that case resort to sync write */
		  __release_file (f);
		  syscall (SYS_sigsetmask, omask);
		  errno = err;
		  return __sync_write (f, buf, len);
		}
	    }
	  bcopy (buf, f->f_async_buf, len);
          SendPacket3(f,__rwport,ACTION_WRITE,f->f_fh->fh_Arg1,(long)f->f_async_buf,len);
        }
    }

  __release_file (f);
  syscall (SYS_sigsetmask, omask);
  errno = err;
  return res;
}
