/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  __unlock.c,v 1.1.1.1 1994/04/04 04:30:13 amiga Exp
 *
 *  __unlock.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:13  amiga
 * Initial CVS check in.
 *
 *  Revision 1.3  1992/08/09  20:40:01  amiga
 *  change to use 2.x header files by default
 *
 *  Revision 1.2  1992/07/28  02:50:59  mwild
 *  call FreeDosObject instead of kfree() when > 1.3
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#if __GNUC__ != 2
#define alloca __builtin_alloca
#endif

int
__unlock (BPTR lock)
{
  struct StandardPacket *sp;
  
  sp = alloca(sizeof(*sp)+2);
  sp = LONG_ALIGN (sp);
  __init_std_packet(sp);

  sp->sp_Pkt.dp_Port = u.u_sync_mp;
  sp->sp_Pkt.dp_Type = ACTION_FREE_LOCK;
  sp->sp_Pkt.dp_Arg1 = lock;

  PutPacket (((struct FileLock *)BTOCPTR (lock))->fl_Task, sp);
  __wait_sync_packet (sp);
  
  /* set up Result2 so that the IoErr() works */
  ((struct Process *)FindTask (0))->pr_Result2 = sp->sp_Pkt.dp_Res2;

  return sp->sp_Pkt.dp_Res1;
}

/* ATTENTION: name-clash between sysio-__close and DOS-__Close !! */
int
__Close (BPTR fh)
{
  struct StandardPacket *sp;
  struct FileHandle *fhp = BTOCPTR (fh);
  
  /* only do this is not closing a dummy NIL: filehandle */
  if (fhp->fh_Type)
    {
      sp = alloca(sizeof(*sp)+2);
      sp = LONG_ALIGN (sp);
      __init_std_packet(sp);

      sp->sp_Pkt.dp_Port = u.u_sync_mp;
      sp->sp_Pkt.dp_Type = ACTION_END;
      sp->sp_Pkt.dp_Arg1 = fhp->fh_Arg1;

      PutPacket (fhp->fh_Type, sp);
      __wait_sync_packet (sp);
    }
  
  FreeDosObject (DOS_FILEHANDLE, fhp);

  /* set up Result2 so that the IoErr() works */
  ((struct Process *)FindTask (0))->pr_Result2 = sp->sp_Pkt.dp_Res2;

  return sp->sp_Pkt.dp_Res1;
}
