/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  __swrite.c,v 1.1.1.1 1994/04/04 04:30:12 amiga Exp
 *
 *  __swrite.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:12  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

int
__sync_write(struct file *f, char *buf, int len)
{
  int err=errno, res = 0;
  int omask;

  if (HANDLER_NIL(f)) return len;

  omask = syscall (SYS_sigsetmask, ~0);
  __get_file (f);
  /* this allows intermixing different modes.. we wouldn't need to
   * wait, if we knew the user only used FSYNC-mode */
  __wait_packet(&f->f_sp);

  if (len > 0)
    {
      /* full append-mode means, before each write do an explicit
       * seek to eof */
      if (f->f_flags & FAPPEND)
	{
	  SendPacket3(f,__rwport,ACTION_SEEK,f->f_fh->fh_Arg1,0,OFFSET_END);
          __wait_packet(&f->f_sp);
	}

      SendPacket3(f,__rwport,ACTION_WRITE,f->f_fh->fh_Arg1,(long)buf,len);
      __wait_packet(&f->f_sp);
      res = LastResult(f);
      if (res == -1) err = __ioerr_to_errno(LastError(f));
    }

  LastResult(f) = 0;
  __release_file (f);
  syscall (SYS_sigsetmask, omask);
  errno = err;
  return res;
}
