/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  __pipe.c,v 1.1.1.1 1994/04/04 04:30:48 amiga Exp
 *
 *  __pipe.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:48  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#if __GNUC__ != 2
#define alloca __builtin_alloca
#endif

int
__pipe (BPTR vecs[2])
{
  static char name[] = "PIPE:ixemul00000";
  char *cp;

  ix_lock_base ();

  /* funny piece.. increment the counter ;-)) */
  cp = name + (sizeof (name) - 2);	/* point at last 0 */
  while (++*cp == '9' + 1)
    {
      *cp = '0';
      cp--;
    }
  
  if (vecs[1] = __open (name, MODE_NEWFILE))
    if (vecs[0] = __open (name, MODE_OLDFILE)) 
      goto ok;
    else
      {
	errno = __ioerr_to_errno (IoErr ());
        __Close (vecs[1]);
      }
  else
    errno = __ioerr_to_errno (IoErr ());

  ix_unlock_base ();
  return 0;
  
ok:
  ix_unlock_base ();
  return -1;
}
