/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  __close.c,v 1.1.1.1 1994/04/04 04:29:44 amiga Exp
 *
 *  __close.c,v
 * Revision 1.1.1.1  1994/04/04  04:29:44  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#ifdef DEBUG
#define DP(a) kprintf a
#else
#define DP(a)
#endif

int
__close(struct file *f)
{
  int omask;

  ix_lock_base ();

  f->f_count--;

/* DP(("__close: closing file $%lx, f_count now %ld.\n", f, f->f_count)); */
  if (f->f_count > 0) goto unlock;
  /* don't need file locking here... if the counter is down to 0, nobody
     else CAN have this file locked */
  __wait_packet(&f->f_sp);

  if (!(f->f_flags & FEXTOPEN))
    __Close (CTOBPTR (f->f_fh));   

  /* if we have to set some modes, do it now */
  if (f->f_stb_dirty)
    {
      syscall (SYS_chmod, f->f_name, f->f_stb.st_mode);
      /* should later also set modification time */
    }

  if (f->f_flags & FUNLINK) syscall (SYS_unlink, f->f_name);

  /* NOTE: the FEXTOPEN flag tells us two things: 1) we shouldn't
   * perform a Close() on the filehandle, and 2) the name in the
   * file structure wasn't allocated by malloc(), so we shouldn't 
   * free() it either. */
  if (!(f->f_flags & FEXTOPEN) && f->f_name) 
    {
/*      DP(("f->f_name(%s) ", f->f_name));*/
      kfree (f->f_name);
    }

  if (f->f_async_len) 
    {
/*      DP(("f->f_async_len "));*/
      kfree (f->f_async_buf);
    }

unlock:
  ix_unlock_base ();

  return 0;
}
