#include "common.h"
#ifdef IEEE_SINGBAS
#include <inline/mathieeesingbas.h>
#else
#include <inline/mathffp.h>
#include <inline/mathtrans.h>
#endif

int
__lesf2 (a, b)
     FLOAT a, b;
{
#ifdef IEEE_SINGBAS
  return IEEESPCmp (a, b);
#else
  return SPCmp( SPFieee(a), SPFieee(b));
#endif
}
