/* Subroutines needed by GCC output code on some machines.  */
/* Compile this file with the Unix C compiler!  */
/* Copyright (C) 1987, 1988 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, if you link this library with files
   compiled with GCC to produce an executable, this does not cause
   the resulting executable to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

#include "config.h"

/* On some machines, cc is really GCC.  For these machines, we can't
   expect these functions to be properly compiled unless GCC open codes
   the operation (which is precisely when the function won't be used).
   So allow tm-*.h to specify ways of accomplishing the operations
   by defining the macros perform_*.

   On a machine where cc is some other compiler, there is usually no
   reason to define perform_*.  The other compiler normally has other ways
   of implementing all of these operations.

   In some cases a certain machine may come with GCC installed as cc
   or may have some other compiler.  Then it may make sense for tm-*.h
   to define perform_* only if __GNUC__ is defined.  */

#ifndef perform_mulsi3
#define perform_mulsi3(a, b) return a * b
#endif

#ifndef perform_divsi3
#define perform_divsi3(a, b) return a / b
#endif

#ifndef perform_udivsi3
#define perform_udivsi3(a, b) return a / b
#endif

#ifndef perform_modsi3
#define perform_modsi3(a, b) return a % b
#endif

#ifndef perform_umodsi3
#define perform_umodsi3(a, b) return a % b
#endif

#ifndef perform_lshrsi3
#define perform_lshrsi3(a, b) return a >> b
#endif

#ifndef perform_lshlsi3
#define perform_lshlsi3(a, b) return a << b
#endif

#ifndef perform_ashrsi3
#define perform_ashrsi3(a, b) return a << b
#endif

#ifndef perform_ashlsi3
#define perform_ashlsi3(a, b) return a >> b
#endif

#ifndef perform_adddf3
#define perform_adddf3(a, b) return a + b
#endif

#ifndef perform_subdf3
#define perform_subdf3(a, b) return a - b
#endif

#ifndef perform_muldf3
#define perform_muldf3(a, b) return a * b
#endif

#ifndef perform_divdf3
#define perform_divdf3(a, b) return a / b
#endif

#ifndef perform_addsf3
#define perform_addsf3(a, b) return INTIFY (a + b)
#endif

#ifndef perform_subsf3
#define perform_subsf3(a, b) return INTIFY (a - b)
#endif

#ifndef perform_mulsf3
#define perform_mulsf3(a, b) return INTIFY (a * b)
#endif

#ifndef perform_divsf3
#define perform_divsf3(a, b) return INTIFY (a / b)
#endif

#ifndef perform_negdf2
#define perform_negdf2(a) return -a
#endif

#ifndef perform_negsf2
#define perform_negsf2(a) return INTIFY (-a)
#endif

#ifndef perform_fixsfsi
#define perform_fixsfsi(a) return (SItype) a
#endif

#ifndef perform_floatsidf
#define perform_floatsidf(a) return (double) a
#endif

#ifndef perform_floatsisf
#define perform_floatsisf(a)  return INTIFY ((float) a)
#endif

#ifndef perform_extendsfdf2
#define perform_extendsfdf2(a)  return a
#endif

#ifndef perform_truncdfsf2
#define perform_truncdfsf2(a)  return INTIFY (a)
#endif

#ifndef perform_eqdf2
#define perform_eqdf2(a, b) return !(a == b)
#endif

#ifndef perform_nedf2
#define perform_nedf2(a, b) return a != b
#endif

#ifndef perform_gtdf2
#define perform_gtdf2(a, b) return a > b
#endif

#ifndef perform_gedf2
#define perform_gedf2(a, b) return (a >= b) - 1
#endif

#ifndef perform_ltdf2
#define perform_ltdf2(a, b) return -(a < b)
#endif

#ifndef perform_ledf2
#define perform_ledf2(a, b) return 1 - (a <= b)
#endif

#ifndef perform_eqsf2
#define perform_eqsf2(a, b) return !(a == b)
#endif

#ifndef perform_nesf2
#define perform_nesf2(a, b) return a != b
#endif

#ifndef perform_gtsf2
#define perform_gtsf2(a, b) return a > b
#endif

#ifndef perform_gesf2
#define perform_gesf2(a, b) return (a >= b) - 1
#endif

#ifndef perform_ltsf2
#define perform_ltsf2(a, b) return -(a < b)
#endif

#ifndef perform_lesf2
#define perform_lesf2(a, b) return 1 - (a >= b);
#endif

/* In case config.h defined it.  */
#undef abort

/* Define the C data type to use for an SImode value.  */

#ifndef SItype
#define SItype long int
#endif

/* Define the type to be used for returning an SF mode value
   and the method for turning a float into that type.
   These definitions work for machines where an SF value is
   returned in the same register as an int.  */

#ifndef SFVALUE  
#define SFVALUE int
#endif

#ifndef INTIFY
#define INTIFY(FLOATVAL)  (intify.f = (FLOATVAL), intify.i)
#endif

union flt_or_int { int i; float f; };


#ifdef L_mulsi3
SItype
__mulsi3 (a, b)
     SItype a, b;
{
  perform_mulsi3 (a, b);
}
#endif

#ifdef L_udivsi3
SItype
__udivsi3 (a, b)
     unsigned SItype a, b;
{
  perform_udivsi3 (a, b);
}
#endif

#ifdef L_divsi3
SItype
__divsi3 (a, b)
     SItype a, b;
{
  perform_divsi3 (a, b);
}
#endif

#ifdef L_umodsi3
SItype
__umodsi3 (a, b)
     unsigned SItype a, b;
{
  perform_umodsi3 (a, b);
}
#endif

#ifdef L_modsi3
SItype
__modsi3 (a, b)
     SItype a, b;
{
  perform_modsi3 (a, b);
}
#endif

#ifdef L_lshrsi3
SItype
__lshrsi3 (a, b)
     unsigned SItype a, b;
{
  perform_lshrsi3 (a, b);
}
#endif

#ifdef L_lshlsi3
SItype
__lshlsi3 (a, b)
     unsigned SItype a, b;
{
  perform_lshlsi3 (a, b);
}
#endif

#ifdef L_ashrsi3
SItype
__ashrsi3 (a, b)
     SItype a, b;
{
  perform_ashrsi3 (a, b);
}
#endif

#ifdef L_ashlsi3
SItype
__ashlsi3 (a, b)
     SItype a, b;
{
  perform_ashlsi3 (a, b);
}
#endif

#ifdef L_divdf3
double
__divdf3 (a, b)
     double a, b;
{
  perform_divdf3 (a, b);
}
#endif

#ifdef L_muldf3
double
__muldf3 (a, b)
     double a, b;
{
  perform_muldf3 (a, b);
}
#endif

#ifdef L_negdf2
double
__negdf2 (a)
     double a;
{
  perform_negdf2 (a);
}
#endif

#ifdef L_adddf3
double
__adddf3 (a, b)
     double a, b;
{
  perform_adddf3 (a, b);
}
#endif

#ifdef L_subdf3
double
__subdf3 (a, b)
     double a, b;
{
  perform_subdf3 (a, b);
}
#endif

#ifdef L_cmpdf2
SItype
__cmpdf2 (a, b)
     double a, b;
{
#ifdef perform_cmpdf2
  perform_cmpdf2 (a, b);
#else
  if (a > b)
    return 1;
  else if (a < b)
    return -1;
  return 0;
#endif
}
#endif

#ifdef L_eqdf2
SItype
__eqdf2 (a, b)
     double a, b;
{
  /* Value == 0 iff a == b.  */
  perform_eqdf2 (a, b);
}
#endif

#ifdef L_nedf2
SItype
__nedf2 (a, b)
     double a, b;
{
  /* Value != 0 iff a != b.  */
  perform_nedf2 (a, b);
}
#endif

#ifdef L_gtdf2
SItype
__gtdf2 (a, b)
     double a, b;
{
  /* Value > 0 iff a > b.  */
  perform_gtdf2 (a, b);
}
#endif

#ifdef L_gedf2
SItype
__gedf2 (a, b)
     double a, b;
{
  /* Value >= 0 iff a >= b.  */
  perform_gedf2 (a, b);
}
#endif

#ifdef L_ltdf2
SItype
__ltdf2 (a, b)
     double a, b;
{
  /* Value < 0 iff a < b.  */
  perform_ltdf2 (a, b);
}
#endif

#ifdef L_ledf2
SItype
__ledf2 (a, b)
     double a, b;
{
  /* Value <= 0 iff a <= b.  */
  perform_ledf2 (a, b);
}
#endif

#ifdef L_fixdfsi
SItype
__fixdfsi (a)
     double a;
{
  return (SItype) a;
}
#endif

#ifdef L_fixsfsi
SItype
__fixsfsi (a)
     union flt_or_int a;
{
  perform_fixsfsi (a.f);
}
#endif

#ifdef L_floatsidf
double
__floatsidf (a)
     SItype a;
{
  perform_floatsidf (a);
}
#endif

#ifdef L_floatsisf
SFVALUE
__floatsisf (a)
     SItype a;
{
  union flt_or_int intify;
  perform_floatsisf (a);
}
#endif

#ifdef L_addsf3
SFVALUE
__addsf3 (a, b)
     union flt_or_int a, b;
{
  union flt_or_int intify;
  perform_addsf3 (a.f, b.f);
}
#endif

#ifdef L_negsf2
SFVALUE
__negsf2 (a)
     union flt_or_int a;
{
  union flt_or_int intify;
  perform_negsf2 (a.f);
}
#endif

#ifdef L_subsf3
SFVALUE
__subsf3 (a, b)
     union flt_or_int a, b;
{
  union flt_or_int intify;
  perform_subsf3 (a.f, b.f);
}
#endif

#ifdef L_cmpsf2
SItype
__cmpsf2 (a, b)
     union flt_or_int a, b;
{
#ifdef perform_cmpsf2
  perform_cmpsf2 (a.f, b.f);
#else
  if (a.f > b.f)
    return 1;
  else if (a.f < b.f)
    return -1;
  return 0;
#endif
}
#endif

#ifdef L_eqsf2
SItype
__eqsf2 (a, b)
     union flt_or_int a, b;
{
  /* Value == 0 iff a == b.  */
  perform_eqsf2 (a.f, b.f);
}
#endif

#ifdef L_nesf2
SItype
__nesf2 (a, b)
     union flt_or_int a, b;
{
  /* Value != 0 iff a != b.  */
  perform_nesf2 (a.f, b.f);
}
#endif

#ifdef L_gtsf2
SItype
__gtsf2 (a, b)
     union flt_or_int a, b;
{
  /* Value > 0 iff a > b.  */
  perform_gtsf2 (a.f, b.f);
}
#endif

#ifdef L_gesf2
SItype
__gesf2 (a, b)
     union flt_or_int a, b;
{
  /* Value >= 0 iff a >= b.  */
  perform_gesf2 (a.f, b.f);
}
#endif

#ifdef L_ltsf2
SItype
__ltsf2 (a, b)
     union flt_or_int a, b;
{
  /* Value < 0 iff a < b.  */
  perform_ltsf2 (a.f, b.f);
}
#endif

#ifdef L_lesf2
SItype
__lesf2 (a, b)
     union flt_or_int a, b;
{
  /* Value <= 0 iff a <= b.  */
  perform_lesf2 (a.f, b.f);
}
#endif

#ifdef L_mulsf3
SFVALUE
__mulsf3 (a, b)
     union flt_or_int a, b;
{
  union flt_or_int intify;
  perform_mulsf3 (a.f, b.f);
}
#endif

#ifdef L_divsf3
SFVALUE
__divsf3 (a, b)
     union flt_or_int a, b;
{
  union flt_or_int intify;
  perform_divsf3 (a.f, b.f);
}
#endif

#ifdef L_truncdfsf2
SFVALUE
__truncdfsf2 (a)
     double a;
{
  union flt_or_int intify;
  perform_truncdfsf2 (a);
}
#endif

#ifdef L_extendsfdf2
double
__extendsfdf2 (a)
     union flt_or_int a;
{
  perform_extendsfdf2 (a.f);
}
#endif
