/*	@(#)tmpnam.c	1.2	*/
/*LINTLIBRARY*/

#define KERNEL
#include "ixemul.h"

/* for L_tmpnam and P_tmpdir */
#include <stdio.h>

/*
 * NOTE: this uses a static buffer, but since we want to generate `random'
 *       filenames, this isn't as bad as one might think :-)
 */

extern char *mktemp(), *strcpy(), *strcat();
static char seed[] = { 'a', 'a', 'a', '\0' };

char *
tmpnam(char *s)
{
	register char *p, *q;

	p = (s == NULL)? syscall (SYS_malloc, L_tmpnam): s;
	(void) strcpy(p, P_tmpdir);
	(void) strcat(p, seed);
	(void) strcat(p, "XXXXXX");

	q = seed;
	while(*q == 'z')
		*q++ = 'a';
	++*q;

	(void) mktemp(p);
	return(p);
}
